/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ast.rpg.tokenizer;

import java.util.ArrayList;
import java.util.StringTokenizer;
import miworkplace.ast.rpg.tokenizer.Delimiter;
import miworkplace.ast.rpg.tokenizer.Line;
import miworkplace.ast.rpg.tokenizer.LineType;
import miworkplace.ast.rpg.tokenizer.Token;

public class Tokenizer {
    public static final String DELIMITER = " ():.;'";

    public static Token[] tokenize(String code) {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        String[] lines = Tokenizer.splitCode(code);
        LineType lastLineType = null;
        boolean freeForm = false;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith("**") && lines[i].toUpperCase().startsWith("**CTDATA")) break;
            Token[] tokens = Tokenizer.splitLine(lines[i], i + 1);
            Line line = new Line(i + 1);
            line.setLineType(Tokenizer.determineLineType(lines[i].toUpperCase(), lastLineType, freeForm));
            line.setData(lines[i]);
            Token[] tokenArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                Token token = tokenArray[n2];
                token.setLine(line);
                line.addToken(token);
                tokenList.add(token);
                ++n2;
            }
            lastLineType = line.getLineType();
            if (!freeForm && lastLineType.equals((Object)LineType.FreeFormStart)) {
                freeForm = true;
            } else if (freeForm && lastLineType.equals((Object)LineType.FreeFormEnd)) {
                freeForm = false;
            }
            ++i;
        }
        return tokenList.toArray(new Token[tokenList.size()]);
    }

    public static String[] splitCode(String code) {
        String[] lines = code.split("\n");
        return lines;
    }

    public static Token[] splitLine(String line, int lineNumber) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        boolean concatingString = false;
        StringBuilder temp = new StringBuilder();
        int position = 1;
        int tempPosition = -1;
        StringTokenizer tokenizer = new StringTokenizer(line, " ():.;'\n\r", true);
        while (tokenizer.hasMoreTokens()) {
            String tokenData = tokenizer.nextToken();
            if (concatingString && !tokenData.equals("'")) {
                temp.append(tokenData);
                if (tempPosition == -1) {
                    tempPosition = position;
                }
            } else if (tokenData.equals("'")) {
                boolean bl = concatingString = !concatingString;
                if (concatingString) {
                    token = new Delimiter(tokenData);
                    token.setPosition(position);
                    token.setLineNumber(lineNumber);
                    tokens.add(token);
                } else {
                    token = new Token(temp.toString());
                    token.setPosition(tempPosition);
                    token.setLineNumber(lineNumber);
                    tokens.add(token);
                    temp.setLength(0);
                    tempPosition = -1;
                    token = new Delimiter(tokenData);
                    token.setPosition(position);
                    token.setLineNumber(lineNumber);
                    tokens.add(token);
                }
            } else if (!tokenData.trim().isEmpty()) {
                token = new Token(tokenData);
                token.setPosition(position);
                token.setLineNumber(lineNumber);
                tokens.add(token);
            }
            position += tokenData.length();
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    private static LineType determineLineType(String line, LineType lastLineType, boolean freeForm) {
        LineType type = LineType.Empty;
        if (line.length() < 6) {
            type = lastLineType == LineType.FreeFormStart || lastLineType == LineType.FreeForm ? LineType.FreeForm : (lastLineType == LineType.IledocsStart || lastLineType == LineType.Iledocs ? LineType.Iledocs : (freeForm ? LineType.FreeForm : LineType.Empty));
        } else if (line.length() >= 8 && line.substring(5, 8).equals("/**")) {
            type = LineType.IledocsStart;
        } else if (line.length() >= 8 && line.substring(6, 8).equals("*/")) {
            type = LineType.IledocsEnd;
        } else if (line.length() >= 7 && line.charAt(6) == '*') {
            type = lastLineType == LineType.IledocsStart || lastLineType == LineType.Iledocs ? LineType.Iledocs : LineType.Comment;
        } else if (line.length() >= 6 && line.charAt(5) == ' ' && line.substring(6).trim().startsWith("//")) {
            type = LineType.Comment;
        } else if (line.length() >= 6 && line.charAt(5) == 'H') {
            type = LineType.Header;
        } else if (line.length() >= 6 && line.charAt(5) == 'F') {
            type = LineType.File;
        } else if (line.length() >= 6 && line.charAt(5) == 'D') {
            type = LineType.Declaration;
        } else if (line.length() >= 6 && line.charAt(5) == 'I') {
            type = LineType.Input;
        } else if (line.length() >= 6 && line.charAt(5) == 'O') {
            type = LineType.Output;
        } else if (line.length() >= 6 && line.charAt(5) == 'P') {
            type = LineType.Procedure;
        } else if (line.length() >= 6 && line.charAt(5) == 'C') {
            type = LineType.Calculation;
        } else if (line.length() >= 11 && line.substring(6, 11).equals("/COPY")) {
            type = LineType.Copy;
        } else if (freeForm && line.trim().startsWith("/COPY")) {
            type = LineType.Copy;
        } else if (line.length() >= 14 && line.substring(6, 14).equals("/INCLUDE")) {
            type = LineType.Include;
        } else if (freeForm && line.trim().startsWith("/INCLUDE")) {
            type = LineType.Include;
        } else if (line.length() >= 11 && line.substring(6, 11).equals("/FREE")) {
            type = LineType.FreeFormStart;
        } else if (line.length() >= 15 && line.substring(6, 15).equals("/END-FREE")) {
            type = LineType.FreeFormEnd;
        } else if (line.length() >= 8 && line.substring(5, 7).equals(" /") && line.charAt(7) != '/') {
            type = LineType.CompilerDirective;
        } else if (line.trim().length() >= 8 && !line.substring(7).startsWith("//")) {
            type = LineType.FreeForm;
        } else if (lastLineType == LineType.FreeFormStart || lastLineType == LineType.FreeForm) {
            type = LineType.FreeForm;
        } else if (freeForm) {
            type = LineType.FreeForm;
        } else if (line.length() >= 8 && !line.substring(8).trim().isEmpty()) {
            type = LineType.FreeForm;
        }
        return type;
    }
}

