/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ast.rpg.tokenizer;

import java.util.ArrayList;
import java.util.Iterator;
import miworkplace.ast.rpg.tokenizer.LineType;
import miworkplace.ast.rpg.tokenizer.Token;

public class Line {
    private ArrayList<Token> tokens = new ArrayList();
    private LineType type = LineType.Empty;
    private int lineNumber = -1;
    private String data = "";

    public Line() {
    }

    public Line(int lineNumber) {
        this.setLineNumber(lineNumber);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void addToken(Token token) {
        this.tokens.add(token);
    }

    public void removeToken(Token token) {
        this.tokens.remove(token);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setLineType(LineType type) {
        this.type = type;
    }

    public LineType getLineType() {
        return this.type;
    }

    public Token getTokenAtPosition(int pos) {
        for (Token token : this.tokens) {
            if (!token.occupiesPosition(pos)) continue;
            return token;
        }
        return null;
    }

    public int count() {
        return this.tokens.size();
    }

    public Iterator iterator() {
        return this.tokens.iterator();
    }
}

