/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.markdown.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class EmphasisRule
implements IRule {
    private static char[][] fDelimiters = null;
    private char[] fSequence;
    protected IToken fToken;

    public EmphasisRule(String marker, IToken token) {
        assert (marker.equals("*") || marker.equals("_") || marker.equals("**") || marker.equals("***") || marker.equals("`") || marker.equals("``"));
        Assert.isNotNull((Object)token);
        this.fSequence = marker.toCharArray();
        this.fToken = token;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c != sequence[i]) {
                int j = i;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        scanner.unread();
        boolean sawSpaceBefore = Character.isWhitespace(scanner.read());
        if (!sawSpaceBefore && scanner.getColumn() != 0) {
            return Token.UNDEFINED;
        }
        int c = scanner.read();
        if (c != this.fSequence[0] || !this.sequenceDetected(scanner, this.fSequence, false)) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        int readCount = this.fSequence.length;
        if (fDelimiters == null) {
            fDelimiters = scanner.getLegalLineDelimiters();
        }
        int delimiterFound = 0;
        if (sawSpaceBefore) {
            boolean after = Character.isWhitespace(scanner.read());
            scanner.unread();
            if (after) {
                delimiterFound = 2;
            }
        }
        while (delimiterFound < 2 && (c = scanner.read()) != -1) {
            ++readCount;
            if (!sawSpaceBefore && c == this.fSequence[0] && this.sequenceDetected(scanner, this.fSequence, false)) {
                return this.fToken;
            }
            int i = 0;
            while (i < fDelimiters.length) {
                if (c == fDelimiters[i][0] && this.sequenceDetected(scanner, fDelimiters[i], true)) {
                    ++delimiterFound;
                    break;
                }
                ++i;
            }
            if (i == fDelimiters.length) {
                delimiterFound = 0;
            }
            sawSpaceBefore = Character.isWhitespace(c);
        }
        while (readCount > 0) {
            scanner.unread();
            --readCount;
        }
        return Token.UNDEFINED;
    }
}

