/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.markdown.handler;

import jakarta.inject.Inject;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.markdown.CheatSheet;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ShowCheatSheetHandler {
    @Inject
    private MApplication application;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;

    @Execute
    public void execute() {
        MPart part = this.getVisibleCheatSheet();
        if (part == null) {
            part = this.createPart();
        }
        part = this.partService.showPart(part, EPartService.PartState.ACTIVATE);
    }

    private MPart getVisibleCheatSheet() {
        for (MPart part : this.partService.getParts()) {
            if (part.getObject() == null || !(part.getObject() instanceof CheatSheet)) continue;
            return part;
        }
        return null;
    }

    private MPart createPart() {
        String partDescriptorId = "miworkplace.ui.editor.markdown.partdescriptor.cheatsheet";
        String contributionURI = "bundleclass://miworkplace.ui.editor.markdown/miworkplace.ui.editor.markdown.CheatSheet";
        MPart part = this.partService.createPart(partDescriptorId);
        part.setLabel(Messages.markdown_cheatsheet_part_title);
        part.setContributionURI(contributionURI);
        part.getTags().add("removeOnHide");
        MPartStack partStack = (MPartStack)this.modelService.find("miworkplace.right", (MUIElement)this.application);
        partStack.getChildren().add(part);
        return part;
    }
}

