/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.log;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class ApplicationLogListener
implements LogListener,
EventHandler {
    private static final String LOG_LEVEL_ERROR = "ERROR";
    private static final String LOG_LEVEL_WARN = "WARN ";
    private static final String LOG_LEVEL_INFO = "INFO ";
    private static final String LOG_LEVEL_DEBUG = "DEBUG";
    private static final String[] LOG_LEVELS = new String[]{"ERROR", "WARN ", "INFO ", "DEBUG"};
    private final String logName = ".application.log";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String expression = "miworkplace.*";
    private final Pattern p = Pattern.compile("miworkplace.*");
    private int logLevel = 3;
    private Scope scope = Scope.application;
    private File file;
    private FileWriter writer;
    private String lineSeparator = System.getProperty("line.separator");
    private boolean open = false;

    public void activate() {
        this.logLevel = Platform.inDebugMode() ? 4 : 1;
        URL workspaceLocation = Platform.getInstanceLocation().getURL();
        try {
            this.file = new File(workspaceLocation.getPath() + File.separator + ".metadata/.application.log");
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            this.logRotate();
            this.writer = new FileWriter(this.file);
            this.open = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deactivate() {
        this.close();
    }

    private void close() {
        if (!this.open) {
            return;
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.open = false;
    }

    public void bindLogReader(LogReaderService logReader) {
        logReader.addLogListener((LogListener)this);
    }

    public void unbindLogReader(LogReaderService logReader) {
        logReader.removeLogListener((LogListener)this);
    }

    public void logged(LogEntry entry) {
        if (!this.isLoggable(entry)) {
            return;
        }
        String message = this.formatLogTime(entry.getTime()) + " " + this.formatLogLevel(entry.getLevel()) + " - " + entry.getBundle().getSymbolicName() + " - " + entry.getMessage();
        if (entry.getServiceReference() != null) {
            message = message + " - [ " + this.getServiceInfo(entry) + " ]";
        }
        this.output(message);
    }

    private String getServiceInfo(LogEntry entry) {
        String info;
        ServiceReference reference = entry.getServiceReference();
        if (reference.getProperty("component.id") == null) {
            info = reference.getClass().getName() + " (" + String.valueOf(reference.getProperty("service.id")) + ")";
        } else {
            String[] classNames = (String[])reference.getProperty("objectClass");
            info = classNames[0] + " (" + String.valueOf(reference.getProperty("component.id")) + ") \"" + String.valueOf(reference.getProperty("component.name")) + "\"";
        }
        return info;
    }

    private void output(String message) {
        try {
            this.writer.write(message + this.lineSeparator);
            this.writer.flush();
        }
        catch (IOException iOException) {
            System.err.println("Error writing log entry. Probably outputstream already closed.");
            System.err.println("Not logged entry: " + message);
        }
    }

    private String formatLogTime(long time) {
        return this.dateFormat.format(new Date(time));
    }

    private String formatLogLevel(int logLevel) {
        return LOG_LEVELS[--logLevel];
    }

    private boolean isLoggable(LogEntry entry) {
        if (!this.open) {
            return false;
        }
        if (this.logLevel < entry.getLevel()) {
            return false;
        }
        return this.scope != Scope.application || this.p.matcher(entry.getBundle().getSymbolicName()).matches();
    }

    public void logRotate() {
        if (this.file.exists() && this.file.length() > 0L) {
            File backup = new File(this.file.getAbsolutePath() + ".bak");
            if (backup.exists()) {
                backup.delete();
            }
            try {
                backup.createNewFile();
                FileWriter out = new FileWriter(backup);
                IOUtils.copy((Reader)new FileReader(this.file), (Writer)out);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void handleEvent(Event event) {
        this.close();
    }

    private static enum Scope {
        all,
        application;

    }
}

