/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.handler;

import jakarta.inject.Inject;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.spools.SpooledFilesPart;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;

public class ShowUserSpooledFilesHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IActiveConnectionService connectionService;

    @CanExecute
    public boolean canExecute(MPart part, MToolItem toolItem) {
        SpooledFilesPart view = (SpooledFilesPart)part.getObject();
        boolean userFilter = view.isUserFilter();
        if (userFilter) {
            toolItem.setIconURI("platform:/plugin/miworkplace.images/icons/users.png");
            toolItem.setTooltip("Showing all spooled files. Click to toggle.");
        } else {
            toolItem.setIconURI("platform:/plugin/miworkplace.images/icons/user.png");
            toolItem.setTooltip("Showing your spooled files. Click to toggle.");
        }
        return true;
    }

    @Execute
    public void run() {
        if (this.connectionService.getLastUsedActiveConnection() != null) {
            this.eventBroker.send("miworkplace/spools/user", (Object)this.connectionService.getLastUsedActiveConnection().getName());
        }
    }
}

