/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.handler;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.list.SpooledFileListItem;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Iterator;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.validator.ObjectPathValidator;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.spools.SpoolUtil;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class MoveSpoolHandler {
    private final String notifyTitle;
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext context;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IActiveConnectionService connectionService;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IConnectionUtilities connUtilFacade;

    public MoveSpoolHandler() {
        this.notifyTitle = Messages.spools_handler_move_notify_title;
    }

    @Execute
    public void run(@Named(value="activeShell") Shell shell) {
        Object selection = this.selectionService.getSelection("miworkplace.spools.part");
        if (selection != null) {
            IConnection activeConnection = this.connectionService.getLastUsedActiveConnection();
            if (activeConnection == null) {
                Notifier.notify((String)this.notifyTitle, (String)Messages.spools_handler_move_conn_not_active, (Notifier.Type)Notifier.Type.DISCONNECTED, (boolean)true);
                return;
            }
            AS400 system = activeConnection.getSystem();
            InputDialog dialog = new InputDialog(shell, Messages.spools_handler_move_input_title, Messages.spools_handler_move_input_prompt, null, (IInputValidator)ContextInjectionFactory.make(ObjectPathValidator.class, (IEclipseContext)this.context));
            if (dialog.open() == 0) {
                String[] qparts = dialog.getValue().toUpperCase().split("/");
                if (qparts.length == 2) {
                    QSYSObjectPathName qname = new QSYSObjectPathName(qparts[0], qparts[1], "OUTQ");
                    OutputQueue queue = new OutputQueue(system, qname.getPath());
                    if (this.connUtilFacade.doesObjectExist(activeConnection, qname.getPath())) {
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        Iterator iterator = ss.iterator();
                        while (iterator.hasNext()) {
                            SpooledFile spool = SpoolUtil.toSpoolFile(this.connectionService.getLastUsedActiveConnection().getSystem(), (SpooledFileListItem)iterator.next());
                            try {
                                spool.move(queue);
                            }
                            catch (Exception e) {
                                String message = "Could not move spooled file " + spool.getName() + ". Error: " + e.getMessage();
                                this.logger.error(message, (Throwable)e);
                            }
                        }
                        this.eventBroker.send("miworkplace/spools/update", new Object());
                    } else {
                        Notifier.error((String)this.notifyTitle, (String)String.format(Messages.spools_handler_move_no_outqueue, dialog.getValue()));
                    }
                } else {
                    String message = "The user entered an invalid output queue: " + dialog.getValue();
                    this.logger.error(message, (Throwable)new Exception(message));
                    Notifier.error((String)this.notifyTitle, (String)String.format(Messages.spools_handler_move_invalid_path, dialog.getValue()));
                }
            }
        }
    }
}

