/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.spools.handler;

import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.list.SpooledFileListItem;
import jakarta.inject.Inject;
import java.util.Iterator;
import miworkplace.common.debug.Debug;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.spools.SpoolUtil;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;

public class HoldSpoolHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IActiveConnectionService connection;

    @Execute
    public void run() {
        Object selection = this.selectionService.getSelection("miworkplace.spools.part");
        if (selection != null) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iterator = ss.iterator();
            while (iterator.hasNext()) {
                SpooledFile spool = SpoolUtil.toSpoolFile(this.connection.getLastUsedActiveConnection().getSystem(), (SpooledFileListItem)iterator.next());
                try {
                    if (spool.getStringAttribute(106).equals("*HELD")) {
                        Notifier.info((String)Messages.spools_handler_hold_dialog_title, (String)String.format(Messages.spools_handler_hold_already_held, this.getName(spool)));
                        continue;
                    }
                    spool.hold("*IMMED");
                }
                catch (Exception e) {
                    String message = "Could not set spooled file " + this.getName(spool) + " on hold. Error: " + e.getMessage();
                    this.logger.error(message, (Throwable)e);
                    Notifier.warn((String)Messages.spools_handler_hold_dialog_title, (String)String.format(Messages.spools_handler_hold_error, this.getName(spool)));
                }
            }
            this.eventBroker.send("miworkplace/spools/update", new Object());
        }
    }

    private String getName(SpooledFile spooledFile) {
        return spooledFile.getName() + " (" + spooledFile.getJobName() + "/" + spooledFile.getJobNumber() + "/" + spooledFile.getJobUser() + ")";
    }
}

