/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RuntimeSystemManager {
    private static HashMap<String, HashMap<String, HashMap<String, Object>>> fUsersMap = new HashMap();

    private RuntimeSystemManager() {
    }

    public static void saveSystem(Object pSystem, String pUser, String pCategory, String pUrl) {
        HashMap<String, Object> systemMap;
        if (pSystem == null) {
            throw new IllegalArgumentException("Failed to save the system: No system is provided.");
        }
        if (pUser == null || pUser.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to save the system: No user is provided.");
        }
        if (pCategory == null || pCategory.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to save the system: No system category is provided.");
        }
        if (pUrl == null || pUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to save the system: No system URL is provided.");
        }
        pUser = pUser.trim();
        pCategory = pCategory.trim();
        pUrl = pUrl.trim();
        HashMap<String, HashMap<String, Object>> systemsMap = fUsersMap.get(pUser);
        if (systemsMap == null) {
            systemsMap = new HashMap();
        }
        if ((systemMap = systemsMap.get(pCategory)) == null) {
            systemMap = new HashMap();
        }
        systemMap.put(pUrl, pSystem);
        systemsMap.put(pCategory, systemMap);
        fUsersMap.put(pUser, systemsMap);
    }

    public static List<Object> getUserSystems(String pUser) {
        if (pUser == null || pUser.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to get the systems: No user is provided.");
        }
        ArrayList<Object> systems = new ArrayList<Object>();
        HashMap<String, HashMap<String, Object>> systemsMap = fUsersMap.get(pUser.trim());
        if (systemsMap != null) {
            for (String systemName : systemsMap.keySet()) {
                HashMap<String, Object> systemMap = systemsMap.get(systemName);
                if (systemMap == null) continue;
                systems.addAll(systemMap.values());
            }
        }
        return systems;
    }

    public static List<Object> getUserCategorySystems(String pUser, String pCategory) {
        HashMap<String, Object> systemMap;
        if (pUser == null || pUser.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to get the systems: No user is provided.");
        }
        if (pCategory == null || pCategory.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to get the systems: No system category is provided.");
        }
        pUser = pUser.trim();
        pCategory = pCategory.trim();
        ArrayList<Object> systems = new ArrayList<Object>();
        HashMap<String, HashMap<String, Object>> systemsMap = fUsersMap.get(pUser);
        if (systemsMap != null && (systemMap = systemsMap.get(pCategory)) != null) {
            systems.addAll(systemMap.values());
        }
        return systems;
    }

    public static Object getSystem(String pUser, String pCategory, String pUrl) {
        HashMap<String, Object> systemMap;
        if (pUser == null || pUser.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to get the system: No user is provided.");
        }
        if (pCategory == null || pCategory.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to get the system: No system category is provided.");
        }
        if (pUrl == null || pUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to get the system: No system URL is provided.");
        }
        pUser = pUser.trim();
        pCategory = pCategory.trim();
        pUrl = pUrl.trim();
        Object system = null;
        HashMap<String, HashMap<String, Object>> systemsMap = fUsersMap.get(pUser.trim());
        if (systemsMap != null && (systemMap = systemsMap.get(pCategory.trim())) != null) {
            system = systemMap.get(pUrl);
        }
        return system;
    }

    public static void deleteUser(String pUser) {
        if (pUser == null || pUser.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to delete the user systems: No user is provided.");
        }
        fUsersMap.remove(pUser.trim());
    }

    public static void deleteUserSystemCategory(String pUser, String pCategory) {
        if (pUser == null || pUser.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to delete the user's system category: No user is provided.");
        }
        if (pCategory == null || pCategory.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to delete the user's system category: No system category is provided.");
        }
        pUser = pUser.trim();
        pCategory = pCategory.trim();
        HashMap<String, HashMap<String, Object>> systemsMap = fUsersMap.get(pUser);
        if (systemsMap != null) {
            systemsMap.remove(pCategory);
            fUsersMap.put(pUser, systemsMap);
        }
    }

    public static void deleteSystem(String pUser, String pCategory, String pUrl) {
        HashMap<String, Object> systemMap;
        if (pUser == null || pUser.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to delete the system: No user is provided.");
        }
        if (pCategory == null || pCategory.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to delete the system: No system category is provided.");
        }
        if (pUrl == null || pUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Failed to delete the system: No system URL is provided.");
        }
        pUser = pUser.trim();
        pCategory = pCategory.trim();
        pUrl = pUrl.trim();
        HashMap<String, HashMap<String, Object>> systemsMap = fUsersMap.get(pUser);
        if (systemsMap != null && (systemMap = systemsMap.get(pCategory)) != null) {
            systemMap.remove(pUrl);
            systemsMap.put(pCategory, systemMap);
            fUsersMap.put(pUser, systemsMap);
        }
    }
}

