/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.CommonConstants;
import com.remainsoftware.common.util.EmailUtils;
import com.remainsoftware.common.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static final String HEX_CHARS = "0123456789ABCDEFabcdef";
    private static final String HEX_CHARS_LOWERCASE = "0123456789abcdef";
    private static final char[] HEX_CHARS_LOWERCASE_ASBYTE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Charset asciiCharset = null;
    private static CharsetDecoder asciiDecoder = null;
    private static RuleBasedCollator EBCDICCollator;
    public static final Pattern STRIP_MULTISPACE;
    public static final Pattern STRIP_ALLEMPTYLINES;
    public static final Pattern STRIP_MULTIEMPTYLINES;
    private static final Logger logger;
    private static final String NON_THIN = "[^iIl1\\.,']";

    static {
        STRIP_MULTISPACE = Pattern.compile("\\s+");
        STRIP_ALLEMPTYLINES = Pattern.compile("\\s*^\\s*$\\s*", 8);
        STRIP_MULTIEMPTYLINES = Pattern.compile("^\\s*$\\n", 8);
        logger = LoggerFactory.getLogger(StringUtils.class);
        asciiCharset = StandardCharsets.UTF_8;
        asciiDecoder = asciiCharset.newDecoder();
    }

    protected StringUtils() {
    }

    private static int textWidth(String str) {
        if (str == null) {
            return 0;
        }
        return str.length() - str.replaceAll(NON_THIN, "").length() / 2;
    }

    public static String truncate(String message, int size) {
        if (message != null) {
            message = message.length() > size ? message.substring(0, size) : message;
        }
        return message;
    }

    public static String ellipsize(String text, int max) {
        if (text == null) {
            return "";
        }
        if (StringUtils.textWidth(text) <= max) {
            return text;
        }
        int end = text.lastIndexOf(32, max - 3);
        if (end == -1) {
            return String.valueOf(text.substring(0, max - 3)) + "...";
        }
        int newEnd = end;
        do {
            if ((newEnd = text.indexOf(32, (end = newEnd) + 1)) != -1) continue;
            newEnd = text.length();
        } while (StringUtils.textWidth(String.valueOf(text.substring(0, newEnd)) + "...") < max);
        return String.valueOf(text.substring(0, end)) + "...";
    }

    public static int toDjb2Hash(String string) {
        byte[] bytes;
        int hash = 5381;
        byte[] byArray = bytes = string.getBytes();
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte c = byArray[n2];
            hash = (hash << 5) + hash + c;
            ++n2;
        }
        return hash;
    }

    public static String toSHA256Hex(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(string.getBytes());
            byte[] byteData = md.digest();
            StringBuilder hexString = new StringBuilder();
            byte[] byArray = byteData;
            int n = byteData.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                String hex = Integer.toHexString(0xFF & element);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
                ++n2;
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean simpleMatchFilter(String match, String filter, boolean caseSensitive) {
        if (match == null || filter == null) {
            return false;
        }
        StringBuilder f = new StringBuilder();
        if (!caseSensitive) {
            f.append("(?i)");
        }
        StringTokenizer st = new StringTokenizer(filter, "?*", true);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals("?")) {
                f.append(".");
                continue;
            }
            if (t.equals("*")) {
                f.append(".*");
                continue;
            }
            f.append("\\Q" + t + "\\E");
        }
        return match.matches(f.toString());
    }

    public static String createRegexFromGlob(String glob) {
        StringBuilder out = new StringBuilder("^");
        int i = 0;
        while (i < glob.length()) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    break;
                }
                case '?': {
                    out.append('.');
                    break;
                }
                case '.': {
                    out.append("\\.");
                    break;
                }
                case '\\': {
                    out.append("\\\\");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        out.append('$');
        return out.toString();
    }

    public static String byteArray2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(HEX_CHARS_LOWERCASE_ASBYTE[(b & 0xF0) >> 4]);
            sb.append(HEX_CHARS_LOWERCASE_ASBYTE[b & 0xF]);
            ++n2;
        }
        return sb.toString();
    }

    public static boolean getBoolean(String st) {
        if (StringUtils.isEmpty(st)) {
            return false;
        }
        return st.equalsIgnoreCase(CommonConstants.BOOL_TRUE);
    }

    public static boolean getBoolean(String value, boolean defBool) {
        if (!StringUtils.isTrueOrFalse(value)) {
            return defBool;
        }
        return value.equalsIgnoreCase(CommonConstants.BOOL_TRUE);
    }

    public static boolean isEmpty(String st) {
        if (st == null || st.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < st.length()) {
            if (!Character.isWhitespace(st.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNotEmpty(String st) {
        if (st == null || st.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < st.length()) {
            if (!Character.isWhitespace(st.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmptyLines(String st) {
        if (st == null || st.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < st.length()) {
            if (!Character.isWhitespace(st.charAt(i)) && st.charAt(i) != '\n' && st.charAt(i) != '\r') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isTrueOrFalse(String st) {
        return !StringUtils.isEmpty(st) && (st.compareToIgnoreCase("true") == 0 || st.compareToIgnoreCase("false") == 0);
    }

    public static boolean isNumeric(String st) {
        if (st == null || st.length() == 0) {
            return false;
        }
        try {
            Long.parseLong(st);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isDigits(String st) {
        if (st == null || st.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < st.length()) {
            if (!Character.isDigit(st.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumber(String st) {
        if (st == null) {
            return false;
        }
        if ((st = st.trim()).length() == 0) {
            return false;
        }
        char firstCh = st.charAt(0);
        int i = 0;
        if (firstCh == '+' || firstCh == '-') {
            i = 1;
        }
        while (i < st.length()) {
            if (!Character.isDigit(st.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isHexString(String st) {
        if (st != null && st.length() > 0) {
            int ix = 0;
            while (ix < st.length()) {
                if (HEX_CHARS.indexOf(st.charAt(ix)) == -1) {
                    return false;
                }
                ++ix;
            }
            return true;
        }
        return false;
    }

    public static boolean isHexLowerCaseString(String st) {
        if (st != null && st.length() > 0) {
            int ix = 0;
            while (ix < st.length()) {
                if (HEX_CHARS_LOWERCASE.indexOf(st.charAt(ix)) == -1) {
                    return false;
                }
                ++ix;
            }
            return true;
        }
        return false;
    }

    public static boolean isSemanticVersionNumber(String version) {
        if (StringUtils.isEmpty(version)) {
            return false;
        }
        return version.matches("\\d+\\.\\d+\\.\\d+");
    }

    public static boolean isSimpleEmailAddress(String emailAddress) {
        if (StringUtils.isEmpty(emailAddress)) {
            return false;
        }
        return EmailUtils.isSimpleEmailAddress(emailAddress);
    }

    public static String getLastSegment(String string, String separator) {
        if (string == null || separator == null) {
            return "";
        }
        int index = string.lastIndexOf(separator);
        if (index == -1) {
            return string;
        }
        return string.substring(index + separator.length());
    }

    public static String getFirstSegment(String string, String separator) {
        if (string == null || separator == null || separator.length() > 1) {
            return "";
        }
        int index = string.indexOf(separator);
        if (index == -1) {
            return "";
        }
        return string.substring(0, index);
    }

    /*
     * Unable to fully structure code
     */
    public static String getFirstSegment(String path) {
        if (path != null) ** GOTO lbl4
        return "";
lbl-1000:
        // 1 sources

        {
            path = path.substring(1);
lbl4:
            // 2 sources

            ** while (path.length() > 0 && path.startsWith((String)"/") || path.startsWith((String)"\\"))
        }
lbl5:
        // 1 sources

        index = StringUtils.getIndexOfFirstSeparator(path);
        if (index == -1) {
            return "";
        }
        return path.substring(0, index);
    }

    public static String getLastSegment(String string) {
        if (string == null) {
            return "";
        }
        int index = StringUtils.getIndexOfLastSeparator(string);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1);
    }

    public static String removeFirstSegment(String string) {
        return StringUtils.removeFirstSegment(string, null);
    }

    public static String removeFirstSegment(String string, String pathSeparator) {
        int index1;
        if (string == null) {
            return string;
        }
        string = string.trim();
        int stripTo = 0;
        int len = string.length();
        if (pathSeparator == null || pathSeparator.isEmpty()) {
            pathSeparator = StringUtils.getSeparator(string);
        }
        if ((index1 = string.indexOf(pathSeparator)) != -1) {
            if (index1 > 0) {
                stripTo = index1 + 1;
            } else if (++index1 < len) {
                int index2 = string.indexOf(pathSeparator, index1);
                stripTo = index2 == -1 ? index1 : index2 + 1;
            }
        }
        if (stripTo == 0 || stripTo >= len) {
            return "";
        }
        return string.substring(stripTo);
    }

    public static String removeLastSegment(String string, String separator) {
        if (string == null || separator == null) {
            return string;
        }
        int index = string.lastIndexOf(separator);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index);
    }

    public static String removeLastSegment(String string) {
        if (string == null) {
            return string;
        }
        int index = StringUtils.getIndexOfLastSeparator(string);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index);
    }

    public static String asFullPath(String path) {
        if (path == null) {
            return path;
        }
        if (CommonConstants.IS_OS_WINDOWS) {
            while (path.startsWith("/") || path.startsWith("\\")) {
                path = path.substring(1);
            }
        }
        path = StringUtils.asPath(path);
        return path;
    }

    /*
     * Unable to fully structure code
     */
    public static String asPath(String path) {
        if (path != null) ** GOTO lbl4
        return path;
lbl-1000:
        // 1 sources

        {
            path = path.substring(0, path.length() - CommonConstants.FILE_SEPARATOR.length());
lbl4:
            // 2 sources

            ** while (path.endsWith((String)"/") || path.endsWith((String)"\\"))
        }
lbl5:
        // 1 sources

        return path;
    }

    /*
     * Unable to fully structure code
     */
    public static String asSubPath(String path) {
        if (path != null) ** GOTO lbl4
        return path;
lbl-1000:
        // 1 sources

        {
            path = path.substring(1);
lbl4:
            // 2 sources

            ** while ((path.startsWith((String)"/") || path.startsWith((String)"\\")) && path.length() > 1)
        }
lbl5:
        // 1 sources

        return path;
    }

    public static String addPathSeparator(String path) {
        String pathSeparator;
        if (path == null) {
            return path;
        }
        String aPath = path.trim();
        if (aPath.endsWith(pathSeparator = StringUtils.getSeparator(aPath))) {
            return aPath;
        }
        return String.valueOf(aPath) + pathSeparator;
    }

    public static String addPath(String basePath, String path) {
        String pathSeparator;
        if (basePath == null) {
            return null;
        }
        if (StringUtils.isEmpty(path)) {
            return basePath;
        }
        path = path.trim();
        while (path.length() >= 1 && (path.startsWith("/") || path.startsWith("\\"))) {
            path = path.substring(1);
        }
        if ((basePath = basePath.trim()).endsWith(pathSeparator = StringUtils.getSeparator(basePath))) {
            return String.valueOf(basePath) + path;
        }
        return String.valueOf(basePath) + pathSeparator + path;
    }

    public static String toOSPath(String path) {
        if (path == null) {
            return path;
        }
        if (CommonConstants.IS_OS_WINDOWS) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    public static String toNonOSPath(String path) {
        if (path == null) {
            return path;
        }
        return path.replace('\\', '/').replaceAll("/{2,}", "/");
    }

    public static boolean isRootPath(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 1 && (path.startsWith("/") || path.startsWith("\\"))) {
            return true;
        }
        return CommonConstants.IS_OS_WINDOWS && path.length() <= 3 && path.contains(":");
    }

    public static String appendPath(String prefix, String suffix) {
        if (prefix == null) {
            return suffix != null ? suffix : "";
        }
        String pathSeparator = StringUtils.getSeparator(prefix);
        if (prefix.length() == 0) {
            return suffix;
        }
        if (prefix.endsWith(pathSeparator)) {
            if (suffix.startsWith(pathSeparator)) {
                return String.valueOf(prefix) + suffix.substring(1);
            }
            return String.valueOf(prefix) + suffix;
        }
        if (suffix.startsWith(pathSeparator)) {
            return String.valueOf(prefix) + suffix;
        }
        return String.valueOf(prefix) + pathSeparator + suffix;
    }

    public static String replaceFirst(String stringIn, String findStr, String replStr) {
        if (stringIn == null) {
            return null;
        }
        if (findStr == null || replStr == null || findStr.length() == 0) {
            return stringIn;
        }
        Pattern regex = Pattern.compile(findStr);
        Matcher match = regex.matcher(stringIn);
        return match.replaceFirst(replStr);
    }

    public static String replaceAll(String stringIn, String findStr, String replStr) {
        if (stringIn == null) {
            return null;
        }
        if (findStr == null || replStr == null || findStr.length() == 0) {
            return stringIn;
        }
        Pattern regex = Pattern.compile(findStr);
        Matcher match = regex.matcher(stringIn);
        String strOut = match.replaceAll(replStr);
        return strOut;
    }

    public static String replace(String stringIn, String findStr, String replStr) {
        if (stringIn == null) {
            return null;
        }
        if (findStr == null || replStr == null || findStr.length() == 0) {
            return stringIn;
        }
        StringBuffer sb = new StringBuffer(stringIn.length());
        int start = 0;
        int end = 0;
        while ((end = stringIn.indexOf(findStr, start)) != -1) {
            sb.append(stringIn.substring(start, end)).append(replStr);
            start = end + findStr.length();
        }
        sb.append(stringIn.substring(start));
        return sb.toString();
    }

    private static String concatenateIntoString(String[] strings, int first, int last, String quote, String delimiter) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return "";
        }
        if (first < 0) {
            first = 0;
        }
        if (last < 0) {
            last = strings.length;
        }
        if (quote == null) {
            quote = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuffer result = new StringBuffer();
        int trueLast = last >= strings.length ? strings.length - 1 : last;
        boolean haveDelimiter = delimiter.length() > 0;
        int index = first;
        while (index <= trueLast) {
            result.append(String.valueOf(quote) + strings[index] + quote);
            if (index != last && haveDelimiter) {
                result.append(delimiter);
            }
            ++index;
        }
        return result.toString();
    }

    public static String concatenateIntoString(String[] strings, int first, int last, String delimiter) {
        return StringUtils.concatenateIntoString(strings, first, last, "", delimiter);
    }

    public static String concatenateIntoString(String[] strings) {
        return StringUtils.concatenateIntoString(strings, 0, strings.length, "'", " ");
    }

    public static String concatenateIntoString(String[] strings, String quote) {
        return StringUtils.concatenateIntoString(strings, 0, strings.length, quote, " ");
    }

    public static String concatenateIntoString(String[] strings, String quote, String delimiter) {
        return StringUtils.concatenateIntoString(strings, 0, strings.length, quote, delimiter);
    }

    public String pad(int pLen, String pInput) {
        if (pInput.length() >= pLen) {
            return pInput.substring(0, pLen);
        }
        StringBuilder builder = new StringBuilder(pInput);
        int i = pInput.length();
        while (i < pLen) {
            builder.append(" ");
            ++i;
        }
        return builder.toString();
    }

    public static String[] parseIntoSubstrings(String string, String delimiter) {
        String next;
        if (string == null || string.length() == 0 || delimiter == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int index = string.indexOf(delimiter);
        while (index != -1) {
            next = string.substring(start, index);
            result.add(next);
            start = index + 1;
            index = string.indexOf(delimiter, start);
        }
        next = start >= string.length() ? "" : string.substring(start);
        result.add(next);
        return result.toArray(new String[result.size()]);
    }

    public static String getSubstring(byte[] bytes, byte delimiter, int index, boolean includeRest) {
        if (bytes == null) {
            return "";
        }
        byte[] bytesForSlot = StringUtils.getBytesForSlot(bytes, delimiter, index, includeRest);
        if (bytesForSlot == null) {
            return "";
        }
        return new String(bytesForSlot);
    }

    public static int getOffsetOfDelimeter(byte[] bytes, byte delimiter, int start, int n) {
        if (bytes != null) {
            int count = 0;
            int i = start;
            while (i < bytes.length) {
                if (bytes[i] == delimiter) {
                    ++count;
                }
                if (count == n) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static byte[] getBytesForSlot(byte[] bytes, byte delimiter, int index, boolean includeRest) {
        int start;
        if (index == 0) {
            start = -1;
        } else {
            start = StringUtils.getOffsetOfDelimeter(bytes, delimiter, 0, index);
            if (start == -1) {
                return null;
            }
        }
        int end = StringUtils.getOffsetOfDelimeter(bytes, delimiter, start + 1, 1);
        int length = end == -1 || includeRest ? bytes.length - start - 1 : end - start - 1;
        byte[] result = new byte[length];
        System.arraycopy(bytes, start + 1, result, 0, length);
        return result;
    }

    public static boolean equals(byte[] syncBytes, byte[] oldBytes) {
        if (syncBytes.length != oldBytes.length) {
            return false;
        }
        int i = 0;
        while (i < oldBytes.length) {
            if (oldBytes[i] != syncBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean matchesPattern(String sString, String sPattern, boolean bCaseSensitive) {
        return StringUtils.matchesPattern(sString, sPattern, 0, 0, bCaseSensitive);
    }

    public static boolean matchesPattern(String sString, String sPattern) {
        return StringUtils.matchesPattern(sString, sPattern, true);
    }

    public static String expandTabs(String string, int nTabSize) {
        if (string == null) {
            return null;
        }
        if (nTabSize <= 0) {
            return string;
        }
        boolean bHasTabs = false;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '\t') {
                bHasTabs = true;
                break;
            }
            ++i;
        }
        if (!bHasTabs) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(string.length() + 20);
        int nChar = 0;
        while (nChar < string.length()) {
            char c = string.charAt(nChar);
            if (c == '\t') {
                int nNumSpaces = (buffer.length() / nTabSize + 1) * nTabSize - buffer.length();
                int j = 0;
                while (j < nNumSpaces) {
                    buffer.append(' ');
                    ++j;
                }
            } else {
                buffer.append(c);
            }
            ++nChar;
        }
        return buffer.toString();
    }

    public static String appendWithSpaces(String string, int count) {
        return StringUtils.appendWithChar(string, ' ', count);
    }

    public static String appendWithChar(String string, char c, int count) {
        if (string == null) {
            return null;
        }
        if (count <= 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(string.length() + count);
        buffer.append(string);
        int ix = 0;
        while (ix < count) {
            buffer.append(c);
            ++ix;
        }
        return buffer.toString();
    }

    public static char getSeparatorAsChar(String path) {
        int index;
        char pathSeparator = '/';
        if (path != null && (index = StringUtils.getIndexOfFirstSeparator(path)) != -1) {
            pathSeparator = path.charAt(index);
        }
        return pathSeparator;
    }

    public static String getSeparator(String path) {
        int index;
        char pathSeparator = '/';
        if (path != null && (index = StringUtils.getIndexOfFirstSeparator(path)) != -1) {
            pathSeparator = path.charAt(index);
        }
        return String.valueOf(pathSeparator);
    }

    private static int getIndexOfFirstSeparator(String path) {
        int index = path.indexOf("/");
        if (index == -1) {
            index = path.indexOf("\\");
        }
        return index;
    }

    private static int getIndexOfLastSeparator(String path) {
        int index = path.lastIndexOf("/");
        if (index == -1) {
            index = path.lastIndexOf("\\");
        }
        return index;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean matchesPattern(String sString, String sPattern, int nStringIndex, int nPatternIndex, boolean bCaseSensitive) {
        nPatternLength = sPattern.length();
        nStringLength = sString.length();
        while (true) {
            block16: {
                if (nPatternIndex >= nPatternLength) {
                    return nStringIndex >= nStringLength;
                }
                if (nStringIndex >= nStringLength && sPattern.charAt(nPatternIndex) != '*') {
                    return false;
                }
                if (sPattern.charAt(nPatternIndex) == '*') {
                    if (++nPatternIndex >= nPatternLength) {
                        return true;
                    }
                    while (true) {
                        if (StringUtils.matchesPattern(sString, sPattern, nStringIndex, nPatternIndex, bCaseSensitive)) {
                            return true;
                        }
                        if (nStringIndex >= nStringLength) {
                            return false;
                        }
                        ++nStringIndex;
                    }
                }
                if (sPattern.charAt(nPatternIndex) == '?') {
                    ++nPatternIndex;
                    ++nStringIndex;
                    continue;
                }
                if (sPattern.charAt(nPatternIndex) != '[') break block16;
                ++nPatternIndex;
                while (true) {
                    block17: {
                        if (nPatternIndex >= nPatternLength || sPattern.charAt(nPatternIndex) == ']') {
                            return false;
                        }
                        if (StringUtils.areCharsEqual(sPattern.charAt(nPatternIndex), sString.charAt(nStringIndex), bCaseSensitive)) ** GOTO lbl41
                        if (nPatternIndex >= nPatternLength - 1 || sPattern.charAt(nPatternIndex + 1) != '-') break block17;
                        if (nPatternIndex >= nPatternLength - 2) {
                            return false;
                        }
                        c = sString.charAt(nStringIndex);
                        if (StringUtils.isCharInRange(c, cRangeStart = sPattern.charAt(nPatternIndex), cRangeEnd = sPattern.charAt(nPatternIndex + 2), bCaseSensitive)) ** GOTO lbl41
                        nPatternIndex += 2;
                    }
                    ++nPatternIndex;
                }
lbl-1000:
                // 1 sources

                {
                    if (nPatternIndex >= nPatternLength) {
                        --nPatternIndex;
                        break;
                    }
                    ++nPatternIndex;
lbl41:
                    // 3 sources

                    ** while (sPattern.charAt((int)nPatternIndex) != ']')
                }
lbl42:
                // 2 sources

                ++nPatternIndex;
                ++nStringIndex;
                continue;
            }
            if (sPattern.charAt(nPatternIndex) == '\\' && ++nPatternIndex >= nPatternLength) {
                return false;
            }
            if (nPatternIndex < nPatternLength && nStringIndex < nStringLength && !StringUtils.areCharsEqual(sPattern.charAt(nPatternIndex), sString.charAt(nStringIndex), bCaseSensitive)) {
                return false;
            }
            ++nPatternIndex;
            ++nStringIndex;
        }
    }

    private static boolean areCharsEqual(char c1, char c2, boolean bCaseSensitive) {
        if (bCaseSensitive) {
            return c1 == c2;
        }
        return Character.toUpperCase(c1) == Character.toUpperCase(c2);
    }

    private static boolean isCharInRange(char c, char cRangeStart, char cRangeEnd, boolean bCaseSensitive) {
        if (!bCaseSensitive) {
            c = Character.toUpperCase(c);
            cRangeStart = Character.toUpperCase(cRangeStart);
            cRangeEnd = Character.toUpperCase(cRangeEnd);
        }
        if (cRangeEnd < cRangeStart) {
            char cTemp = cRangeStart;
            cRangeStart = cRangeEnd;
            cRangeEnd = cTemp;
        }
        return c >= cRangeStart && c <= cRangeEnd;
    }

    public static String trimRight(String string) {
        if (string == null) {
            return null;
        }
        int ix = string.length() - 1;
        while (ix >= 0 && string.charAt(ix) == ' ') {
            --ix;
        }
        if (ix < 0) {
            return "";
        }
        return string.substring(0, ix + 1);
    }

    public static String[] split(String string, char separator) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int pos = 0;
        LinkedList<String> list = new LinkedList<String>();
        int length = string.length();
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (ch == separator) {
                list.add(string.substring(pos, i));
                pos = i + 1;
            }
            ++i;
        }
        if (pos != length) {
            list.add(string.substring(pos, length));
        } else if (string.charAt(--pos) == separator) {
            list.add(string.substring(pos, pos));
        }
        return list.toArray(new String[0]);
    }

    public static String[] split(String string) {
        return StringUtils.split(string, null, -1);
    }

    public static String[] split(String string, String separator) {
        return StringUtils.split(string, separator, -1);
    }

    public static String[] split(String string, String separator, int max) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tok = null;
        tok = separator == null ? new StringTokenizer(string) : new StringTokenizer(string, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        while (tok.hasMoreTokens()) {
            if (max > 0 && i == listSize - 1) {
                StringBuffer buf = new StringBuffer(1 * string.length() * (listSize - i) / listSize);
                while (tok.hasMoreTokens()) {
                    buf.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    buf.append(separator);
                }
                list[i] = buf.toString();
                break;
            }
            list[i] = tok.nextToken();
            ++i;
        }
        return list;
    }

    public static String[] splitInChunks(String string, int chunkSize) {
        if (chunkSize <= 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int length = string.length();
        int i = 0;
        while (i < length) {
            result.add(string.substring(i, Math.min(length, i + chunkSize)));
            i += chunkSize;
        }
        return result.toArray(new String[result.size()]);
    }

    public static Collator getEBCDICCollator() {
        if (EBCDICCollator == null) {
            String changedRules = "<' '<'('<'='<';'<','<'<'<'&'<')'<':'<'.'<'_'<a<b<c<d<e<f<g<h<i<j<k<l<m<n<o<p<q<r<s<t<u<v<w<x<y<z<A<B<C<D<E<F<G<H<I<J<K<L<M<N<O<P<Q<R<S<T<U<V<W<X<Y<Z";
            try {
                EBCDICCollator = new RuleBasedCollator(changedRules);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return EBCDICCollator;
    }

    public static boolean isAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        return path.trim().startsWith("/") || path.trim().startsWith("\\");
    }

    public static String duplicateQuotes(String s) {
        return s.replaceAll("'", "''");
    }

    public static String convertAsciiToHex(String st) {
        Validate.isNotNull(st);
        byte[] bytes = st.getBytes();
        int sLen = bytes.length;
        StringBuffer sBuf = new StringBuffer(sLen * 2);
        int i = 0;
        while (i < sLen) {
            byte val = bytes[i];
            sBuf.append(HEX_CHARS.charAt((val & 0xF0) >> 4));
            sBuf.append(HEX_CHARS.charAt(val & 0xF));
            ++i;
        }
        return sBuf.toString();
    }

    public static String convertHexToAscii(String st) throws Exception {
        Validate.isNotNull(st);
        String asciiStr = "";
        CharBuffer charBuf = null;
        byte[] bytes = new byte[st.length() / 2];
        try {
            int i = 0;
            int j = 0;
            while (i < st.length()) {
                bytes[j] = (byte)Integer.parseInt(st.substring(i, i + 2), 16);
                i += 2;
                ++j;
            }
            ByteBuffer asciiBytes = ByteBuffer.wrap(bytes);
            charBuf = asciiDecoder.decode(asciiBytes);
        }
        catch (Exception e) {
            String msg = "error on converting hex string '" + st + "' to ascii , reason = " + e.getMessage();
            throw new Exception(msg, e);
        }
        if (charBuf != null) {
            asciiStr = charBuf.toString();
        }
        return asciiStr;
    }

    public static String reverse(String pString) {
        if (StringUtils.isNotEmpty(pString)) {
            return new StringBuffer(pString).reverse().toString();
        }
        return pString;
    }

    public static String removeSurroundingSquareBrackets(String st) {
        int lastBrPos;
        Validate.isNotNull(st);
        st = st.trim();
        int len = st.length();
        if (st.startsWith("[") && (lastBrPos = st.lastIndexOf("]")) > 0 && lastBrPos == len - 1) {
            st = st.substring(1, lastBrPos);
        }
        return st;
    }

    public static int countOccurrences(String st, char chr) {
        int count = 0;
        if (st != null) {
            int i = 0;
            while (i < st.length()) {
                if (st.charAt(i) == chr) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    public static String stripExtension(String st) {
        return st != null && st.lastIndexOf(".") > 0 ? st.substring(0, st.lastIndexOf(".")) : st;
    }

    public static String getFileExtension(String fileName) {
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static String removeSurroundingQuotes(String st) {
        if (st == null || st.length() == 0) {
            return st;
        }
        if (st.startsWith("\"")) {
            st = st.substring(1, st.length());
        }
        if (st.endsWith("\"")) {
            st = st.substring(0, st.length() - 1);
        }
        return st;
    }

    public static String removeQuotesOnQuoted(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length());
            string = string.substring(0, string.length() - 1);
        } else if (string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(1, string.length());
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String extractMessage(Exception e) {
        if (e == null) {
            return "null";
        }
        return e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : (e.getCause() != null ? (e.getCause().getMessage() != null && !e.getCause().getMessage().isEmpty() ? e.getCause().getMessage() : e.getClass().getSimpleName()) : e.getClass().getSimpleName());
    }

    public static String extractMessage(Throwable t) {
        if (t == null) {
            return "null";
        }
        return t.getMessage() != null && !t.getMessage().isEmpty() ? t.getMessage() : (t.getCause() != null ? (t.getCause().getMessage() != null && !t.getCause().getMessage().isEmpty() ? t.getCause().getMessage() : t.getClass().getSimpleName()) : t.getClass().getSimpleName());
    }

    public static String extractCompoundMessage(Exception e) {
        if (e == null) {
            return "null";
        }
        Throwable cause = e.getCause();
        Throwable causesCause = null;
        if (cause != null) {
            causesCause = cause.getCause();
        }
        return String.valueOf(StringUtils.extractMessage(e)) + (cause != null ? " [" + StringUtils.extractMessage(cause) + "]" : "") + (causesCause != null ? " [" + StringUtils.extractMessage(causesCause) + "]" : "");
    }

    public static String extractCompoundMessage(Throwable e) {
        if (e == null) {
            return "null";
        }
        return String.valueOf(StringUtils.extractMessage(e)) + (e.getCause() != null ? " (" + StringUtils.extractMessage(e.getCause()) + ")" : "");
    }

    public static String extractCauseMessage(Exception e) {
        if (e.getCause() != null) {
            return e.getCause().getMessage() != null ? e.getCause().getMessage() : e.getCause().getClass().getSimpleName();
        }
        return StringUtils.extractMessage(e);
    }

    public static String extractCauseMessage(Throwable e) {
        if (e.getCause() != null) {
            return e.getCause().getMessage() != null ? e.getCause().getMessage() : e.getCause().getClass().getSimpleName();
        }
        return StringUtils.extractMessage(e);
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static boolean isEqualIgnoreCase(String s1, String s2) {
        if (s1 == null || s2 == null || s1.length() != s2.length()) {
            return false;
        }
        char[] sa1 = s1.toCharArray();
        char[] sa2 = s2.toCharArray();
        int i = 0;
        while (i < s1.length()) {
            if (StringUtils.elevateCase(sa1[i]) != StringUtils.elevateCase(sa2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static char elevateCase(char c) {
        if (c < '\u0130' || c > '\u212b') {
            return Character.toUpperCase(c);
        }
        if (c == '\u0130' || c == '\u03f4' || c == '\u2126' || c >= '\u212a') {
            return Character.toUpperCase(Character.toLowerCase(c));
        }
        return Character.toUpperCase(c);
    }

    public static String toUpperCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] sa = new char[str.length()];
        char[] stra = str.toCharArray();
        int i = 0;
        while (i < stra.length) {
            sa[i] = StringUtils.elevateCase(stra[i]);
            ++i;
        }
        return String.valueOf(sa);
    }

    public static String join(String pDelimiter, Object[] pArray) {
        try {
            if (pArray.length > 0) {
                StringBuilder builder = new StringBuilder();
                Object[] objectArray = pArray;
                int n = pArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    builder.append(object).append(pDelimiter);
                    ++n2;
                }
                builder.delete(builder.length() - pDelimiter.length(), builder.length());
                return builder.toString();
            }
            return "";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String toDC(String domainName) {
        if (domainName == null || !domainName.contains(".")) {
            return domainName;
        }
        StringBuilder buf = new StringBuilder();
        String[] stringArray = domainName.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.length() != 0) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append("DC=").append(token);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static boolean isEqual(String pass, String string1, String string2) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] bytesStr1 = string1.getBytes();
        byte[] bytesStr2 = string2.getBytes();
        md.reset();
        md.update(bytesStr1);
        byte[] digest1 = md.digest(pass.getBytes());
        md.reset();
        md.update(bytesStr2);
        byte[] digest2 = md.digest(pass.getBytes());
        return MessageDigest.isEqual(digest1, digest2);
    }

    public static String locationNameToBasePath(String location) {
        Validate.isNotEmpty(location, "location-name must be set");
        return location.replaceAll("[:\\\\/*?|<> \"]", "_").replaceAll("_+", "_");
    }

    public static List<String> getOccurrences(String pString, String pRegex) {
        Pattern p = Pattern.compile(pRegex);
        Matcher m = p.matcher(pString);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            if (result.contains(m.group())) continue;
            result.add(m.group());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static String getFirstLogicalName(String path) {
        if (path != null && !path.isEmpty()) ** GOTO lbl4
        return "";
lbl-1000:
        // 1 sources

        {
            path = path.substring(1);
lbl4:
            // 2 sources

            ** while (path.startsWith((String)"\\") || path.startsWith((String)"/"))
        }
lbl5:
        // 1 sources

        index = StringUtils.getIndexOfFirstSeparator(path);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String toTitelCase(String word) {
        if (word == null || word.isEmpty()) {
            return word;
        }
        StringBuilder converted = new StringBuilder();
        boolean convertNext = true;
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isSpaceChar(ch)) {
                convertNext = true;
            } else if (convertNext) {
                ch = Character.toTitleCase(ch);
                convertNext = false;
            } else {
                ch = Character.toLowerCase(ch);
            }
            converted.append(ch);
            ++n2;
        }
        return converted.toString();
    }

    public static Map<String, String> extractQueryParameters(String query) {
        String[] pairs;
        LinkedHashMap<String, String> parms = new LinkedHashMap<String, String>();
        if (query == null) {
            return parms;
        }
        String[] stringArray = pairs = query.split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair;
            String key = pair = stringArray[n2];
            String value = "";
            int idx = pair.indexOf("=");
            if (idx > 0) {
                key = pair.substring(0, idx);
                value = pair.substring(idx + 1);
            }
            try {
                parms.put(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("failed to decode URI query key: " + key + " with value: " + value + " for query: " + query, (Throwable)e);
            }
            ++n2;
        }
        return parms;
    }
}

