/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.CustomJob;
import com.remainsoftware.common.util.Validate;
import com.remainsoftware.common.util.models.ICustomJobQueueDispatcher;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialCustomJobEventQueue
implements ICustomJobQueueDispatcher,
IJobChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(SequentialCustomJobEventQueue.class);
    private volatile int jobCount = 0;
    public static final int UNLIMITED_QUEUE_SIZE = -1;
    private final int maxAllowdInQueue;
    private final LinkedList<Job> queue = new LinkedList();
    IProgressMonitor progressGroupMonitor = null;
    private final String name;
    private Job runningJob = null;

    public SequentialCustomJobEventQueue(String name, int maxInQueue) {
        this.name = name;
        this.maxAllowdInQueue = maxInQueue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(IJobChangeEvent event) {
        SequentialCustomJobEventQueue sequentialCustomJobEventQueue = this;
        synchronized (sequentialCustomJobEventQueue) {
            this.runningJob = null;
        }
        Job job = event.getJob();
        job.removeJobChangeListener((IJobChangeListener)this);
        ((CustomJob)job).close();
        SequentialCustomJobEventQueue sequentialCustomJobEventQueue2 = this;
        synchronized (sequentialCustomJobEventQueue2) {
            logger.info(String.valueOf(this.name) + " has finished job (#" + this.jobCount + "): " + ((CustomJob)job).getDetailedDescription());
            --this.jobCount;
            if (this.queue.size() > 0) {
                Job customJob = this.queue.removeFirst();
                customJob.setPriority(20);
                customJob.setSystem(true);
                customJob.setUser(false);
                customJob.addJobChangeListener((IJobChangeListener)this);
                customJob.setProgressGroup(this.progressGroupMonitor, 1);
                customJob.schedule();
            } else {
                this.progressGroupMonitor.done();
                this.progressGroupMonitor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void running(IJobChangeEvent event) {
        SequentialCustomJobEventQueue sequentialCustomJobEventQueue = this;
        synchronized (sequentialCustomJobEventQueue) {
            this.runningJob = event.getJob();
        }
        logger.info(String.valueOf(this.name) + " running job: " + ((CustomJob)this.runningJob).getDetailedDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduled(IJobChangeEvent event) {
        Job job = event.getJob();
        SequentialCustomJobEventQueue sequentialCustomJobEventQueue = this;
        synchronized (sequentialCustomJobEventQueue) {
            ++this.jobCount;
            logger.info(String.valueOf(this.name) + " has scheduled job (#" + this.jobCount + "): " + ((CustomJob)job).getDetailedDescription());
        }
    }

    public void sleeping(IJobChangeEvent event) {
    }

    @Override
    public boolean queue(CustomJob customJob) {
        return this.queue(customJob, false, null);
    }

    @Override
    public boolean queue(CustomJob customJob, boolean isLongRunning) {
        return this.queue(customJob, isLongRunning, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean queue(CustomJob customJob, boolean isLongRunning, Map<QualifiedName, Boolean> properties) {
        Validate.isNotNull((Object)customJob, "job may not be null");
        SequentialCustomJobEventQueue sequentialCustomJobEventQueue = this;
        synchronized (sequentialCustomJobEventQueue) {
            block8: {
                if (this.maxAllowdInQueue == -1 || this.maxAllowdInQueue < 0 || this.queue.size() < this.maxAllowdInQueue) break block8;
                logger.warn("Unable to queue job, maximum allowed in queue (" + this.maxAllowdInQueue + ") has been reached");
                return false;
            }
            if (this.progressGroupMonitor == null) {
                this.progressGroupMonitor = Job.getJobManager().createProgressGroup();
                this.progressGroupMonitor.beginTask(customJob.getGeneralDescription(), 2);
            }
            this.queue.add(customJob);
            if (this.jobCount <= 0) {
                this.jobCount = 0;
                customJob = (CustomJob)this.queue.removeFirst();
                customJob.setPriority(isLongRunning ? 30 : 20);
                if (properties != null) {
                    Set<QualifiedName> keys = properties.keySet();
                    for (QualifiedName qfName : keys) {
                        customJob.setProperty(qfName, properties.get(qfName));
                    }
                }
                customJob.setSystem(true);
                customJob.setUser(false);
                customJob.addJobChangeListener(this);
                customJob.setProgressGroup(this.progressGroupMonitor, 1);
                customJob.schedule();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getRunningJob() {
        SequentialCustomJobEventQueue sequentialCustomJobEventQueue = this;
        synchronized (sequentialCustomJobEventQueue) {
            return this.runningJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJobCount() {
        SequentialCustomJobEventQueue sequentialCustomJobEventQueue = this;
        synchronized (sequentialCustomJobEventQueue) {
            return this.jobCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        SequentialCustomJobEventQueue sequentialCustomJobEventQueue = this;
        synchronized (sequentialCustomJobEventQueue) {
            block4: {
                if (this.queue.size() != 0) break block4;
                this.jobCount = 0;
                return true;
            }
        }
        return false;
    }
}

