/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.util;

import com.remainsoftware.common.util.Validate;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanDirVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(CleanDirVisitor.class);
    private boolean suppressAndLogExceptions = false;

    public CleanDirVisitor() {
        this.suppressAndLogExceptions = false;
    }

    public CleanDirVisitor(boolean suppressAndLogExceptions) {
        this.suppressAndLogExceptions = suppressAndLogExceptions;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Validate.isNotNull(file, "path must be set");
        logger.trace("deleting file: " + file.toString());
        try {
            Files.delete(file);
        }
        catch (IOException e) {
            String causeMsg = null;
            Throwable cause = e.getCause();
            if (this.suppressAndLogExceptions) {
                if (cause != null) {
                    causeMsg = cause.getMessage() != null ? cause.getMessage() : cause.getClass().getSimpleName();
                }
                logger.error("failed to delete file: " + file.toString() + ", message = " + e.getClass().getSimpleName() + ": " + e.getMessage() + (causeMsg != null ? ", cause = " + causeMsg : ""));
            }
            throw e;
        }
        return FileVisitResult.CONTINUE;
    }
}

