/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ui.util;

import com.remainsoftware.common.ui.util.Messages;
import com.remainsoftware.common.util.ServiceUtils;
import com.remainsoftware.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class UiUtils {
    private static final String INFORMATION = Messages.UiUtils_information;
    private static final String CONFIRMATION = Messages.UiUtils_confirmation;
    private static final String QUESTION = Messages.UiUtils_question;
    private static final String WARNING = Messages.UiUtils_warning;
    private static final String ERROR = Messages.UiUtils_error;

    public static boolean openDetailsDialog(String title, String message, IStatus status) {
        int[] usersChoice = new int[1];
        org.eclipse.ui.IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            usersChoice[0] = ErrorDialog.openError((Shell)activeWorkbenchWindow.getShell(), (String)title, (String)message, (IStatus)status);
        } else {
            workbench.getDisplay().syncExec(() -> {
                int n = ErrorDialog.openError((Shell)workbench.getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (IStatus)status);
            });
        }
        return usersChoice[0] == 0;
    }

    public static boolean openInformationDialog(String message) {
        return UiUtils.openDialog(2, INFORMATION, message);
    }

    public static boolean openInformationDialog(String title, String message) {
        return UiUtils.openDialog(2, StringUtils.isNotEmpty((String)title) ? title : INFORMATION, message);
    }

    public static boolean openConfirmationDialog(String message) {
        return UiUtils.openDialog(5, CONFIRMATION, message);
    }

    public static boolean openConfirmationDialog(String title, String message) {
        return UiUtils.openDialog(5, StringUtils.isNotEmpty((String)title) ? title : CONFIRMATION, message);
    }

    public static boolean openQuestionDialog(String message) {
        return UiUtils.openDialog(3, QUESTION, message);
    }

    public static boolean openQuestionDialog(String title, String message) {
        return UiUtils.openDialog(3, StringUtils.isNotEmpty((String)title) ? title : QUESTION, message);
    }

    public static boolean openQuestionWithCancelDialog(String message) {
        return UiUtils.openDialog(6, QUESTION, message);
    }

    public static boolean openQuestionWithCancelDialog(String title, String message) {
        return UiUtils.openDialog(6, StringUtils.isNotEmpty((String)title) ? title : QUESTION, message);
    }

    public static boolean openWarningDialog(String message) {
        return UiUtils.openDialog(4, WARNING, message);
    }

    public static boolean openWarningDialog(String title, String message) {
        return UiUtils.openDialog(4, StringUtils.isNotEmpty((String)title) ? title : WARNING, message);
    }

    public static boolean openErrorDialog(String message) {
        return UiUtils.openDialog(1, ERROR, message);
    }

    public static boolean openErrorDialog(String title, String message) {
        return UiUtils.openDialog(1, StringUtils.isNotEmpty((String)title) ? title : ERROR, message);
    }

    public static boolean openErrorDialog(Throwable throwable) {
        return UiUtils.openDialog(1, ERROR, StringUtils.extractMessage((Throwable)throwable));
    }

    public static boolean openErrorDialog(String title, Throwable throwable) {
        return UiUtils.openDialog(1, StringUtils.isNotEmpty((String)title) ? title : ERROR, StringUtils.extractMessage((Throwable)throwable));
    }

    public static int openDefaultDialogWithButtons(String title, Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(0, title, image, message, buttons);
    }

    public static int openInformationDialogWithButtons(Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(2, INFORMATION, image, message, buttons);
    }

    public static int openInformationDialogWithButtons(String title, Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(2, StringUtils.isNotEmpty((String)title) ? title : INFORMATION, image, message, buttons);
    }

    public static int openQuestionDialogWithButtons(Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(3, QUESTION, image, message, buttons);
    }

    public static int openQuestionDialogWithButtons(String title, Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(3, StringUtils.isNotEmpty((String)title) ? title : QUESTION, image, message, buttons);
    }

    public static int openWarningDialogWithButtons(Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(4, WARNING, image, message, buttons);
    }

    public static int openWarningDialogWithButtons(String title, Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(4, StringUtils.isNotEmpty((String)title) ? title : WARNING, image, message, buttons);
    }

    public static int openErrorDialogWithButtons(Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(1, ERROR, image, message, buttons);
    }

    public static int openErrorDialogWithButtons(String title, Image image, String message, String[] buttons) {
        return UiUtils.openDialogWithButtons(1, StringUtils.isNotEmpty((String)title) ? title : ERROR, image, message, buttons);
    }

    public static int openErrorDialogWithButtons(Image image, Throwable throwable, String[] buttons) {
        return UiUtils.openDialogWithButtons(1, ERROR, image, StringUtils.extractMessage((Throwable)throwable), buttons);
    }

    public static int openErrorDialogWithButtons(String title, Image image, Throwable throwable, String[] buttons) {
        return UiUtils.openDialogWithButtons(1, StringUtils.isNotEmpty((String)title) ? title : ERROR, image, StringUtils.extractMessage((Throwable)throwable), buttons);
    }

    public static int openDefaultToggleDialog(String title, Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(0, title, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openInformationToggleDialog(Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(2, INFORMATION, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openInformationToggleDialog(String title, Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(2, StringUtils.isNotEmpty((String)title) ? title : INFORMATION, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openQuestionToggleDialog(Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(3, QUESTION, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openQuestionToggleDialog(String title, Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(3, StringUtils.isNotEmpty((String)title) ? title : QUESTION, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openWarningToggleDialog(Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(4, WARNING, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openWarningToggleDialog(String title, Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(4, StringUtils.isNotEmpty((String)title) ? title : WARNING, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openErrorToggleDialog(Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(1, ERROR, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openErrorToggleDialog(String title, Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(1, StringUtils.isNotEmpty((String)title) ? title : ERROR, image, message, toggleMessage, preferenceKey, buttons);
    }

    public static int openErrorToggleDialog(Image image, Throwable throwable, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(1, ERROR, image, StringUtils.extractMessage((Throwable)throwable), toggleMessage, preferenceKey, buttons);
    }

    public static int openErrorToggleDialog(String title, Image image, Throwable throwable, String toggleMessage, String preferenceKey, String[] buttons) {
        return UiUtils.openToggleDialog(1, StringUtils.isNotEmpty((String)title) ? title : ERROR, image, StringUtils.extractMessage((Throwable)throwable), toggleMessage, preferenceKey, buttons);
    }

    public static Shell centerWindowLocation(Shell shell) {
        if (shell == null) {
            throw new IllegalArgumentException("The shell is null.");
        }
        Rectangle activeWindowBounds = UiUtils.getActiveShell().getBounds();
        Point shellSize = shell.getSize();
        int x = activeWindowBounds.width / 2 - shellSize.x / 2 + activeWindowBounds.x;
        int y = activeWindowBounds.height / 2 - shellSize.y / 2 + activeWindowBounds.y;
        shell.setLocation(x, y);
        return shell;
    }

    public static Shell setWindowSize(Shell shell, int width, int height, double maxWidthPercentage, double maxHeightPercentage) {
        double heightMonitorPercent;
        if (shell == null) {
            throw new IllegalArgumentException("The shell is null.");
        }
        double maxWidthPercent = maxWidthPercentage <= 1.0 ? maxWidthPercentage : 1.0;
        double maxHeightPercent = maxHeightPercentage <= 1.0 ? maxHeightPercentage : 1.0;
        int finalWidth = width;
        int finalHeight = height;
        Rectangle monitorSize = shell.getMonitor().getBounds();
        double widthMonitorPercent = (double)width / (double)monitorSize.width;
        if (widthMonitorPercent > maxWidthPercent) {
            finalWidth = (int)((double)monitorSize.width * maxWidthPercent);
        }
        if ((heightMonitorPercent = (double)height / (double)monitorSize.height) > maxHeightPercent) {
            finalHeight = (int)((double)monitorSize.height * maxHeightPercent);
        }
        shell.setSize(finalWidth, finalHeight);
        return shell;
    }

    public static Shell setWindowSize(Shell shell, double widthPercentage, double heightPercentage) {
        if (shell == null) {
            throw new IllegalArgumentException("The shell is null.");
        }
        double widthPercent = widthPercentage <= 1.0 ? widthPercentage : 1.0;
        double heightPercent = heightPercentage <= 1.0 ? heightPercentage : 1.0;
        Rectangle monitorSize = shell.getMonitor().getBounds();
        shell.setSize((int)((double)monitorSize.width * widthPercent), (int)((double)monitorSize.height * heightPercent));
        return shell;
    }

    public static Shell restrictWindowSize(Shell shell, double maxWidthPercentage, double maxHeightPercentage) {
        int newHeight;
        if (shell == null) {
            throw new IllegalArgumentException("The shell is null.");
        }
        double maxWidthPercent = maxWidthPercentage <= 1.0 ? maxWidthPercentage : 1.0;
        double maxHeightPercent = maxHeightPercentage <= 1.0 ? maxHeightPercentage : 1.0;
        Rectangle monitorSize = shell.getMonitor().getBounds();
        int maxWidth = (int)((double)monitorSize.width * maxWidthPercent);
        int maxHeight = (int)((double)monitorSize.height * maxHeightPercent);
        Point shellSize = shell.getSize();
        int newWidth = shellSize.x > maxWidth ? maxWidth : 0;
        int n = newHeight = shellSize.y > maxHeight ? maxHeight : 0;
        if (newWidth != 0 || newHeight != 0) {
            shell.setSize(newWidth != 0 ? newWidth : shellSize.x, newHeight != 0 ? newHeight : shellSize.y);
        }
        return shell;
    }

    public static Composite setCompositeEnablement(Composite composite, boolean enable) {
        if (composite == null) {
            throw new IllegalArgumentException("The composite is null.");
        }
        Display.getDefault().syncExec(() -> {
            composite.setEnabled(enable);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(enable);
                if (control instanceof Composite) {
                    UiUtils.setCompositeEnablement((Composite)control, enable);
                }
                ++n2;
            }
        });
        return composite;
    }

    public static Composite setHelp(Composite composite, String contextId) {
        if (composite == null) {
            throw new IllegalArgumentException("The composite is null.");
        }
        if (StringUtils.isEmpty((String)contextId)) {
            throw new IllegalArgumentException("The context ID is null or empty.");
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, contextId);
        return composite;
    }

    public static IWorkbenchPage getActivePage() {
        return UiUtils.getActiveWorkbenchWindow().getActivePage();
    }

    public static Shell getActiveShell() {
        return UiUtils.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow[] activeWorkbenchWindows = new IWorkbenchWindow[1];
        org.eclipse.ui.IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindows[0] = activeWorkbenchWindow;
        } else {
            workbench.getDisplay().syncExec(() -> {
                IWorkbenchWindow iWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            });
        }
        return activeWorkbenchWindows[0];
    }

    public static EPartService getPartService() throws IllegalStateException {
        MApplication application = ((IWorkbench)ServiceUtils.getOSGiService(UiUtils.class, IWorkbench.class)).getApplication();
        IEclipseContext context = application.getContext();
        EPartService partService = (EPartService)context.get(EPartService.class);
        try {
            partService.getActivePart();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            MTrimmedWindow window = (MTrimmedWindow)application.getChildren().get(0);
            IEclipseContext windowContext = window.getContext();
            context.activate();
            windowContext.setParent(context);
            windowContext.activateBranch();
            partService = (EPartService)context.get(EPartService.class);
            partService.getActivePart();
        }
        return partService;
    }

    public static List<IEditorDescriptor> getEditorDescriptors(String relativeFileName, boolean editable) throws Exception {
        ArrayList<IEditorDescriptor> editorDescriptors = new ArrayList<IEditorDescriptor>();
        IEditorDescriptor[] iEditorDescriptorArray = PlatformUI.getWorkbench().getEditorRegistry().getEditors(relativeFileName);
        int n = iEditorDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editorDescriptor = iEditorDescriptorArray[n2];
            editorDescriptors.add(editorDescriptor);
            ++n2;
        }
        boolean isTextEditorIncluded = false;
        for (IEditorDescriptor editorDescriptor : editorDescriptors) {
            if (!editorDescriptor.getId().equals("org.eclipse.ui.DefaultTextEditor")) continue;
            isTextEditorIncluded = true;
            break;
        }
        if (!isTextEditorIncluded) {
            editorDescriptors.add(UiUtils.getEditorDescriptor("sdsds.sdsds", editable));
        }
        return editorDescriptors;
    }

    public static IEditorDescriptor getEditorDescriptor(String relativeFileName, boolean editable) throws Exception {
        return IDE.getEditorDescriptor((String)relativeFileName, (boolean)true, (boolean)editable);
    }

    public static Text addSelectOnFocusToText(Text text) {
        if (text == null) {
            throw new IllegalArgumentException("The text widget is null.");
        }
        Listener listener = new Listener(){
            private boolean fHasFocus;
            private boolean fHadFocusOnMousedown;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 15: {
                        Text textWidget = (Text)event.widget;
                        textWidget.selectAll();
                        textWidget.getDisplay().asyncExec(() -> {
                            boolean bl = this.fHasFocus = true;
                        });
                        break;
                    }
                    case 16: {
                        this.fHasFocus = false;
                        ((Text)event.widget).clearSelection();
                        break;
                    }
                    case 3: {
                        this.fHadFocusOnMousedown = this.fHasFocus;
                        break;
                    }
                    case 4: {
                        Text textWidget = (Text)event.widget;
                        if (textWidget.getSelectionCount() != 0 || this.fHadFocusOnMousedown) break;
                        ((Text)event.widget).selectAll();
                    }
                }
            }
        };
        text.addListener(15, listener);
        text.addListener(16, listener);
        text.addListener(3, listener);
        text.addListener(4, listener);
        return text;
    }

    private static boolean openDialog(int type, String title, String message) {
        boolean[] usersChoice = new boolean[1];
        org.eclipse.ui.IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            usersChoice[0] = MessageDialog.open((int)type, (Shell)activeWorkbenchWindow.getShell(), (String)title, (String)message, (int)0);
        } else {
            workbench.getDisplay().syncExec(() -> {
                boolean bl = MessageDialog.open((int)type, (Shell)workbench.getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (int)0);
            });
        }
        return usersChoice[0];
    }

    private static int openDialogWithButtons(int type, String title, Image image, String message, String[] buttons) {
        int[] returnCode = new int[1];
        org.eclipse.ui.IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            returnCode[0] = new MessageDialog(activeWorkbenchWindow.getShell(), title, image, message, type, buttons, 0).open();
        } else {
            workbench.getDisplay().syncExec(() -> {
                int n2 = new MessageDialog(workbench.getActiveWorkbenchWindow().getShell(), title, image, message, type, buttons, 0).open();
            });
        }
        return returnCode[0];
    }

    private static int openToggleDialog(int type, String title, Image image, String message, String toggleMessage, String preferenceKey, String[] buttons) {
        int[] returnCode = new int[1];
        IPreferenceStore preferenceStore = PlatformUI.getPreferenceStore();
        org.eclipse.ui.IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            MessageDialogWithToggle toggleDialog = new MessageDialogWithToggle(activeWorkbenchWindow.getShell(), title, image, message, type, buttons, 0, toggleMessage, true);
            toggleDialog.setToggleState(preferenceStore.getBoolean(preferenceKey));
            returnCode[0] = toggleDialog.open();
            preferenceStore.setValue(preferenceKey, toggleDialog.getToggleState());
        } else {
            workbench.getDisplay().syncExec(() -> {
                MessageDialogWithToggle toggleDialog = new MessageDialogWithToggle(workbench.getActiveWorkbenchWindow().getShell(), title, image, message, type, buttons, 0, toggleMessage, true);
                toggleDialog.setToggleState(preferenceStore.getBoolean(preferenceKey));
                nArray[0] = toggleDialog.open();
                preferenceStore.setValue(preferenceKey, toggleDialog.getToggleState());
            });
        }
        return returnCode[0];
    }

    private UiUtils() {
    }
}

