/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ui.util;

import com.myjavatools.lib.Strings;
import com.remainsoftware.common.ssl.CertificateUtils;
import com.remainsoftware.common.ui.util.Activator;
import com.remainsoftware.common.ui.util.Messages;
import com.remainsoftware.common.util.StringUtils;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SslPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String SINGE_QUOTE_EMPTY_STRING = "''";
    private static final String REMOVE_CERTIFICATE = Messages.SPP_0;
    private static final String VIEW_CERTIFICATE = Messages.SPP_1;
    private static final String ADD_CERTIFICATE = Messages.SPP_2;
    private List hostsList;
    private Map<String, X509Certificate> trustedHostsWithCertificates;
    private Map<String, File> newTrustedHostsFile = new HashMap<String, File>();
    private Map<String, X509Certificate> newTrustedHostsCert = new HashMap<String, X509Certificate>();
    protected File lastCertFile;

    public SslPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.SPP_3);
    }

    protected Control createContents(Composite parent) {
        Composite field = new Composite(parent, 0);
        GridData fgd = new GridData(1808);
        fgd.horizontalSpan = 3;
        field.setLayoutData((Object)fgd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        field.setLayout((Layout)gl);
        Label label = new Label(field, 16384);
        label.setText(Messages.SPP_4);
        new Label(field, 16384);
        this.hostsList = new List(field, 2820);
        this.hostsList.setLayoutData((Object)new GridData(1808));
        Composite column = new Composite(field, 0);
        GridData gd_column = new GridData(1808);
        gd_column.grabExcessHorizontalSpace = false;
        column.setLayoutData((Object)gd_column);
        GridLayout gl_column = new GridLayout();
        gl_column.marginHeight = 0;
        column.setLayout((Layout)gl_column);
        Button add = new Button(column, 8);
        add.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        add.setText(Messages.SPP_Add);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileSelectDialog = new FileDialog(SslPreferencePage.this.getShell());
                if (SslPreferencePage.this.lastCertFile != null && SslPreferencePage.this.lastCertFile.exists()) {
                    fileSelectDialog.setFilterPath(SslPreferencePage.this.lastCertFile.getParentFile().getAbsolutePath());
                }
                fileSelectDialog.setFilterExtensions(CertificateUtils.X509CERT_WILDCARD_EXTENSIONS);
                String file = fileSelectDialog.open();
                if (file != null) {
                    SslPreferencePage.this.lastCertFile = new File(file.trim());
                    if (SslPreferencePage.this.lastCertFile.exists()) {
                        String certFileName = SslPreferencePage.this.lastCertFile.getAbsolutePath();
                        try {
                            X509Certificate x509Cert = CertificateUtils.createX509CertificateFromFile((File)SslPreferencePage.this.lastCertFile);
                            String[] hostNames = CertificateUtils.getCertificateHostNames((X509Certificate)x509Cert);
                            if (hostNames.length == 0) {
                                MessageDialog.openWarning((Shell)new Shell(), (String)Messages.SPP_Add, (String)String.format(String.valueOf(Messages.SPP_6) + Messages.SPP_7, certFileName, Messages.SPP_22));
                            } else {
                                String[] stringArray = hostNames;
                                int n = hostNames.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String hostName = stringArray[n2];
                                    if (!SslPreferencePage.this.hostsListContains(hostName)) {
                                        SslPreferencePage.this.hostsList.add(hostName);
                                        SslPreferencePage.this.newTrustedHostsFile.put(hostName, SslPreferencePage.this.lastCertFile);
                                        SslPreferencePage.this.newTrustedHostsCert.put(hostName, x509Cert);
                                    }
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception e) {
                            MessageDialog.openWarning((Shell)new Shell(), (String)Messages.SPP_Add, (String)String.format(String.valueOf(Messages.SPP_6) + Messages.SPP_7, certFileName, StringUtils.extractMessage((Exception)e)));
                        }
                    } else {
                        SslPreferencePage.this.lastCertFile = null;
                    }
                }
            }
        });
        Button remove = new Button(column, 8);
        remove.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        remove.setText(REMOVE_CERTIFICATE);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int s = SslPreferencePage.this.hostsList.getSelectionIndex();
                if (s >= 0) {
                    SslPreferencePage.this.hostsList.remove(s);
                }
            }
        });
        Button view = new Button(column, 8);
        view.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        view.setText(VIEW_CERTIFICATE);
        view.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int s = SslPreferencePage.this.hostsList.getSelectionIndex();
                if (s >= 0) {
                    String host = SslPreferencePage.this.hostsList.getItem(s);
                    X509Certificate x509Cert = (X509Certificate)SslPreferencePage.this.newTrustedHostsCert.get(host);
                    if (x509Cert == null) {
                        x509Cert = (X509Certificate)SslPreferencePage.this.trustedHostsWithCertificates.get(host);
                    }
                    if (x509Cert != null) {
                        String ipAddress = CertificateUtils.getIpAddressFromSubjectAltName((X509Certificate)x509Cert);
                        MessageDialog.openInformation((Shell)new Shell(), (String)VIEW_CERTIFICATE, (String)String.format(String.valueOf(Messages.SPP_8) + Messages.SPP_9 + Messages.SPP_10 + Messages.SPP_11 + Messages.SPP_12 + Messages.SPP_13 + Messages.SPP_14 + Messages.SPP_15 + Messages.SPP_16, Strings.join((CharSequence)",", (Object[])CertificateUtils.getCertificateHostNames((X509Certificate)x509Cert)), CertificateUtils.getCertificateIssuerDN((X509Certificate)x509Cert), CertificateUtils.getFirstCommonNameFromSubject((X509Certificate)x509Cert), CertificateUtils.getCertificateExpirationDate((X509Certificate)x509Cert).toString(), CertificateUtils.isSelfSigned((X509Certificate)x509Cert), CertificateUtils.getCertificateSignatureAlgorithmName((X509Certificate)x509Cert), CertificateUtils.getCertificatePublicKeyLength((X509Certificate)x509Cert), Strings.join((CharSequence)",", (Object[])CertificateUtils.getDnsNamesFromSubjectAltName((X509Certificate)x509Cert)), ipAddress != null ? ipAddress : SslPreferencePage.SINGE_QUOTE_EMPTY_STRING));
                    }
                }
            }
        });
        Label spacer = new Label(column, 16384);
        spacer.setLayoutData((Object)new GridData(1040));
        this.loadCertificateHosts();
        return field;
    }

    private boolean hostsListContains(String hostName) {
        String[] stringArray = this.hostsList.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            if (host.equals(hostName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void loadCertificateHosts() {
        this.trustedHostsWithCertificates = CertificateUtils.getTrustedHostsWithCertificates();
        for (String host : this.trustedHostsWithCertificates.keySet()) {
            this.hostsList.add(host);
        }
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        for (String host : this.trustedHostsWithCertificates.keySet()) {
            if (this.hostsListContains(host) || CertificateUtils.removeTrustedHost((String)host, (boolean)true)) continue;
            MessageDialog.openWarning((Shell)new Shell(), (String)REMOVE_CERTIFICATE, (String)String.format(String.valueOf(Messages.SPP_17) + Messages.SPP_18, host, CertificateUtils.getRemainCertificatesPath()));
        }
        for (String host : this.newTrustedHostsFile.keySet()) {
            try {
                CertificateUtils.addCertificateTrustedHostFromFile((File)this.newTrustedHostsFile.get(host));
            }
            catch (Exception e) {
                MessageDialog.openWarning((Shell)new Shell(), (String)ADD_CERTIFICATE, (String)String.format(String.valueOf(Messages.SPP_19) + Messages.SPP_20 + Messages.SPP_21, this.lastCertFile.getAbsolutePath(), CertificateUtils.getRemainCertificatesPath(), StringUtils.extractMessage((Exception)e)));
            }
        }
        return true;
    }
}

