/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.unix.packet.UnixPacket;
import com.ibm.iseries.unix.panel.UnixFilesPanel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class UnixSourceFilesPacket
extends UnixPacket {
    private ArrayList m_files;
    private ISeriesMessage m_msgObj;

    public UnixSourceFilesPacket() {
        super(3006);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_files.clear();
        this.m_files = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        int n3 = commLink.readInt();
        this.m_files = new ArrayList(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_files.add(commLink.readString());
        }
        Collections.sort(this.m_files);
        n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            UnixFilesPanel unixFilesPanel = (UnixFilesPanel)this.m_ctxt.getPanel("files");
            if (unixFilesPanel != null) {
                unixFilesPanel.setFiles(this.m_files);
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }
}

