/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

public class Tokenizer {
    protected static final String DEFAULT = " \t\n\r\f";
    protected static final char QUOTE = '\'';
    protected String m_str;
    protected int m_lastPos;
    protected int m_curPos;
    protected String m_delimiters;
    protected char m_minDelimChar;
    protected char m_maxDelimChar;
    protected int m_quoteCount;
    protected boolean m_honorQuotes;

    public static String[] tokenize(String string) {
        return Tokenizer.tokenize(string, null);
    }

    public static String[] tokenize(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        Tokenizer tokenizer = new Tokenizer(string, string2);
        int n = tokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = tokenizer.nextToken();
        }
        return stringArray;
    }

    public Tokenizer(String string) {
        this(string, null);
    }

    public Tokenizer(String string, String string2) {
        this.m_str = string;
        this.m_delimiters = string2 == null ? DEFAULT : string2;
        this.m_lastPos = string == null ? 0 : string.length();
        this.m_curPos = 0;
        this.setDelimRange();
    }

    public int countTokens() {
        int n = 0;
        int n2 = this.m_curPos;
        this.m_quoteCount = 0;
        while (n2 < this.m_lastPos && (n2 = this.skipDelimiters(n2)) < this.m_lastPos) {
            n2 = this.scanToken(n2);
            ++n;
        }
        this.m_quoteCount = 0;
        return n;
    }

    public String nextToken() {
        this.m_curPos = this.skipDelimiters(this.m_curPos);
        if (this.m_curPos >= this.m_lastPos) {
            return null;
        }
        int n = this.m_curPos;
        this.m_curPos = this.scanToken(this.m_curPos);
        return this.m_str.substring(n, this.m_curPos);
    }

    protected boolean isDelimChar(char c) {
        return c >= this.m_minDelimChar && c <= this.m_maxDelimChar && this.m_delimiters.indexOf(c) >= 0;
    }

    protected boolean isTokenChar(char c) {
        return c < this.m_minDelimChar || c > this.m_maxDelimChar || this.m_delimiters.indexOf(c) < 0;
    }

    protected int skipDelimiters(int n) {
        char c;
        int n2 = -1;
        while (n < this.m_lastPos && !this.isTokenChar(c = this.m_str.charAt(n))) {
            if (this.m_honorQuotes && c == '\'') {
                ++this.m_quoteCount;
                if (n2 == -1) {
                    n2 = n;
                }
            }
            ++n;
        }
        return n2 >= 0 ? n2 : n;
    }

    protected int scanToken(int n) {
        int n2;
        if (this.m_honorQuotes) {
            for (n2 = n; n2 < this.m_lastPos && this.isDelimChar(this.m_str.charAt(n2)); ++n2) {
            }
        }
        while (n2 < this.m_lastPos) {
            char c = this.m_str.charAt(n2);
            if (this.isDelimChar(c)) {
                if (!this.m_honorQuotes) break;
                if (c == '\'' && --this.m_quoteCount == 0) {
                    ++n2;
                }
                if (this.m_quoteCount == 0) break;
            }
            ++n2;
        }
        return n2;
    }

    protected void setDelimRange() {
        char c = '\uffff';
        char c2 = '\u0000';
        for (int i = 0; i < this.m_delimiters.length(); ++i) {
            char c3 = this.m_delimiters.charAt(i);
            if (c3 < c) {
                c = c3;
            }
            if (c3 <= c2) continue;
            c2 = c3;
        }
        this.m_minDelimChar = c;
        this.m_maxDelimChar = c2;
        this.m_honorQuotes = this.m_delimiters.indexOf(39) >= 0;
    }
}

