/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Help;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class Dialog
extends JDialog
implements ActionListener {
    protected static final int GRID_GAP = 3;
    protected static final int PANEL_GAP = 15;
    protected static final int BORDER_GAP = 10;
    protected static final String ESCAPE = "esc";
    protected static final String DOIT = "doit";
    protected static final String CANCEL = "cancel";
    protected static final String HELP = "help";
    protected Component m_parent;
    protected boolean m_canceled;
    protected String m_helpId;
    protected int m_helpSetId;
    protected JButton m_doItButton;
    protected JButton m_cancelButton;
    protected JButton m_helpButton;
    protected boolean m_isLtoR;
    protected int m_clockDepth;

    public Dialog(JFrame jFrame, String string, boolean bl, String string2) {
        super(jFrame, string, bl);
        this.init(jFrame, string2);
    }

    public Dialog(JDialog jDialog, String string, boolean bl, String string2) {
        super(jDialog, string, bl);
        this.init(jDialog, string2);
    }

    private void init(Component component, String string) {
        this.m_canceled = true;
        this.m_parent = component;
        this.m_helpId = string != null ? string : "";
        this.m_helpSetId = 0;
        this.m_isLtoR = MRI.isLtoR();
        this.setDefaultCloseOperation(2);
    }

    public void cleanUp() {
        this.m_parent = null;
        this.m_doItButton = null;
        this.m_cancelButton = null;
        this.m_helpButton = null;
        this.m_helpId = null;
    }

    public void display(DebugWindow debugWindow) {
        Dialog dialog = debugWindow.getActiveDialog();
        debugWindow.setActiveDialog(this);
        this.m_helpSetId = debugWindow.getHelpSetId();
        this.pack();
        this.setLocationRelativeTo(this.m_parent);
        this.setVisible(true);
        this.cleanUp();
        debugWindow.setActiveDialog(dialog);
    }

    public void display() {
        this.pack();
        this.setLocationRelativeTo(this.m_parent);
        this.setVisible(true);
        this.cleanUp();
    }

    public void doOk() {
    }

    public boolean wasCanceled() {
        return this.m_canceled;
    }

    protected void setCanceled(boolean bl) {
        this.m_canceled = bl;
    }

    protected void listenForEscape(JComponent jComponent) {
        jComponent.registerKeyboardAction(this, ESCAPE, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void listenForEscape(JTable jTable) {
        jTable.registerKeyboardAction(this, ESCAPE, KeyStroke.getKeyStroke(27, 0), 0);
    }

    protected JPanel defaultButtons(String string) {
        return this.defaultButtons(string, true, true);
    }

    protected JPanel defaultButtons(String string, boolean bl, boolean bl2) {
        JPanel jPanel = null;
        jPanel = bl || bl2 ? new JPanel(new FlowLayout(this.m_isLtoR ? 2 : 0)) : new JPanel(new FlowLayout(1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.m_doItButton = new JButton(string);
        this.m_doItButton.setActionCommand(DOIT);
        this.m_doItButton.addActionListener(this);
        Util.setAccessible((Accessible)this.m_doItButton, string);
        if (bl) {
            this.m_cancelButton = new JButton(MRI.get("DBG_CANCEL"));
            this.m_cancelButton.setActionCommand(CANCEL);
            this.m_cancelButton.addActionListener(this);
            Util.setAccessible((Accessible)this.m_cancelButton, this.m_cancelButton.getText());
        }
        if (bl2) {
            this.m_helpButton = new JButton(MRI.get("DBG_HELP"));
            this.m_helpButton.setActionCommand(HELP);
            this.m_helpButton.addActionListener(this);
            Util.setAccessible((Accessible)this.m_helpButton, this.m_helpButton.getText());
        }
        Util.setOrientation(jPanel);
        Util.setOrientation(this.m_doItButton);
        if (bl) {
            Util.setOrientation(this.m_cancelButton);
        }
        if (bl2) {
            Util.setOrientation(this.m_helpButton);
        }
        jPanel.add(this.m_doItButton);
        if (bl) {
            jPanel.add(this.m_cancelButton);
        }
        if (bl2) {
            jPanel.add(this.m_helpButton);
        }
        return jPanel;
    }

    protected Border getEmptyBorder(int n, int n2, int n3, int n4) {
        Border border = null;
        border = this.m_isLtoR ? BorderFactory.createEmptyBorder(n, n2, n3, n4) : BorderFactory.createEmptyBorder(n, n4, n3, n2);
        return border;
    }

    protected Border getTitledBorder(String string) {
        TitledBorder titledBorder = null;
        titledBorder = this.m_isLtoR ? BorderFactory.createTitledBorder(null, string, 1, 2) : BorderFactory.createTitledBorder(null, string, 3, 2);
        return titledBorder;
    }

    protected void postClock() {
        if (++this.m_clockDepth == 1) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    protected void retractClock() {
        if (--this.m_clockDepth == 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CANCEL) || string.equals(ESCAPE)) {
            this.dispose();
        } else if (string.equals(HELP) && this.m_helpId != null && this.m_helpId.length() > 0) {
            Help.instance(this.m_helpSetId).displayHelp(this.m_helpId, this);
        }
    }
}

