/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.RequestPacketElement;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.Tokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ActionGroup
extends HashMap {
    public static final int SELECTION_VALID = 0;
    public static final int SELECTION_FLYOVER = 1;
    private DebugContext m_ctxt;
    private Settings m_userCfg;
    private ArrayList m_runningActions;
    private ArrayList m_selectionActions;
    private ArrayList m_fKeyActions;
    private boolean m_tempDisabled;
    public RequestPacketElement m_var;
    public RequestPacketElement m_brk;
    public RequestPacketElement m_thread;
    public ArrayList m_brks;
    public ArrayList m_pgms;
    public ArrayList m_groups;
    public String m_pgmLib;
    public String m_pgmName;
    public int m_pgmType;
    public String m_viewId;
    public int m_lineNum;
    public String m_selection;
    public int m_selectionType;
    public TabPanel m_panel;
    public DebugSource m_debugSrc;
    public String m_address;
    public int m_callstackPos;
    public boolean m_callstackContext;
    public String m_helpId;

    public ActionGroup(Settings settings) {
        this.m_userCfg = settings;
        this.m_callstackPos = -1;
        this.m_selectionType = -1;
        this.m_lineNum = -1;
        this.m_pgmType = -1;
    }

    public ActionGroup(DebugContext debugContext, Settings settings) {
        this.m_ctxt = debugContext;
        this.m_userCfg = this.m_ctxt.getUserConfig();
        this.m_runningActions = new ArrayList();
        this.m_selectionActions = new ArrayList();
        this.m_fKeyActions = new ArrayList();
        this.m_callstackPos = -1;
        this.m_selectionType = -1;
        this.m_lineNum = -1;
        this.m_pgmType = -1;
        String string = settings.getString("actionPkg", "");
        String[] stringArray = Tokenizer.tokenize(settings.getString("actionCat", ""));
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = Tokenizer.tokenize(settings.getString(stringArray[i], ""));
            this.loadActionCategory(string, stringArray2);
        }
    }

    private void loadActionCategory(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string2 = stringArray[i].startsWith("com.ibm.iseries") ? stringArray[i] : string + "." + stringArray[i];
                Class<?> clazz = Class.forName(string2);
                Action action = (Action)clazz.newInstance();
                this.put(action.getKey(), action);
                if (action.isOffWhilePgmRunning() || action.isOnWhilePgmRunning()) {
                    this.m_runningActions.add(action);
                }
                if (action.isSelectionDependent()) {
                    this.m_selectionActions.add(action);
                }
                action.init(this.m_ctxt, this.m_userCfg);
                if (!action.isFKey()) continue;
                this.m_fKeyActions.add(action);
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("ActionGroup.loadActionCategory()  " + stringArray[i] + ": caught exception: " + throwable.toString());
            }
        }
    }

    public void cleanUp() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            action.cleanUp();
        }
        this.clear();
        this.m_runningActions.clear();
        this.m_selectionActions.clear();
        this.m_fKeyActions.clear();
        this.m_ctxt = null;
        this.m_userCfg = null;
        this.m_runningActions = null;
        this.m_selectionActions = null;
        this.clearAllContexts();
    }

    public DebugContext getContext() {
        return this.m_ctxt;
    }

    public Action getAction(String string) {
        return (Action)this.get(string);
    }

    public void putAction(Action action) {
        this.put(action.getKey(), action);
        action.init(null, this.m_userCfg);
    }

    public void enableAction(String string, boolean bl) {
        Action action = (Action)this.get(string);
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    public ArrayList getFKeyActions() {
        return this.m_fKeyActions;
    }

    public void setDefaultEnablement() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            action.restoreDefaultEnabled();
        }
    }

    public void setSupported(double d) {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            action.setSupported(d);
        }
    }

    public void setPgmRunning(boolean bl) {
        int n = this.m_runningActions.size();
        for (int i = 0; i < n; ++i) {
            Action action = (Action)this.m_runningActions.get(i);
            if (action.isOffWhilePgmRunning()) {
                action.setEnabled(!bl);
                continue;
            }
            if (!action.isOnWhilePgmRunning()) continue;
            action.setEnabled(bl);
        }
    }

    public void enableSelectionActions(boolean bl) {
        int n = this.m_selectionActions.size();
        for (int i = 0; i < n; ++i) {
            Action action = (Action)this.m_selectionActions.get(i);
            action.setEnabled(bl);
        }
    }

    public void setActiveSource(DebugSource debugSource) {
        this.m_panel = null;
        this.m_debugSrc = debugSource;
        this.m_helpId = "dbgsource_p";
        this.m_viewId = debugSource != null ? debugSource.getViewId() : "";
    }

    public void setActivePanel(TabPanel tabPanel) {
        this.m_panel = tabPanel;
        this.m_helpId = this.m_panel != null ? this.m_panel.getHelpId() : "dbgsource_p";
    }

    public void clearAllContexts() {
        this.m_var = null;
        this.m_brk = null;
        this.m_thread = null;
        this.m_brks = null;
        this.m_pgms = null;
        this.m_groups = null;
        this.m_pgmLib = null;
        this.m_pgmName = null;
        this.m_pgmType = -1;
        this.m_viewId = null;
        this.m_lineNum = -1;
        this.m_selection = null;
        this.m_selectionType = -1;
        this.m_panel = null;
        this.m_debugSrc = null;
        this.m_address = null;
        this.m_callstackPos = -1;
        this.m_callstackContext = false;
        this.m_helpId = null;
    }

    public void setVarContext(RequestPacketElement requestPacketElement) {
        this.m_var = requestPacketElement;
    }

    public void clearVarContext() {
        this.m_var = null;
    }

    public void setLnBrkContext(String string, int n, RequestPacketElement requestPacketElement) {
        this.m_viewId = string;
        this.m_lineNum = n;
        this.m_brk = requestPacketElement;
        this.m_brks = null;
    }

    public void setLnBrkContext(ArrayList arrayList) {
        this.m_brks = arrayList;
        this.m_brk = null;
    }

    public void clearLnBrkContext() {
        this.m_brk = null;
        this.m_viewId = null;
        this.m_lineNum = -1;
        if (this.m_brks != null) {
            this.m_brks.clear();
            this.m_brks = null;
        }
    }

    public void setResolveLoadmapContext(ArrayList arrayList) {
        this.m_pgms = arrayList;
    }

    public void clearResolveLoadmapContext() {
        this.m_pgms = null;
    }

    public void setGotoSrcContext(String string, int n) {
        this.m_viewId = string;
        this.m_lineNum = n;
    }

    public void setGotoSrcContext(String string, int n, int n2) {
        this.m_viewId = string;
        this.m_lineNum = n;
        this.m_callstackPos = n2;
    }

    public void clearGotoSrcContext() {
        this.m_viewId = null;
        this.m_lineNum = -1;
        this.m_callstackPos = -1;
    }

    public void setCallstackContext(boolean bl) {
        this.m_callstackContext = bl;
    }

    public boolean isCallstackContext() {
        boolean bl = this.m_callstackContext;
        this.m_callstackContext = false;
        return bl;
    }

    public void setThreadContext(RequestPacketElement requestPacketElement) {
        this.m_thread = requestPacketElement;
    }

    public void clearThreadContext() {
        this.m_thread = null;
    }

    public void setAddPgmContext(String string, String string2, int n) {
        this.m_pgmLib = string;
        this.m_pgmName = string2;
        this.m_pgmType = n;
    }

    public void setAddPgmContext(int n) {
        this.m_pgmLib = null;
        this.m_pgmName = null;
        this.m_pgmType = n;
    }

    public void clearAddPgmContext() {
        this.m_pgmLib = null;
        this.m_pgmName = null;
        this.m_pgmType = -1;
    }

    public void setRmvPgmContext(ArrayList arrayList) {
        this.m_pgms = arrayList;
    }

    public void clearRmvPgmContext() {
        this.m_pgms = null;
    }

    public void setDltGroupContext(ArrayList arrayList) {
        this.m_groups = arrayList;
    }

    public void clearDltGroupContext() {
        this.m_groups = null;
    }

    public void setSelectionContext(String string, int n, String string2, int n2) {
        this.m_selection = string2;
        this.m_selectionType = n2;
        this.m_viewId = string;
        this.m_lineNum = n;
    }

    public void clearSelectionContext() {
        this.m_selection = null;
        this.m_selectionType = -1;
    }

    public String getSelectionContext() {
        return this.m_selection;
    }

    public void setAddressContext(String string) {
        this.m_address = string;
    }

    public void clearAddressContext() {
        this.m_address = null;
    }
}

