/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.source;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.Breakpoints;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.listener.CursorListener;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.source.AutoEvalTooltip;
import com.ibm.iseries.debug.source.SourceRowHeader;
import com.ibm.iseries.debug.source.SourceView;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.FontUIResource;

public class SourceTextArea
extends JTextArea
implements SourceView,
CursorListener,
CaretListener,
FocusListener,
MouseListener,
MouseMotionListener {
    protected DebugContext m_ctxt;
    protected BreakpointGroupManager m_brkgrpMgr;
    protected SettingsManager m_settingsMgr;
    protected Breakpoints m_breakpoints;
    protected FontUIResource m_font;
    protected FontMetrics m_fontMetrics;
    protected ContextMenu m_contextMenu;
    protected int m_fontHeight;
    protected int m_fontAscent;
    protected boolean m_fullSource = true;
    protected int m_start = 1;
    protected int m_end;
    protected int m_lineCount;
    protected int m_active;
    protected String m_activeText;
    protected String m_activeOrigText;
    protected int m_activeStart = -1;
    protected int m_activeEnd = -1;
    protected int m_activeLength;
    protected int m_firstTab;
    protected String m_viewId = "";
    protected BreakpointDescriptor m_descriptor;
    protected MouseMotionTimer m_timer;
    protected int m_mousePos = -1;
    protected int m_selectionStart = -1;
    protected int m_selectionEnd = -1;
    protected boolean m_haveSelection;
    protected boolean m_autoEval;
    protected boolean m_ignoreFocus;
    protected String m_findText;

    public SourceTextArea() {
        this.setEditable(false);
        this.m_descriptor = new BreakpointDescriptor();
        this.addCaretListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.m_timer = new MouseMotionTimer();
    }

    public void lookAndFeelModifications(ContextMenu contextMenu) {
        this.m_contextMenu = contextMenu;
        this.settingsChanged(15);
    }

    public void settingsChanged(int n) {
        if (SettingsEvent.generalChanged(n)) {
            this.setTabSize(this.m_settingsMgr.m_srcTabSize);
        }
        if (SettingsEvent.colorsChanged(n)) {
            this.repaint();
        }
        if (SettingsEvent.fontsChanged(n)) {
            this.m_font = this.m_settingsMgr.m_srcFont;
            this.m_fontMetrics = this.getFontMetrics(this.m_font);
            this.m_fontHeight = this.m_fontMetrics.getHeight();
            this.m_fontAscent = this.m_fontMetrics.getMaxAscent();
            this.setFont(this.m_font);
        }
    }

    public void init(DebugContext debugContext, SourceRowHeader sourceRowHeader) {
        this.m_ctxt = debugContext;
        this.m_brkgrpMgr = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        this.m_settingsMgr = (SettingsManager)this.m_ctxt.getManager("settmgr");
        this.setTabSize(this.m_settingsMgr.m_srcTabSize);
        this.m_ctxt.getManager("cursormgr").addListener(this);
        ArrayList arrayList = this.m_ctxt.getActionGroup().getFKeyActions();
        int n = arrayList.size();
        if (n > 0) {
            ActionMap actionMap = this.getActionMap();
            InputMap inputMap = this.getInputMap(0);
            for (int i = 0; i < n; ++i) {
                Action action = (Action)arrayList.get(i);
                inputMap.put(action.getKeyStroke(), action);
                actionMap.put(action, action);
            }
            this.setActionMap(actionMap);
            this.setInputMap(0, inputMap);
        }
    }

    public void cleanUp() {
        this.m_ctxt.getManager("cursormgr").removeListener(this);
        this.m_ctxt = null;
        this.m_brkgrpMgr = null;
        this.m_settingsMgr = null;
        this.m_contextMenu = null;
        this.m_font = null;
        this.m_fontMetrics = null;
        this.m_breakpoints = null;
        this.m_descriptor = null;
        this.m_viewId = null;
        this.m_findText = null;
        this.m_timer = null;
        this.m_activeText = null;
        this.m_activeOrigText = null;
        this.removeCaretListener(this);
        this.removeMouseListener(this);
        this.removeFocusListener(this);
        this.setText("");
    }

    public JComponent getComponent() {
        return this;
    }

    public DebugContext getContext() {
        return this.m_ctxt;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public void setAccessibleDescription(String string) {
        Util.setAccessible(this, MRI.get("DBG_SOURCE_CODE_VIEW"), string);
    }

    public void setSourceInfo(SourceViewEvent sourceViewEvent) {
        BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
        this.m_viewId = sourceViewEvent.getViewId();
        this.m_start = sourceViewEvent.getStartLineNum();
        this.m_end = sourceViewEvent.getEndLineNum();
        this.m_lineCount = sourceViewEvent.getTotalLineCount();
        this.m_breakpoints = breakpointManager.getBreakpoints(this.m_viewId);
        this.m_findText = null;
        this.setText(sourceViewEvent.getSourceCode());
        this.getCaret().setDot(0);
        if (this.m_end == 0 || this.m_lineCount == 0) {
            this.m_end = this.m_lineCount = this.m_start + this.getPhysicalLineCount() - 1;
            sourceViewEvent.setEndLineNum(this.m_end);
            sourceViewEvent.setTotalLineCount(this.m_lineCount);
        }
        if (this.m_active > 0 && (this.m_active < this.m_start || this.m_active > this.m_end)) {
            this.m_active = 0;
        }
        this.m_fullSource = this.m_start == 1 && this.m_end == this.m_lineCount;
    }

    public void clearSourceInfo() {
        this.setText("");
        this.m_viewId = "";
        this.m_breakpoints = null;
        this.m_start = 1;
        this.m_end = 0;
        this.m_lineCount = 0;
        this.m_fullSource = true;
        this.m_active = 0;
        this.m_activeText = null;
        this.m_activeOrigText = null;
        this.m_activeStart = -1;
        this.m_activeEnd = -1;
        this.m_activeLength = 0;
        this.m_firstTab = 0;
        this.m_selectionStart = -1;
        this.m_selectionEnd = -1;
        this.m_haveSelection = false;
        this.m_autoEval = false;
        this.m_findText = null;
    }

    public int getPhysicalLineCount() {
        int n = this.getLineCount();
        try {
            String string;
            char c;
            int n2 = this.getDocument().getLength();
            if (n2 > 0 && ((c = (string = this.getText(n2 - 1, 1)).charAt(0)) == '\r' || c == '\n')) {
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n;
    }

    public int getStartLineNum() {
        return this.m_start;
    }

    public int getEndLineNum() {
        return this.m_end;
    }

    public int getTotalLineCount() {
        return this.m_lineCount;
    }

    public int getCursorLineNum() {
        int n = -1;
        try {
            n = this.getLineOfOffset(this.getCaretPosition());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.m_start + n;
    }

    public boolean isLineNumVisible(int n) {
        int n2 = n - this.m_start;
        int n3 = n2 * this.m_fontHeight;
        Rectangle rectangle = this.getVisibleRect();
        return n3 >= rectangle.y + this.m_fontHeight && n3 <= rectangle.y + rectangle.height - this.m_fontHeight;
    }

    public boolean isValidBreakpointLineNum(int n) {
        return true;
    }

    public void scrollToLineNum(int n) {
        int n2;
        int n3 = n - this.m_start;
        try {
            n2 = this.getLineStartOffset(n3);
            int n4 = this.getLineEndOffset(n3) - 1;
            this.select(n2, n4);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        n2 = n3 * this.m_fontHeight;
        Rectangle rectangle = this.getVisibleRect();
        if (n2 < rectangle.y + this.m_fontHeight || n2 > rectangle.y + rectangle.height - this.m_fontHeight) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.y = n2 - rectangle.height / 3;
            if (rectangle2.y < 0) {
                rectangle2.y = 0;
            } else if (rectangle2.y % this.m_fontHeight != 0) {
                rectangle2.y += this.m_fontHeight - rectangle2.y % this.m_fontHeight;
            }
            if (rectangle2.y != rectangle.y) {
                this.scrollRectToVisible(rectangle2);
            } else {
                this.repaint(rectangle);
            }
        }
    }

    public void scrollToLineNum(int n, boolean bl) {
        if (bl) {
            this.setActiveLineNum(n);
        } else {
            this.moveCaretToLineNum(n);
        }
        int n2 = n - this.m_start;
        int n3 = n2 * this.m_fontHeight;
        Rectangle rectangle = this.getVisibleRect();
        if (n3 < rectangle.y + this.m_fontHeight || n3 > rectangle.y + rectangle.height - this.m_fontHeight) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.y = n3 - rectangle.height / 3;
            if (rectangle2.y < 0) {
                rectangle2.y = 0;
            } else if (rectangle2.y % this.m_fontHeight != 0) {
                rectangle2.y += this.m_fontHeight - rectangle2.y % this.m_fontHeight;
            }
            if (rectangle2.y != rectangle.y) {
                this.scrollRectToVisible(rectangle2);
            } else {
                this.repaint(rectangle);
            }
        }
    }

    public int getActiveLineNum() {
        return this.m_active;
    }

    public void setActiveLineNum(int n) {
        int n2 = n - this.m_start + 1;
        int n3 = n - this.m_start;
        if (n2 <= 0 || n2 > this.getPhysicalLineCount()) {
            return;
        }
        this.m_active = n;
        try {
            this.m_activeStart = this.getLineStartOffset(n3);
            this.m_activeEnd = this.getLineEndOffset(n3) - 1;
            this.m_activeLength = this.m_activeEnd - this.m_activeStart;
            if (this.m_activeLength > 0) {
                this.m_activeOrigText = this.getText(this.m_activeStart, this.m_activeLength);
                this.m_activeText = this.fixActiveText(this.m_activeOrigText);
            } else {
                this.m_activeText = "";
                this.m_activeOrigText = "";
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.moveCaretToLineNum(this.m_active);
        this.repaint(this.getVisibleRect());
    }

    public void resetActiveLineNum() {
        if (this.m_active > 0) {
            this.m_active = -1;
            this.m_activeText = null;
            this.m_activeOrigText = null;
            this.repaint(this.getVisibleRect());
        }
    }

    public void select(int n, int n2) {
        boolean bl = this.m_autoEval;
        this.m_autoEval = false;
        super.select(n, n2);
        this.m_autoEval = bl;
    }

    public int findText(String string, int n, boolean bl, boolean bl2) {
        int n2 = -1;
        if (string != null && string.length() > 0) {
            if (this.m_findText == null) {
                this.m_findText = !bl ? this.getText().toUpperCase() : this.getText();
            }
            int n3 = this.getCaretPosition();
            if (!bl) {
                string = string.toUpperCase();
            }
            if (n > 0) {
                n2 = this.m_findText.indexOf(string, this.getCaretPosition());
                if (n2 < 0 && bl2 && n3 > 0) {
                    n2 = this.m_findText.indexOf(string, 0);
                }
            } else {
                n3 = this.m_haveSelection ? this.getSelectionStart() : n3;
                n2 = n3;
                String string2 = this.m_findText.substring(0, n2);
                n2 = string2.lastIndexOf(string);
                if (n2 < 0 && bl2 && n3 < this.m_findText.length() - 1 && (n2 = (string2 = this.m_findText.substring(n3)).lastIndexOf(string)) >= 0) {
                    n2 += n3;
                }
            }
            if (n2 >= 0) {
                this.requestFocus();
                this.select(n2, n2 + string.length());
                n2 = this.convertPosToLineNum(n2);
            }
        }
        return n2;
    }

    public int findTextInLine(String string, int n, boolean bl, boolean bl2) {
        int n2 = -1;
        if (string != null && string.length() > 0) {
            int n3 = n - this.m_start;
            int n4 = 0;
            try {
                n4 = this.getLineStartOffset(n3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (this.m_findText == null) {
                this.m_findText = !bl ? this.getText().toUpperCase() : this.getText();
            }
            if (!bl) {
                string = string.toUpperCase();
            }
            if ((n2 = this.m_findText.indexOf(string, n4)) >= 0) {
                this.requestFocus();
                this.select(n2, n2 + string.length());
            } else if (bl2 && n4 > 0 && (n2 = this.m_findText.indexOf(string, 0)) >= 0) {
                this.select(n2, n2 + string.length());
            }
            if (n2 >= 0) {
                n2 = this.convertPosToLineNum(n2);
            }
        }
        return n2;
    }

    public void gotoLine(int n) {
        if (n < this.m_start) {
            n = this.m_start;
        } else if (n > this.m_end) {
            n = this.m_end;
        }
        int n2 = n - this.m_start + 1;
        int n3 = n - this.m_start;
        try {
            int n4 = this.getLineStartOffset(n3);
            int n5 = this.getLineEndOffset(n3) - 1;
            if (n4 >= 0 && n5 >= 0) {
                this.requestFocus();
                this.select(n4, n5);
                this.repaint(this.getVisibleRect());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void moveCaretToLineNum(int n) {
        try {
            int n2 = n - this.m_start;
            int n3 = this.getLineStartOffset(n2);
            int n4 = this.getLineEndOffset(n2);
            int n5 = this.getCaretPosition();
            if (n5 < n3 || n5 > n4) {
                this.setCaretPosition(n3);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void moveCaretToPos(int n) {
        try {
            this.setCaretPosition(n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected int convertPosToLineNum(int n) {
        int n2 = -1;
        if (n >= 0) {
            try {
                n2 = this.m_start + this.getLineOfOffset(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return n2;
    }

    public void ignoreFocus(boolean bl) {
        this.m_ignoreFocus = bl;
    }

    public boolean getAutoEval() {
        return this.m_autoEval;
    }

    public void setAutoEval(boolean bl) {
        this.m_autoEval = bl;
        if (this.m_autoEval) {
            this.addMouseMotionListener(this);
        } else {
            this.removeMouseMotionListener(this);
        }
    }

    public void displayAutoEvalTooltip(String string) {
        if (this.m_mousePos >= 0) {
            try {
                if (string != null && string.length() > 0) {
                    Rectangle rectangle = this.modelToView(this.m_mousePos);
                    AutoEvalTooltip.instance().showTooltip(this, rectangle.x, rectangle.y, string);
                } else {
                    AutoEvalTooltip.instance().hideTooltip();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected String getLine(int n) {
        String string = "";
        int n2 = n - this.m_start + 1;
        int n3 = n - this.m_start;
        if (n2 <= 0 || n2 > this.getPhysicalLineCount()) {
            return string;
        }
        try {
            int n4 = this.getLineStartOffset(n3);
            int n5 = this.getLineEndOffset(n3) - 1;
            int n6 = n5 - n4;
            if (n6 > 0) {
                string = this.getText(n4, n6);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    protected String fixActiveText(String string) {
        this.m_firstTab = Integer.MAX_VALUE;
        if (string.indexOf(13) >= 0 || string.indexOf(10) >= 0 || string.indexOf(9) >= 0) {
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer(string);
            for (n2 = stringBuffer.length() - 1; n2 >= 0 && ((n = stringBuffer.charAt(n2)) == 13 || n == 10); --n2) {
                stringBuffer.deleteCharAt(n2);
            }
            n2 = 0;
            n = string.indexOf(9);
            if (n >= 0) {
                this.m_firstTab = n;
            }
            while (n >= 0) {
                stringBuffer.replace(n + n2, n + n2 + 1, this.m_settingsMgr.m_srcTab);
                n2 += this.m_settingsMgr.m_srcTabSize - 1;
                n = string.indexOf(9, n + 1);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    protected int mapActiveTextPos(int n, int n2, int n3) {
        if (n3 <= this.m_firstTab) {
            if (n3 >= this.m_activeOrigText.length()) {
                n3 = this.m_activeText.length();
            }
            return n3;
        }
        int n4 = n2;
        block4: for (int i = n; i < n3; ++i) {
            char c = this.m_activeOrigText.charAt(i);
            switch (c) {
                case '\t': {
                    n4 += this.m_settingsMgr.m_srcTabSize;
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    i = n3;
                    continue block4;
                }
                default: {
                    ++n4;
                }
            }
        }
        return n4;
    }

    protected String validateAutoEvalExpression(String string) {
        int n = string.length() - 1;
        boolean bl = false;
        block5: for (int i = 0; !bl && i <= n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '=': {
                    if (i + 1 > n || string.charAt(i + 1) == '=') continue block5;
                    string = "";
                    bl = true;
                    continue block5;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    char c2;
                    if (i + 1 > n || (c2 = string.charAt(i + 1)) != c && c2 != '=') continue block5;
                    string = "";
                    bl = true;
                    continue block5;
                }
                case ';': {
                    string = "";
                    bl = true;
                }
            }
        }
        return string;
    }

    protected String parseAutoEvalExpression(String string, int n) {
        char c;
        boolean bl = false;
        int n2 = n;
        int n3 = string.length() - 1;
        if (n2 > n3) {
            n2 = n3 >= 0 ? n3 : 0;
        }
        block13: while (!bl && n2 >= 0) {
            c = string.charAt(n2);
            switch (c) {
                case ' ': 
                case '(': 
                case ',': 
                case ':': 
                case ';': 
                case '?': {
                    if (n2 != n) {
                        ++n2;
                        bl = true;
                        continue block13;
                    }
                    --n2;
                    continue block13;
                }
                case '+': 
                case '-': {
                    if (n2 > 0 && string.charAt(n2 - 1) == c) {
                        ++n2;
                        bl = true;
                        continue block13;
                    }
                    --n2;
                    continue block13;
                }
                case '=': {
                    if (n2 > 0 && string.charAt(n2 - 1) != '=') {
                        ++n2;
                        bl = true;
                        continue block13;
                    }
                    --n2;
                    continue block13;
                }
            }
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        c = '\u0000';
        int n4 = n2;
        int n5 = 0;
        while (c == '\u0000' && n4 <= n3) {
            char c2 = string.charAt(n4);
            switch (c2) {
                case '\n': 
                case ':': 
                case ';': 
                case '?': {
                    c = '\u0001';
                    break;
                }
                case '=': {
                    if (n4 + 1 <= n3 && string.charAt(n4 + 1) != '=') {
                        c = '\u0001';
                        break;
                    }
                    ++n4;
                    break;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    if (n4 + 1 <= n3) {
                        char c3 = string.charAt(n4 + 1);
                        if (c3 == c2 || c3 == '=') {
                            c = '\u0001';
                            break;
                        }
                        ++n4;
                        break;
                    }
                    ++n4;
                    break;
                }
                case '(': 
                case '[': {
                    ++n5;
                    ++n4;
                    break;
                }
                case ' ': 
                case ',': {
                    if (n5 == 0) {
                        c = '\u0001';
                        break;
                    }
                    ++n4;
                    break;
                }
                case ')': 
                case ']': {
                    if (n5 == 0) {
                        c = '\u0001';
                        break;
                    }
                    if (--n5 == 0) {
                        c = '\u0001';
                    }
                    ++n4;
                    break;
                }
                default: {
                    ++n4;
                }
            }
        }
        String string2 = string.substring(n2, n4).trim();
        return string2;
    }

    protected int sqlXlate(String string, int n) {
        if (string == null || string.length() <= 0 || n < 0 || n >= string.length()) {
            return 4;
        }
        char c = string.charAt(n);
        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) >= 0) {
            return 0;
        }
        if ("abcdefghijklmnopqrstuvwxyz".indexOf(c) >= 0) {
            return 0;
        }
        if (c == '_') {
            return 0;
        }
        if (c == '.') {
            return 1;
        }
        if ("0123456789".indexOf(c) >= 0) {
            return 2;
        }
        if (c == '\"') {
            return 5;
        }
        if (c == ' ') {
            return 6;
        }
        return 3;
    }

    protected String parseAutoEvalSQLExpression(String string, int n) {
        int n2;
        int[][] nArrayArray = new int[][]{{5, 5, 5, 6, -3, 7, 6}, {1, 1, 1, 1, -3, 2, 1}, {-1, 3, -1, -1, -1, 1, -1}, {4, -1, -1, -1, -1, 1, 10}, {4, 3, 4, -2, -2, -1, 9}, {5, 5, 5, 6, -3, 7, 6}, {4, 6, 6, 6, -3, 1, 6}, {7, 7, 7, 7, -3, 8, 7}, {5, 5, 5, 6, -3, 7, 6}, {-2, 3, -2, -2, -2, -2, 9}, {4, -1, -1, -1, -1, -1, 10}};
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 = n;
        while (true) {
            int n6;
            if ((n4 = nArrayArray[n4][n6 = this.sqlXlate(string, n3)]) >= 0) {
                if ((n4 == 5 || n4 == 7 || n4 == 8) && --n3 < 0) {
                    n4 = 6;
                }
                if (n4 == 6) {
                    n5 = n3 + 1;
                }
                if (n4 == 2 || n4 == 4) {
                    n2 = n3;
                }
                if (n4 == 5 || n4 == 7 || n4 == 8) continue;
                ++n3;
                continue;
            }
            if (n4 == -3) {
                return "";
            }
            if (n2 >= n) break;
            n4 = 6;
            n5 = n3 = n2 + 1;
        }
        return string.substring(n5, n2 + 1);
    }

    public boolean isManagingFocus() {
        return false;
    }

    public void requestFocus() {
        if (this.m_ignoreFocus) {
            return;
        }
        super.requestFocus();
    }

    public Component getNextFocusableComponent() {
        JComponent jComponent;
        if (this.m_ctxt != null && (jComponent = this.m_ctxt.getDesktopNextFocusComponent()) != null) {
            return jComponent;
        }
        return super.getNextFocusableComponent();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_active > 0) {
            Rectangle rectangle = this.getVisibleRect();
            int n = (this.m_active - this.m_start) * this.m_fontHeight;
            if (n >= rectangle.y - this.m_fontHeight && n <= rectangle.y + rectangle.height + this.m_fontHeight) {
                Rectangle rectangle2 = new Rectangle(0, n, this.getWidth() - 1, this.m_fontHeight);
                Color color = graphics.getColor();
                graphics.setColor(this.m_settingsMgr.m_srcActiveBg);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(this.m_settingsMgr.m_srcActiveFg);
                graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (this.m_activeLength > 0) {
                    n = (this.m_active - this.m_start) * this.m_fontHeight + this.m_fontAscent;
                    graphics.drawString(this.m_activeText, 0, n);
                    int n2 = this.getSelectionStart();
                    int n3 = this.getSelectionEnd();
                    if (n2 != n3) {
                        if (n2 <= this.m_activeStart && n3 >= this.m_activeEnd) {
                            rectangle2.width = this.m_fontMetrics.stringWidth(this.m_activeText);
                            graphics.setColor(this.getSelectionColor());
                            graphics.fillRect(rectangle2.x, rectangle2.y + 1, rectangle2.width, rectangle2.height - 1);
                            graphics.setColor(this.getSelectedTextColor());
                            graphics.drawString(this.m_activeText, 0, n);
                            graphics.setColor(color);
                        } else if (n2 >= this.m_activeStart && n2 <= this.m_activeEnd || n3 >= this.m_activeStart && n3 <= this.m_activeEnd) {
                            int n4 = n2 > this.m_activeStart ? n2 - this.m_activeStart : 0;
                            int n5 = n3 < this.m_activeEnd ? n3 - this.m_activeStart : this.m_activeEnd;
                            int n6 = this.mapActiveTextPos(0, 0, n4);
                            int n7 = this.mapActiveTextPos(n4, n6, n5);
                            String string = this.m_activeText.substring(0, n6);
                            String string2 = this.m_activeText.substring(n6, n7);
                            rectangle2.x = this.m_fontMetrics.stringWidth(string);
                            rectangle2.width = this.m_fontMetrics.stringWidth(string2);
                            graphics.setColor(this.getSelectionColor());
                            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                            graphics.setColor(this.getSelectedTextColor());
                            graphics.drawString(string2, rectangle2.x, n);
                            graphics.setColor(color);
                        }
                    }
                }
                graphics.setColor(color);
            }
        }
    }

    public void cut() {
    }

    public void paste() {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.m_fullSource && keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 33: {
                    if (this.m_start <= 1) break;
                    Rectangle rectangle = this.getVisibleRect();
                    if (rectangle.y > this.m_fontHeight / 2) break;
                    this.m_fullSource = true;
                    SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                    sourceViewManager.requestSourceViewScroll(this.m_viewId, this.m_start - 1);
                    keyEvent.consume();
                    break;
                }
                case 34: {
                    if (this.m_end >= this.m_lineCount) break;
                    Rectangle rectangle = this.getVisibleRect();
                    if (rectangle.y + rectangle.height < this.getHeight() - this.m_fontHeight / 2) break;
                    this.m_fullSource = true;
                    SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                    sourceViewManager.requestSourceViewScroll(this.m_viewId, this.m_start + this.getPhysicalLineCount() - 1);
                    keyEvent.consume();
                }
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public void postCursor(int n) {
        switch (n) {
            case 2: {
                this.setCursor(Cursor.getPredefinedCursor(3));
                break;
            }
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected void prepareBreakpointDescriptor(int n, BreakpointDescriptor breakpointDescriptor) {
        breakpointDescriptor.setViewId(this.m_viewId);
        breakpointDescriptor.setLineNum(n);
        breakpointDescriptor.setGroupId(this.m_brkgrpMgr.getCurrentGroupId());
        breakpointDescriptor.setState(0);
    }

    protected void prepareActionContext(int n) {
        if (n >= this.getDocument().getLength()) {
            return;
        }
        this.m_ctxt.getActionGroup().clearLnBrkContext();
        BreakpointDescriptor breakpointDescriptor = null;
        int n2 = this.convertPosToLineNum(n);
        if (this.isValidBreakpointLineNum(n2)) {
            breakpointDescriptor = this.m_breakpoints.getDescriptor(n2);
            this.m_ctxt.updateBreakpointActions(breakpointDescriptor);
            if (breakpointDescriptor == null) {
                breakpointDescriptor = this.m_descriptor;
                this.prepareBreakpointDescriptor(n2, breakpointDescriptor);
            }
            this.m_ctxt.getActionGroup().setLnBrkContext(breakpointDescriptor.getViewId(), breakpointDescriptor.getLineNum(), breakpointDescriptor);
        } else {
            this.m_ctxt.updateBreakpointActions();
        }
        this.m_selectionStart = this.getSelectionStart();
        this.m_selectionEnd = this.getSelectionEnd();
        boolean bl = this.m_haveSelection = this.m_selectionStart != this.m_selectionEnd;
        if (this.m_haveSelection) {
            String string = this.getSelectedText().trim();
            this.m_ctxt.getActionGroup().setSelectionContext(this.m_viewId, n2, string, 0);
            if (this.m_autoEval && string.length() > 0 && string.indexOf(13) == -1 && string.indexOf(10) == -1) {
                String string2 = this.validateAutoEvalExpression(string);
                if (string2.length() > 0) {
                    this.m_ctxt.getAction("aeval").run();
                } else {
                    this.m_ctxt.clearMessage();
                }
            }
        } else {
            this.m_ctxt.getActionGroup().clearSelectionContext();
        }
        this.m_ctxt.getActionGroup().enableSelectionActions(this.m_haveSelection);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (!this.getCaret().isVisible()) {
            this.getCaret().setVisible(true);
        }
        this.prepareActionContext(caretEvent.getDot());
    }

    protected boolean handlePopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            try {
                int n = this.viewToModel(mouseEvent.getPoint());
                int n2 = this.getSelectionStart();
                int n3 = this.getSelectionEnd();
                if (n >= n2 && n <= n3) {
                    this.prepareActionContext(n);
                } else {
                    this.moveCaretToPos(n);
                }
                this.m_contextMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (!this.handlePopupMenu(mouseEvent) && (n = this.viewToModel(mouseEvent.getPoint())) >= 0) {
            this.m_mousePos = n;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_mousePos = -1;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_mousePos = -1;
        AutoEvalTooltip.instance().hideTooltip();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.viewToModel(mouseEvent.getPoint());
        if (n >= 0) {
            if (AutoEvalTooltip.instance().isTooltipVisible() && this.m_mousePos != n) {
                if (this.m_haveSelection) {
                    if (n < this.m_selectionStart || n > this.m_selectionEnd) {
                        AutoEvalTooltip.instance().hideTooltip();
                    }
                } else {
                    AutoEvalTooltip.instance().hideTooltip();
                }
            }
            this.m_mousePos = n;
            this.m_timer.m_tm.restart();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        boolean bl;
        if (!this.getCaret().isVisible()) {
            this.getCaret().setVisible(true);
        }
        this.m_ctxt.setActiveSource(this.m_viewId);
        boolean bl2 = bl = this.getSelectionStart() != this.getSelectionEnd();
        if (bl) {
            int n = this.convertPosToLineNum(this.getCaretPosition());
            this.m_ctxt.getActionGroup().setSelectionContext(this.m_viewId, n, this.getSelectedText(), 0);
        } else {
            this.m_ctxt.getActionGroup().clearSelectionContext();
        }
        this.m_ctxt.getActionGroup().enableSelectionActions(bl);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected class MouseMotionTimer
    implements ActionListener {
        public Timer m_tm = new Timer(AutoEvalTooltip.SHOW_MS, this);

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_tm.stop();
            if (SourceTextArea.this.m_mousePos >= 0) {
                if (SourceTextArea.this.m_haveSelection && SourceTextArea.this.m_mousePos >= SourceTextArea.this.m_selectionStart && SourceTextArea.this.m_mousePos <= SourceTextArea.this.m_selectionEnd) {
                    return;
                }
                try {
                    int n = SourceTextArea.this.getLineOfOffset(SourceTextArea.this.m_mousePos);
                    int n2 = SourceTextArea.this.getLineStartOffset(n);
                    int n3 = SourceTextArea.this.getLineEndOffset(n);
                    if (SourceTextArea.this.m_mousePos < n3 && n3 > n2) {
                        String string = SourceTextArea.this.getText(n2, n3 - n2 - 1);
                        String string2 = null;
                        DebugSource debugSource = SourceTextArea.this.m_ctxt.getDesktop().getActiveSource();
                        PgmManager pgmManager = (PgmManager)SourceTextArea.this.m_ctxt.getManager("pgmmgr");
                        string2 = pgmManager.getView(debugSource.getViewId()).isSQLRoot() ? SourceTextArea.this.parseAutoEvalSQLExpression(string, SourceTextArea.this.m_mousePos - n2) : SourceTextArea.this.parseAutoEvalExpression(string, SourceTextArea.this.m_mousePos - n2);
                        if (string2.length() > 0) {
                            SourceTextArea.this.m_ctxt.getActionGroup().setSelectionContext(SourceTextArea.this.m_viewId, SourceTextArea.this.m_start + n, string2, 1);
                            SourceTextArea.this.m_ctxt.getAction("aeval").run();
                        } else {
                            AutoEvalTooltip.instance().hideTooltip();
                        }
                    } else {
                        AutoEvalTooltip.instance().hideTooltip();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

