/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.BreakpointGroup;
import com.ibm.iseries.debug.BreakpointIcon;
import com.ibm.iseries.debug.BreakpointSwatchIcon;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.event.BreakpointEvent;
import com.ibm.iseries.debug.event.BreakpointGroupEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.listener.BreakpointGroupListener;
import com.ibm.iseries.debug.listener.BreakpointListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BreakpointsPanel
extends TabPanel
implements BreakpointListener,
BreakpointGroupListener,
LAFListener,
DebugConstants,
MouseListener,
ActionListener,
TreeSelectionListener,
DragSourceListener,
DropTargetListener,
DragGestureListener,
ClipboardOwner {
    public static final String KEY = "breakpoints";
    private static final String GIF = "/com/ibm/iseries/debug/dbg017.gif";
    private static final int ROOT_LEVEL = 0;
    private static final int GROUP_LEVEL = 1;
    private static final int PGM_LEVEL = 2;
    private static final int MODULE_LEVEL = 3;
    private static final int CLASS_DESC_LEVEL = 3;
    private static final int DESC_LEVEL = 4;
    private static final int ROOT_COUNT = 1;
    private static final int GROUP_COUNT = 2;
    private static final int PGM_COUNT = 3;
    private static final int MODULE_COUNT = 4;
    private static final int CLASS_DESC_COUNT = 4;
    private static final int DESC_COUNT = 5;
    private static final String DELETE = "delete";
    private JScrollPane m_scrollPane;
    private DefaultMutableTreeNode m_root = new DefaultMutableTreeNode(MRI.get("DBG_BREAKPOINT_GROUPS"));
    private JTree m_tree;
    private DefaultTreeModel m_treeModel;
    private TreeSelectionModel m_treeSelect;
    private ArrayList m_descriptors;
    private ArrayList m_groups;
    private HashMap m_groupNodes = new HashMap();
    private RootRenderer m_rootRenderer;
    private GroupRenderer m_groupRenderer;
    private ProgramRenderer m_pgmRenderer;
    private ModuleRenderer m_moduleRenderer;
    private BreakRenderer m_breakRenderer;
    private ContextMenu m_contextMenu;
    private DragSource m_dragSource;
    private DropTarget m_dropTarget;
    private TreePath m_dragPath;
    private BreakpointGroup m_dragGroup;
    private BreakpointGroup.Program m_dragPgm;
    private BreakpointGroup.Module m_dragModule;
    private boolean m_ignoreDrag;
    private boolean m_disableMsgs;
    private BreakpointGroupManager m_brkgrpMgr;

    public BreakpointsPanel() {
        super(MRI.get("DBG_BREAKPOINTS"), MRI.getIcon(0, GIF));
        this.m_descriptors = new ArrayList();
        this.m_groups = new ArrayList();
        this.m_tree = new JTree();
        this.m_treeModel = new DefaultTreeModel(this.m_root);
        this.m_treeSelect = this.m_tree.getSelectionModel();
        this.m_tree.setModel(this.m_treeModel);
        this.m_tree.addMouseListener(this);
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.registerKeyboardAction(this, DELETE, KeyStroke.getKeyStroke(127, 0), 2);
        this.m_scrollPane = new JScrollPane(this.m_tree);
        this.m_tree.addFocusListener(this);
        this.m_scrollPane.getViewport().addFocusListener(this);
        Util.setAccessible((Accessible)this.m_tree, this.m_name);
        Util.setOrientation(this.m_scrollPane);
        Util.setOrientation(this.m_tree);
        this.m_dropTarget = new DropTarget(this.m_tree, this);
        this.m_dragSource = new DragSource();
        this.m_dragSource.createDefaultDragGestureRecognizer(this.m_tree, 2, this);
    }

    private void lookAndFeelModifications() {
        String string = LAFManager.instance().getLookAndFeel();
        if (string.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
            this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.m_rootRenderer = new RootRenderer();
        this.m_groupRenderer = new GroupRenderer();
        this.m_pgmRenderer = new ProgramRenderer();
        this.m_moduleRenderer = new ModuleRenderer();
        this.m_breakRenderer = new BreakRenderer();
        this.m_tree.setCellRenderer(this.m_rootRenderer);
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("brkContextMenu", null));
        this.m_contextMenu.init(this.getActionGroup());
    }

    public void disableMessages() {
        this.m_disableMsgs = true;
    }

    public void enableMessages() {
        this.m_disableMsgs = false;
    }

    public boolean messagesDisabled() {
        return this.m_disableMsgs;
    }

    public void selectBreakpoint(BreakpointDescriptor breakpointDescriptor) {
        BreakpointGroup breakpointGroup = this.m_brkgrpMgr.getGroup(breakpointDescriptor.getGroupId());
        DefaultMutableTreeNode defaultMutableTreeNode = breakpointGroup != null ? this.m_groupNodes.get(breakpointGroup.getGroupName()) : null;
        if (defaultMutableTreeNode == null) {
            return;
        }
        BreakpointGroup.Program program = breakpointGroup.getProgram(breakpointDescriptor.getViewId());
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getPgmNode(defaultMutableTreeNode, breakpointGroup, program.getPgmPath());
        if (defaultMutableTreeNode2 == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        if (program.getPgmType() == 2) {
            int n = program.descriptorIndex(breakpointDescriptor.getLineNum());
            if (n < 0 || n > defaultMutableTreeNode2.getChildCount()) {
                return;
            }
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n);
        } else {
            BreakpointGroup.Module module = program.getModule(breakpointDescriptor.getViewId());
            DefaultMutableTreeNode defaultMutableTreeNode4 = this.getModuleNode(defaultMutableTreeNode2, program, module.getModuleName());
            if (defaultMutableTreeNode4 == null) {
                return;
            }
            int n = module.descriptorSortOrder(breakpointDescriptor.getLineNum());
            if (n < 0 || n > defaultMutableTreeNode4.getChildCount()) {
                return;
            }
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n);
        }
        if (defaultMutableTreeNode3 != null) {
            TreePath treePath = new TreePath(defaultMutableTreeNode3.getPath());
            this.m_tree.setSelectionPath(treePath);
        }
    }

    private Object getUserObject(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getUserObject();
    }

    private Object getUserObject(TreePath treePath, int n) {
        if (treePath.getPathCount() - 1 < n) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n);
        return defaultMutableTreeNode.getUserObject();
    }

    private boolean isRootPath(TreePath treePath) {
        return treePath.getPathCount() == 1;
    }

    private boolean isGroupPath(TreePath treePath) {
        return treePath.getPathCount() == 2;
    }

    private boolean isPgmPath(TreePath treePath) {
        return treePath.getPathCount() == 3;
    }

    private boolean isModulePath(TreePath treePath) {
        boolean bl = false;
        if (treePath.getPathCount() == 4 && this.getUserObject(treePath) instanceof BreakpointGroup.Module) {
            bl = true;
        }
        return bl;
    }

    private boolean isClassDescriptorPath(TreePath treePath) {
        boolean bl = false;
        if (treePath.getPathCount() == 4 && this.getUserObject(treePath) instanceof BreakpointDescriptor) {
            bl = true;
        }
        return bl;
    }

    private boolean isDescriptorPath(TreePath treePath) {
        boolean bl = false;
        if (treePath.getPathCount() == 5 && this.getUserObject(treePath) instanceof BreakpointDescriptor) {
            bl = true;
        }
        return bl;
    }

    private DefaultMutableTreeNode getPgmNode(DefaultMutableTreeNode defaultMutableTreeNode, BreakpointGroup breakpointGroup, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        block2: {
            int n;
            block1: {
                defaultMutableTreeNode2 = null;
                n = defaultMutableTreeNode.getChildCount();
                if (n != breakpointGroup.getProgramCount()) break block1;
                int n2 = breakpointGroup.programSortOrder(string);
                if (n2 < 0 || string.equals((defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2)).toString())) break block2;
                defaultMutableTreeNode2 = null;
                break block2;
            }
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (!string.equals(defaultMutableTreeNode3.toString())) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                break;
            }
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode getModuleNode(DefaultMutableTreeNode defaultMutableTreeNode, BreakpointGroup.Program program, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        block2: {
            int n;
            block1: {
                defaultMutableTreeNode2 = null;
                n = defaultMutableTreeNode.getChildCount();
                if (n != program.getModuleCount()) break block1;
                int n2 = program.moduleSortOrder(string);
                if (n2 < 0 || string.equals((defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2)).toString())) break block2;
                defaultMutableTreeNode2 = null;
                break block2;
            }
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (!string.equals(defaultMutableTreeNode3.toString())) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                break;
            }
        }
        return defaultMutableTreeNode2;
    }

    private void prepareActionContext(TreePath[] treePathArray) {
        if (!this.m_tree.hasFocus()) {
            return;
        }
        this.m_ctxt.getActionGroup().clearDltGroupContext();
        this.m_ctxt.getActionGroup().clearLnBrkContext();
        this.m_descriptors.clear();
        this.m_groups.clear();
        if (treePathArray == null || treePathArray.length == 0) {
            this.m_ctxt.updateBreakpointActions();
            this.m_ctxt.enableAction("copy", false);
            return;
        }
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < treePathArray.length; ++i) {
            Object object;
            TreePath treePath = treePathArray[i];
            if (this.isRootPath(treePath)) {
                object = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
                this.m_descriptors = ((BreakpointManager)object).getAllBreakpoints();
                break;
            }
            if (this.isGroupPath(treePath)) {
                object = (BreakpointGroup)this.getUserObject(treePath);
                ((BreakpointGroup)object).getDescriptors(this.m_descriptors);
                this.m_groups.add(((BreakpointGroup)object).getGroupName());
                ++n;
                continue;
            }
            if (this.isPgmPath(treePath)) {
                object = (BreakpointGroup.Program)this.getUserObject(treePath);
                ((BreakpointGroup.Program)object).getDescriptors(this.m_descriptors);
                bl = false;
                continue;
            }
            if (this.isModulePath(treePath)) {
                object = (BreakpointGroup.Module)this.getUserObject(treePath);
                ((BreakpointGroup.Module)object).getDescriptors(this.m_descriptors);
                bl = false;
                continue;
            }
            if (!this.isDescriptorPath(treePath) && !this.isClassDescriptorPath(treePath)) continue;
            object = (BreakpointDescriptor)this.getUserObject(treePath);
            this.m_descriptors.add(object);
            bl = false;
        }
        this.m_ctxt.updateBreakpointActions(bl, n, this.m_descriptors);
        this.m_ctxt.getActionGroup().setDltGroupContext(this.m_groups);
        this.m_ctxt.getActionGroup().setLnBrkContext(this.m_descriptors);
        this.m_ctxt.enableAction("copy", treePathArray.length > 0);
    }

    private void clearActionContext() {
        this.m_ctxt.updateBreakpointActions();
        this.m_ctxt.enableAction("copy", false);
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.lookAndFeelModifications();
        this.m_ctxt.getManager("brkmgr").addListener(this);
        this.m_ctxt.getManager("brkgrpmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
        this.m_brkgrpMgr = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
    }

    public void cleanUp() {
        this.m_ctxt.getManager("brkmgr").removeListener(this);
        this.m_ctxt.getManager("brkgrpmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_tree.removeFocusListener(this);
        this.m_scrollPane.getViewport().removeFocusListener(this);
        this.m_scrollPane = null;
        this.m_root = null;
        this.m_tree = null;
        this.m_treeModel = null;
        this.m_treeSelect = null;
        this.m_descriptors = null;
        this.m_groups = null;
        this.m_groupNodes = null;
        this.m_rootRenderer = null;
        this.m_groupRenderer = null;
        this.m_moduleRenderer = null;
        this.m_breakRenderer = null;
        this.m_contextMenu = null;
        this.m_dragSource = null;
        this.m_dropTarget = null;
        this.m_dragPath = null;
        this.m_dragGroup = null;
        this.m_dragPgm = null;
        this.m_dragModule = null;
        this.m_brkgrpMgr = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgbrkpts_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_scrollPane;
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
        } else {
            this.clearActionContext();
        }
    }

    public boolean canDoCopy() {
        return this.m_tree.getSelectionPath() != null;
    }

    public void copy() {
        TreePath treePath = this.m_tree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(defaultMutableTreeNode.toString());
            clipboard.setContents(stringSelection, this);
        }
    }

    public void breakpointGroupChanged(BreakpointGroupEvent breakpointGroupEvent) {
        switch (breakpointGroupEvent.getType()) {
            case 1: {
                ArrayList arrayList = this.m_brkgrpMgr.getGroups();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    BreakpointGroup breakpointGroup = (BreakpointGroup)arrayList.get(i);
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(breakpointGroup);
                    this.m_groupNodes.put(breakpointGroup.getGroupName(), defaultMutableTreeNode);
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, i);
                }
                this.m_tree.expandRow(0);
                break;
            }
            case 2: {
                this.m_root.removeAllChildren();
                this.m_treeModel.reload();
                break;
            }
            case 3: {
                this.insertGroupNode(breakpointGroupEvent.getGroup());
                break;
            }
            case 4: {
                this.removeGroupNode(breakpointGroupEvent.getGroup().getGroupName());
                break;
            }
            case 5: {
                this.renameGroupNode(breakpointGroupEvent.getPrevName(), breakpointGroupEvent.getGroup());
                this.m_tree.repaint(this.m_tree.getVisibleRect());
            }
        }
    }

    private void insertGroupNode(BreakpointGroup breakpointGroup) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_groupNodes.get(breakpointGroup.getGroupName());
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(breakpointGroup);
            this.m_groupNodes.put(breakpointGroup.getGroupName(), defaultMutableTreeNode);
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_root, this.m_brkgrpMgr.sortOrder(breakpointGroup.getGroupName()));
        }
    }

    private void removeGroupNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_groupNodes.get(string);
        if (defaultMutableTreeNode != null) {
            this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode);
            defaultMutableTreeNode.removeAllChildren();
            this.m_groupNodes.remove(string);
        }
    }

    private void renameGroupNode(String string, BreakpointGroup breakpointGroup) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (!string.equals(breakpointGroup.getGroupName()) && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_groupNodes.get(string)) != null) {
            this.m_groupNodes.remove(string);
            this.m_groupNodes.put(breakpointGroup.getGroupName(), defaultMutableTreeNode);
            this.m_treeModel.nodeChanged(defaultMutableTreeNode);
        }
    }

    public void breakpointChanged(BreakpointEvent breakpointEvent) {
        BreakpointGroup breakpointGroup = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = -1;
        int n2 = breakpointEvent.getCount();
        if (n2 > 0) {
            this.m_tree.clearSelection();
        }
        block17: for (int i = 0; i < n2; ++i) {
            BreakpointDescriptor breakpointDescriptor = breakpointEvent.getDescriptorAt(i);
            if (breakpointDescriptor.getGroupId() != n) {
                n = breakpointDescriptor.getGroupId();
                breakpointGroup = this.m_brkgrpMgr.getGroup(n);
                defaultMutableTreeNode = breakpointGroup != null ? this.m_groupNodes.get(breakpointGroup.getGroupName()) : null;
            }
            switch (breakpointEvent.getType()) {
                case 1: 
                case 6: {
                    Object object4;
                    Object object2 = breakpointGroup.getProgram(breakpointDescriptor.getViewId());
                    Object object3 = this.getPgmNode(defaultMutableTreeNode, breakpointGroup, ((BreakpointGroup.Program)object2).getPgmPath());
                    if (object3 == null) {
                        object3 = this.insertPgmNode(defaultMutableTreeNode, breakpointGroup, (BreakpointGroup.Program)object2);
                    }
                    switch (((BreakpointGroup.Program)object2).getPgmType()) {
                        case 0: 
                        case 1: 
                        case 10: 
                        case 11: 
                        case 12: {
                            object4 = ((BreakpointGroup.Program)object2).getModule(breakpointDescriptor.getViewId());
                            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getModuleNode((DefaultMutableTreeNode)object3, (BreakpointGroup.Program)object2, ((BreakpointGroup.Module)object4).getModuleName());
                            if (defaultMutableTreeNode2 == null) {
                                this.insertModuleNode((DefaultMutableTreeNode)object3, (BreakpointGroup.Program)object2, (BreakpointGroup.Module)object4, breakpointDescriptor);
                                break;
                            }
                            this.insertDescriptorNode(defaultMutableTreeNode2, (BreakpointGroup.Module)object4, breakpointDescriptor);
                            break;
                        }
                        case 2: {
                            this.insertClassDescriptorNode((DefaultMutableTreeNode)object3, (BreakpointGroup.Program)object2, breakpointDescriptor);
                        }
                    }
                    if (i != n2 - 1) continue block17;
                    if (n2 == 1) {
                        this.setSingularMessage(breakpointEvent, breakpointDescriptor);
                        continue block17;
                    }
                    this.setPluralMessage(breakpointEvent);
                    continue block17;
                }
                case 2: 
                case 5: {
                    Object object;
                    Object object4;
                    Object object3;
                    Object object2;
                    if (i == n2 - 1) {
                        if (n2 == 1) {
                            this.setSingularMessage(breakpointEvent, breakpointDescriptor);
                        } else {
                            this.setPluralMessage(breakpointEvent);
                        }
                    }
                    if (defaultMutableTreeNode == null || (object4 = this.getPgmNode(defaultMutableTreeNode, breakpointGroup, (String)(object3 = ((PgmManager)(object2 = (PgmManager)this.m_ctxt.getManager("pgmmgr"))).getPgmPath(breakpointDescriptor.getViewId())))) == null) continue block17;
                    BreakpointGroup.Program program = breakpointGroup.getProgram(breakpointDescriptor.getViewId());
                    if (program == null) {
                        this.m_treeModel.removeNodeFromParent((MutableTreeNode)object4);
                        ((DefaultMutableTreeNode)object4).removeAllChildren();
                        continue block17;
                    }
                    switch (program.getPgmType()) {
                        case 0: 
                        case 1: 
                        case 10: 
                        case 11: 
                        case 12: {
                            object = ((PgmManager)object2).getModuleName(breakpointDescriptor.getViewId());
                            DefaultMutableTreeNode defaultMutableTreeNode3 = this.getModuleNode((DefaultMutableTreeNode)object4, program, (String)object);
                            if (defaultMutableTreeNode3 == null) continue block17;
                            BreakpointGroup.Module module = program.getModule(breakpointDescriptor.getViewId());
                            if (module != null) {
                                int n3 = module.descriptorSortOrder(breakpointDescriptor.getLineNum());
                                if ((n3 = n3 * -1 - 1) >= defaultMutableTreeNode3.getChildCount()) continue block17;
                                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(n3);
                                this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode4);
                                break;
                            }
                            this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode3);
                            defaultMutableTreeNode3.removeAllChildren();
                            break;
                        }
                        case 2: {
                            int n4 = program.descriptorIndex(breakpointDescriptor.getLineNum());
                            n4 = n4 * -1 - 1;
                            if (n4 < ((DefaultMutableTreeNode)object4).getChildCount()) {
                                DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object4).getChildAt(n4);
                                this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode5);
                            } else {
                                break;
                            }
                        }
                    }
                    continue block17;
                }
                case 3: 
                case 4: {
                    Object object;
                    Object object2 = breakpointGroup.getProgram(breakpointDescriptor.getViewId());
                    Object object3 = this.getPgmNode(defaultMutableTreeNode, breakpointGroup, ((BreakpointGroup.Program)object2).getPgmPath());
                    Object object4 = null;
                    if (object3 == null) {
                        object3 = this.insertPgmNode(defaultMutableTreeNode, breakpointGroup, (BreakpointGroup.Program)object2);
                    }
                    switch (((BreakpointGroup.Program)object2).getPgmType()) {
                        case 0: 
                        case 1: 
                        case 10: 
                        case 11: 
                        case 12: {
                            BreakpointGroup.Module module = ((BreakpointGroup.Program)object2).getModule(breakpointDescriptor.getViewId());
                            object = this.getModuleNode((DefaultMutableTreeNode)object3, (BreakpointGroup.Program)object2, module.getModuleName());
                            int n5 = module.descriptorSortOrder(breakpointDescriptor.getLineNum());
                            if (object == null) {
                                object = this.insertModuleNode((DefaultMutableTreeNode)object3, (BreakpointGroup.Program)object2, module, breakpointDescriptor);
                                object4 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(0);
                                break;
                            }
                            if (n5 >= 0 && n5 < ((DefaultMutableTreeNode)object).getChildCount()) {
                                object4 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(n5);
                                break;
                            }
                            object4 = this.insertDescriptorNode((DefaultMutableTreeNode)object, module, breakpointDescriptor);
                            break;
                        }
                        case 2: {
                            int n6 = ((BreakpointGroup.Program)object2).descriptorIndex(breakpointDescriptor.getLineNum());
                            object4 = n6 >= 0 && n6 < ((DefaultMutableTreeNode)object3).getChildCount() ? (DefaultMutableTreeNode)((DefaultMutableTreeNode)object3).getChildAt(n6) : this.insertClassDescriptorNode((DefaultMutableTreeNode)object3, (BreakpointGroup.Program)object2, breakpointDescriptor);
                        }
                    }
                    if (object4 != null) {
                        TreePath treePath = new TreePath(((DefaultMutableTreeNode)object4).getPath());
                        this.m_tree.addSelectionPath(treePath);
                        this.m_treeModel.reload((TreeNode)object4);
                    }
                    if (i != n2 - 1) continue block17;
                    if (n2 == 1) {
                        this.setSingularMessage(breakpointEvent, breakpointDescriptor);
                        continue block17;
                    }
                    this.setPluralMessage(breakpointEvent);
                }
            }
        }
    }

    private void setPluralMessage(BreakpointEvent breakpointEvent) {
        if (this.m_disableMsgs) {
            return;
        }
        String string = null;
        switch (breakpointEvent.getType()) {
            case 1: {
                string = MRI.get("DBG_BREAKS_ADDED");
                break;
            }
            case 2: {
                string = MRI.get("DBG_BREAKS_REMOVED");
                break;
            }
            case 3: {
                string = MRI.get("DBG_BREAKS_ENABLED");
                break;
            }
            case 4: {
                string = MRI.get("DBG_BREAKS_DISABLED");
            }
        }
        if (string != null) {
            this.m_ctxt.setMessage(string);
        }
    }

    private void setSingularMessage(BreakpointEvent breakpointEvent, BreakpointDescriptor breakpointDescriptor) {
        if (this.m_disableMsgs) {
            return;
        }
        String string = null;
        switch (breakpointEvent.getType()) {
            case 1: {
                String string2 = breakpointDescriptor.getAddress();
                if (string2 == null) {
                    Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum())};
                    string = MessageFormat.format(MRI.get("DBG_BREAK_ADDED_FMT"), objectArray);
                    break;
                }
                Object[] objectArray = new Object[]{string2};
                string = MessageFormat.format(MRI.get("DBG_ASM_BREAK_ADDED_FMT"), objectArray);
                break;
            }
            case 2: {
                String string3 = breakpointDescriptor.getCondition();
                String string4 = breakpointDescriptor.getThreadId();
                String string5 = breakpointDescriptor.getAddress();
                if (string5 != null) {
                    Object[] objectArray = new Object[]{string5};
                    string = MessageFormat.format(MRI.get("DBG_ASM_BREAK_REMOVED_FMT"), objectArray);
                    break;
                }
                if (string3.length() > 0) {
                    if (string4.length() > 0) {
                        Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string3, string4};
                        string = MessageFormat.format(MRI.get("DBG_COND_TBREAK_REMOVED_FMT"), objectArray);
                        break;
                    }
                    Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string3};
                    string = MessageFormat.format(MRI.get("DBG_COND_BREAK_REMOVED_FMT"), objectArray);
                    break;
                }
                if (string4.length() > 0) {
                    Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string4};
                    string = MessageFormat.format(MRI.get("DBG_TBREAK_REMOVED_FMT"), objectArray);
                    break;
                }
                Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum())};
                string = MessageFormat.format(MRI.get("DBG_BREAK_REMOVED_FMT"), objectArray);
                break;
            }
            case 3: {
                String string6 = breakpointDescriptor.getCondition();
                String string7 = breakpointDescriptor.getThreadId();
                String string8 = breakpointDescriptor.getAddress();
                if (string8 != null) {
                    Object[] objectArray = new Object[]{string8};
                    string = MessageFormat.format(MRI.get("DBG_ASM_BREAK_ENABLED_FMT"), objectArray);
                    break;
                }
                if (string6.length() > 0) {
                    if (string7.length() > 0) {
                        Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string6, string7};
                        string = MessageFormat.format(MRI.get("DBG_COND_TBREAK_ENABLED_FMT"), objectArray);
                        break;
                    }
                    Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string6};
                    string = MessageFormat.format(MRI.get("DBG_COND_BREAK_ENABLED_FMT"), objectArray);
                    break;
                }
                if (string7.length() > 0) {
                    Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string7};
                    string = MessageFormat.format(MRI.get("DBG_TBREAK_ENABLED_FMT"), objectArray);
                    break;
                }
                Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum())};
                string = MessageFormat.format(MRI.get("DBG_BREAK_ENABLED_FMT"), objectArray);
                break;
            }
            case 4: {
                String string9 = breakpointDescriptor.getCondition();
                String string10 = breakpointDescriptor.getThreadId();
                String string11 = breakpointDescriptor.getAddress();
                if (string11 != null) {
                    Object[] objectArray = new Object[]{string11};
                    string = MessageFormat.format(MRI.get("DBG_ASM_BREAK_DISABLED_FMT"), objectArray);
                    break;
                }
                if (string9.length() > 0) {
                    if (string10.length() > 0) {
                        Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string9, string10};
                        string = MessageFormat.format(MRI.get("DBG_COND_TBREAK_DISABLED_FMT"), objectArray);
                        break;
                    }
                    Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string9};
                    string = MessageFormat.format(MRI.get("DBG_COND_BREAK_DISABLED_FMT"), objectArray);
                    break;
                }
                if (string10.length() > 0) {
                    Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum()), string10};
                    string = MessageFormat.format(MRI.get("DBG_TBREAK_DISABLED_FMT"), objectArray);
                    break;
                }
                Object[] objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum())};
                string = MessageFormat.format(MRI.get("DBG_BREAK_DISABLED_FMT"), objectArray);
            }
        }
        if (string != null) {
            this.m_ctxt.setMessage(string);
        }
    }

    private void ensureVisible(TreePath treePath) {
        Rectangle rectangle = this.m_tree.getVisibleRect();
        Rectangle rectangle2 = this.m_tree.getPathBounds(treePath);
        if (rectangle2.y < rectangle.y || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
            rectangle.y = rectangle2.y;
            this.m_tree.scrollRectToVisible(rectangle);
        }
    }

    private DefaultMutableTreeNode insertPgmNode(DefaultMutableTreeNode defaultMutableTreeNode, BreakpointGroup breakpointGroup, BreakpointGroup.Program program) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(program);
        int n = defaultMutableTreeNode.getChildCount();
        if (n == 0) {
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
        } else if (n == breakpointGroup.getProgramCount() - 1) {
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, breakpointGroup.programSortOrder(program.getPgmPath()));
        } else {
            int n2;
            String string = defaultMutableTreeNode2.toString();
            for (n2 = n - 1; n2 >= 0; --n2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                int n3 = string.compareTo(defaultMutableTreeNode3.toString());
                if (n3 < 0) continue;
                this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n2 + 1);
                break;
            }
            if (n2 < 0) {
                this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
            }
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode insertModuleNode(DefaultMutableTreeNode defaultMutableTreeNode, BreakpointGroup.Program program, BreakpointGroup.Module module, BreakpointDescriptor breakpointDescriptor) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(module);
        int n = defaultMutableTreeNode.getChildCount();
        if (n == 0) {
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
        } else if (n == program.getModuleCount() - 1) {
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, program.moduleSortOrder(module.getModuleName()));
        } else {
            int n2;
            object = defaultMutableTreeNode2.toString();
            for (n2 = n - 1; n2 >= 0; --n2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                int n3 = ((String)object).compareTo(defaultMutableTreeNode3.toString());
                if (n3 < 0) continue;
                this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n2 + 1);
                break;
            }
            if (n2 < 0) {
                this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
            }
        }
        object = new DefaultMutableTreeNode(breakpointDescriptor);
        this.m_treeModel.insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode2, 0);
        TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
        this.m_tree.expandPath(treePath);
        this.ensureVisible(treePath);
        treePath = new TreePath(((DefaultMutableTreeNode)object).getPath());
        this.m_tree.addSelectionPath(treePath);
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode insertDescriptorNode(DefaultMutableTreeNode defaultMutableTreeNode, BreakpointGroup.Module module, BreakpointDescriptor breakpointDescriptor) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = module.descriptorSortOrder(breakpointDescriptor.getLineNum());
        if (n < defaultMutableTreeNode.getChildCount() && ((BreakpointDescriptor)(object = (BreakpointDescriptor)(defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n)).getUserObject())).getLineNum() != breakpointDescriptor.getLineNum()) {
            defaultMutableTreeNode2 = null;
        }
        if (defaultMutableTreeNode2 == null) {
            if (n > defaultMutableTreeNode.getChildCount()) {
                n = defaultMutableTreeNode.getChildCount();
            }
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(breakpointDescriptor);
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
        } else {
            defaultMutableTreeNode2.setUserObject(breakpointDescriptor);
            this.m_treeModel.reload(defaultMutableTreeNode2);
        }
        object = new TreePath(defaultMutableTreeNode2.getPath());
        this.m_tree.addSelectionPath((TreePath)object);
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode insertClassDescriptorNode(DefaultMutableTreeNode defaultMutableTreeNode, BreakpointGroup.Program program, BreakpointDescriptor breakpointDescriptor) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = program.descriptorIndex(breakpointDescriptor.getLineNum());
        if (n < defaultMutableTreeNode.getChildCount() && ((BreakpointDescriptor)(object = (BreakpointDescriptor)(defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n)).getUserObject())).getLineNum() != breakpointDescriptor.getLineNum()) {
            defaultMutableTreeNode2 = null;
        }
        if (defaultMutableTreeNode2 == null) {
            if (n > defaultMutableTreeNode.getChildCount()) {
                n = defaultMutableTreeNode.getChildCount();
            }
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(breakpointDescriptor);
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
        } else {
            defaultMutableTreeNode2.setUserObject(breakpointDescriptor);
            this.m_treeModel.reload(defaultMutableTreeNode2);
        }
        object = new TreePath(defaultMutableTreeNode2.getPath());
        this.m_tree.addSelectionPath((TreePath)object);
        return defaultMutableTreeNode2;
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    private boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            TreePath treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                if (this.m_tree.isPathSelected(treePath)) {
                    this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
                } else {
                    this.m_tree.setSelectionPath(treePath);
                }
            } else {
                this.m_ctxt.updateBreakpointActions();
            }
            this.m_ignoreDrag = true;
            this.m_contextMenu.show(this.m_tree, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath;
        this.m_ctxt.setActivePanel(this);
        if (!this.handlePopupMenu(mouseEvent) && mouseEvent.getClickCount() == 2 && (treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (this.isDescriptorPath(treePath) || this.isClassDescriptorPath(treePath))) {
            this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
            this.m_ctxt.getAction("gosrc").run();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DELETE) && this.m_tree.hasFocus()) {
            Action action = this.m_ctxt.getAction("dgrp");
            if (action != null && action.isEnabled()) {
                action.run();
            } else {
                Action action2 = this.m_ctxt.getAction("rbrk");
                if (action2 != null && action2.isEnabled()) {
                    action2.run();
                }
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public boolean validateDrop(TreePath treePath) {
        Comparable comparable;
        if (treePath == null || this.isRootPath(treePath) || this.isDescriptorPath(treePath) || this.isClassDescriptorPath(treePath)) {
            return false;
        }
        if (this.m_dragPath != null && this.m_dragPath.getPathCount() < treePath.getPathCount()) {
            return false;
        }
        if (this.m_dragGroup != null && ((BreakpointGroup)(comparable = (BreakpointGroup)this.getUserObject(treePath, 1))).getGroupId() == this.m_dragGroup.getGroupId()) {
            return false;
        }
        if (this.m_dragPgm != null && (comparable = (BreakpointGroup.Program)this.getUserObject(treePath, 2)) != null && !((BreakpointGroup.Program)comparable).getPgmPath().equals(this.m_dragPgm.getPgmPath())) {
            return false;
        }
        return this.m_dragModule == null || (comparable = (BreakpointGroup.Module)this.getUserObject(treePath, 3)) == null || ((BreakpointGroup.Module)comparable).getModuleName().equals(this.m_dragModule.getModuleName());
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.getDropAction() != 2 || !dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.m_tree.getPathForLocation(point.x, point.y);
        if (this.validateDrop(treePath)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.dragOver(dropTargetDragEvent);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.m_tree.getPathForLocation(point.x, point.y);
        if (!this.validateDrop(treePath)) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        try {
            object = dropTargetDropEvent.getTransferable();
            String string = (String)object.getTransferData(DataFlavor.stringFlavor);
            if (string == null || !string.equals("DBG_BREAKPOINTS_PANEL")) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            dropTargetDropEvent.rejectDrop();
            return;
        }
        object = (BreakpointGroup)this.getUserObject(treePath, 1);
        this.m_brkgrpMgr.moveBreakpoints(this.m_dragGroup.getGroupId(), ((BreakpointGroup)object).getGroupId(), this.m_descriptors);
        dropTargetDropEvent.acceptDrop(2);
        this.m_dragPath = null;
        this.m_dragGroup = null;
        this.m_dragPgm = null;
        this.m_dragModule = null;
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.m_ignoreDrag) {
            this.m_ignoreDrag = false;
            return;
        }
        this.m_dragPath = null;
        this.m_dragGroup = null;
        this.m_dragPgm = null;
        this.m_dragModule = null;
        TreePath treePath = this.m_tree.getSelectionPath();
        if (treePath == null || this.isRootPath(treePath)) {
            return;
        }
        BreakpointGroup breakpointGroup = (BreakpointGroup)this.getUserObject(treePath, 1);
        if (!breakpointGroup.hasBreakpoints()) {
            return;
        }
        this.m_dragPath = treePath;
        this.m_dragGroup = breakpointGroup;
        this.m_dragPgm = (BreakpointGroup.Program)this.getUserObject(treePath, 2);
        if (this.isModulePath(treePath) || this.isDescriptorPath(treePath)) {
            this.m_dragModule = (BreakpointGroup.Module)this.getUserObject(treePath, 3);
        }
        this.m_dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, new StringSelection("DBG_BREAKPOINTS_PANEL"), this);
    }

    private class BreakRenderer
    extends DefaultTreeCellRenderer {
        private BreakpointIcon m_icon = null;

        public BreakRenderer() {
            FontMetrics fontMetrics = BreakpointsPanel.this.m_tree.getFontMetrics(BreakpointsPanel.this.m_tree.getFont());
            int n = fontMetrics.getAscent() + fontMetrics.getDescent();
            if (n % 2 == 0) {
                --n;
            }
            this.m_icon = new BreakpointIcon(n);
            this.setLeafIcon(this.m_icon);
            this.setOpenIcon(this.m_icon);
            this.setClosedIcon(this.m_icon);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)object2;
            this.m_icon.setGradient(breakpointDescriptor.isServiceEntryPoint());
            this.m_icon.setColor(BreakpointsPanel.this.m_brkgrpMgr.getGroupColor(breakpointDescriptor.getGroupId()));
            this.m_icon.setEnabled(breakpointDescriptor.isEnabled());
            return this;
        }
    }

    private class ModuleRenderer
    extends DefaultTreeCellRenderer {
    }

    private class ProgramRenderer
    extends DefaultTreeCellRenderer {
    }

    private class GroupRenderer
    extends DefaultTreeCellRenderer {
        private BreakpointSwatchIcon m_icon = null;

        public GroupRenderer() {
            int n = BreakpointsPanel.this.m_tree.getFontMetrics(BreakpointsPanel.this.m_tree.getFont()).getHeight() - 4;
            this.m_icon = new BreakpointSwatchIcon(n);
            this.setLeafIcon(this.m_icon);
            this.setOpenIcon(this.m_icon);
            this.setClosedIcon(this.m_icon);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            BreakpointGroup breakpointGroup = (BreakpointGroup)object2;
            this.m_icon.setGradient(!bl2 && !bl3);
            this.m_icon.setColor(breakpointGroup.getColor());
            this.setIcon(this.m_icon);
            return this;
        }
    }

    private class RootRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = null;
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object == BreakpointsPanel.this.m_root) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                component = this;
            } else if (object2 instanceof BreakpointGroup) {
                component = BreakpointsPanel.this.m_groupRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            } else if (object2 instanceof BreakpointGroup.Program) {
                component = BreakpointsPanel.this.m_pgmRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            } else if (object2 instanceof BreakpointGroup.Module) {
                component = BreakpointsPanel.this.m_moduleRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            } else if (object2 instanceof BreakpointDescriptor) {
                component = BreakpointsPanel.this.m_breakRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            } else {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                component = this;
            }
            return component;
        }
    }
}

