/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.dialog.DecryptionKeyDialog;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.request.SourceViewDecryptRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import java.text.MessageFormat;

public class SourceViewPacket
extends DebuggerPacket {
    protected static final String CANT_ACCESS_SOURCE = "CPF954A CPF954C CPF9565 CPF9598 CPF959E CPF9C87";
    protected static final String SOURCE_MODIFIED = "CPF9561 CPF9566 CPF9596 CPF9597";
    static int m_decTimes = 0;
    private static final int MAX_TRIES = 3;
    protected String m_viewId;
    protected String m_source;
    protected int m_startLineNum;
    protected int m_endLineNum;
    protected int m_lineCount;
    protected ISeriesMessage m_msgObj;

    public SourceViewPacket() {
        super(1504);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_viewId = null;
        this.m_source = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_viewId = commLink.readString();
        int n2 = commLink.readInt();
        this.m_source = n2 == 1 ? commLink.readString() : commLink.readAsciiString();
        this.m_startLineNum = commLink.readInt();
        this.m_endLineNum = commLink.readInt();
        this.m_lineCount = commLink.readInt();
        int n3 = commLink.readInt();
        if (n3 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            PgmManager pgmManager;
            ViewDescriptor viewDescriptor;
            SourceViewEvent sourceViewEvent = new SourceViewEvent(this, this.m_viewId, this.m_source, this.m_startLineNum, this.m_endLineNum, this.m_lineCount);
            SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
            sourceViewManager.fireSourceViewEvent(sourceViewEvent);
            if (this.m_lineCount > 0 && (viewDescriptor = (pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr")).getView(this.m_viewId)) != null && viewDescriptor.getTotalLineCount() != this.m_lineCount) {
                viewDescriptor.setTotalLineCount(this.m_lineCount);
            }
            m_decTimes = 0;
        } else {
            Object object;
            Object[] objectArray;
            String string = this.m_msgObj.getMsgId();
            boolean bl = true;
            boolean bl2 = true;
            if (SOURCE_MODIFIED.indexOf(string) >= 0) {
                objectArray = new SourceViewEvent(this, this.m_viewId, this.m_source, this.m_startLineNum, this.m_endLineNum, this.m_lineCount);
                object = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                ((SourceViewManager)object).fireSourceViewEvent((SourceViewEvent)objectArray);
                m_decTimes = 0;
            } else if (!(CANT_ACCESS_SOURCE.indexOf(string) < 0 && this.m_source.length() <= 0 || string.equals("CPF957E"))) {
                objectArray = (PgmManager)this.m_ctxt.getManager("pgmmgr");
                object = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                String string2 = objectArray.getAlternateViewId(this.m_viewId);
                if (string2.length() == 0) {
                    ((SourceViewManager)object).requestLocalSourceView(this.m_viewId, this.m_source);
                    bl2 = false;
                    bl = false;
                } else {
                    ((SourceViewManager)object).requestAlternateSourceView(string2);
                    bl2 = false;
                }
                m_decTimes = 0;
            } else if (string.equals("CPF957E") && m_decTimes < 3 && this.m_ctxt.getSystemVersion() >= 7.10001) {
                String string3;
                if (m_decTimes > 0) {
                    objectArray = new Object[]{Integer.toString(3 - m_decTimes)};
                    object = MessageFormat.format(MRI.get("DBG_DECTIMES_WARN"), objectArray);
                    Util.errorMessage(this.m_ctxt.getDebugFrame(), MRI.get("DBG_ERROR"), (String)object);
                }
                objectArray = new DecryptionKeyDialog(this.m_ctxt.getJFrame(), "Enter Decryption Key", "dbgentdeckey");
                object = (PgmManager)this.m_ctxt.getManager("pgmmgr");
                objectArray.setCompletePath(((PgmManager)object).getCompletePath(this.m_viewId));
                ViewDescriptor viewDescriptor = ((PgmManager)object).getView(this.m_viewId);
                SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                switch (viewDescriptor.getViewType()) {
                    case 1: {
                        string3 = MRI.get("DBG_SOURCE_VIEW");
                        break;
                    }
                    case 2: {
                        string3 = MRI.get("DBG_LISTING_VIEW");
                        break;
                    }
                    case 3: {
                        string3 = MRI.get("DBG_STATEMENT_VIEW");
                        break;
                    }
                    default: {
                        string3 = MRI.get("DBG_OTHER");
                    }
                }
                objectArray.setViewName(string3);
                if (this.m_source.length() == 30) {
                    objectArray.setSrcLibrary(this.m_source.substring(0, 10));
                    objectArray.setSrcFile(this.m_source.substring(10, 20));
                    objectArray.setSrcMbr(this.m_source.substring(20, 30));
                }
                objectArray.display();
                if (!objectArray.wasCanceled()) {
                    SourceViewDecryptRequest sourceViewDecryptRequest = new SourceViewDecryptRequest(objectArray.getPassword());
                    this.m_ctxt.sendRequest(sourceViewDecryptRequest);
                    sourceViewManager.requestSourceView(this.m_viewId);
                    ++m_decTimes;
                    bl2 = false;
                    bl = false;
                }
            }
            if (bl || bl2) {
                objectArray = Toolbox.instance().getMsgText(this.m_ctxt, this.m_msgObj);
                if (bl) {
                    this.m_ctxt.setMessage((String)objectArray);
                }
                if (bl2) {
                    object = new ISeriesMessageDialog(this.m_ctxt, this.m_msgObj);
                    ((Dialog)object).display(this.m_ctxt);
                }
            }
        }
        this.m_ctxt.retractClock();
        this.cleanUp();
    }
}

