/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.request.RmvPgmRequest;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;

public class RmvPgmPacket
extends DebuggerPacket {
    private PgmDescriptor[] m_descriptors;
    private ISeriesMessage m_msgObj;

    public RmvPgmPacket() {
        super(1503);
    }

    public void cleanUp() {
        super.cleanUp();
        for (int i = 0; i < this.m_descriptors.length; ++i) {
            this.m_descriptors[i] = null;
        }
        this.m_descriptors = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        int n3 = commLink.readInt();
        this.m_descriptors = new PgmDescriptor[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_descriptors[n2] = new PgmDescriptor();
            this.m_descriptors[n2].read(commLink);
        }
        n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            PgmEvent pgmEvent = new PgmEvent(this, 2, this.m_descriptors);
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            pgmManager.fireProgramRemovedEvent(pgmEvent);
            pgmEvent.cleanUp();
            if (RmvPgmRequest.isPending()) {
                ContextManager contextManager = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
                contextManager.refreshContext(true);
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }
}

