/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class LocalsPacket
extends DebuggerPacket
implements DebugConstants {
    private String m_viewId;
    private int m_lineNum;
    private int m_procId;
    private int m_varMask;
    private ArrayList m_descriptors;

    public LocalsPacket() {
        super(1508);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptors.clear();
        this.m_descriptors = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_viewId = commLink.readString();
        this.m_lineNum = commLink.readInt();
        this.m_varMask = commLink.readInt();
        this.m_procId = commLink.readInt();
        int n2 = commLink.readInt();
        this.m_descriptors = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            VariableDescriptor variableDescriptor = new VariableDescriptor();
            variableDescriptor.read(commLink);
            this.m_descriptors.add(variableDescriptor);
        }
        Collections.sort(this.m_descriptors);
    }

    public void run() {
        VariableManager variableManager = (VariableManager)this.m_ctxt.getManager("varmgr");
        variableManager.fireVariableEvent(new VariableEvent(this, 0, 1, this.m_descriptors, this.m_procId));
        this.cleanUp();
    }
}

