/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.panel.VariablesPanel;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;
import java.util.ArrayList;

public class EvalVarPacket
extends DebuggerPacket
implements DebugConstants {
    private int m_panelId;
    private int m_varMask;
    private ArrayList m_descriptors;
    private ISeriesMessage m_msgObj;

    public EvalVarPacket() {
        super(1514);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptors = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        this.m_panelId = commLink.readInt();
        this.m_varMask = commLink.readInt();
        int n3 = commLink.readInt();
        this.m_descriptors = new ArrayList(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            VariableDescriptor variableDescriptor = new VariableDescriptor();
            variableDescriptor.read(commLink);
            this.m_descriptors.add(variableDescriptor);
        }
        n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj != null) {
            this.displayMessage(this.m_msgObj);
            if (this.m_descriptors.size() == 1) {
                VariablesPanel variablesPanel = null;
                switch (this.m_panelId) {
                    case 1: {
                        variablesPanel = (VariablesPanel)this.m_ctxt.getPanel("locals");
                        break;
                    }
                    case 2: {
                        variablesPanel = (VariablesPanel)this.m_ctxt.getPanel("monitors");
                    }
                }
                variablesPanel.forgetDerefed((VariableDescriptor)this.m_descriptors.get(0));
                variablesPanel.forgetBounded((VariableDescriptor)this.m_descriptors.get(0));
            }
        } else {
            VariableManager variableManager = (VariableManager)this.m_ctxt.getManager("varmgr");
            variableManager.fireVariableEvent(new VariableEvent(this, 1, this.m_panelId, this.m_descriptors, 0));
        }
        this.m_ctxt.retractClock();
        this.cleanUp();
    }
}

