/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.memory.MemoryHexView;
import com.ibm.iseries.debug.util.DebugContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class MemoryCharEditor
extends JTextArea
implements DebugConstants,
CaretListener,
MouseListener {
    private static short[] EtoA = new short[]{0, 1, 2, 3, 26, 9, 26, 127, 26, 26, 26, 11, 12, 13, 14, 15, 16, 17, 18, 19, 26, 10, 8, 26, 24, 25, 26, 26, 28, 29, 30, 31, 26, 26, 28, 26, 26, 10, 23, 27, 26, 26, 26, 26, 26, 5, 6, 7, 26, 26, 22, 26, 26, 30, 26, 4, 26, 26, 26, 26, 20, 21, 26, 26, 32, 166, 225, 128, 235, 144, 159, 226, 171, 139, 155, 46, 60, 40, 43, 124, 38, 169, 170, 156, 219, 165, 153, 227, 168, 158, 33, 36, 42, 41, 59, 94, 45, 47, 223, 220, 154, 221, 222, 152, 157, 172, 186, 44, 37, 95, 62, 63, 215, 136, 148, 176, 177, 178, 252, 214, 251, 96, 58, 35, 64, 39, 61, 34, 248, 97, 98, 99, 100, 101, 102, 103, 104, 105, 150, 164, 243, 175, 174, 197, 140, 106, 107, 108, 109, 110, 111, 112, 113, 114, 151, 135, 206, 147, 241, 254, 200, 126, 115, 116, 117, 118, 119, 120, 121, 122, 239, 192, 218, 91, 242, 249, 181, 182, 253, 183, 184, 185, 230, 187, 188, 189, 141, 217, 191, 93, 216, 196, 123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 203, 202, 190, 232, 236, 237, 125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 161, 173, 245, 244, 163, 143, 92, 231, 83, 84, 85, 86, 87, 88, 89, 90, 160, 133, 142, 233, 228, 209, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 247, 240, 250, 167, 255};
    private static short[] AtoE = new short[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 37, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 34, 29, 53, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 173, 224, 189, 95, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 79, 208, 161, 7, 0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 37, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 34, 29, 53, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 173, 224, 189, 95, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 79, 208, 161, 7};
    private static Color s_fg = UIManager.getColor("TextArea.foreground");
    private static Color s_bg = UIManager.getColor("TextArea.background");
    private static Color s_caret = UIManager.getColor("TextArea.caretForeground");
    private MemoryHexView m_view;
    private int m_mode;
    private byte[] m_bytes;
    private int m_bytesPerLine;
    private int m_bytesPerChar;
    private int m_charsPerLine;
    private int m_cursorDirection;
    private boolean m_cursorNotify;
    private boolean m_forceMaxSizeEval;
    private boolean m_editing;

    public MemoryCharEditor(MemoryHexView memoryHexView) {
        this.m_view = memoryHexView;
        this.m_mode = 1;
        this.m_bytesPerChar = 1;
        this.m_cursorDirection = 1;
        this.m_cursorNotify = true;
        this.m_forceMaxSizeEval = true;
        this.addCaretListener(this);
        this.addMouseListener(this);
    }

    public void init(DebugContext debugContext, int n) {
        this.m_mode = debugContext.getUserConfig().getInt("memCharMode", n);
    }

    public void cleanUp() {
        this.setText("");
        this.m_view = null;
        this.m_bytes = null;
    }

    public JComponent getComponent() {
        return this;
    }

    public void setEditMode(boolean bl) {
        this.m_editing = bl;
        if (bl) {
            this.setBackground(s_fg);
            this.setForeground(s_bg);
            this.setCaretColor(s_bg);
        } else {
            this.setBackground(s_bg);
            this.setForeground(s_fg);
            this.setCaretColor(s_caret);
        }
    }

    public int getCharacterMode() {
        return this.m_mode;
    }

    public void setCharacterMode(int n) {
        int n2 = this.cursorToOffset(this.getCaretPosition());
        this.m_mode = n;
        this.m_forceMaxSizeEval = true;
        this.calculateBytesPerChar();
        if (this.m_bytes == null) {
            return;
        }
        this.setData(this.m_bytes, this.m_bytesPerLine, this.isEditable());
        this.setCaretPosition(this.offsetToCursor(n2));
    }

    private void calculateBytesPerChar() {
        switch (this.m_mode) {
            case 0: 
            case 1: {
                this.m_bytesPerChar = 1;
                break;
            }
            case 2: {
                this.m_bytesPerChar = 2;
                break;
            }
            case 3: {
                this.m_bytesPerChar = 4;
            }
        }
    }

    public int getBytesPerLine() {
        return this.m_bytesPerLine;
    }

    public void setBytesPerLine(int n) {
        if (this.m_bytes == null) {
            this.m_bytesPerLine = n;
            this.m_forceMaxSizeEval = true;
            return;
        }
        this.m_cursorNotify = false;
        int n2 = this.cursorToOffset(this.getCaretPosition());
        this.setData(this.m_bytes, n, this.isEditable());
        this.setCaretPosition(this.offsetToCursor(n2));
        this.m_cursorNotify = true;
    }

    public void setData(byte[] byArray, int n, boolean bl) {
        if (this.m_bytesPerLine != n) {
            this.m_forceMaxSizeEval = true;
        }
        this.calculateBytesPerChar();
        this.m_bytes = byArray;
        this.m_bytesPerLine = n;
        this.m_charsPerLine = this.m_bytesPerLine / this.m_bytesPerChar;
        String string = this.byteArrayToString(this.m_bytes);
        int n2 = string.length();
        int n3 = n2 % this.m_charsPerLine == 0 ? n2 / this.m_charsPerLine : n2 / this.m_charsPerLine + 1;
        StringBuffer stringBuffer = new StringBuffer(n2 + n3);
        stringBuffer.append(string);
        for (int i = this.m_charsPerLine; i < n2 + n3 - 1; i += this.m_charsPerLine + 1) {
            stringBuffer.insert(i, '\n');
        }
        this.setText(stringBuffer.toString());
        this.setEditable(bl);
        if (this.m_forceMaxSizeEval) {
            this.m_forceMaxSizeEval = false;
            try {
                String string2 = this.getText(0, this.getLineEndOffset(0));
                Dimension dimension = this.getMaximumSize();
                dimension.width = this.getFontMetrics(this.getFont()).stringWidth(string2) + 1;
                this.setMaximumSize(dimension);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void refresh() {
        int n = this.getCaretPosition();
        this.setData(this.m_bytes, this.m_bytesPerLine, this.isEditable());
        this.setCaretPosition(n);
    }

    public void refreshOffset(int n) {
        this.m_cursorNotify = false;
        byte[] byArray = new byte[this.m_bytesPerChar];
        int n2 = n;
        switch (this.m_bytesPerChar) {
            case 1: {
                byArray[0] = this.m_bytes[n];
                break;
            }
            case 2: {
                if (n % 2 == 1) {
                    --n;
                }
                System.arraycopy(this.m_bytes, n, byArray, 0, 2);
                break;
            }
            case 4: {
                if (n % 4 != 0) {
                    n -= n % 4;
                }
                System.arraycopy(this.m_bytes, n, byArray, 0, 4);
            }
        }
        String string = this.byteArrayToString(byArray);
        int n3 = this.offsetToCursor(n);
        this.replaceRange(string, n3, n3 + 1);
        if (this.m_bytesPerChar == 1) {
            this.setCaretPosition(n3 + 1);
        } else if ((n2 + 1) % this.m_bytesPerChar == 0) {
            this.setCaretPosition(n3 + 1);
        } else {
            this.setCaretPosition(n3);
        }
        this.m_cursorNotify = true;
    }

    public void clear() {
        this.setText("");
        this.getCaret().setVisible(false);
        this.m_bytes = null;
    }

    public int getCursorOffset() {
        if (this.getDocument().getLength() == 0) {
            return 0;
        }
        return this.cursorToOffset(this.getCaretPosition());
    }

    public void setCursorToOffset(int n, boolean bl) {
        int n2 = this.offsetToCursor(n);
        if (n2 < this.getDocument().getLength()) {
            this.m_cursorNotify = bl;
            this.setCaretPosition(n2);
            this.m_cursorNotify = true;
        }
    }

    protected String byteArrayToString(byte[] byArray) {
        String string = null;
        switch (this.m_mode) {
            case 1: {
                byte[] byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] >= 32 && byArray2[i] <= 126) continue;
                    byArray2[i] = 46;
                }
                string = new String(byArray2);
                break;
            }
            case 0: {
                byte[] byArray3 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                for (int i = 0; i < byArray3.length; ++i) {
                    short s = byArray3[i];
                    if (s < 0) {
                        s = (short)((short)(byArray3[i] & 0xF0) | (short)(byArray3[i] & 0xF));
                    }
                    byArray3[i] = (byte)EtoA[s];
                    if (byArray3[i] >= 32 && byArray3[i] <= 126) continue;
                    byArray3[i] = 46;
                }
                string = new String(byArray3);
                break;
            }
            case 2: {
                char[] cArray = new char[byArray.length / 2];
                int n = 0;
                int n2 = 0;
                while (n < byArray.length) {
                    cArray[n2] = (char)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
                    int n3 = Character.getType(cArray[n2]);
                    switch (n3) {
                        case 0: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 27: 
                        case 28: {
                            cArray[n2] = 46;
                        }
                    }
                    ++n2;
                }
                string = new String(cArray);
                break;
            }
            case 3: {
                char[] cArray = new char[byArray.length / 4];
                int n = 0;
                int n4 = 0;
                while (n < byArray.length) {
                    if (byArray[n] != 0 || byArray[n + 1] != 0) {
                        n += 4;
                        cArray[n4] = 46;
                    } else {
                        n += 2;
                        cArray[n4] = (char)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
                        int n5 = Character.getType(cArray[n4]);
                        switch (n5) {
                            case 0: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 18: 
                            case 19: 
                            case 27: 
                            case 28: {
                                cArray[n4] = 46;
                            }
                        }
                    }
                    ++n4;
                }
                string = new String(cArray);
            }
        }
        return string;
    }

    protected byte[] stringToByteArray(String string) {
        byte[] byArray = null;
        switch (this.m_mode) {
            case 1: {
                byArray = string.getBytes();
                break;
            }
            case 0: {
                byArray = string.getBytes();
                for (int i = 0; i < byArray.length; ++i) {
                    short s = byArray[i];
                    if (s < 0) {
                        s = (short)((short)(byArray[i] & 0xF0) | (short)(byArray[i] & 0xF));
                    }
                    byArray[i] = (byte)AtoE[s];
                }
                break;
            }
            case 2: {
                char[] cArray = new char[string.length()];
                string.getChars(0, cArray.length, cArray, 0);
                byArray = new byte[cArray.length * 2];
                int n = 0;
                for (int i = 0; i < cArray.length; ++i) {
                    byArray[n++] = (byte)(cArray[i] >> 8);
                    byArray[n++] = (byte)cArray[i];
                }
                break;
            }
            case 3: {
                char[] cArray = new char[string.length()];
                string.getChars(0, cArray.length, cArray, 0);
                byArray = new byte[cArray.length * 4];
                int n = 0;
                for (int i = 0; i < cArray.length; ++i) {
                    byArray[n++] = 0;
                    byArray[n++] = 0;
                    byArray[n++] = (byte)(cArray[i] >> 8);
                    byArray[n++] = (byte)cArray[i];
                }
                break;
            }
        }
        return byArray;
    }

    public String getLine(int n) {
        String string = "";
        try {
            int n2 = this.getLineStartOffset(n);
            int n3 = this.getLineEndOffset(n) - 1;
            int n4 = n3 - n2;
            if (n4 > 0) {
                string = this.getText(n2, n4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    protected int cursorToOffset(int n) {
        int n2 = -1;
        try {
            int n3 = this.getLineOfOffset(n);
            int n4 = n % (this.m_charsPerLine + 1);
            n2 = n3 * this.m_bytesPerLine + n4 * this.m_bytesPerChar;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }

    protected int offsetToCursor(int n) {
        int n2 = n / this.m_bytesPerLine;
        int n3 = n % this.m_bytesPerLine;
        int n4 = n2 * (this.m_charsPerLine + 1) + n3 / this.m_bytesPerChar;
        return n4;
    }

    protected boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public boolean isManagingFocus() {
        return false;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = keyEvent.getID() == 401;
        switch (keyEvent.getKeyCode()) {
            case 8: {
                int n;
                if (bl && (n = this.getCaretPosition()) > 0) {
                    this.m_cursorDirection = -1;
                    this.setCaretPosition(n - 1);
                }
                keyEvent.consume();
                break;
            }
            case 35: {
                if (bl) {
                    try {
                        if (keyEvent.getModifiers() == 2) {
                            this.setCaretPosition(this.getDocument().getLength() - 1);
                        } else {
                            this.setCaretPosition(this.getLineEndOffset(this.getLineOfOffset(this.getCaretPosition())) - 2);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                keyEvent.consume();
                break;
            }
            case 127: {
                if (bl) {
                    this.getToolkit().beep();
                }
                keyEvent.consume();
                break;
            }
            case 37: 
            case 38: 
            case 224: 
            case 226: {
                this.m_cursorDirection = -1;
                break;
            }
            default: {
                this.m_cursorDirection = 1;
                break;
            }
            case 27: {
                if (bl && this.m_editing) {
                    this.m_view.signalCancelEdit();
                }
                keyEvent.consume();
                break;
            }
            case 10: {
                if (bl && this.m_editing) {
                    this.m_view.signalAcceptEdit();
                }
                keyEvent.consume();
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyChar() == '\b') {
            return true;
        }
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
    }

    public void cut() {
    }

    public void replaceSelection(String string) {
        int n = this.getCaretPosition();
        int n2 = string.length();
        if (n2 == 0 || n >= this.getDocument().getLength()) {
            return;
        }
        if (this.hasSelection()) {
            this.setCaretPosition(this.getSelectionEnd());
            n = this.getCaretPosition();
        }
        byte[] byArray = this.stringToByteArray(string);
        int n3 = this.cursorToOffset(n);
        int n4 = n3 + byArray.length < this.m_bytes.length ? byArray.length : this.m_bytes.length - n3;
        System.arraycopy(byArray, 0, this.m_bytes, n3, n4);
        if (n2 == 1) {
            this.replaceRange(string, n, n + 1);
            this.m_view.charModified(n3, this.m_bytesPerChar);
        } else {
            this.refresh();
            this.m_view.charsModified();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(SettingsManager.getFixedPitchFont());
    }

    public void caretUpdate(CaretEvent caretEvent) {
        try {
            int n = this.getDocument().getLength();
            int n2 = caretEvent.getDot();
            if (n > 0 && !this.hasSelection()) {
                if (n2 < n) {
                    char c;
                    String string = this.getText(n2, 1);
                    if (string.length() > 0 && (c = string.charAt(0)) == '\n') {
                        this.setCaretPosition(n2 + this.m_cursorDirection);
                    }
                } else {
                    this.setCaretPosition(n - 1);
                }
                if (this.m_cursorNotify) {
                    this.m_view.syncCharCursor(this.cursorToOffset(this.getCaretPosition()));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isPopupTrigger() && (n = this.viewToModel(mouseEvent.getPoint())) >= 0) {
            this.setCaretPosition(n);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isPopupTrigger() && (n = this.viewToModel(mouseEvent.getPoint())) >= 0) {
            this.setCaretPosition(n);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

