/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.memory.MemoryRowHeader;
import com.ibm.iseries.debug.util.DebugContext;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public class MemoryAddrHeader
extends JTextArea
implements MemoryRowHeader {
    private DebugContext m_ctxt;
    private MemoryAddress m_addr;
    private int m_byteCount;
    private int m_bytesPerLine;

    public MemoryAddrHeader() {
        this.setEditable(false);
        this.getCaret().setVisible(false);
    }

    public void init(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public void cleanUp() {
        this.m_ctxt = null;
        this.m_addr = null;
        this.setText("");
    }

    public JComponent getComponent() {
        return this;
    }

    public void setAddress(MemoryAddress memoryAddress, int n, int n2) {
        if (this.m_addr != null && this.m_addr.equals(memoryAddress) && this.m_byteCount == n && this.m_bytesPerLine == n2) {
            return;
        }
        this.m_addr = memoryAddress;
        this.m_byteCount = n;
        this.m_bytesPerLine = n2;
        int n3 = this.m_ctxt.getAddrSizeInBits();
        int n4 = this.m_ctxt.getAddrOffsetSizeInBits();
        int n5 = 0;
        if (n4 > 0 && n3 > n4 && this.m_addr.getBitCount() > n4) {
            n5 = n3 / 4 - n4 / 4;
        }
        StringBuffer stringBuffer = new StringBuffer((this.m_addr.getNibbleCount() + 1) * (this.m_byteCount / n2 + 5));
        for (int i = 0; i < this.m_byteCount; i += n2) {
            stringBuffer.append(this.m_addr.add(i).toString(n5));
            stringBuffer.append("   ");
            if (i + n2 >= this.m_byteCount) continue;
            stringBuffer.append('\n');
        }
        this.setText(stringBuffer.toString());
    }

    public void clear() {
        this.setText("");
        this.m_addr = null;
        this.m_byteCount = 0;
        this.m_bytesPerLine = 0;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
    }

    public void scrollRectToVisible(Rectangle rectangle) {
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(SettingsManager.getFixedPitchFont());
    }
}

