/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.Breakpoints;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.event.BreakpointEvent;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.listener.BreakpointListener;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.listener.SourceViewListener;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.panel.BreakpointsPanel;
import com.ibm.iseries.debug.request.MapLnBrkRequest;
import com.ibm.iseries.debug.request.SourceViewRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Manager;
import com.ibm.iseries.debug.util.Request;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Tokenizer;
import com.ibm.iseries.debug.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFileChooser;

public class SourceViewManager
extends Manager
implements BreakpointListener,
SettingsListener,
DebugConstants {
    public static final String KEY = "srcmgr";
    protected static boolean s_sendAsUnicode = true;
    protected DebugContext m_ctxt;
    protected SourceChooser m_chooser;
    protected String m_defaultDir = "";
    protected String m_srcPath = "";
    protected String[] m_srcDir;
    protected int m_maxLines = 5000;
    protected int m_maxAsmLines = 200;
    protected boolean m_sendAsUnicode = true;
    protected SourceViewEvent m_curEvent;
    protected SourceViewEvent m_prevEvent;
    protected String m_pendingViewId;
    protected String m_mapFromViewId;
    protected String m_mapToViewId;
    protected HashMap m_localSrcFiles;

    public static void setUnicodeSrc(boolean bl) {
        s_sendAsUnicode = bl;
    }

    public static boolean getUnicodeSrc() {
        return s_sendAsUnicode;
    }

    public SourceViewManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        this.m_localSrcFiles = new HashMap();
        Settings settings = this.m_ctxt.getUserConfig();
        this.m_defaultDir = settings.getString("srcDir", System.getProperty("user.home"));
        this.m_maxLines = settings.getInt("srcMaxLines", 5000);
        this.m_maxAsmLines = settings.getInt("asmMaxLines", 200);
        this.m_sendAsUnicode = settings.getBool("srcUnicode", s_sendAsUnicode);
        this.parseSourcePath();
        this.m_ctxt.getManager("settmgr").addListener(this);
    }

    public String getKey() {
        return KEY;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_ctxt.getManager("settmgr").removeListener(this);
        this.m_localSrcFiles.clear();
        this.m_ctxt = null;
        this.m_chooser = null;
        this.m_defaultDir = null;
        this.m_srcPath = null;
        this.m_srcDir = null;
        this.m_curEvent = null;
        this.m_prevEvent = null;
        this.m_pendingViewId = null;
        this.m_mapFromViewId = null;
        this.m_mapToViewId = null;
        this.m_localSrcFiles = null;
    }

    public void clear() {
        super.clear();
        if (this.m_localSrcFiles != null) {
            this.m_localSrcFiles.clear();
        }
    }

    public SourceChooser getSourceChooser() {
        if (this.m_chooser == null) {
            this.m_chooser = new SourceChooser(this.m_defaultDir);
        }
        return this.m_chooser;
    }

    public void autoRequestSourceView(String string) {
        BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
        if (breakpointManager.hasPendingBreakpoints()) {
            this.m_pendingViewId = string;
            breakpointManager.addListener(this);
        } else {
            this.requestSourceView(string, -1, -1, false, null);
        }
    }

    public void requestSourceView(String string) {
        this.requestSourceView(string, -1, -1, false, null);
    }

    public void requestSourceViewLineNum(String string, int n) {
        this.requestSourceView(string, -1, n, true, null);
    }

    public void requestSourceViewContext(String string, int n) {
        this.requestSourceView(string, n, -1, false, null);
    }

    public void requestSourceViewFind(String string, int n, String string2) {
        this.requestSourceView(string, -1, n, false, string2);
    }

    public void requestSourceViewScroll(String string, int n) {
        this.requestSourceView(string, -1, n, false, null);
    }

    public void requestAlternateSourceView(String string) {
        if (this.m_mapToViewId != null) {
            this.m_mapToViewId = string;
        }
        this.requestSourceView(string, -1, -1, false, null);
    }

    public void requestAndMapSourceView(String string, String string2) {
        this.m_mapFromViewId = string;
        this.m_mapToViewId = string2;
        this.requestSourceView(string2, -1, -1, false, null);
    }

    protected void requestSourceView(String string, int n, int n2, boolean bl, String string2) {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        ContextManager contextManager = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
        ViewDescriptor viewDescriptor = pgmManager.getView(string);
        if (viewDescriptor != null) {
            Object object;
            int n3;
            int n4 = 1;
            int n5 = 0;
            int n6 = viewDescriptor.getTotalLineCount();
            int n7 = 1;
            int n8 = n3 = viewDescriptor.isAssembler() ? this.m_maxAsmLines : this.m_maxLines;
            if (n6 > n3) {
                if (n > 0) {
                    n7 = n;
                } else if (n2 > 0) {
                    n7 = n2;
                } else if (string.equals(contextManager.getContextViewId())) {
                    n7 = contextManager.getContextLineNum();
                } else if (string.equals(contextManager.getAsmContextViewId())) {
                    n7 = contextManager.getAsmContextLineNum();
                } else {
                    n7 = n2 = this.locateBreakpointLineNum(string);
                    bl = false;
                }
                if (n7 > 0 && this.isCacheHit(string, n7, n2, bl, string2)) {
                    return;
                }
                n4 = this.locateStartLineNum(n7, n6, n3);
                n5 = n4 + n3 - 1;
                if (n5 > n6) {
                    n5 = n6;
                }
            } else if (n < 0 && n2 < 0 && !string.equals(contextManager.getContextViewId()) && !string.equals(contextManager.getAsmContextViewId())) {
                n2 = this.locateBreakpointLineNum(string);
                bl = false;
            }
            this.m_ctxt.postClock();
            if (n2 > 0) {
                object = this.m_ctxt.getDesktop();
                object.setUserPointOfInterest(string, n2, bl, string2);
            }
            object = new SourceViewRequest(string, n4, n5, this.m_sendAsUnicode);
            this.m_ctxt.sendRequest((Request)object);
        } else {
            int n9 = this.m_maxLines;
            int n10 = 1;
            int n11 = 0;
            int n12 = -1;
            if (n > 0) {
                n12 = n;
            } else if (n2 > 0) {
                n12 = n2;
            } else if (string.equals(contextManager.getContextViewId())) {
                n12 = contextManager.getContextLineNum();
            } else if (string.equals(contextManager.getAsmContextViewId())) {
                n12 = contextManager.getAsmContextLineNum();
                n9 = this.m_maxAsmLines;
            }
            if (n12 > n9) {
                n10 = n12 - n9;
                if (n10 < 1) {
                    n10 = 1;
                }
                n11 = n10 + n9;
            }
            SourceViewRequest sourceViewRequest = new SourceViewRequest(string, n10, n11, this.m_sendAsUnicode);
            this.m_ctxt.sendRequest(sourceViewRequest);
        }
    }

    protected boolean isCacheHit(String string, int n, int n2, boolean bl, String string2) {
        if (this.m_prevEvent != null && this.m_prevEvent.containsLineNum(string, n)) {
            if (n2 > 0) {
                this.m_ctxt.getDesktop().setUserPointOfInterest(string, n2, bl, string2);
            }
            this.m_ctxt.postClock();
            this.fireSourceViewEvent(this.m_prevEvent);
            this.m_ctxt.retractClock();
            return true;
        }
        return false;
    }

    protected int locateStartLineNum(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = n3 / 2;
        n4 = n + n5 > n2 ? n2 - n3 + 1 : n - n5;
        if (n4 < 1) {
            n4 = 1;
        }
        return n4;
    }

    protected int locateBreakpointLineNum(String string) {
        Breakpoints breakpoints;
        BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
        int n = -1;
        if (breakpointManager.hasBreakpoints(string) && (breakpoints = breakpointManager.getBreakpoints(string)) != null) {
            ArrayList arrayList = breakpoints.getDescriptors();
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)arrayList.get(i);
                if (i != 0 && !breakpointDescriptor.isEnabled()) continue;
                n = breakpointDescriptor.getLineNum();
                if (breakpointDescriptor.isEnabled()) break;
            }
            arrayList.clear();
        }
        return n;
    }

    public void requestLocalSourceView(String string, String string2) {
        int n;
        File file;
        File file2 = (File)this.m_localSrcFiles.get(string);
        if (file2 != null) {
            if (file2.getPath().length() > 0) {
                this.createSourceViewEvent(string, file2);
            }
            return;
        }
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        PgmDescriptor pgmDescriptor = pgmManager.getProgram(string);
        file2 = pgmDescriptor.getPgmType() == 2 ? this.searchSourcePathForClass(pgmDescriptor.getPgmPath()) : this.searchSourcePath(string2);
        if (file2 != null) {
            Object[] objectArray = new Object[]{file2.getAbsolutePath()};
            this.m_ctxt.setMessage(MessageFormat.format(MRI.get("DBG_SOURCE_FILE_LOCATION_FMT"), objectArray));
            this.m_localSrcFiles.put(string, file2);
            this.createSourceViewEvent(string, file2);
            return;
        }
        Object[] objectArray = new Object[]{pgmDescriptor.getPgmPath(), ""};
        String string3 = MRI.get("DBG_SOURCE_NOT_AVAILABLE_FMT");
        String string4 = MRI.get("DBG_SOURCE_ON_CLIENT_FMT");
        if (string2.length() > 0) {
            objectArray[0] = string2;
            objectArray[1] = pgmDescriptor.getPgmPath();
            string3 = MRI.get("DBG_SOURCE_FILE_NOT_AVAILABLE_FMT");
            string4 = MRI.get("DBG_SOURCE_FILE_ON_CLIENT_FMT");
        }
        this.m_ctxt.setMessage(MessageFormat.format(string3, objectArray));
        int n2 = Util.confirm(this.m_ctxt.getJFrame(), MRI.get("DBG_SOURCE_NOT_AVAILABLE_TITLE"), MessageFormat.format(string4, objectArray));
        if (n2 != 0) {
            this.m_localSrcFiles.put(string, new File(""));
            return;
        }
        this.m_chooser = this.getSourceChooser();
        if (string2.length() > 0 && (file = this.m_chooser.getCurrentDirectory()) != null && (file2 = new File(file, string2)).exists() && file2.canRead()) {
            this.m_chooser.setSelectedFile(file2);
        }
        if ((n = this.m_chooser.showOpenDialog(this.m_ctxt.getJFrame())) == 0) {
            String string5 = this.m_chooser.getCurrentDirectory().getAbsolutePath();
            if (!this.m_defaultDir.equals(string5)) {
                this.m_defaultDir = string5;
                this.m_ctxt.getUserConfig().setString("srcDir", this.m_defaultDir);
            }
            file2 = this.m_chooser.getSelectedFile();
            objectArray[0] = file2.getAbsolutePath();
            this.m_ctxt.setMessage(MessageFormat.format(MRI.get("DBG_SOURCE_FILE_LOCATION_FMT"), objectArray));
            this.m_localSrcFiles.put(string, file2);
            this.createSourceViewEvent(string, file2);
        }
    }

    public void requestSourceViews(String[] stringArray) {
    }

    public void addToFilenameCache(String string, String string2) {
    }

    public void rmvFromFilenameCache(String string) {
    }

    public void rmvFromLocalFilesCache(String string) {
        this.m_localSrcFiles.remove(string);
    }

    public void requestSourceViewFromMethod(String string) {
    }

    protected void parseSourcePath() {
        String string = this.m_ctxt.getUserConfig().getString("strdbgClientSrcPath", "");
        if (string.length() == 0) {
            this.m_srcDir = new String[0];
            return;
        }
        if (!this.m_srcPath.equals(string)) {
            this.m_srcPath = string;
            this.m_srcDir = Tokenizer.tokenize(this.m_srcPath, File.pathSeparator);
            if (this.m_srcDir != null) {
                for (int i = 0; i < this.m_srcDir.length; ++i) {
                    if (this.m_srcDir[i].endsWith(File.separator)) continue;
                    int n = i;
                    this.m_srcDir[n] = this.m_srcDir[n] + File.separator;
                }
            } else {
                this.m_srcDir = new String[0];
            }
        }
    }

    protected File searchAllDirs(String string, String string2) {
        File file = null;
        String string3 = string + File.separator + string2;
        file = new File(string3);
        if (file != null && file.exists() && file.canRead()) {
            return file;
        }
        file = null;
        File file2 = new File(string);
        File[] fileArray = file2.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    String string4 = fileArray[i].getPath();
                    if (string4.indexOf(".") != 0) {
                        file = this.searchAllDirs(string4, string2);
                    } else {
                        string3 = string4 + string2;
                        file = new File(string3);
                    }
                }
                if (file != null && file.exists() && file.canRead()) break;
                file = null;
            }
        }
        return file;
    }

    protected File searchSourcePath(String string) {
        File file = null;
        if (string.length() != 0) {
            this.parseSourcePath();
            for (int i = 0; i < this.m_srcDir.length; ++i) {
                String string2;
                String string3 = this.m_srcDir[i];
                int n = string3.lastIndexOf(42);
                if (n > 1) {
                    string2 = string3.substring(0, n - 1);
                    file = this.searchAllDirs(string2, string);
                } else {
                    string2 = this.m_srcDir[i] + string;
                    file = new File(string2);
                }
                if (file != null && file.exists() && file.canRead()) break;
                file = null;
            }
        }
        return file;
    }

    protected File searchSourcePathForClass(String string) {
        String string2;
        File file = null;
        this.parseSourcePath();
        String string3 = string.replace('.', File.separatorChar);
        for (int i = 0; !(i >= this.m_srcDir.length || (file = new File(string2 = this.m_srcDir[i] + string3 + ".java")).exists() && file.canRead()); ++i) {
            file = null;
        }
        return file;
    }

    protected void createSourceViewEvent(String string, File file) {
        if (file.exists() && file.canRead()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                int n = (int)file.length();
                byte[] byArray = new byte[n];
                fileInputStream.read(byArray);
                String string2 = new String(byArray);
                SourceViewEvent sourceViewEvent = new SourceViewEvent(this, string, string2, 1, 0, 0);
                this.fireSourceViewEvent(sourceViewEvent);
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                String string3 = MessageFormat.format(MRI.get("DBG_SOURCE_READ_ERROR_FMT"), objectArray);
                this.m_ctxt.setMessage(string3);
                Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), string3);
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void fireSourceViewEvent(SourceViewEvent sourceViewEvent) {
        Object object;
        int n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            object = (SourceViewListener)this.m_listeners.get(i);
            object.sourceViewAvailable(sourceViewEvent);
        }
        if (this.m_mapFromViewId != null && this.m_mapToViewId != null) {
            if (!this.m_mapFromViewId.equals(this.m_mapToViewId)) {
                BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
                if (breakpointManager.hasBreakpoints(this.m_mapFromViewId)) {
                    object = (BreakpointsPanel)this.m_ctxt.getPanel("breakpoints");
                    ((BreakpointsPanel)object).disableMessages();
                    Breakpoints breakpoints = breakpointManager.getBreakpoints(this.m_mapFromViewId);
                    ArrayList arrayList = breakpoints.getDescriptors();
                    MapLnBrkRequest mapLnBrkRequest = new MapLnBrkRequest(this.m_mapToViewId, arrayList);
                    this.m_ctxt.sendRequest(mapLnBrkRequest);
                    this.m_ctxt.getPgmEnv().setSaved(false);
                }
                object = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
                ((ContextManager)object).mapContext(this.m_mapFromViewId, this.m_mapToViewId);
            }
            this.m_mapToViewId = null;
            this.m_mapFromViewId = null;
        }
        if (!sourceViewEvent.isFullSource()) {
            if (this.m_prevEvent != null && this.m_prevEvent != sourceViewEvent) {
                this.m_prevEvent.cleanUp();
            }
            this.m_prevEvent = this.m_curEvent;
            this.m_curEvent = sourceViewEvent;
        } else {
            sourceViewEvent.cleanUp();
        }
    }

    public void breakpointChanged(BreakpointEvent breakpointEvent) {
        if (this.m_pendingViewId != null) {
            BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
            if (breakpointEvent.getType() == 1 && breakpointManager.hasPendingDisable()) {
                return;
            }
            this.requestSourceView(this.m_pendingViewId, -1, -1, false, null);
            this.m_pendingViewId = null;
            breakpointManager.removeListener(this);
        }
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
        if (settingsEvent.generalChanged()) {
            Settings settings = this.m_ctxt.getUserConfig();
            this.m_maxLines = settings.getInt("srcMaxLines", 5000);
            this.m_maxAsmLines = settings.getInt("asmMaxLines", 200);
        }
    }

    public class SourceChooser
    extends JFileChooser {
        public SourceChooser(String string) {
            super(string);
        }
    }
}

