/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.listener.PgmListener;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.request.AddPgmRequest;
import com.ibm.iseries.debug.request.RmvPgmRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugFile;
import com.ibm.iseries.debug.util.Manager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class PgmManager
extends Manager
implements DebugConstants {
    public static final String KEY = "pgmmgr";
    protected DebugContext m_ctxt;
    protected HashMap m_viewIdToPgm;
    protected HashMap m_viewIdToModule;
    protected HashMap m_viewIdToView;
    protected HashMap m_initialView;
    protected ArrayList m_pgms;
    protected ArrayList m_srvpgms;
    protected ArrayList m_classes;
    protected AddPgmRequest m_envRequest;
    protected ModuleDescriptor m_mainModule;

    public PgmManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        this.m_viewIdToPgm = new HashMap();
        this.m_viewIdToModule = new HashMap();
        this.m_viewIdToView = new HashMap();
        this.m_initialView = new HashMap();
        this.init();
    }

    public String getKey() {
        return KEY;
    }

    public void init() {
        if (this.m_pgms == null) {
            this.m_pgms = new ArrayList();
        }
        if (this.m_srvpgms == null) {
            this.m_srvpgms = new ArrayList();
        }
        if (this.m_classes == null) {
            this.m_classes = new ArrayList();
        }
    }

    public void clear() {
        super.clear();
        this.clearMaps();
        this.fireProgramsClearedEvent(new PgmEvent(this, 3));
    }

    public void cleanUp() {
        super.cleanUp();
        this.clearMaps();
        this.m_ctxt = null;
        this.m_viewIdToPgm = null;
        this.m_viewIdToModule = null;
        this.m_viewIdToView = null;
        this.m_initialView = null;
        this.m_pgms = null;
        this.m_srvpgms = null;
        this.m_classes = null;
        this.m_envRequest = null;
    }

    protected ArrayList pgmTypeToList(int n) {
        switch (n) {
            case 0: {
                return this.m_pgms;
            }
            case 1: {
                return this.m_srvpgms;
            }
            case 2: {
                return this.m_classes;
            }
        }
        return null;
    }

    public PgmDescriptor getProgram(String string) {
        return (PgmDescriptor)this.m_viewIdToPgm.get(string);
    }

    public ModuleDescriptor getModule(String string) {
        return (ModuleDescriptor)this.m_viewIdToModule.get(string);
    }

    public ModuleDescriptor getMainModule() {
        return this.m_mainModule;
    }

    public String getModuleName(String string) {
        String string2 = "";
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (moduleDescriptor != null) {
            string2 = moduleDescriptor.getModuleName();
        }
        return string2;
    }

    public MemoryAddress getModuleAddress(String string) {
        MemoryAddress memoryAddress = null;
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (moduleDescriptor != null) {
            memoryAddress = moduleDescriptor.getStartAddress();
        }
        return memoryAddress;
    }

    public ViewDescriptor getView(String string) {
        return (ViewDescriptor)this.m_viewIdToView.get(string);
    }

    public MemoryAddress getViewAddress(String string, int n) {
        ModuleDescriptor moduleDescriptor;
        MemoryAddress memoryAddress = null;
        ViewDescriptor viewDescriptor = (ViewDescriptor)this.m_viewIdToView.get(string);
        if (viewDescriptor != null && viewDescriptor.isAssembler() && (moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string)) != null) {
            memoryAddress = moduleDescriptor.getStartAddress().add((n - 1) * 4);
        }
        return memoryAddress;
    }

    public String getViewId(String string, String string2, int n, String string3) {
        String string4 = PgmDescriptor.getPgmPath(string, string2, n);
        ArrayList arrayList = this.pgmTypeToList(n);
        int n2 = Collections.binarySearch(arrayList, string4);
        if (n2 >= 0) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)arrayList.get(n2);
            int n3 = pgmDescriptor.getModuleCount();
            for (int i = 0; i < n3; ++i) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(i);
                if (!moduleDescriptor.getModuleName().equals(string3)) continue;
                return moduleDescriptor.getViewId();
            }
        }
        return "";
    }

    public String getCompletePath(String string) {
        String string2 = "";
        PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_viewIdToPgm.get(string);
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (pgmDescriptor != null && moduleDescriptor != null) {
            string2 = PgmDescriptor.getCompletePath(pgmDescriptor.getPgmLibrary(), pgmDescriptor.getPgmName(), pgmDescriptor.getPgmType(), moduleDescriptor.getModuleName());
        }
        return string2;
    }

    public String getPgmPath(String string) {
        String string2 = "";
        PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_viewIdToPgm.get(string);
        if (pgmDescriptor != null) {
            string2 = pgmDescriptor.getPgmPath();
        }
        return string2;
    }

    public String getAlternateViewId(String string) {
        int n;
        ViewDescriptor viewDescriptor;
        String string2 = "";
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (moduleDescriptor != null && (viewDescriptor = moduleDescriptor.getCurrentView()).isSource() && (n = moduleDescriptor.getCurrentViewIndex()) < moduleDescriptor.getViewCount() - 1 && !(viewDescriptor = moduleDescriptor.getViewAt(n + 1)).isStatement()) {
            string2 = viewDescriptor.getViewId();
            moduleDescriptor.setCurrentViewIndex(n + 1);
        }
        return string2;
    }

    public int programSortOrder(String string, int n) {
        ArrayList arrayList = this.pgmTypeToList(n);
        if (arrayList != null) {
            return Collections.binarySearch(arrayList, string);
        }
        return 0;
    }

    public void setInitialViewIndex(String string, String string2, int n, String string3, int n2) {
        String string4 = PgmDescriptor.getPgmPath(string, string2, n) + "_" + string3;
        this.m_initialView.put(string4, new Integer(n2));
    }

    protected String setInitialViewId(PgmDescriptor pgmDescriptor, ModuleDescriptor moduleDescriptor) {
        String string = pgmDescriptor.getPgmPath() + "_" + moduleDescriptor.getModuleName();
        Integer n = (Integer)this.m_initialView.get(string);
        String string2 = moduleDescriptor.getViewId();
        if (n != null) {
            moduleDescriptor.setCurrentViewIndex(n);
            this.m_initialView.remove(string);
        }
        return string2;
    }

    public void fireProgramAddedEvent(PgmEvent pgmEvent) {
        int n;
        if (this.m_envRequest != null) {
            switch (pgmEvent.getInitiatedFrom()) {
                case 1: {
                    this.m_envRequest = null;
                    break;
                }
                case 0: {
                    return;
                }
                case -1: {
                    this.m_envRequest = null;
                    return;
                }
            }
        }
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        int n2 = pgmEvent.getCount();
        boolean bl = this.m_viewIdToPgm.isEmpty();
        boolean bl2 = !this.m_initialView.isEmpty();
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        if (bl) {
            string2 = this.m_ctxt.getPgmEnv().getEnvPgmPath();
        }
        for (n = 0; n < n2; ++n) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n);
            int n3 = pgmDescriptor.getPgmType();
            int n4 = this.programSortOrder(pgmDescriptor.getPgmPath(), n3);
            if (n4 >= 0) continue;
            ArrayList arrayList = this.pgmTypeToList(n3);
            arrayList.add(n4 * -1 - 1, pgmDescriptor);
            int n5 = pgmDescriptor.getModuleCount();
            for (int i = 0; i < n5; ++i) {
                String string3;
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(i);
                int n6 = moduleDescriptor.getViewCount();
                for (int j = 0; j < n6; ++j) {
                    ViewDescriptor viewDescriptor = moduleDescriptor.getViewAt(j);
                    String string4 = viewDescriptor.getViewId();
                    if (j == 0 && bl && !bl3 && viewDescriptor.hasMain()) {
                        this.m_mainModule = moduleDescriptor;
                        string = string4;
                        if (pgmDescriptor.getPgmPath().equals(string2)) {
                            bl3 = true;
                        }
                    }
                    this.m_viewIdToPgm.put(string4, pgmDescriptor);
                    this.m_viewIdToModule.put(string4, moduleDescriptor);
                    this.m_viewIdToView.put(string4, viewDescriptor);
                }
                if (!bl2 || string == null || !(string3 = this.setInitialViewId(pgmDescriptor, moduleDescriptor)).equals(string)) continue;
                string = moduleDescriptor.getViewId();
            }
        }
        n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(i);
            pgmListener.programAdded(pgmEvent);
        }
        if (bl && bl3) {
            sourceViewManager.autoRequestSourceView(string);
        }
    }

    public void fireProgramUpdatedEvent(PgmEvent pgmEvent) {
        int n;
        int n2 = pgmEvent.getCount();
        for (n = 0; n < n2; ++n) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n);
            int n3 = pgmDescriptor.getPgmType();
            int n4 = this.programSortOrder(pgmDescriptor.getPgmPath(), n3);
            if (n4 < 0) continue;
            ArrayList arrayList = this.pgmTypeToList(n3);
            PgmDescriptor pgmDescriptor2 = (PgmDescriptor)arrayList.get(n4);
            pgmEvent.setDescriptorAt(pgmDescriptor2.merge(pgmDescriptor), n);
            int n5 = pgmDescriptor.getModuleCount();
            for (int i = 0; i < n5; ++i) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(i);
                int n6 = moduleDescriptor.getViewCount();
                for (int j = 0; j < n6; ++j) {
                    ViewDescriptor viewDescriptor = moduleDescriptor.getViewAt(j);
                    String string = viewDescriptor.getViewId();
                    this.m_viewIdToPgm.put(string, pgmDescriptor2);
                    this.m_viewIdToModule.put(string, moduleDescriptor);
                    this.m_viewIdToView.put(string, viewDescriptor);
                }
            }
        }
        n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(i);
            pgmListener.programUpdated(pgmEvent);
        }
    }

    public void fireProgramRemovedEvent(PgmEvent pgmEvent) {
        int n;
        int n2 = pgmEvent.getCount();
        for (n = 0; n < n2; ++n) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n);
            int n3 = this.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType());
            if (n3 < 0) continue;
            DebugDesktop debugDesktop = this.m_ctxt.getDesktop();
            BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
            int n4 = pgmDescriptor.getModuleCount();
            for (int i = 0; i < n4; ++i) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(i);
                int n5 = moduleDescriptor.getViewCount();
                for (int j = 0; j < n5; ++j) {
                    String string = moduleDescriptor.getViewId(j);
                    breakpointManager.clearBreakpoints(string);
                    debugDesktop.closeSource(string);
                    this.m_viewIdToPgm.remove(string);
                    this.m_viewIdToModule.remove(string);
                    this.m_viewIdToView.remove(string);
                }
            }
            ArrayList arrayList = this.pgmTypeToList(pgmDescriptor.getPgmType());
            arrayList.remove(n3);
        }
        n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(i);
            pgmListener.programRemoved(pgmEvent);
        }
    }

    public void fireProgramsClearedEvent(PgmEvent pgmEvent) {
        int n = this.m_listeners.size();
        for (int i = 0; i < n; ++i) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(i);
            pgmListener.programsCleared(pgmEvent);
        }
    }

    protected void clearMaps() {
        this.m_viewIdToPgm.clear();
        this.m_viewIdToModule.clear();
        this.m_viewIdToView.clear();
        if (this.m_pgms != null) {
            this.m_pgms.clear();
        }
        if (this.m_srvpgms != null) {
            this.m_srvpgms.clear();
        }
        if (this.m_classes != null) {
            this.m_classes.clear();
        }
    }

    public void removeAll() {
        if (this.m_viewIdToPgm.size() > 0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.m_pgms);
            arrayList.addAll(this.m_srvpgms);
            arrayList.addAll(this.m_classes);
            if (arrayList.size() > 0) {
                RmvPgmRequest rmvPgmRequest = new RmvPgmRequest(arrayList);
                this.m_ctxt.sendRequest(rmvPgmRequest);
                rmvPgmRequest.cancelPending();
                arrayList.clear();
                this.clear();
            }
        }
    }

    public int openEnvironment(DebugFile debugFile, String string, String string2) throws IOException {
        int n;
        String string3;
        String string4;
        int n2;
        this.clearMaps();
        int n3 = debugFile.readInt();
        int n4 = debugFile.readInt();
        int n5 = debugFile.readInt();
        int n6 = n3 + n4 + n5;
        if (n6 == 0) {
            return 0;
        }
        PgmDescriptor[] pgmDescriptorArray = new PgmDescriptor[n6];
        int n7 = 0;
        boolean bl = string.length() > 0 && string2.length() > 0;
        for (n2 = 0; n2 < n3; ++n2) {
            string4 = debugFile.readString();
            string3 = debugFile.readString();
            n = debugFile.readInt();
            if (bl && string4.equals(string)) {
                string4 = string2;
            }
            pgmDescriptorArray[n7++] = new PgmDescriptor(string4, string3, n);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            string4 = debugFile.readString();
            string3 = debugFile.readString();
            n = debugFile.readInt();
            if (bl && string4.equals(string)) {
                string4 = string2;
            }
            pgmDescriptorArray[n7++] = new PgmDescriptor(string4, string3, n);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            string4 = debugFile.readString();
            string3 = debugFile.readString();
            n = debugFile.readInt();
            if (bl && string4.equals(string)) {
                string4 = string2;
            }
            pgmDescriptorArray[n7++] = new PgmDescriptor(string4, string3, n);
        }
        if (this.m_ctxt.getPgmEnv().isAutoOpen()) {
            this.m_envRequest = new AddPgmRequest(pgmDescriptorArray);
            this.m_ctxt.sendRequest(this.m_envRequest);
        } else {
            AddPgmRequest addPgmRequest = new AddPgmRequest(pgmDescriptorArray);
            this.m_ctxt.sendRequest(addPgmRequest);
        }
        return n6;
    }

    public void saveEnvironment(DebugFile debugFile) throws IOException {
        PgmDescriptor pgmDescriptor;
        int n;
        int n2 = this.m_pgms.size();
        int n3 = this.m_srvpgms.size();
        int n4 = this.m_classes.size();
        debugFile.writeInt(n2);
        debugFile.writeInt(n3);
        debugFile.writeInt(n4);
        for (n = 0; n < n2; ++n) {
            pgmDescriptor = (PgmDescriptor)this.m_pgms.get(n);
            debugFile.writeString(pgmDescriptor.getPgmLibrary());
            debugFile.writeString(pgmDescriptor.getPgmName());
            debugFile.writeInt(pgmDescriptor.getPgmType());
        }
        for (n = 0; n < n3; ++n) {
            pgmDescriptor = (PgmDescriptor)this.m_srvpgms.get(n);
            debugFile.writeString(pgmDescriptor.getPgmLibrary());
            debugFile.writeString(pgmDescriptor.getPgmName());
            debugFile.writeInt(pgmDescriptor.getPgmType());
        }
        for (n = 0; n < n4; ++n) {
            pgmDescriptor = (PgmDescriptor)this.m_classes.get(n);
            debugFile.writeString(pgmDescriptor.getPgmLibrary());
            debugFile.writeString(pgmDescriptor.getPgmName());
            debugFile.writeInt(pgmDescriptor.getPgmType());
        }
    }
}

