/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.event;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.event.DebuggerEvent;
import java.util.ArrayList;

public class BreakpointEvent
extends DebuggerEvent {
    public static final int BRK_ADDED = 1;
    public static final int BRK_REMOVED = 2;
    public static final int BRK_ENABLED = 3;
    public static final int BRK_DISABLED = 4;
    public static final int BRK_REMOVED_FROM_GROUP = 5;
    public static final int BRK_ADDED_TO_GROUP = 6;
    private BreakpointDescriptor[] m_descriptors;

    public BreakpointEvent(Object object, int n, BreakpointDescriptor breakpointDescriptor) {
        super(object, n);
        this.m_descriptors = new BreakpointDescriptor[1];
        this.m_descriptors[0] = breakpointDescriptor;
    }

    public BreakpointEvent(Object object, int n, BreakpointDescriptor[] breakpointDescriptorArray) {
        super(object, n);
        this.m_descriptors = breakpointDescriptorArray;
    }

    public BreakpointEvent(Object object, int n, ArrayList arrayList) {
        super(object, n);
        int n2 = arrayList.size();
        this.m_descriptors = new BreakpointDescriptor[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_descriptors[i] = (BreakpointDescriptor)arrayList.get(i);
        }
    }

    public void cleanUp() {
        for (int i = 0; i < this.m_descriptors.length; ++i) {
            this.m_descriptors[i] = null;
        }
        this.m_descriptors = null;
    }

    public int getCount() {
        return this.m_descriptors.length;
    }

    public BreakpointDescriptor[] getDescriptors() {
        return this.m_descriptors;
    }

    public BreakpointDescriptor getDescriptorAt(int n) {
        return this.m_descriptors[n];
    }

    public String getViewId(int n) {
        return this.m_descriptors[n].getViewId();
    }

    public int getLineNum(int n) {
        return this.m_descriptors[n].getLineNum();
    }

    public int getGroupId(int n) {
        return this.m_descriptors[n].getGroupId();
    }

    public int getGroupState(int n) {
        return this.m_descriptors[n].getState();
    }

    public void removeDescriptorAt(int n) {
        BreakpointDescriptor[] breakpointDescriptorArray = new BreakpointDescriptor[this.m_descriptors.length - 1];
        int n2 = 0;
        for (int i = 0; i < this.m_descriptors.length; ++i) {
            if (i == n) continue;
            breakpointDescriptorArray[n2++] = this.m_descriptors[i];
        }
        this.m_descriptors = breakpointDescriptorArray;
    }
}

