/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.RequestPacketElement;
import java.io.IOException;

public class ViewDescriptor
implements RequestPacketElement {
    public static final int SOURCE = 1;
    public static final int LISTING = 2;
    public static final int STATEMENT = 3;
    public static final int OTHER = 4;
    public static final int ASSEMBLER = 5;
    public static final int ILE_C = 327680;
    public static final int ILE_CPP = 327681;
    public static final int ILE_CL = 393216;
    public static final int ILE_COBOL = 458753;
    public static final int ILE_RPG = 1507330;
    public static final int OPM_CL = 393217;
    public static final int OPM_COBOL = 458752;
    public static final int OPM_RPG = 0x170001;
    public static final int _JAVA = 0x1D0000;
    public static final int HLL_IPA = 0x1E0000;
    public static final int ILE_CX = -1008467968;
    public static final int ILE_PLX = 0x140000;
    public static final int UNIX_C = 65536;
    public static final int UNIX_FORTRAN = 65537;
    public static final int UNIX_PASCAL = 65538;
    public static final int UNIX_COBOL = 65539;
    public static final int UNIX_UNSUPPORTED = 65540;
    public static final int UNIX_CPP = 65541;
    public static final int UNIX_JAVA = 65542;
    public static final String SQL_ROOT_DESC = "SQL Object Processor Root View";
    private String m_viewId;
    private int m_viewType;
    private int m_lineCount;
    private boolean m_hasMain;
    private String m_viewDesc;
    private int m_compilerId;

    public String getViewId() {
        return this.m_viewId;
    }

    public int getViewType() {
        return this.m_viewType;
    }

    public boolean isSource() {
        return this.m_viewType == 1;
    }

    public boolean isListing() {
        return this.m_viewType == 2;
    }

    public boolean isStatement() {
        return this.m_viewType == 3;
    }

    public boolean isAssembler() {
        return this.m_viewType == 5;
    }

    public int getCompilerId() {
        return this.m_compilerId;
    }

    public boolean isCorCPP() {
        switch (this.m_compilerId) {
            case -1008467968: 
            case 65536: 
            case 65541: 
            case 327680: 
            case 327681: {
                return true;
            }
        }
        return false;
    }

    public boolean isJava() {
        switch (this.m_compilerId) {
            case 65542: 
            case 0x1D0000: {
                return true;
            }
        }
        return false;
    }

    public boolean isSQLRoot() {
        return this.m_viewDesc.equals(SQL_ROOT_DESC);
    }

    public String getViewDescription() {
        return this.m_viewDesc;
    }

    public int getTotalLineCount() {
        return this.m_lineCount;
    }

    public void setTotalLineCount(int n) {
        this.m_lineCount = n;
    }

    public boolean hasMain() {
        return this.m_hasMain;
    }

    public void read(CommLink commLink) throws IOException {
        this.m_viewId = commLink.readString();
        this.m_viewType = commLink.readInt();
        this.m_lineCount = commLink.readInt();
        this.m_hasMain = commLink.readInt() == 1;
        this.m_viewDesc = commLink.readString();
        this.m_compilerId = commLink.readInt();
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_viewId);
        n += 4;
        n += 4;
        n += 4;
        n += commLink.writeSize(this.m_viewDesc);
        return n += 4;
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeString(this.m_viewId);
        commLink.writeInt(this.m_viewType);
        commLink.writeInt(this.m_lineCount);
        commLink.writeInt(this.m_hasMain ? 1 : 0);
        commLink.writeString(this.m_viewDesc);
        commLink.writeInt(this.m_compilerId);
    }
}

