/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import javax.swing.Icon;

public class BreakpointIcon
implements Icon {
    private int[] x1 = new int[7];
    private int[] x2 = new int[7];
    private int[] y1 = new int[7];
    private int[] y2 = new int[7];
    private Color m_color = null;
    private boolean m_enabled = true;
    private boolean m_visible = true;
    private boolean m_gradient = false;
    private int m_size = 0;

    public BreakpointIcon(int n) {
        this(n, null, true);
    }

    public BreakpointIcon(int n, Color color, boolean bl) {
        this.m_size = n;
        this.m_color = color;
        this.m_enabled = bl;
        this.setSize(this.m_size);
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    public void setVisible(boolean bl) {
        this.m_visible = bl;
    }

    public void setGradient(boolean bl) {
        this.m_gradient = bl;
    }

    public void setSize(int n) {
        this.x1[0] = 0;
        this.x1[1] = 0;
        this.x1[4] = n;
        this.x1[2] = this.x1[4] - n / 2;
        this.x1[3] = this.x1[2];
        this.x1[5] = this.x1[2];
        this.x1[6] = this.x1[2];
        this.y1[0] = n - n / 4;
        this.y1[1] = n / 4;
        this.y1[2] = this.y1[1];
        this.y1[3] = 0;
        this.y1[4] = n / 2 + 1;
        this.y1[5] = n;
        this.y1[6] = this.y1[0];
        this.m_size = n;
    }

    public int getIconHeight() {
        return this.m_size;
    }

    public int getIconWidth() {
        return this.m_size;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.paint(this.m_enabled, this.m_color, graphics, n, n2);
    }

    public void paint(boolean bl, Color color, Graphics graphics, int n, int n2) {
        if (!this.m_visible) {
            return;
        }
        Color color2 = graphics.getColor();
        this.x2[0] = this.x1[0] + n;
        this.x2[1] = this.x1[1] + n;
        this.x2[2] = this.x1[2] + n;
        this.x2[3] = this.x1[3] + n;
        this.x2[4] = this.x1[4] + n;
        this.x2[5] = this.x1[5] + n;
        this.x2[6] = this.x1[6] + n;
        if (bl) {
            this.y2[0] = this.y1[0] + n2 + 1;
            this.y2[1] = this.y1[1] + n2 + 1;
            this.y2[2] = this.y1[2] + n2 + 1;
            this.y2[3] = this.y1[3] + n2;
            this.y2[4] = this.y1[4] + n2;
            this.y2[5] = this.y1[5] + n2;
            this.y2[6] = this.y1[6] + n2 + 1;
            if (this.m_gradient) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                GradientPaint gradientPaint = new GradientPaint(n, n2, color, n + this.m_size, n2, Color.white);
                Polygon polygon = new Polygon(this.x2, this.y2, 7);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(polygon);
                graphics2D.setPaint(paint);
            } else {
                graphics.setColor(color);
                graphics.fillPolygon(this.x2, this.y2, this.y2.length);
            }
            this.y2[0] = this.y1[0] + n2;
            this.y2[1] = this.y1[1] + n2 + 1;
            this.y2[2] = this.y1[2] + n2 + 1;
            this.y2[3] = this.y1[3] + n2 + 1;
            this.y2[4] = this.y1[4] + n2;
            this.y2[5] = this.y1[5] + n2;
            this.y2[6] = this.y1[6] + n2;
            graphics.setColor(Color.darkGray);
            graphics.drawPolygon(this.x2, this.y2, this.y2.length);
            graphics.setColor(color2);
        } else {
            this.y2[0] = this.y1[0] + n2;
            this.y2[1] = this.y1[1] + n2 + 1;
            this.y2[2] = this.y1[2] + n2 + 1;
            this.y2[3] = this.y1[3] + n2 + 1;
            this.y2[4] = this.y1[4] + n2;
            this.y2[5] = this.y1[5] + n2;
            this.y2[6] = this.y1[6] + n2;
            graphics.setColor(color);
            graphics.drawPolygon(this.x2, this.y2, this.y2.length);
            graphics.setColor(color2);
        }
    }
}

