/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.Breakpoints;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.BreakpointEvent;
import com.ibm.iseries.debug.listener.BreakpointListener;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugFile;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.plaf.ColorUIResource;

public class BreakpointGroup
implements BreakpointListener,
DebugConstants,
Comparable {
    private DebugContext m_ctxt;
    private BreakpointManager m_brkMgr;
    private PgmManager m_pgmMgr;
    private String m_name;
    private int m_id;
    private ColorUIResource m_color;
    private ArrayList m_programs;

    public BreakpointGroup(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        this.m_brkMgr = (BreakpointManager)debugContext.getManager("brkmgr");
        this.m_pgmMgr = (PgmManager)debugContext.getManager("pgmmgr");
        this.m_programs = new ArrayList();
        this.m_brkMgr.insertListener(this);
    }

    public BreakpointGroup(DebugContext debugContext, String string, int n, ColorUIResource colorUIResource) {
        this(debugContext);
        this.m_name = string;
        this.m_id = n;
        this.m_color = colorUIResource;
    }

    public String getGroupName() {
        return this.m_name;
    }

    public void setGroupName(String string) {
        this.m_name = string;
    }

    public int getGroupId() {
        return this.m_id;
    }

    public ColorUIResource getColor() {
        return this.m_color;
    }

    public void setColor(ColorUIResource colorUIResource) {
        this.m_color = colorUIResource;
    }

    public void cleanUp() {
        this.m_name = null;
        int n = this.m_programs.size();
        for (int i = 0; i < n; ++i) {
            Program program = (Program)this.m_programs.get(i);
            program.cleanUp();
        }
        this.m_programs.clear();
        this.m_programs = null;
        this.m_brkMgr.removeListener(this);
        this.m_brkMgr = null;
        this.m_pgmMgr = null;
    }

    public boolean hasBreakpoints() {
        return this.m_programs.size() > 0;
    }

    public int getProgramCount() {
        return this.m_programs.size();
    }

    public boolean containsProgram(String string) {
        return Collections.binarySearch(this.m_programs, this.m_pgmMgr.getPgmPath(string)) >= 0;
    }

    public Program getProgram(String string) {
        String string2 = this.m_pgmMgr.getPgmPath(string);
        Program program = null;
        int n = Collections.binarySearch(this.m_programs, string2);
        if (n >= 0) {
            program = (Program)this.m_programs.get(n);
        }
        return program;
    }

    public ArrayList getPrograms() {
        return this.m_programs;
    }

    public int programSortOrder(String string) {
        return Collections.binarySearch(this.m_programs, string);
    }

    public void getDescriptors(ArrayList arrayList) {
        int n = this.m_programs.size();
        for (int i = 0; i < n; ++i) {
            Program program = (Program)this.m_programs.get(i);
            program.getDescriptors(arrayList);
        }
    }

    public ArrayList getDescriptors() {
        ArrayList arrayList = new ArrayList();
        this.getDescriptors(arrayList);
        return arrayList;
    }

    private Program addProgram(String string) {
        Program program;
        int n = Collections.binarySearch(this.m_programs, this.m_pgmMgr.getPgmPath(string));
        if (n < 0) {
            program = new Program(string);
            this.m_programs.add(n * -1 - 1, program);
        } else {
            program = (Program)this.m_programs.get(n);
        }
        return program;
    }

    private void removeProgram(String string) {
        int n = Collections.binarySearch(this.m_programs, this.m_pgmMgr.getPgmPath(string));
        if (n >= 0) {
            Program program = (Program)this.m_programs.get(n);
            program.cleanUp();
            this.m_programs.remove(n);
        }
    }

    private void breakpointRemoved(String string) {
        Program program = this.getProgram(string);
        if (program != null) {
            program.breakpointRemoved(string);
            if (!program.hasBreakpoints()) {
                this.removeProgram(string);
            }
        }
    }

    public int read(DebugFile debugFile, String string, String string2, ArrayList arrayList, ArrayList arrayList2) throws IOException {
        int n = 0;
        boolean bl = string.length() > 0 && string2.length() > 0;
        this.m_name = debugFile.readString();
        this.m_id = debugFile.readInt();
        int n2 = debugFile.readInt();
        int n3 = debugFile.readInt();
        int n4 = debugFile.readInt();
        this.m_color = new ColorUIResource(new Color(n2, n3, n4));
        int n5 = debugFile.readInt();
        for (int i = 0; i < n5; ++i) {
            String string3 = debugFile.readString();
            String string4 = debugFile.readString();
            int n6 = debugFile.readInt();
            if (n6 == 2 && string3.length() == 0) {
                string3 = "*DEFAULT";
            }
            if (bl && string3.equals(string)) {
                string3 = string2;
            }
            String string5 = string3.indexOf(32) >= 0 ? "\"" + string3 + "\" " + string4 + " " + n6 + " " : string3 + " " + string4 + " " + n6 + " ";
            int n7 = debugFile.readInt();
            for (int j = 0; j < n7; ++j) {
                String string6 = debugFile.readString();
                int n8 = debugFile.readInt();
                int n9 = debugFile.readInt();
                String string7 = string5 + string6 + " " + n9;
                if (n6 == 0 || n6 == 1) {
                    string7 = string7.toUpperCase();
                }
                if (n9 > 0) {
                    this.m_pgmMgr.setInitialViewIndex(string3, string4, n6, string6, n9);
                }
                block6: for (int k = 0; k < n8; ++k) {
                    int n10 = debugFile.readInt();
                    int n11 = debugFile.readInt();
                    String string8 = debugFile.readString();
                    BreakpointDescriptor breakpointDescriptor = new BreakpointDescriptor(string7, n10, this.m_id, n11, string8, "");
                    ++n;
                    switch (n11) {
                        case 1: {
                            arrayList.add(breakpointDescriptor);
                            continue block6;
                        }
                        case 2: {
                            arrayList.add(breakpointDescriptor);
                            arrayList2.add(breakpointDescriptor);
                        }
                    }
                }
            }
        }
        return n;
    }

    public void write(DebugFile debugFile) throws IOException {
        Module module;
        int n;
        int n2;
        ArrayList arrayList;
        Program program;
        int n3;
        debugFile.writeString(this.m_name);
        debugFile.writeInt(this.m_id);
        debugFile.writeInt(this.m_color.getRed());
        debugFile.writeInt(this.m_color.getGreen());
        debugFile.writeInt(this.m_color.getBlue());
        if (!this.hasBreakpoints()) {
            debugFile.writeInt(0);
            return;
        }
        ArrayList arrayList2 = this.getPrograms();
        int n4 = arrayList2.size();
        int n5 = 0;
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            program = (Program)arrayList2.get(n3);
            nArray[n3] = 0;
            if (!program.hasBreakpoints()) continue;
            ++n5;
            arrayList = program.getModules();
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                module = (Module)arrayList.get(n);
                if (!module.hasBreakpoints()) continue;
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
            }
        }
        debugFile.writeInt(n5);
        for (n3 = 0; n3 < n4; ++n3) {
            program = (Program)arrayList2.get(n3);
            if (!program.hasBreakpoints()) continue;
            debugFile.writeString(program.getPgmLibrary());
            debugFile.writeString(program.getPgmName());
            debugFile.writeInt(program.getPgmType());
            debugFile.writeInt(nArray[n3]);
            arrayList = program.getModules();
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                module = (Module)arrayList.get(n);
                if (!module.hasBreakpoints()) continue;
                ArrayList arrayList3 = module.getDescriptors();
                int n7 = arrayList3.size();
                debugFile.writeString(module.getModuleName());
                debugFile.writeInt(n7);
                for (int i = 0; i < n7; ++i) {
                    BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)arrayList3.get(i);
                    if (i == 0) {
                        ModuleDescriptor moduleDescriptor = this.m_pgmMgr.getModule(breakpointDescriptor.getViewId());
                        int n8 = moduleDescriptor.getViewIndex(breakpointDescriptor.getViewId());
                        debugFile.writeInt(n8);
                    }
                    debugFile.writeInt(breakpointDescriptor.getLineNum());
                    debugFile.writeInt(breakpointDescriptor.getState());
                    debugFile.writeString(breakpointDescriptor.getCondition());
                }
            }
        }
    }

    public void breakpointChanged(BreakpointEvent breakpointEvent) {
        int n = breakpointEvent.getType();
        if (n == 3 || n == 4) {
            return;
        }
        int n2 = breakpointEvent.getCount();
        block4: for (int i = 0; i < n2; ++i) {
            BreakpointDescriptor breakpointDescriptor = breakpointEvent.getDescriptorAt(i);
            if (breakpointDescriptor.getGroupId() != this.m_id) continue;
            switch (n) {
                case 1: 
                case 6: {
                    Program program = this.addProgram(breakpointDescriptor.getViewId());
                    program.addModule(breakpointDescriptor.getViewId());
                    continue block4;
                }
                case 2: 
                case 5: {
                    this.breakpointRemoved(breakpointDescriptor.getViewId());
                }
            }
        }
    }

    public String toString() {
        return this.m_name;
    }

    public int compareTo(Object object) {
        return this.m_name.compareTo(object.toString());
    }

    public class Module
    implements Comparable {
        private String m_moduleName;
        private Breakpoints m_breakpoints;

        public Module(String string, Breakpoints breakpoints) {
            this.m_moduleName = string;
            this.m_breakpoints = breakpoints;
        }

        public void cleanUp() {
            this.m_breakpoints = null;
        }

        public String getModuleName() {
            return this.m_moduleName;
        }

        public int getGroupId() {
            return BreakpointGroup.this.m_id;
        }

        public boolean hasBreakpoints() {
            return this.m_breakpoints.getCount(BreakpointGroup.this.m_id) > 0;
        }

        public int getBreakpointCount() {
            return this.m_breakpoints.getCount(BreakpointGroup.this.m_id);
        }

        public BreakpointDescriptor getDescriptor(int n) {
            return this.m_breakpoints.getDescriptor(n);
        }

        public void getDescriptors(ArrayList arrayList) {
            this.m_breakpoints.getDescriptors(arrayList, BreakpointGroup.this.m_id);
        }

        public ArrayList getDescriptors() {
            return this.m_breakpoints.getDescriptors(BreakpointGroup.this.m_id);
        }

        public int descriptorSortOrder(int n) {
            ArrayList arrayList = this.m_breakpoints.getDescriptors(BreakpointGroup.this.m_id);
            int n2 = Collections.binarySearch(arrayList, new Integer(n));
            arrayList.clear();
            return n2;
        }

        public String toString() {
            return this.m_moduleName;
        }

        public int compareTo(Object object) {
            return this.m_moduleName.compareTo(object.toString());
        }
    }

    public class Program
    implements Comparable {
        private String m_pgmPath;
        private String m_pgmLib;
        private String m_pgmName;
        private int m_pgmType;
        private ArrayList m_modules;

        public Program(String string) {
            PgmDescriptor pgmDescriptor = BreakpointGroup.this.m_pgmMgr.getProgram(string);
            this.m_pgmPath = pgmDescriptor.getPgmPath();
            this.m_pgmLib = pgmDescriptor.getPgmLibrary();
            this.m_pgmName = pgmDescriptor.getPgmName();
            this.m_pgmType = pgmDescriptor.getPgmType();
            this.m_modules = new ArrayList();
        }

        public void cleanUp() {
            int n = this.m_modules.size();
            for (int i = 0; i < n; ++i) {
                Module module = (Module)this.m_modules.get(i);
                module.cleanUp();
            }
            this.m_modules.clear();
            this.m_modules = null;
        }

        public int getGroupId() {
            return BreakpointGroup.this.m_id;
        }

        public String getPgmPath() {
            return this.m_pgmPath;
        }

        public String getPgmLibrary() {
            return this.m_pgmLib;
        }

        public String getPgmName() {
            return this.m_pgmName;
        }

        public int getPgmType() {
            return this.m_pgmType;
        }

        public boolean hasBreakpoints() {
            return this.m_modules.size() > 0;
        }

        public int getModuleCount() {
            return this.m_modules.size();
        }

        public boolean containsModule(String string) {
            return Collections.binarySearch(this.m_modules, string) >= 0;
        }

        public Module getModule(String string) {
            String string2 = BreakpointGroup.this.m_pgmMgr.getModuleName(string);
            int n = Collections.binarySearch(this.m_modules, string2);
            Module module = null;
            if (n >= 0) {
                module = (Module)this.m_modules.get(n);
            }
            return module;
        }

        public ArrayList getModules() {
            return this.m_modules;
        }

        public int moduleSortOrder(String string) {
            return Collections.binarySearch(this.m_modules, string);
        }

        public void getDescriptors(ArrayList arrayList) {
            int n = this.m_modules.size();
            for (int i = 0; i < n; ++i) {
                Module module = (Module)this.m_modules.get(i);
                module.getDescriptors(arrayList);
            }
        }

        public ArrayList getDescriptors() {
            ArrayList arrayList = new ArrayList();
            this.getDescriptors(arrayList);
            return arrayList;
        }

        public int descriptorIndex(int n) {
            Module module = (Module)this.m_modules.get(0);
            int n2 = -1;
            if (module != null) {
                ArrayList arrayList = module.getDescriptors();
                n2 = Collections.binarySearch(arrayList, new Integer(n));
                arrayList.clear();
            }
            return n2;
        }

        private Module addModule(String string) {
            String string2 = BreakpointGroup.this.m_pgmMgr.getModuleName(string);
            int n = Collections.binarySearch(this.m_modules, string2);
            Module module = null;
            if (n < 0) {
                Breakpoints breakpoints = BreakpointGroup.this.m_brkMgr.getBreakpoints(string);
                module = new Module(string2, breakpoints);
                this.m_modules.add(n * -1 - 1, module);
            } else {
                module = (Module)this.m_modules.get(n);
            }
            return module;
        }

        private void removeModule(String string) {
            String string2 = BreakpointGroup.this.m_pgmMgr.getModuleName(string);
            int n = Collections.binarySearch(this.m_modules, string2);
            if (n >= 0) {
                Module module = (Module)this.m_modules.get(n);
                module.cleanUp();
                this.m_modules.remove(n);
            }
        }

        private void breakpointRemoved(String string) {
            Module module = this.getModule(string);
            if (module != null && !module.hasBreakpoints()) {
                this.removeModule(string);
            }
        }

        public String toString() {
            return this.m_pgmPath;
        }

        public int compareTo(Object object) {
            return this.m_pgmPath.compareTo(object.toString());
        }
    }
}

