/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.JavaApplicationCall;
import com.ibm.as400.access.Trace;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import utilities.RunJavaApplication;

class RunJavaApplicationThread
extends Thread {
    static final int RUN_APPLICATION = 1;
    static final int OUTPUT = 2;
    static final int INPUT = 3;
    static final int ERROR = 4;
    private static ResourceBundle resources_ = ResourceBundle.getBundle("utilities.UTMRI");
    private int threadID_ = 0;
    private JavaApplicationCall runMain_ = null;

    RunJavaApplicationThread(JavaApplicationCall javaApplicationCall, int n) {
        this.runMain_ = javaApplicationCall;
        this.threadID_ = n;
    }

    public void run() {
        if (this.threadID_ == 1) {
            System.out.println(resources_.getString("REMOTE_START_PROGRAM") + " " + this.runMain_.getJavaApplication() + "\n");
            boolean bl = false;
            try {
                bl = this.runMain_.run();
            }
            catch (Exception exception) {
                System.out.println(resources_.getString("REMOTE_CALL_JAVA_ERROR"));
                System.out.println(exception.toString());
            }
            AS400Message[] aS400MessageArray = this.runMain_.getMessageList();
            if (aS400MessageArray != null && aS400MessageArray.length > 0) {
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    System.out.print(aS400MessageArray[i].getID());
                    System.out.print(resources_.getString("REMOTE_MESSAGE_FROM_COMMAND_SEP"));
                    System.out.println(aS400MessageArray[i].getText());
                }
            }
        } else {
            if (this.threadID_ == 2) {
                while (true) {
                    String string = null;
                    while ((string = this.runMain_.getStandardOutString()) != null) {
                        System.out.println(string);
                    }
                    this.delay();
                }
            }
            if (this.threadID_ == 4) {
                while (true) {
                    String string = null;
                    while ((string = this.runMain_.getStandardErrorString()) != null) {
                        System.out.println(string);
                    }
                    this.delay();
                }
            }
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while (true) {
                try {
                    String string = bufferedReader.readLine();
                    if (string != null) {
                        RunJavaApplication.getInputBuffer().addElement(string);
                    }
                }
                catch (Exception exception) {
                    Trace.log(2, exception);
                }
                this.delay();
            }
        }
        System.out.println();
        System.out.print(resources_.getString("REMOTE_PROMPT"));
    }

    private void delay() {
        try {
            RunJavaApplicationThread.sleep(100L);
        }
        catch (Exception exception) {
            Trace.log(2, exception);
        }
    }
}

