/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.PrinterList;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PrintersPropertiesPane;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPrinter;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VPrinters
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getPrintText("AS400_PRINTERS");
    private static String descriptionColumnHeader_ = ResourceLoader.getPrintText("DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VPrinters16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VPrinters32.gif", description_);
    private static String name_ = ResourceLoader.getPrintText("PRINTERS");
    private static String outputQueueColumnHeader_ = ResourceLoader.getPrintText("OUTPUT_QUEUE");
    private static String printerColumnHeader_ = ResourceLoader.getPrintText("PRINTER");
    private static String statusColumnHeader_ = ResourceLoader.getPrintText("STATUS");
    private static TableColumnModel detailsColumnModel_ = null;
    private static Object detailsColumnModelLock_ = new Object();
    private static final int dfltPrinterColWidth = 15;
    private static final int dfltStatusColWidth = 25;
    private static final int dfltDescriptionColWidth = 25;
    private static final int dfltOutputQueueColWidth = 12;
    private static int[] attrsToRetrieve = new int[]{10, 190, 12, 191, 109, 199, 40, 42, 89, 44, 48, -5, -6, 75, 200, 90, 197, 120, 121, 122, 123, 124, 193, 187, 202, 208, 204, 209, 207, 206, 203, 201, 205};
    private PrinterList list_ = null;
    private transient VObject[] children_;
    private transient boolean childrenLoaded_;
    private transient boolean childrenLoading_;
    private transient VNode parent_;
    private transient VPropertiesPane propertiesPane_;
    private transient VPrinters thisPointer_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VPrinters() {
        this.list_ = new PrinterList();
        this.parent_ = null;
        this.initializeTransient();
    }

    public VPrinters(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.list_ = new PrinterList(aS400);
        this.parent_ = null;
        this.initializeTransient();
    }

    public VPrinters(VNode vNode, AS400 aS400) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.list_ = new PrinterList(aS400);
        this.parent_ = vNode;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public synchronized TreeNode getChildAt(int n) {
        this.updateChildren();
        if (n < 0 || n >= this.children_.length) {
            return null;
        }
        return (TreeNode)((Object)this.children_[n]);
    }

    public synchronized int getChildCount() {
        this.updateChildren();
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public synchronized VObject getDetailsChildAt(int n) {
        this.updateChildren();
        if (n < 0 || n >= this.children_.length) {
            return null;
        }
        return this.children_[n];
    }

    public int getDetailsChildCount() {
        this.updateChildren();
        return this.children_.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableColumnModel getDetailsColumnModel() {
        Object object = detailsColumnModelLock_;
        synchronized (object) {
            if (detailsColumnModel_ == null) {
                detailsColumnModel_ = new DefaultTableColumnModel();
                VTableColumn vTableColumn = new VTableColumn(0, VPrinter.PRINTER_PROPERTY);
                vTableColumn.setCellRenderer(new VObjectCellRenderer());
                vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
                vTableColumn.setHeaderValue(printerColumnHeader_);
                int n = printerColumnHeader_.length();
                if (n < 15) {
                    n = 15;
                }
                vTableColumn.setPreferredCharWidth(n);
                detailsColumnModel_.addColumn(vTableColumn);
                VTableColumn vTableColumn2 = new VTableColumn(1, VPrinter.STATUS_PROPERTY);
                vTableColumn2.setCellRenderer(new VObjectCellRenderer());
                vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
                vTableColumn2.setHeaderValue(statusColumnHeader_);
                n = statusColumnHeader_.length();
                if (n < 25) {
                    n = 25;
                }
                vTableColumn2.setPreferredCharWidth(n);
                detailsColumnModel_.addColumn(vTableColumn2);
                VTableColumn vTableColumn3 = new VTableColumn(2, VPrinter.DESCRIPTION_PROPERTY);
                vTableColumn3.setCellRenderer(new VObjectCellRenderer());
                vTableColumn3.setHeaderRenderer(new VObjectHeaderRenderer());
                vTableColumn3.setHeaderValue(descriptionColumnHeader_);
                n = descriptionColumnHeader_.length();
                if (n < 25) {
                    n = 25;
                }
                vTableColumn3.setPreferredCharWidth(n);
                detailsColumnModel_.addColumn(vTableColumn3);
                VTableColumn vTableColumn4 = new VTableColumn(3, VPrinter.OUTPUTQUEUE_PROPERTY);
                vTableColumn4.setCellRenderer(new VObjectCellRenderer());
                vTableColumn4.setHeaderRenderer(new VObjectHeaderRenderer());
                vTableColumn4.setHeaderValue(outputQueueColumnHeader_);
                n = outputQueueColumnHeader_.length();
                if (n < 12) {
                    n = 12;
                }
                vTableColumn4.setPreferredCharWidth(n);
                detailsColumnModel_.addColumn(vTableColumn4);
            }
        }
        return detailsColumnModel_;
    }

    public synchronized int getDetailsIndex(VObject vObject) {
        this.updateChildren();
        for (int i = 0; i < this.children_.length; ++i) {
            if (this.children_[i] != vObject) continue;
            return i;
        }
        return -1;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public synchronized int getIndex(TreeNode treeNode) {
        this.updateChildren();
        for (int i = 0; i < this.children_.length; ++i) {
            if (this.children_[i] != treeNode) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public String getPrinterFilter() {
        return this.list_.getPrinterFilter();
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public synchronized Object getPropertyValue(Object object) {
        if (object == NAME_PROPERTY) {
            return this;
        }
        if (object == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public AS400 getSystem() {
        return this.list_.getSystem();
    }

    public String getText() {
        return name_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.children_ = new VNode[0];
        this.propertiesPane_ = new PrintersPropertiesPane(this, this.list_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.thisPointer_ = this;
        this.childrenLoaded_ = true;
        this.childrenLoading_ = false;
        this.list_.setAttributesToRetrieve(attrsToRetrieve);
        this.list_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.list_.addVetoableChangeListener(this.vetoableChangeSupport_);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isSortable() {
        return false;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        this.childrenLoaded_ = false;
        this.workingEventSupport_.fireStopWorking();
    }

    private void loadChildren() throws Exception {
        if (!this.childrenLoading_) {
            int n;
            this.childrenLoading_ = true;
            if (this.children_ != null) {
                for (n = 0; n < this.children_.length; ++n) {
                    this.children_[n].removeErrorListener(this.errorEventSupport_);
                    this.children_[n].removeVObjectListener(this.objectEventSupport_);
                    this.children_[n].removeWorkingListener(this.workingEventSupport_);
                }
            }
            this.list_.openSynchronously();
            n = this.list_.size();
            if (Trace.isTraceOn()) {
                Trace.log(3, "ListSize:" + n);
            }
            this.children_ = new VObject[n];
            Printer printer = null;
            VPrinter vPrinter = null;
            for (int i = 0; i < n; ++i) {
                printer = (Printer)this.list_.getObject(i);
                vPrinter = new VPrinter(this.thisPointer_, printer);
                this.children_[i] = vPrinter;
                vPrinter.addErrorListener(this.errorEventSupport_);
                vPrinter.addVObjectListener(this.objectEventSupport_);
                vPrinter.addWorkingListener(this.workingEventSupport_);
            }
            this.list_.close();
            this.childrenLoaded_ = true;
            this.childrenLoading_ = false;
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setPrinterFilter(String string) throws PropertyVetoException {
        this.list_.setPrinterFilter(string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        this.list_.setSystem(aS400);
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
    }

    public String toString() {
        return name_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChildren() {
        if (!this.childrenLoaded_) {
            try {
                try {
                    this.workingEventSupport_.fireStartWorking();
                    this.loadChildren();
                }
                catch (Exception exception) {
                    this.errorEventSupport_.fireError(exception);
                    Object var3_2 = null;
                    this.workingEventSupport_.fireStopWorking();
                }
                Object var3_1 = null;
                this.workingEventSupport_.fireStopWorking();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.workingEventSupport_.fireStopWorking();
                throw throwable;
            }
        }
    }
}

