/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTFGroup;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class PTFGroupList {
    private AS400 system_;

    public PTFGroupList(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(aS400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTFGroup[] getPTFGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            Object object4;
            int n;
            int n2 = this.system_.getCcsid();
            ConvTable convTable = ConvTable.getTable(n2, null);
            ProgramParameter[] programParameterArray = new ProgramParameter[4];
            programParameterArray[0] = new ProgramParameter(convTable.stringToByteArray("JT4PTF    QTEMP     "));
            programParameterArray[0].setParameterType(2);
            programParameterArray[1] = new ProgramParameter(convTable.stringToByteArray("LSTG0100"));
            programParameterArray[1].setParameterType(2);
            programParameterArray[2] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
            programParameterArray[2].setParameterType(2);
            programParameterArray[3] = new ProgramParameter(new byte[4]);
            programParameterArray[3].setParameterType(2);
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroups", 0, programParameterArray);
            boolean bl = serviceProgramCall.isStayOnThread();
            Object object2 = bl ? "JT4PTF    QTEMP     " : this.system_;
            byte[] byArray = null;
            Object object3 = object2;
            synchronized (object3) {
                UserSpace userSpace = new UserSpace(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC");
                userSpace.setMustUseProgramCall(true);
                if (!bl) {
                    userSpace.setMustUseSockets(true);
                }
                try {
                    userSpace.create(262144, true, "", (byte)0, "User space for PTF Group list", "*EXCLUDE");
                    if (!serviceProgramCall.run()) {
                        throw new AS400Exception(serviceProgramCall.getMessageList());
                    }
                    n = userSpace.getLength();
                    byArray = new byte[n];
                    userSpace.read(byArray, 0);
                    Object var12_14 = null;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    try {
                        userSpace.delete();
                    }
                    catch (Exception exception) {
                        Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                    }
                    throw throwable;
                }
                try {
                    userSpace.delete();
                }
                catch (Exception object4) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)object4);
                }
            }
            int n3 = BinaryConverter.byteArrayToInt(byArray, 124);
            int n4 = BinaryConverter.byteArrayToInt(byArray, 132);
            n = BinaryConverter.byteArrayToInt(byArray, 136);
            int n5 = BinaryConverter.byteArrayToInt(byArray, 140);
            convTable = ConvTable.getTable(n5, null);
            int n6 = 0;
            object4 = new PTFGroup[n4];
            for (int i = 0; i < n4; ++i) {
                n6 = n3 + i * n;
                String string = convTable.byteArrayToString(byArray, n6, 60);
                String string2 = convTable.byteArrayToString(byArray, n6 += 60, 100);
                int n7 = BinaryConverter.byteArrayToInt(byArray, n6 += 100);
                int n8 = BinaryConverter.byteArrayToInt(byArray, n6 += 4);
                String string3 = convTable.byteArrayToString(byArray, n6 += 4, 6);
                n6 += 6;
                object4[i] = new PTFGroup(this.system_, string, string2, n7, n8, string3);
            }
            return object4;
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
            throw new InternalErrorException(10, (Throwable)propertyVetoException);
        }
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public AS400 getSystem() {
        return this.system_;
    }
}

