/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CallStackEntry;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IntegerHashtable;
import com.ibm.as400.access.JobHashtable;
import com.ibm.as400.access.JobLog;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Job
implements Serializable {
    static final long serialVersionUID = 6L;
    private static final byte[] BLANKS16_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    private static final Boolean ON_THREAD = ProgramCall.THREADSAFE_TRUE;
    private static final Boolean OFF_THREAD = ProgramCall.THREADSAFE_FALSE;
    private boolean cacheChanges_ = true;
    private boolean isConnected_ = false;
    private final JobHashtable values_ = new JobHashtable();
    private JobHashtable cachedChanges_ = null;
    private String name_;
    private String user_;
    private String number_;
    private String status_;
    private String type_;
    private String subtype_;
    private AS400 system_;
    private String internalJobID_;
    private byte[] realInternalJobID_;
    private transient PropertyChangeSupport propertyChangeListeners_;
    private transient VetoableChangeSupport vetoableChangeListeners_;
    private transient CommandCall cmdCall_;
    private transient ProgramCall pgmCall_;
    private transient ProgramCall pgmCall_onThread_;
    private transient ProgramCall pgmCall_offThread_;
    private transient Object remoteCommandLock_ = new Object();
    private transient AS400Timestamp timestampConverter_;
    public static final int ACCOUNTING_CODE = 1001;
    public static final String ACCOUNTING_CODE_BLANK = "*BLANK";
    public static final int ACTIVE_JOB_STATUS = 101;
    public static final String ACTIVE_JOB_STATUS_NONE = "    ";
    public static final String ACTIVE_JOB_STATUS_WAIT_BIN_SYNCH_DEVICE_AND_ACTIVE = "BSCA";
    public static final String ACTIVE_JOB_STATUS_WAIT_BIN_SYNCH_DEVICE = "BSCW";
    public static final String ACTIVE_JOB_STATUS_WAIT_COMM_DEVICE_AND_ACTIVE = "CMNA";
    public static final String ACTIVE_JOB_STATUS_WAIT_COMM_DEVICE = "CMNW";
    public static final String ACTIVE_JOB_STATUS_WAIT_CHECKPOINT = "CMTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_CONDITION = "CNDW";
    public static final String ACTIVE_JOB_STATUS_WAIT_CPI_COMM = "CPCW";
    public static final String ACTIVE_JOB_STATUS_WAIT_DEQUEUE_AND_ACTIVE = "DEQA";
    public static final String ACTIVE_JOB_STATUS_WAIT_DEQUEUE = "DEQW";
    public static final String ACTIVE_JOB_STATUS_WAIT_DISKETTE_AND_ACTIVE = "DKTA";
    public static final String ACTIVE_JOB_STATUS_WAIT_DISKETTE = "DKTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_DELAYED = "DLYW";
    public static final String ACTIVE_JOB_STATUS_WAIT_DELAY = "DLYW";
    public static final String ACTIVE_JOB_STATUS_DISCONNECTED = "DSC ";
    public static final String ACTIVE_JOB_STATUS_WAIT_DISPLAY_AND_ACTIVE = "DSPA";
    public static final String ACTIVE_JOB_STATUS_WAIT_DISPLAY = "DSPW";
    public static final String ACTIVE_JOB_STATUS_ENDED = "END ";
    public static final String ACTIVE_JOB_STATUS_WAIT_DATABASE_EOF_AND_ACTIVE = "EOFA";
    public static final String ACTIVE_JOB_STATUS_WAIT_DATABASE_EOF = "EOFW";
    public static final String ACTIVE_JOB_STATUS_ENDING = "EOJ ";
    public static final String ACTIVE_JOB_STATUS_WAIT_EVENT = "EVTW";
    public static final String ACTIVE_JOB_STATUS_SUSPENDED = "GRP ";
    public static final String ACTIVE_JOB_STATUS_HELD = "HLD ";
    public static final String ACTIVE_JOB_STATUS_HELD_THREAD = "HLDT";
    public static final String ACTIVE_JOB_STATUS_WAIT_ICF_FILE_AND_ACTIVE = "ICFA";
    public static final String ACTIVE_JOB_STATUS_WAIT_ICF_FILE = "ICFW";
    public static final String ACTIVE_JOB_STATUS_INELIGIBLE = "INEL";
    public static final String ACTIVE_JOB_STATUS_WAIT_JAVA_AND_ACTIVE = "JVAA";
    public static final String ACTIVE_JOB_STATUS_WAIT_JAVA = "JVAW";
    public static final String ACTIVE_JOB_STATUS_WAIT_LOCK = "LCKW";
    public static final String ACTIVE_JOB_STATUS_WAIT_LOCK_SPACE_AND_ACTIVE = "LSPA";
    public static final String ACTIVE_JOB_STATUS_WAIT_LOCK_SPACE = "LSPW";
    public static final String ACTIVE_JOB_STATUS_WAIT_MULTIPLE_FILES_AND_ACTIVE = "MLTA";
    public static final String ACTIVE_JOB_STATUS_WAIT_MULTIPLE_FILES = "MLTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_MESSAGE = "MSGW";
    public static final String ACTIVE_JOB_STATUS_WAIT_MUTEX = "MTXW";
    public static final String ACTIVE_JOB_STATUS_WAIT_MIXED_DEVICE_FILE = "MXDW";
    public static final String ACTIVE_JOB_STATUS_WAIT_OPTICAL_DEVICE_AND_ACTIVE = "OPTA";
    public static final String ACTIVE_JOB_STATUS_WAIT_OPTICAL_DEVICE = "OPTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_OSI = "OSIW";
    public static final String ACTIVE_JOB_STATUS_WAIT_PRINT_AND_ACTIVE = "PRTA";
    public static final String ACTIVE_JOB_STATUS_WAIT_PRINT = "PRTW";
    public static final String ACTIVE_JOB_STATUS_WAIT_PRESTART = "PSRW";
    public static final String ACTIVE_JOB_STATUS_RUNNING = "RUN ";
    public static final String ACTIVE_JOB_STATUS_WAIT_SELECTION = "SELW";
    public static final String ACTIVE_JOB_STATUS_WAIT_SEMAPHORE = "SEMW";
    public static final String ACTIVE_JOB_STATUS_STOPPED = "SIGS";
    public static final String ACTIVE_JOB_STATUS_WAIT_SIGNAL = "SIGW";
    public static final String ACTIVE_JOB_STATUS_SUSPENDED_SYSTEM_REQUEST = "SRQ ";
    public static final String ACTIVE_JOB_STATUS_WAIT_SAVE_FILE_AND_ACTIVE = "SVFA";
    public static final String ACTIVE_JOB_STATUS_WAIT_SAVE_FILE = "SVFW";
    public static final String ACTIVE_JOB_STATUS_WAIT_TAPE_DEVICE_AND_ACTIVE = "TAPA";
    public static final String ACTIVE_JOB_STATUS_WAIT_TAPE_DEVICE = "TAPW";
    public static final String ACTIVE_JOB_STATUS_WAIT_THREAD = "THDW";
    public static final String ACTIVE_JOB_STATUS_WAIT_TIME_INTERVAL_AND_ACTIVE = "TIMA";
    public static final String ACTIVE_JOB_STATUS_WAIT_TIME_INTERVAL = "TIMW";
    public static final int ACTIVE_JOB_STATUS_FOR_JOBS_ENDING = 103;
    public static final int ASP_GROUP = 104;
    public static final int ALLOW_MULTIPLE_THREADS = 102;
    public static final String ALLOW_MULTIPLE_THREADS_NO = "0";
    public static final String ALLOW_MULTIPLE_THREADS_YES = "1";
    public static final int AUXILIARY_IO_REQUESTS = 1401;
    public static final int AUXILIARY_IO_REQUESTS_LARGE = 1406;
    public static final int BREAK_MESSAGE_HANDLING = 201;
    public static final String BREAK_MESSAGE_HANDLING_NORMAL = "*NORMAL";
    public static final String BREAK_MESSAGE_HANDLING_HOLD = "*HOLD";
    public static final String BREAK_MESSAGE_HANDLING_NOTIFY = "*NOTIFY";
    public static final int CCSID = 302;
    public static final int CCSID_SYSTEM_VALUE = -1;
    public static final int CCSID_INITIAL_USER = -2;
    public static final int CHARACTER_ID_CONTROL = 311;
    public static final String CHARACTER_ID_CONTROL_DEVICE = "*DEVD";
    public static final String CHARACTER_ID_CONTROL_JOB = "*JOBCCSID";
    public static final String CHARACTER_ID_CONTROL_SYSTEM_VALUE = "*SYSVAL";
    public static final String CHARACTER_ID_CONTROL_INITIAL_USER = "*USRPRF";
    public static final int CLIENT_IP_ADDRESS = 318;
    public static final int COMPLETION_STATUS = 306;
    public static final String COMPLETION_STATUS_NOT_COMPLETED = " ";
    public static final String COMPLETION_STATUS_COMPLETED_NORMALLY = "0";
    public static final String COMPLETION_STATUS_COMPLETED_ABNORMALLY = "1";
    public static final int CONTROLLED_END_REQUESTED = 502;
    public static final String END_STATUS_CANCELLED = "1";
    public static final String END_STATUS_NOT_CANCELLED = "0";
    public static final String END_STATUS_JOB_NOT_RUNNING = " ";
    public static final int ELAPSED_CPU_PERCENT_USED = 314;
    public static final int ELAPSED_CPU_PERCENT_USED_FOR_DATABASE = 316;
    public static final int ELAPSED_CPU_TIME_USED = 315;
    public static final int ELAPSED_CPU_TIME_USED_FOR_DATABASE = 317;
    public static final int ELAPSED_DISK_IO = 414;
    public static final int ELAPSED_DISK_IO_ASYNCH = 416;
    public static final int ELAPSED_DISK_IO_SYNCH = 417;
    public static final int ELAPSED_INTERACTIVE_RESPONSE_TIME = 904;
    public static final int ELAPSED_INTERACTIVE_TRANSACTIONS = 905;
    public static final int ELAPSED_LOCK_WAIT_TIME = 10008;
    public static final int ELAPSED_PAGE_FAULTS = 1609;
    public static final int ELAPSED_TIME = 10007;
    public static final int COUNTRY_ID = 303;
    public static final String COUNTRY_ID_SYSTEM_VALUE = "*SYSVAL";
    public static final String COUNTRY_ID_INITIAL_USER = "*USRPRF";
    public static final int CPU_TIME_USED = 304;
    public static final int CPU_TIME_USED_LARGE = 312;
    public static final int CPU_TIME_USED_FOR_DATABASE = 313;
    public static final int CURRENT_LIBRARY = 10000;
    public static final int CURRENT_LIBRARY_EXISTENCE = 10001;
    public static final int CURRENT_SYSTEM_POOL_ID = 307;
    public static final int CURRENT_USER = 305;
    public static final int DATE_ENDED = 418;
    public static final int DATE_ENTERED_SYSTEM = 402;
    public static final int DATE_FORMAT = 405;
    public static final String DATE_FORMAT_SYSTEM_VALUE = "*SYS";
    public static final String DATE_FORMAT_YMD = "*YMD";
    public static final String DATE_FORMAT_MDY = "*MDY";
    public static final String DATE_FORMAT_DMY = "*DMY";
    public static final String DATE_FORMAT_JULIAN = "*JUL";
    public static final int DATE_SEPARATOR = 406;
    public static final String DATE_SEPARATOR_SYSTEM_VALUE = "S";
    public static final String DATE_SEPARATOR_SLASH = "/";
    public static final String DATE_SEPARATOR_DASH = "-";
    public static final String DATE_SEPARATOR_PERIOD = ".";
    public static final String DATE_SEPARATOR_BLANK = " ";
    public static final String DATE_SEPARATOR_COMMA = ",";
    public static final int DATE_STARTED = 401;
    public static final int DBCS_CAPABLE = 407;
    public static final String DBCS_CAPABLE_NO = "0";
    public static final String DBCS_CAPABLE_YES = "1";
    public static final int DECIMAL_FORMAT = 413;
    public static final String DECIMAL_FORMAT_SYSTEM_VALUE = "*SYSVAL";
    public static final String DECIMAL_FORMAT_PERIOD = "";
    public static final String DECIMAL_FORMAT_COMMA_J = "J";
    public static final String DECIMAL_FORMAT_COMMA_I = "I";
    public static final int DEFAULT_CCSID = 412;
    public static final int DEFAULT_WAIT_TIME = 409;
    public static final int DEVICE_RECOVERY_ACTION = 410;
    public static final String DEVICE_RECOVERY_ACTION_SYSTEM_VALUE = "*SYSVAL";
    public static final String DEVICE_RECOVERY_ACTION_MESSAGE = "*MSG";
    public static final String DEVICE_RECOVERY_ACTION_DISCONNECT_MESSAGE = "*DSCMSG";
    public static final String DEVICE_RECOVERY_ACTION_DISCONNECT_END_REQUEST = "*DSCENDRQS";
    public static final String DEVICE_RECOVERY_ACTION_END_JOB = "*ENDJOB";
    public static final String DEVICE_RECOVERY_ACTION_END_JOB_NO_LIST = "*ENDJOBNOLIST";
    public static final int ELIGIBLE_FOR_PURGE = 1604;
    public static final String ELIGIBLE_FOR_PURGE_YES = "*YES";
    public static final String ELIGIBLE_FOR_PURGE_NO = "*NO";
    public static final String ELIGIBLE_FOR_PURGE_IGNORED = "";
    public static final int END_SEVERITY = 501;
    public static final int FUNCTION_NAME = 601;
    public static final int FUNCTION_TYPE = 602;
    public static final String FUNCTION_TYPE_BLANK = "";
    public static final String FUNCTION_TYPE_COMMAND = "C";
    public static final String FUNCTION_TYPE_DELAY = "D";
    public static final String FUNCTION_TYPE_GROUP = "G";
    public static final String FUNCTION_TYPE_INDEX = "I";
    public static final String FUNCTION_TYPE_JAVA = "J";
    public static final String FUNCTION_TYPE_LOG = "L";
    public static final String FUNCTION_TYPE_MRT = "M";
    public static final String FUNCTION_TYPE_MENU = "N";
    public static final String FUNCTION_TYPE_IO = "O";
    public static final String FUNCTION_TYPE_PROCEDURE = "R";
    public static final String FUNCTION_TYPE_PROGRAM = "P";
    public static final String FUNCTION_TYPE_SPECIAL = "*";
    public static final long INITIAL_THREAD = -1L;
    public static final int INQUIRY_MESSAGE_REPLY = 901;
    public static final String INQUIRY_MESSAGE_REPLY_REQUIRED = "*RQD";
    public static final String INQUIRY_MESSAGE_REPLY_DEFAULT = "*DFT";
    public static final String INQUIRY_MESSAGE_REPLY_SYSTEM_REPLY_LIST = "*SYSRPYL";
    public static final int INTERACTIVE_TRANSACTIONS = 1402;
    public static final int INTERNAL_JOB_ID = 11000;
    public static final int INTERNAL_JOB_IDENTIFIER = 11007;
    public static final int JOB_DATE = 1002;
    public static final int JOB_DESCRIPTION = 1003;
    public static final int JOB_END_REASON = 1014;
    public static final int JOB_LOG_OUTPUT = 1018;
    public static final String JOB_LOG_OUTPUT_SYSTEM_VALUE = "*SYSVAL";
    public static final String JOB_LOG_OUTPUT_JOB_LOG_SERVER = "*JOBLOGSVR";
    public static final String JOB_LOG_OUTPUT_JOB_END = "*JOBEND";
    public static final String JOB_LOG_OUTPUT_PENDING = "*PND";
    public static final int JOB_LOG_PENDING = 1015;
    public static final String JOB_LOG_PENDING_NO = "0";
    public static final String JOB_LOG_PENDING_YES = "1";
    public static final int JOB_NAME = 11001;
    public static final String JOB_NAME_INTERNAL = "*INT";
    public static final String JOB_NAME_CURRENT = "*";
    public static final int JOB_NUMBER = 11002;
    public static final String JOB_NUMBER_BLANK = "";
    public static final int JOB_QUEUE = 1004;
    public static final int JOB_QUEUE_DATE = 404;
    public static final int JOB_QUEUE_PRIORITY = 1005;
    public static final int JOB_QUEUE_STATUS = 1903;
    public static final String JOB_QUEUE_STATUS_BLANK = "";
    public static final String JOB_QUEUE_STATUS_SCHEDULED = "SCD";
    public static final String JOB_QUEUE_STATUS_HELD = "HLD";
    public static final String JOB_QUEUE_STATUS_READY = "RLS";
    public static final int JOB_STATUS = 11003;
    public static final String JOB_STATUS_ACTIVE = "*ACTIVE";
    public static final String JOB_STATUS_JOBQ = "*JOBQ";
    public static final String JOB_STATUS_OUTQ = "*OUTQ";
    public static final int JOB_SUBTYPE = 11004;
    public static final String JOB_SUBTYPE_BLANK = "";
    public static final String JOB_SUBTYPE_IMMEDIATE = "D";
    public static final String JOB_SUBTYPE_PROCEDURE_START_REQUEST = "E";
    public static final String JOB_SUBTYPE_MACHINE_SERVER_JOB = "F";
    public static final String JOB_SUBTYPE_PRESTART = "J";
    public static final String JOB_SUBTYPE_PRINT_DRIVER = "P";
    public static final String JOB_SUBTYPE_MRT = "T";
    public static final String JOB_SUBTYPE_ALTERNATE_SPOOL_USER = "U";
    public static final int JOB_SWITCHES = 1006;
    public static final int JOB_TYPE = 11005;
    public static final String JOB_TYPE_NOT_VALID = "";
    public static final String JOB_TYPE_AUTOSTART = "A";
    public static final String JOB_TYPE_BATCH = "B";
    public static final String JOB_TYPE_INTERACTIVE = "I";
    public static final String JOB_TYPE_SUBSYSTEM_MONITOR = "M";
    public static final String JOB_TYPE_SPOOLED_READER = "R";
    public static final String JOB_TYPE_SYSTEM = "S";
    public static final String JOB_TYPE_SPOOLED_WRITER = "W";
    public static final String JOB_TYPE_SCPF_SYSTEM = "X";
    public static final int JOB_TYPE_ENHANCED = 1016;
    public static final Integer JOB_TYPE_ENHANCED_AUTOSTART = new Integer(110);
    public static final Integer JOB_TYPE_ENHANCED_BATCH = new Integer(210);
    public static final Integer JOB_TYPE_ENHANCED_BATCH_IMMEDIATE = new Integer(220);
    public static final Integer JOB_TYPE_ENHANCED_BATCH_MRT = new Integer(230);
    public static final Integer JOB_TYPE_ENHANCED_BATCH_ALTERNATE_SPOOL_USER = new Integer(240);
    public static final Integer JOB_TYPE_ENHANCED_COMM_PROCEDURE_START_REQUEST = new Integer(310);
    public static final Integer JOB_TYPE_ENHANCED_INTERACTIVE = new Integer(910);
    public static final Integer JOB_TYPE_ENHANCED_INTERACTIVE_GROUP = new Integer(920);
    public static final Integer JOB_TYPE_ENHANCED_INTERACTIVE_SYSREQ = new Integer(930);
    public static final Integer JOB_TYPE_ENHANCED_INTERACTIVE_SYSREQ_AND_GROUP = new Integer(940);
    public static final Integer JOB_TYPE_ENHANCED_PRESTART = new Integer(1610);
    public static final Integer JOB_TYPE_ENHANCED_PRESTART_BATCH = new Integer(1620);
    public static final Integer JOB_TYPE_ENHANCED_PRESTART_COMM = new Integer(1630);
    public static final Integer JOB_TYPE_ENHANCED_READER = new Integer(1810);
    public static final Integer JOB_TYPE_ENHANCED_SUBSYSTEM = new Integer(1910);
    public static final Integer JOB_TYPE_ENHANCED_SYSTEM = new Integer(1920);
    public static final Integer JOB_TYPE_ENHANCED_WRITER = new Integer(2310);
    public static final int JOB_USER_IDENTITY = 1012;
    public static final int JOB_USER_IDENTITY_SETTING = 1013;
    public static final String JOB_USER_IDENTITY_SETTING_DEFAULT = "0";
    public static final String JOB_USER_IDENTITY_SETTING_APPLICATION = "1";
    public static final String JOB_USER_IDENTITY_SETTING_SYSTEM = "2";
    public static final int KEEP_DDM_CONNECTIONS_ACTIVE = 408;
    public static final String KEEP_DDM_CONNECTIONS_ACTIVE_KEEP = "*KEEP";
    public static final String KEEP_DDM_CONNECTIONS_ACTIVE_DROP = "*DROP";
    public static final int LANGUAGE_ID = 1201;
    public static final String LANGUAGE_ID_SYSTEM_VALUE = "*SYSVAL";
    public static final String LANGUAGE_ID_INITIAL_USER = "*USRPRF";
    public static final int LOG_CL_PROGRAMS = 1203;
    public static final String LOG_CL_PROGRAMS_YES = "*YES";
    public static final String LOG_CL_PROGRAMS_NO = "*NO";
    public static final int LOGGING_LEVEL = 1202;
    public static final String LOGGING_LEVEL_NONE = "0";
    public static final String LOGGING_LEVEL_MESSAGES_BY_SEVERITY = "1";
    public static final String LOGGING_LEVEL_REQUESTS_BY_SEVERITY_AND_ASSOCIATED_MESSAGES = "2";
    public static final String LOGGING_LEVEL_ALL_REQUESTS_AND_ASSOCIATED_MESSAGES = "3";
    public static final String LOGGING_LEVEL_ALL_REQUESTS_AND_MESSAGES = "4";
    public static final int LOGGING_SEVERITY = 1204;
    public static final int LOGGING_TEXT = 1205;
    public static final String LOGGING_TEXT_MESSAGE = "*MSG";
    public static final String LOGGING_TEXT_SECLVL = "*SECLVL";
    public static final String LOGGING_TEXT_NO_LIST = "*NOLIST";
    public static final int MAX_CPU_TIME = 1302;
    public static final int MAX_TEMP_STORAGE = 1303;
    public static final int MAX_TEMP_STORAGE_LARGE = 1305;
    public static final int MAX_THREADS = 1304;
    public static final int MEMORY_POOL = 1306;
    public static final String MEMORY_POOL_MACHINE = "*MACHINE";
    public static final String MEMORY_POOL_BASE = "*BASE";
    public static final String MEMORY_POOL_INTERACTIVE = "*INTERACT";
    public static final String MEMORY_POOL_SPOOL = "*SPOOL";
    public static final int MESSAGE_REPLY = 1307;
    public static final String MESSAGE_REPLY_NOT_IN_MESSAGE_WAIT = "0";
    public static final String MESSAGE_REPLY_WAITING = "1";
    public static final String MESSAGE_REPLY_NOT_WAITING = "2";
    public static final int MESSAGE_QUEUE_ACTION = 1007;
    public static final String MESSAGE_QUEUE_ACTION_SYSTEM_VALUE = "*SYSVAL";
    public static final String MESSAGE_QUEUE_ACTION_NO_WRAP = "*NOWRAP";
    public static final String MESSAGE_QUEUE_ACTION_WRAP = "*WRAP";
    public static final String MESSAGE_QUEUE_ACTION_PRINT_WRAP = "*PRTWRAP";
    public static final int MESSAGE_QUEUE_MAX_SIZE = 1008;
    public static final int MODE = 1301;
    public static final int OUTPUT_QUEUE = 1501;
    public static final String OUTPUT_QUEUE_DEVICE = "*DEV";
    public static final String OUTPUT_QUEUE_WORK_STATION = "*WRKSTN";
    public static final String OUTPUT_QUEUE_INITIAL_USER = "*USRPRF";
    public static final int OUTPUT_QUEUE_PRIORITY = 1502;
    public static final int PRINT_KEY_FORMAT = 1601;
    public static final String PRINT_KEY_FORMAT_SYSTEM_VALUE = "*SYSVAL";
    public static final String PRINT_KEY_FORMAT_NONE = "*NONE";
    public static final String PRINT_KEY_FORMAT_BORDER = "*PRTBDR";
    public static final String PRINT_KEY_FORMAT_HEADER = "*PRTHDR";
    public static final String PRINT_KEY_FORMAT_ALL = "*PRTALL";
    public static final int PRINT_TEXT = 1602;
    public static final String PRINT_TEXT_SYSTEM_VALUE = "*SYSVAL";
    public static final String PRINT_TEXT_BLANK = "*BLANK";
    public static final int PRINTER_DEVICE_NAME = 1603;
    public static final String PRINTER_DEVICE_NAME_SYSTEM_VALUE = "*SYSVAL";
    public static final String PRINTER_DEVICE_NAME_WORK_STATION = "*WRKSTN";
    public static final String PRINTER_DEVICE_NAME_INITIAL_USER = "*USRPRF";
    public static final int PRODUCT_LIBRARIES = 10002;
    public static final int PRODUCT_RETURN_CODE = 1605;
    public static final int PROGRAM_RETURN_CODE = 1606;
    public static final int ROUTING_DATA = 1803;
    public static final int RUN_PRIORITY = 1802;
    public static final int SCHEDULE_DATE = 1920;
    public static final String SCHEDULE_DATE_CURRENT = "*CURRENT";
    public static final String SCHEDULE_DATE_MONTH_START = "*MONTHSTR";
    public static final String SCHEDULE_DATE_MONTH_END = "*MONTHEND";
    public static final String SCHEDULE_DATE_MONDAY = "*MON";
    public static final String SCHEDULE_DATE_TUESDAY = "*TUE";
    public static final String SCHEDULE_DATE_WEDNESDAY = "*WED";
    public static final String SCHEDULE_DATE_THURSDAY = "*THU";
    public static final String SCHEDULE_DATE_FRIDAY = "*FRI";
    public static final String SCHEDULE_DATE_SATURDAY = "*SAT";
    public static final String SCHEDULE_DATE_SUNDAY = "*SUN";
    public static final int SCHEDULE_TIME = 1921;
    public static final String SCHEDULE_TIME_CURRENT = "*CURRENT";
    static final int SCHEDULE_DATE_GETTER = 403;
    public static final int SERVER_TYPE = 1911;
    public static final int SIGNED_ON_JOB = 701;
    public static final String SIGNED_ON_JOB_TRUE = "0";
    public static final String SIGNED_ON_JOB_FALSE = "1";
    public static final int SORT_SEQUENCE_TABLE = 1901;
    public static final String SORT_SEQUENCE_TABLE_SYSTEM_VALUE = "*SYSVAL";
    public static final String SORT_SEQUENCE_TABLE_INITIAL_USER = "*USRPRF";
    public static final String SORT_SEQUENCE_TABLE_NONE = "*HEX";
    public static final String SORT_SEQUENCE_TABLE_LANGUAGE_SHARED_WEIGHT = "*LANGIDSHR";
    public static final String SORT_SEQUENCE_TABLE_LANGUAGE_UNIQUE_WEIGHT = "*LANGIDUNQ";
    public static final int SPECIAL_ENVIRONMENT = 1908;
    public static final String SPECIAL_ENVIRONMENT_NONE = "*NONE";
    public static final String SPECIAL_ENVIRONMENT_SYSTEM_36 = "*S36";
    public static final String SPECIAL_ENVIRONMENT_NOT_ACTIVE = "";
    public static final int SPOOLED_FILE_ACTION = 1982;
    public static final String SPOOLED_FILE_ACTION_KEEP = "*KEEP";
    public static final String SPOOLED_FILE_ACTION_DETACH = "*DETACH";
    public static final String SPOOLED_FILE_ACTION_SYSTEM_VALUE = "*SYSVAL";
    public static final int STATUS_MESSAGE_HANDLING = 1902;
    public static final String STATUS_MESSAGE_HANDLING_SYSTEM_VALUE = "*SYSVAL";
    public static final String STATUS_MESSAGE_HANDLING_INITIAL_USER = "*USRPRF";
    public static final String STATUS_MESSAGE_HANDLING_NONE = "*NONE";
    public static final String STATUS_MESSAGE_HANDLING_NORMAL = "*NORMAL";
    public static final int SUBMITTED_BY_JOB_NAME = 1904;
    public static final int SUBMITTED_BY_USER = 10006;
    public static final int SUBMITTED_BY_JOB_NUMBER = 10005;
    public static final int SUBSYSTEM = 1906;
    public static final int SYSTEM_POOL_ID = 1907;
    public static final int SYSTEM_LIBRARY_LIST = 10003;
    public static final int TEMP_STORAGE_USED = 2004;
    public static final int TEMP_STORAGE_USED_LARGE = 2009;
    public static final int THREAD_COUNT = 2008;
    public static final int TIME_SEPARATOR = 2001;
    public static final String TIME_SEPARATOR_SYSTEM_VALUE = "S";
    public static final String TIME_SEPARATOR_COLON = ":";
    public static final String TIME_SEPARATOR_PERIOD = ".";
    public static final String TIME_SEPARATOR_BLANK = " ";
    public static final String TIME_SEPARATOR_COMMA = ",";
    public static final int TIME_SLICE = 2002;
    public static final int TIME_SLICE_END_POOL = 2003;
    public static final String TIME_SLICE_END_POOL_SYSTEM_VALUE = "*SYSVAL";
    public static final String TIME_SLICE_END_POOL_NONE = "*NONE";
    public static final String TIME_SLICE_END_POOL_BASE = "*BASE";
    public static final int TOTAL_RESPONSE_TIME = 1801;
    public static final int UNIT_OF_WORK_ID = 2101;
    public static final int LOCATION_NAME = 21012;
    public static final int NETWORK_ID = 21013;
    public static final int INSTANCE = 21011;
    public static final int SEQUENCE_NUMBER = 21014;
    public static final int USER_LIBRARY_LIST = 10004;
    public static final int USER_NAME = 11006;
    public static final String USER_NAME_BLANK = "";
    public static final int USER_RETURN_CODE = 2102;
    static final IntegerHashtable setterKeys_ = new IntegerHashtable();
    private static final int FORMAT_DTS = 1;

    private static boolean isTypeBinary(int n) {
        switch (n) {
            case 302: 
            case 409: 
            case 1204: 
            case 1802: 
            case 2002: {
                return true;
            }
        }
        return false;
    }

    public Job() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object.");
        }
    }

    public Job(AS400 aS400) {
        this(aS400, "*", "", "");
    }

    public Job(AS400 aS400, String string, String string2, String string3) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object, system: " + aS400 + ", job name: " + string + ", user name: " + string2 + ", job number: " + string3);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'jobName' is null.");
            throw new NullPointerException("jobName");
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of parameter 'jobName' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("jobName (" + string + ")", 1);
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'userName' is null.");
            throw new NullPointerException("userName");
        }
        if (string2.length() > 10) {
            Trace.log(2, "Length of parameter 'userName' is not valid: '" + string2 + "'");
            throw new ExtendedIllegalArgumentException("userName (" + string2 + ")", 1);
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'jobNumber' is null.");
            throw new NullPointerException("jobNumber");
        }
        if (string3.length() > 6) {
            Trace.log(2, "Length of parameter 'jobNumber' is not valid: '" + string3 + "'");
            throw new ExtendedIllegalArgumentException("jobNumber (" + string3 + ")", 1);
        }
        if (string.equals("*")) {
            if (string2.trim().length() != 0) {
                Trace.log(2, "Value of parameter 'userName' is not valid: " + string2);
                throw new ExtendedIllegalArgumentException("userName (" + string2 + ")", 2);
            }
            if (string3.trim().length() != 0) {
                Trace.log(2, "Value of parameter 'jobNumber' is not valid: " + string3);
                throw new ExtendedIllegalArgumentException("jobNumber (" + string3 + ")", 2);
            }
        }
        this.system_ = aS400;
        this.name_ = string;
        this.setValueInternal(11001, string);
        this.user_ = string2;
        this.setValueInternal(11006, string2);
        this.number_ = string3;
        this.setValueInternal(11002, string3);
        this.internalJobID_ = "";
        this.realInternalJobID_ = null;
        this.setValueInternal(11000, "");
    }

    public Job(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object, system: " + aS400 + ", job identifier: '" + string + "'");
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'internalJobID' is null.");
            throw new NullPointerException("internalJobID");
        }
        if (string.length() != 16) {
            Trace.log(2, "Length of parameter 'internalJobID' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("internalJobID (" + string + ")", 1);
        }
        this.system_ = aS400;
        this.internalJobID_ = string;
        this.realInternalJobID_ = new byte[16];
        for (int i = 0; i < 16; ++i) {
            this.realInternalJobID_[i] = (byte)string.charAt(i);
        }
        this.setValueInternal(11000, string);
        this.setValueInternal(11007, this.realInternalJobID_);
        this.name_ = JOB_NAME_INTERNAL;
        this.setValueInternal(11001, null);
        this.user_ = "";
        this.setValueInternal(11006, null);
        this.number_ = "";
        this.setValueInternal(11002, null);
    }

    public Job(AS400 aS400, byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object, system: " + aS400 + ", job identifier:", byArray);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (byArray == null) {
            Trace.log(2, "Parameter 'internalJobID' is null.");
            throw new NullPointerException("internalJobID");
        }
        if (byArray.length != 16) {
            Trace.log(2, "Length of parameter 'internalJobID' is not valid: " + byArray.length);
            throw new ExtendedIllegalArgumentException("internalJobID.length {" + byArray.length + ")", 1);
        }
        this.system_ = aS400;
        this.realInternalJobID_ = byArray;
        char[] cArray = new char[16];
        for (int i = 0; i < 16; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.internalJobID_ = new String(cArray);
        this.setValueInternal(11000, byArray);
        this.setValueInternal(11007, this.realInternalJobID_);
        this.name_ = JOB_NAME_INTERNAL;
        this.setValueInternal(11001, null);
        this.user_ = "";
        this.setValueInternal(11006, null);
        this.number_ = "";
        this.setValueInternal(11002, null);
    }

    Job(AS400 aS400, String string, String string2, String string3, String string4, String string5, String string6) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job object, system: " + aS400 + ", job name: " + string + ", user name: " + string2 + ", job number: " + string3 + ", status: " + string4 + ", type: " + string5 + ", subtype: " + string6);
        }
        this.system_ = aS400;
        this.name_ = string;
        this.setValueInternal(11001, string);
        this.user_ = string2;
        this.setValueInternal(11006, string2);
        this.number_ = string3;
        this.setValueInternal(11002, string3);
        this.status_ = string4;
        this.setValueInternal(11003, string4);
        this.type_ = string5;
        this.setValueInternal(11005, string5);
        this.subtype_ = string6;
        this.setValueInternal(11004, string6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        Job job = this;
        synchronized (job) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        Job job = this;
        synchronized (job) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    private void connect() {
        if (!this.isConnected_) {
            if (this.system_ == null) {
                Trace.log(2, "Cannot connect to server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.name_ == null) {
                Trace.log(2, "Cannot connect to server before setting name.");
                throw new ExtendedIllegalStateException("name", 4);
            }
            if (this.user_ == null) {
                Trace.log(2, "Cannot connect to server before setting user.");
                throw new ExtendedIllegalStateException("user", 4);
            }
            if (this.number_ == null) {
                Trace.log(2, "Cannot connect to server before setting number.");
                throw new ExtendedIllegalStateException("number", 4);
            }
            this.isConnected_ = true;
        }
    }

    private byte[] createQualifiedJobName() throws IOException {
        if (this.realInternalJobID_ != null) {
            return new byte[]{92, -55, -43, -29, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        }
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        converter.stringToByteArray(this.name_, byArray);
        converter.stringToByteArray(this.user_, byArray, 10);
        converter.stringToByteArray(this.number_, byArray, 20);
        return byArray;
    }

    public void commitChanges() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.commitChanges(false);
    }

    public void commitChanges(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object;
        int n;
        int n2;
        if (Trace.traceOn_) {
            Trace.log(1, "Changing job.");
        }
        this.connect();
        if (this.cachedChanges_ == null || this.cachedChanges_.size_ == 0) {
            return;
        }
        int n3 = this.cachedChanges_.size_;
        int n4 = 0;
        int[][] nArray = this.cachedChanges_.keys_;
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            if (nArray2 == null) continue;
            for (int j = 0; j < nArray2.length; ++j) {
                n2 = setterKeys_.get(nArray2[j]);
                n = (4 - n2 % 4) % 4;
                n4 += 16 + n2 + n;
            }
        }
        byte[] byArray = new byte[4 + n4];
        BinaryConverter.intToByteArray(n3, byArray, 0);
        int n5 = this.system_.getCcsid();
        Converter converter = new Converter(n5, this.system_);
        n2 = 4;
        for (n = 0; n < nArray.length; ++n) {
            object = nArray[n];
            if (object == null) continue;
            for (int i = 0; i < ((int[])object).length; ++i) {
                int n6 = setterKeys_.get(object[i]);
                int n7 = (4 - n6 % 4) % 4;
                BinaryConverter.intToByteArray(16 + n6 + n7, byArray, n2);
                BinaryConverter.intToByteArray(object[i], byArray, n2 += 4);
                n2 += 4;
                boolean bl2 = Job.isTypeBinary(object[i]);
                byArray[n2++] = bl2 ? -62 : -61;
                byArray[n2++] = 64;
                byArray[n2++] = 64;
                byArray[n2++] = 64;
                BinaryConverter.intToByteArray(n6, byArray, n2);
                n2 += 4;
                Object object2 = this.cachedChanges_.get(object[i]);
                if (bl2) {
                    BinaryConverter.intToByteArray((Integer)object2, byArray, n2);
                } else {
                    try {
                        String string = (String)object2;
                        int n8 = n2 + n6 + n7;
                        for (int j = n2; j < n8; ++j) {
                            byArray[j] = 64;
                        }
                        converter.stringToByteArray(string, byArray, n2, n6);
                    }
                    catch (ClassCastException classCastException) {
                        System.arraycopy((byte[])object2, 0, byArray, n2, 8);
                    }
                }
                n2 += n6 + n7;
            }
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(this.createQualifiedJobName()), new ProgramParameter(this.realInternalJobID_ == null ? BLANKS16_ : this.realInternalJobID_), new ProgramParameter(new byte[]{-47, -42, -62, -61, -16, -15, -16, -16}), new ProgramParameter(byArray), new ProgramParameter(new byte[8])};
        Boolean bl3 = bl ? ON_THREAD : OFF_THREAD;
        object = this.getProgramCall("/QSYS.LIB/QWTCHGJB.PGM", programParameterArray, bl3);
        if (Trace.traceOn_) {
            Trace.log(1, "Setting job information for job: " + this.toString());
        }
        if (!object.run()) {
            AS400Message[] aS400MessageArray = object.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
        this.cachedChanges_ = null;
    }

    public void end(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Ending job.");
        }
        if (n < -1) {
            Trace.log(2, "Value of parameter 'delay' is not valid:", n);
            throw new ExtendedIllegalArgumentException("delay (" + n + ")", 4);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("QSYS/ENDJOB JOB(");
        stringBuffer.append(this.number_);
        stringBuffer.append('/');
        stringBuffer.append(this.user_);
        stringBuffer.append('/');
        stringBuffer.append(this.name_);
        stringBuffer.append(") OPTION(");
        if (n == 0) {
            stringBuffer.append("*IMMED)");
        } else {
            stringBuffer.append("*CNTRLD)");
            if (n > 0) {
                stringBuffer.append(" DELAY(");
                stringBuffer.append(n);
                stringBuffer.append(")");
            }
        }
        String string = stringBuffer.toString();
        CommandCall commandCall = this.getCommandCall(string);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        commandCall.getSystem().disconnectService(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CommandCall getCommandCall(String string) {
        if (this.cmdCall_ == null) {
            Object object = this.remoteCommandLock_;
            synchronized (object) {
                if (this.cmdCall_ == null) {
                    this.cmdCall_ = new CommandCall(this.system_);
                }
            }
        }
        try {
            this.cmdCall_.setCommand(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return this.cmdCall_;
    }

    private final ProgramCall getProgramCall(String string, ProgramParameter[] programParameterArray) {
        return this.getProgramCall(string, programParameterArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProgramCall getProgramCall(String string, ProgramParameter[] programParameterArray, Boolean bl) {
        if (ON_THREAD.equals(bl)) {
            if (this.pgmCall_onThread_ == null) {
                Object object = this.remoteCommandLock_;
                synchronized (object) {
                    if (this.pgmCall_onThread_ == null) {
                        this.pgmCall_onThread_ = new ProgramCall(this.system_);
                        this.pgmCall_onThread_.setThreadSafe(true);
                    }
                }
            }
            try {
                this.pgmCall_onThread_.setProgram(string, programParameterArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return this.pgmCall_onThread_;
        }
        if (OFF_THREAD.equals(bl)) {
            if (this.pgmCall_offThread_ == null) {
                Object object = this.remoteCommandLock_;
                synchronized (object) {
                    if (this.pgmCall_offThread_ == null) {
                        this.pgmCall_offThread_ = new ProgramCall(this.system_);
                        this.pgmCall_offThread_.setThreadSafe(false);
                    }
                }
            }
            try {
                this.pgmCall_offThread_.setProgram(string, programParameterArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return this.pgmCall_offThread_;
        }
        if (this.pgmCall_ == null) {
            Object object = this.remoteCommandLock_;
            synchronized (object) {
                if (this.pgmCall_ == null) {
                    this.pgmCall_ = new ProgramCall(this.system_);
                }
            }
        }
        try {
            this.pgmCall_.setProgram(string, programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return this.pgmCall_;
    }

    private Date getAsDate(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = (String)this.getValue(n);
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.clear();
        Date date = null;
        switch (string.trim().length()) {
            case 7: {
                calendar.set(Integer.parseInt(string.substring(0, 3)) + 1900, Integer.parseInt(string.substring(3, 5)) - 1, Integer.parseInt(string.substring(5, 7)));
                date = calendar.getTime();
                break;
            }
            case 13: {
                calendar.set(Integer.parseInt(string.substring(0, 3)) + 1900, Integer.parseInt(string.substring(3, 5)) - 1, Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(7, 9)), Integer.parseInt(string.substring(9, 11)), Integer.parseInt(string.substring(11, 13)));
                date = calendar.getTime();
            }
        }
        return date;
    }

    private int getAsInt(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return Integer.parseInt(this.getValue(n).toString().trim());
    }

    private Date getAsSystemDate(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        AS400Timestamp aS400Timestamp = this.getTimestampConverter(1);
        return aS400Timestamp.toDate(aS400Timestamp.toTimestamp((byte[])this.getValue(n)), TimeZone.getDefault());
    }

    public int getAuxiliaryIORequests() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1401);
    }

    public String getBreakMessageHandling() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(201)).trim();
    }

    public boolean getCacheChanges() {
        return this.cacheChanges_;
    }

    public CallStackEntry[] getCallStack(long l) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (l < 0L && l != -1L) {
            throw new ExtendedIllegalArgumentException("threadID", 2);
        }
        if (!this.isConnected_) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.name_ == null) {
                throw new ExtendedIllegalStateException("name", 4);
            }
            if (this.user_ == null) {
                throw new ExtendedIllegalStateException("user", 4);
            }
            if (this.number_ == null) {
                throw new ExtendedIllegalStateException("number", 4);
            }
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        int n2 = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n2);
        int n3 = 2000;
        programParameterArray[0] = new ProgramParameter(n3);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        programParameterArray[2] = new ProgramParameter(charConverter.stringToByteArray("CSTK0100"));
        byte[] byArray = new byte[56];
        AS400Text aS400Text = new AS400Text(10, n2);
        AS400Text aS400Text2 = new AS400Text(6, n2);
        byte[] byArray2 = this.getInternalJobIdentifier();
        if (!this.name_.equals(JOB_NAME_INTERNAL)) {
            byArray2 = new byte[16];
            for (n = 0; n < 16; ++n) {
                byArray2[n] = 64;
            }
        }
        aS400Text.toBytes(this.name_, byArray, 0);
        aS400Text.toBytes(this.user_, byArray, 10);
        aS400Text2.toBytes(this.number_, byArray, 20);
        System.arraycopy(byArray2, 0, byArray, 26, 16);
        n = l == -1L ? 2 : 0;
        long l2 = l == -1L ? 0L : l;
        BinaryConverter.intToByteArray(n, byArray, 44);
        BinaryConverter.longToByteArray(l2, byArray, 48);
        programParameterArray[3] = new ProgramParameter(byArray);
        programParameterArray[4] = new ProgramParameter(charConverter.stringToByteArray("JIDF0100"));
        programParameterArray[5] = new ProgramParameter(new byte[4]);
        ProgramCall programCall = this.getProgramCall("/QSYS.LIB/QWVRCSTK.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray3 = programParameterArray[0].getOutputData();
        int n4 = BinaryConverter.byteArrayToInt(byArray3, 0);
        int n5 = BinaryConverter.byteArrayToInt(byArray3, 4);
        while (n5 > n4) {
            try {
                n3 = n5 * 2;
                if (Trace.traceOn_) {
                    Trace.log(1, "Calling QWVRCSTK again with receiver size of " + n3);
                }
                programParameterArray[0].setOutputDataLength(n3);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n3));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray3 = programParameterArray[0].getOutputData();
            n4 = BinaryConverter.byteArrayToInt(byArray3, 0);
            n5 = BinaryConverter.byteArrayToInt(byArray3, 4);
        }
        int n6 = BinaryConverter.byteArrayToInt(byArray3, 8);
        int n7 = BinaryConverter.byteArrayToInt(byArray3, 12);
        int n8 = BinaryConverter.byteArrayToInt(byArray3, 16);
        if (n8 != n6 && Trace.traceOn_) {
            Trace.log(4, "Not all call stack entries were returned: total: " + n6 + ", returned: " + n8);
        }
        l = BinaryConverter.byteArrayToLong(byArray3, 20);
        if (byArray3[28] != 64 && Trace.traceOn_) {
            Trace.log(4, "Call stack entry information incomplete due to status: " + Integer.toHexString(0xFF & byArray3[28]));
        }
        CallStackEntry[] callStackEntryArray = new CallStackEntry[n8];
        int n9 = AS400.generateVRM(5, 3, 0);
        boolean bl = this.system_.getVRM() >= n9;
        for (int i = 0; i < n8; ++i) {
            int n10 = BinaryConverter.byteArrayToInt(byArray3, n7);
            int n11 = BinaryConverter.byteArrayToInt(byArray3, n7 + 4);
            int n12 = BinaryConverter.byteArrayToInt(byArray3, n7 + 8);
            int n13 = BinaryConverter.byteArrayToInt(byArray3, n7 + 12);
            int n14 = BinaryConverter.byteArrayToInt(byArray3, n7 + 16);
            int n15 = BinaryConverter.byteArrayToInt(byArray3, n7 + 20);
            String string = charConverter.byteArrayToString(byArray3, n7 + 24, 10).trim();
            String string2 = charConverter.byteArrayToString(byArray3, n7 + 34, 10).trim();
            int n16 = BinaryConverter.byteArrayToInt(byArray3, n7 + 44);
            String string3 = charConverter.byteArrayToString(byArray3, n7 + 48, 10).trim();
            String string4 = charConverter.byteArrayToString(byArray3, n7 + 58, 10).trim();
            byte by = byArray3[n7 + 68];
            long l3 = BinaryConverter.byteArrayToUnsignedInt(byArray3, n7 + 72);
            String string5 = charConverter.byteArrayToString(byArray3, n7 + 76, 10).trim();
            String string6 = charConverter.byteArrayToString(byArray3, n7 + 88, 10).trim();
            String string7 = charConverter.byteArrayToString(byArray3, n7 + 98, 10).trim();
            int n17 = BinaryConverter.byteArrayToInt(byArray3, n7 + 108);
            int n18 = BinaryConverter.byteArrayToInt(byArray3, n7 + 112);
            long l4 = bl ? BinaryConverter.byteArrayToLong(byArray3, n7 + 116) : 0L;
            String[] stringArray = new String[n12];
            for (int j = 0; j < n12; ++j) {
                stringArray[j] = charConverter.byteArrayToString(byArray3, n7 + n11 + j * 10, 10).trim();
            }
            String string8 = n13 > 0 ? charConverter.byteArrayToString(byArray3, n7 + n13, n14).trim() : null;
            callStackEntryArray[i] = new CallStackEntry(this, l, n15, string, string2, n16, string3, string4, by, l3, string5, string6, string7, n17, n18, l4, stringArray, string8);
            n7 += n10;
        }
        return callStackEntryArray;
    }

    public int getCodedCharacterSetID() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(302);
    }

    public String getCompletionStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(306);
    }

    public String getCountryID() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(303)).trim();
    }

    public int getCPUUsed() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(304);
    }

    public String getCurrentLibrary() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(10000)).trim();
    }

    public boolean getCurrentLibraryExistence() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(10001) == 1;
    }

    public Date getDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(402);
    }

    public String getDateFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(405)).trim();
    }

    public String getDateSeparator() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(406);
    }

    public String getDDMConversationHandling() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(408)).trim();
    }

    public String getDecimalFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(413)).trim();
    }

    public int getDefaultCodedCharacterSetIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(412);
    }

    public int getDefaultWait() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(409);
    }

    public String getDeviceRecoveryAction() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(410)).trim();
    }

    public int getEndSeverity() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(501);
    }

    public String getFunctionName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(601)).trim();
    }

    public String getFunctionType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(602);
    }

    public String getInquiryMessageReply() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(901)).trim();
    }

    public int getInteractiveTransactions() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1402);
    }

    public String getInternalJobID() {
        return this.internalJobID_;
    }

    public byte[] getInternalJobIdentifier() {
        return this.realInternalJobID_;
    }

    public String getJobAccountingCode() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1001)).trim();
    }

    public Date getJobActiveDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(401);
    }

    public Date getJobDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(1002);
    }

    public String getJobDescription() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = ((String)this.getValue(1003)).trim();
        if (string.length() > 0 && !string.startsWith("*")) {
            String string2 = string.substring(0, 10).trim();
            String string3 = string.substring(10, string.length());
            String string4 = QSYSObjectPathName.toPath(string3, string2, "JOBD");
            return string4;
        }
        return string;
    }

    public Date getJobEndedDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(418);
    }

    public Date getJobEnterSystemDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsDate(402);
    }

    public JobLog getJobLog() {
        try {
            return new JobLog(this.system_, (String)this.getValue(11001), (String)this.getValue(11006), (String)this.getValue(11002));
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(2, "Error retrieving values to create job log: " + exception);
            }
            return null;
        }
    }

    public String getJobMessageQueueFullAction() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1007)).trim();
    }

    public int getJobMessageQueueMaximumSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1008);
    }

    public Date getJobPutOnJobQueueDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsSystemDate(404);
    }

    public Date getScheduleDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.cachedChanges_ != null && (this.cachedChanges_.contains(1920) || this.cachedChanges_.contains(1921))) {
            int n;
            int n2;
            int n3;
            Calendar calendar = AS400Calendar.getGregorianInstance();
            calendar.clear();
            String string = (String)this.cachedChanges_.get(1920);
            if (string != null) {
                int n4 = Integer.parseInt(string.substring(0, 1));
                n3 = Integer.parseInt(string.substring(1, 3));
                n2 = Integer.parseInt(string.substring(3, 5));
                n = Integer.parseInt(string.substring(5, 7));
                calendar.set(1, n3 + (n4 == 0 ? 1900 : 2000));
                calendar.set(2, n2 - 1);
                calendar.set(5, n);
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
            }
            String string2 = (String)this.cachedChanges_.get(1921);
            if (string2 != null) {
                n3 = Integer.parseInt(string2.substring(0, 2));
                n2 = Integer.parseInt(string2.substring(2, 4));
                n = Integer.parseInt(string2.substring(4, 6));
                calendar.set(11, n3);
                calendar.set(12, n2);
                calendar.set(13, n);
            } else {
                calendar.set(1, 0);
                calendar.set(2, 0);
                calendar.set(5, 0);
            }
            return calendar.getTime();
        }
        return this.getAsSystemDate(403);
    }

    public String getJobStatusInJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1903)).trim();
    }

    public String getJobSwitches() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(1006);
    }

    public String getLanguageID() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(1201);
    }

    public String getLoggingCLPrograms() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1203)).trim();
    }

    public int getLoggingLevel() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return Integer.parseInt((String)this.getValue(1202));
    }

    public int getLoggingSeverity() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1204);
    }

    public String getLoggingText() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1205)).trim();
    }

    public String getModeName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1301)).trim();
    }

    public String getName() {
        return this.name_;
    }

    public String getNumber() {
        return this.number_;
    }

    public int getNumberOfLibrariesInSYSLIBL() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getSystemLibraryList().length;
    }

    public int getNumberOfLibrariesInUSRLIBL() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getUserLibraryList().length;
    }

    public int getNumberOfProductLibraries() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getProductLibraries().length;
    }

    public String getOutputQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = ((String)this.getValue(1501)).trim();
        if (string.length() > 0 && !string.startsWith("*")) {
            String string2 = string.substring(0, 10).trim();
            String string3 = string.substring(10, string.length());
            String string4 = QSYSObjectPathName.toPath(string3, string2, "OUTQ");
            return string4;
        }
        return string;
    }

    public int getOutputQueuePriority() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1502);
    }

    public int getPoolIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1907);
    }

    public String getPrinterDeviceName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1603)).trim();
    }

    public String getPrintKeyFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1601)).trim();
    }

    public String getPrintText() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1602)).trim();
    }

    public String[] getProductLibraries() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = (String)this.getValue(10002);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public boolean getPurge() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1604)).trim().equals("*YES");
    }

    public String getQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = ((String)this.getValue(1004)).trim();
        if (string.length() > 0 && !string.startsWith("*")) {
            String string2 = string.substring(0, 10).trim();
            String string3 = string.substring(10, string.length());
            String string4 = QSYSObjectPathName.toPath(string3, string2, "JOBQ");
            return string4;
        }
        return string;
    }

    public int getQueuePriority() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = ((String)this.getValue(1005)).trim();
        if (string.length() == 0) {
            return -1;
        }
        return new Integer(string);
    }

    public String getRoutingData() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1803)).trim();
    }

    public int getRunPriority() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1802);
    }

    public boolean getSignedOnJob() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(701)).trim().equals("0");
    }

    public String getSortSequenceTable() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = ((String)this.getValue(1901)).trim();
        if (string.length() > 0 && !string.startsWith("*")) {
            String string2 = string.substring(0, 10).trim();
            String string3 = string.substring(10, string.length());
            String string4 = QSYSObjectPathName.toPath(string3, string2, "FILE");
            return string4;
        }
        return string;
    }

    public String getStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(11003)).trim();
    }

    public String getStatusMessageHandling() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(1902)).trim();
    }

    public String getStringValue(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object = this.getValue(n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return ((String)object).trim();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Returning a string representation of the value of a non-String attribute:", n);
        }
        return object.toString();
    }

    public String getSubsystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = ((String)this.getValue(1906)).trim();
        if (string.length() > 10) {
            String string2 = string.substring(0, 10).trim();
            String string3 = string.substring(10, string.length());
            String string4 = QSYSObjectPathName.toPath(string3, string2, "SBSD");
            return string4;
        }
        return string;
    }

    public String getSubtype() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(11004);
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String[] getSystemLibraryList() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = (String)this.getValue(10003);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public String getTimeSeparator() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(2001);
    }

    public int getTimeSlice() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(2002);
    }

    private synchronized AS400Timestamp getTimestampConverter(int n) {
        if (this.timestampConverter_ == null) {
            this.timestampConverter_ = new AS400Timestamp(AS400.getDefaultTimeZone(this.system_));
            this.timestampConverter_.setFormat(n);
        } else if (n != this.timestampConverter_.getFormat()) {
            this.timestampConverter_.setFormat(n);
        }
        return this.timestampConverter_;
    }

    public String getTimeSliceEndPool() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(2003)).trim();
    }

    public int getTotalResponseTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getAsInt(1801);
    }

    public String getType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return (String)this.getValue(11005);
    }

    public String getUser() {
        return this.user_;
    }

    public String[] getUserLibraryList() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = (String)this.getValue(10004);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public Object getValue(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object = this.values_.get(n);
        if (object == null) {
            this.retrieve(n);
            object = this.values_.get(n);
            if (object == null && (n == 1920 || n == 1921)) {
                Date date = this.getAsSystemDate(403);
                this.setValueInternal(1920, date);
                this.setValueInternal(1921, date);
                return date;
            }
        }
        return object;
    }

    public String getWorkIDUnit() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return ((String)this.getValue(2101)).trim();
    }

    public void hold(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("QSYS/HLDJOB JOB(");
        stringBuffer.append(this.number_);
        stringBuffer.append('/');
        stringBuffer.append(this.user_);
        stringBuffer.append('/');
        stringBuffer.append(this.name_);
        stringBuffer.append(") SPLFILE(");
        stringBuffer.append(bl ? "*YES)" : "*NO)");
        stringBuffer.append(" DUPJOBOPT(*MSG)");
        String string = stringBuffer.toString();
        CommandCall commandCall = this.getCommandCall(string);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    private static boolean isReadOnly(int n) {
        return setterKeys_.get(n) == -1;
    }

    public void loadInformation() {
        try {
            this.values_.clear();
            this.setValueInternal(11001, this.name_);
            this.setValueInternal(11006, this.user_);
            this.setValueInternal(11002, this.number_);
            this.setValueInternal(11005, this.type_);
            this.setValueInternal(11004, this.subtype_);
            this.retrieve(2008);
            this.retrieve(307);
            this.retrieve(1002);
            this.retrieve(1911);
            this.retrieve(1205);
            this.retrieve(1908);
            this.retrieve(10004);
            this.retrieve(315);
        }
        catch (Exception exception) {
            Trace.log(2, "Error loading job information:", (Throwable)exception);
        }
    }

    public void loadInformation(int[] nArray) {
        block18: {
            try {
                boolean[] blArray = new boolean[8];
                block9: for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    byte[] byArray = Job.lookupFormatName(n);
                    blArray[byArray[5] & 0xF] = true;
                    this.values_.remove(n);
                    switch (n) {
                        case 11001: {
                            this.setValueInternal(11001, this.name_);
                            continue block9;
                        }
                        case 11006: {
                            this.setValueInternal(11006, this.user_);
                            continue block9;
                        }
                        case 11002: {
                            this.setValueInternal(11002, this.number_);
                            continue block9;
                        }
                        case 11005: {
                            this.setValueInternal(11005, this.type_);
                            continue block9;
                        }
                        case 11004: {
                            this.setValueInternal(11004, this.subtype_);
                            continue block9;
                        }
                    }
                }
                if (blArray[1]) {
                    this.retrieve(2008);
                }
                if (blArray[2]) {
                    this.retrieve(307);
                }
                if (blArray[3]) {
                    this.retrieve(1002);
                }
                if (blArray[4]) {
                    this.retrieve(1911);
                }
                if (blArray[5]) {
                    this.retrieve(1205);
                }
                if (blArray[6]) {
                    this.retrieve(1908);
                }
                if (blArray[7]) {
                    this.retrieve(10004);
                }
                if (blArray[0]) {
                    this.retrieve(315);
                }
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block18;
                Trace.log(2, "Error loading job information: ", (Throwable)exception);
            }
        }
    }

    public void loadStatistics() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(315);
    }

    private static int lookupFormatLength(byte[] byArray) {
        switch (byArray[5] & 0xF) {
            case 1: {
                return 144;
            }
            case 2: {
                return 191;
            }
            case 3: {
                return 187;
            }
            case 4: {
                return 584;
            }
            case 5: {
                return 83;
            }
            case 6: {
                return 322;
            }
            case 7: {
                return 3028;
            }
            case 0: {
                return 144;
            }
        }
        return -1;
    }

    private static byte[] lookupFormatName(int n) {
        switch (n) {
            case 304: 
            case 312: 
            case 409: 
            case 1302: 
            case 1303: 
            case 1304: 
            case 1305: 
            case 1604: 
            case 1802: 
            case 1907: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2008: 
            case 2009: 
            case 11000: 
            case 11001: 
            case 11002: 
            case 11003: 
            case 11004: 
            case 11005: 
            case 11006: 
            case 11007: {
                return new byte[]{-47, -42, -62, -55, -16, -15, -11, -16};
            }
            case 101: 
            case 103: 
            case 307: 
            case 313: 
            case 601: 
            case 602: 
            case 1306: 
            case 1307: 
            case 1401: 
            case 1402: 
            case 1406: 
            case 1801: {
                return new byte[]{-47, -42, -62, -55, -16, -14, -16, -16};
            }
            case 404: 
            case 1002: 
            case 1004: 
            case 1005: 
            case 1501: 
            case 1502: 
            case 1603: 
            case 1903: {
                return new byte[]{-47, -42, -62, -55, -16, -13, -16, -16};
            }
            case 102: 
            case 104: 
            case 201: 
            case 302: 
            case 303: 
            case 306: 
            case 311: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 408: 
            case 410: 
            case 412: 
            case 413: 
            case 418: 
            case 701: 
            case 901: 
            case 1001: 
            case 1003: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1018: 
            case 1201: 
            case 1203: 
            case 1301: 
            case 1601: 
            case 1602: 
            case 1803: 
            case 1901: 
            case 1902: 
            case 1904: 
            case 1911: 
            case 1920: 
            case 1921: 
            case 1982: 
            case 2001: 
            case 2101: 
            case 10005: 
            case 10006: 
            case 21011: 
            case 21012: 
            case 21013: 
            case 21014: {
                return new byte[]{-47, -42, -62, -55, -16, -12, -16, -16};
            }
            case 501: 
            case 1202: 
            case 1204: 
            case 1205: {
                return new byte[]{-47, -42, -62, -55, -16, -11, -16, -16};
            }
            case 305: 
            case 318: 
            case 407: 
            case 502: 
            case 1012: 
            case 1013: 
            case 1605: 
            case 1606: 
            case 1906: 
            case 1908: 
            case 2102: {
                return new byte[]{-47, -42, -62, -55, -16, -10, -16, -16};
            }
            case 10000: 
            case 10001: 
            case 10002: 
            case 10003: 
            case 10004: {
                return new byte[]{-47, -42, -62, -55, -16, -9, -16, -16};
            }
            case -1: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 414: 
            case 416: 
            case 417: 
            case 904: 
            case 905: 
            case 1609: 
            case 10007: 
            case 10008: {
                return new byte[]{-47, -42, -62, -55, -15, -16, -16, -16};
            }
        }
        return null;
    }

    private void parseData(byte[] byArray, byte[] byArray2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        this.name_ = converter.byteArrayToString(byArray2, 8, 10).trim();
        this.user_ = converter.byteArrayToString(byArray2, 18, 10).trim();
        this.number_ = converter.byteArrayToString(byArray2, 28, 6);
        this.realInternalJobID_ = new byte[16];
        System.arraycopy(byArray2, 34, this.realInternalJobID_, 0, 16);
        char[] cArray = new char[16];
        for (int i = 0; i < 16; ++i) {
            cArray[i] = (char)(this.realInternalJobID_[i] & 0xFF);
        }
        this.internalJobID_ = new String(cArray);
        this.status_ = converter.byteArrayToString(byArray2, 50, 10).trim();
        this.type_ = converter.byteArrayToString(byArray2, 60, 1);
        this.subtype_ = converter.byteArrayToString(byArray2, 61, 1);
        this.setValueInternal(11001, this.name_);
        this.setValueInternal(11006, this.user_);
        this.setValueInternal(11002, this.number_);
        this.setValueInternal(11000, this.internalJobID_);
        this.setValueInternal(11007, this.realInternalJobID_);
        this.setValueInternal(11003, this.status_);
        this.setValueInternal(11005, this.type_);
        this.setValueInternal(11004, this.subtype_);
        byte[] byArray3 = new byte[8];
        switch (byArray[5] & 0xF) {
            case 1: {
                this.setAsInt(1802, BinaryConverter.byteArrayToInt(byArray2, 64));
                this.setAsInt(2002, BinaryConverter.byteArrayToInt(byArray2, 68));
                this.setAsInt(409, BinaryConverter.byteArrayToInt(byArray2, 72));
                this.setValueInternal(1604, converter.byteArrayToString(byArray2, 76, 10));
                this.setValueInternal(2003, converter.byteArrayToString(byArray2, 86, 10));
                this.setAsInt(304, BinaryConverter.byteArrayToInt(byArray2, 96));
                this.setAsInt(1907, BinaryConverter.byteArrayToInt(byArray2, 100));
                this.setAsInt(1302, BinaryConverter.byteArrayToInt(byArray2, 104));
                this.setAsInt(2004, BinaryConverter.byteArrayToInt(byArray2, 108));
                this.setAsInt(1303, BinaryConverter.byteArrayToInt(byArray2, 112));
                this.setAsInt(2008, BinaryConverter.byteArrayToInt(byArray2, 116));
                this.setAsInt(1304, BinaryConverter.byteArrayToInt(byArray2, 120));
                this.setAsLong(2009, BinaryConverter.byteArrayToUnsignedInt(byArray2, 124));
                this.setAsLong(1305, BinaryConverter.byteArrayToUnsignedInt(byArray2, 128));
                this.setAsLong(312, BinaryConverter.byteArrayToLong(byArray2, 136));
                break;
            }
            case 2: {
                this.setAsInt(1802, BinaryConverter.byteArrayToInt(byArray2, 72));
                this.setAsInt(1907, BinaryConverter.byteArrayToInt(byArray2, 76));
                this.setAsInt(304, BinaryConverter.byteArrayToInt(byArray2, 80));
                this.setAsInt(1401, BinaryConverter.byteArrayToInt(byArray2, 84));
                this.setAsInt(1402, BinaryConverter.byteArrayToInt(byArray2, 88));
                this.setAsInt(1801, BinaryConverter.byteArrayToInt(byArray2, 92));
                this.setValueInternal(602, converter.byteArrayToString(byArray2, 96, 1));
                this.setValueInternal(601, converter.byteArrayToString(byArray2, 97, 10));
                this.setValueInternal(101, converter.byteArrayToString(byArray2, 107, 4));
                this.setAsInt(307, BinaryConverter.byteArrayToInt(byArray2, 136));
                this.setAsInt(2008, BinaryConverter.byteArrayToInt(byArray2, 140));
                this.setAsLong(1406, BinaryConverter.byteArrayToLong(byArray2, 152));
                this.setAsLong(313, BinaryConverter.byteArrayToLong(byArray2, 160));
                this.setValueInternal(103, converter.byteArrayToString(byArray2, 176, 4));
                this.setValueInternal(1306, converter.byteArrayToString(byArray2, 180, 10));
                this.setValueInternal(1307, converter.byteArrayToString(byArray2, 190, 1));
                break;
            }
            case 3: {
                this.setValueInternal(1004, converter.byteArrayToString(byArray2, 62, 20));
                this.setValueInternal(1005, converter.byteArrayToString(byArray2, 82, 2));
                this.setValueInternal(1501, converter.byteArrayToString(byArray2, 84, 20));
                this.setValueInternal(1502, converter.byteArrayToString(byArray2, 104, 2));
                this.setValueInternal(1603, converter.byteArrayToString(byArray2, 106, 10));
                this.setValueInternal(1904, converter.byteArrayToString(byArray2, 116, 10));
                this.setValueInternal(10006, converter.byteArrayToString(byArray2, 126, 10));
                this.setValueInternal(10005, converter.byteArrayToString(byArray2, 136, 6));
                this.setValueInternal(1903, converter.byteArrayToString(byArray2, 162, 10));
                System.arraycopy(byArray2, 172, byArray3, 0, 8);
                this.setValueInternal(404, byArray3);
                this.setValueInternal(1002, converter.byteArrayToString(byArray2, 180, 7));
                break;
            }
            case 4: {
                this.setValueInternal(402, converter.byteArrayToString(byArray2, 62, 13));
                this.setValueInternal(401, converter.byteArrayToString(byArray2, 75, 13));
                this.setValueInternal(1001, converter.byteArrayToString(byArray2, 88, 15));
                this.setValueInternal(1003, converter.byteArrayToString(byArray2, 103, 20));
                this.setValueInternal(2101, converter.byteArrayToString(byArray2, 123, 24));
                this.setValueInternal(21012, converter.byteArrayToString(byArray2, 123, 8));
                this.setValueInternal(21013, converter.byteArrayToString(byArray2, 131, 8));
                this.setValueInternal(21011, converter.byteArrayToString(byArray2, 139, 6));
                this.setValueInternal(21014, converter.byteArrayToString(byArray2, 145, 2));
                this.setValueInternal(1301, converter.byteArrayToString(byArray2, 147, 8));
                this.setValueInternal(901, converter.byteArrayToString(byArray2, 155, 10));
                this.setValueInternal(1203, converter.byteArrayToString(byArray2, 165, 10));
                this.setValueInternal(201, converter.byteArrayToString(byArray2, 175, 10));
                this.setValueInternal(1902, converter.byteArrayToString(byArray2, 185, 10));
                this.setValueInternal(410, converter.byteArrayToString(byArray2, 195, 13));
                this.setValueInternal(408, converter.byteArrayToString(byArray2, 208, 10));
                this.setValueInternal(406, converter.byteArrayToString(byArray2, 218, 1));
                this.setValueInternal(405, converter.byteArrayToString(byArray2, 219, 4));
                this.setValueInternal(1602, converter.byteArrayToString(byArray2, 223, 30));
                this.setValueInternal(1904, converter.byteArrayToString(byArray2, 253, 10));
                this.setValueInternal(10006, converter.byteArrayToString(byArray2, 263, 10));
                this.setValueInternal(10005, converter.byteArrayToString(byArray2, 273, 6));
                this.setValueInternal(2001, converter.byteArrayToString(byArray2, 299, 1));
                this.setAsInt(302, BinaryConverter.byteArrayToInt(byArray2, 300));
                System.arraycopy(byArray2, 304, byArray3, 0, 8);
                this.setValueInternal(403, byArray3);
                this.setValueInternal(1601, converter.byteArrayToString(byArray2, 312, 10));
                this.setValueInternal(1901, converter.byteArrayToString(byArray2, 322, 20));
                this.setValueInternal(1201, converter.byteArrayToString(byArray2, 342, 3));
                this.setValueInternal(303, converter.byteArrayToString(byArray2, 345, 2));
                this.setValueInternal(306, converter.byteArrayToString(byArray2, 347, 1));
                this.setValueInternal(701, converter.byteArrayToString(byArray2, 348, 1));
                this.setValueInternal(1006, converter.byteArrayToString(byArray2, 349, 8));
                this.setValueInternal(1007, converter.byteArrayToString(byArray2, 357, 10));
                this.setAsInt(1008, BinaryConverter.byteArrayToInt(byArray2, 368));
                this.setAsInt(412, BinaryConverter.byteArrayToInt(byArray2, 372));
                this.setValueInternal(1803, converter.byteArrayToString(byArray2, 376, 80));
                this.setValueInternal(413, converter.byteArrayToString(byArray2, 456, 1));
                this.setValueInternal(311, converter.byteArrayToString(byArray2, 457, 10));
                this.setValueInternal(1911, converter.byteArrayToString(byArray2, 467, 30));
                this.setValueInternal(102, converter.byteArrayToString(byArray2, 497, 1));
                this.setValueInternal(1015, converter.byteArrayToString(byArray2, 498, 1));
                this.setAsInt(1014, BinaryConverter.byteArrayToInt(byArray2, 500));
                this.setAsInt(1016, BinaryConverter.byteArrayToInt(byArray2, 504));
                this.setValueInternal(418, converter.byteArrayToString(byArray2, 508, 13));
                this.setValueInternal(1982, converter.byteArrayToString(byArray2, 522, 10));
                int n = BinaryConverter.byteArrayToInt(byArray2, 532);
                if (n > 0) {
                    this.setValueInternal(104, converter.byteArrayToString(byArray2, n, 10));
                } else {
                    this.setValueInternal(104, "");
                }
                this.setValueInternal(1018, converter.byteArrayToString(byArray2, 554, 10));
                break;
            }
            case 5: {
                this.setAsInt(501, BinaryConverter.byteArrayToInt(byArray2, 64));
                this.setAsInt(1204, BinaryConverter.byteArrayToInt(byArray2, 68));
                this.setValueInternal(1202, converter.byteArrayToString(byArray2, 72, 1));
                this.setValueInternal(1205, converter.byteArrayToString(byArray2, 73, 10));
                break;
            }
            case 6: {
                this.setValueInternal(1006, converter.byteArrayToString(byArray2, 62, 8));
                this.setValueInternal(502, converter.byteArrayToString(byArray2, 70, 1));
                this.setValueInternal(1906, converter.byteArrayToString(byArray2, 71, 20));
                this.setValueInternal(305, converter.byteArrayToString(byArray2, 91, 10));
                this.setValueInternal(407, converter.byteArrayToString(byArray2, 101, 1));
                this.setAsInt(1605, BinaryConverter.byteArrayToInt(byArray2, 104));
                this.setAsInt(2102, BinaryConverter.byteArrayToInt(byArray2, 108));
                this.setAsInt(1606, BinaryConverter.byteArrayToInt(byArray2, 112));
                this.setValueInternal(1908, converter.byteArrayToString(byArray2, 116, 10));
                this.setValueInternal(1012, converter.byteArrayToString(byArray2, 296, 10));
                this.setValueInternal(1013, converter.byteArrayToString(byArray2, 306, 1));
                this.setValueInternal(318, converter.byteArrayToString(byArray2, 307, 15));
                break;
            }
            case 7: {
                int n = BinaryConverter.byteArrayToInt(byArray2, 72);
                this.setAsInt(10001, n);
                int n2 = BinaryConverter.byteArrayToInt(byArray2, 64);
                this.setValueInternal(10003, converter.byteArrayToString(byArray2, 80, 11 * n2));
                int n3 = 80 + 11 * n2;
                int n4 = BinaryConverter.byteArrayToInt(byArray2, 68);
                this.setValueInternal(10002, converter.byteArrayToString(byArray2, n3, 11 * n4));
                n3 += 11 * n4;
                if (n == 1) {
                    this.setValueInternal(10000, converter.byteArrayToString(byArray2, n3, 11));
                    n3 += 11;
                } else {
                    this.setValueInternal(10000, "");
                }
                int n5 = BinaryConverter.byteArrayToInt(byArray2, 76);
                this.setValueInternal(10004, converter.byteArrayToString(byArray2, n3, 11 * n5));
                break;
            }
            case 0: {
                this.setAsLong(10007, BinaryConverter.byteArrayToLong(byArray2, 64));
                this.setAsLong(414, BinaryConverter.byteArrayToLong(byArray2, 72));
                this.setAsLong(416, BinaryConverter.byteArrayToLong(byArray2, 80));
                this.setAsLong(417, BinaryConverter.byteArrayToLong(byArray2, 88));
                this.setAsInt(904, BinaryConverter.byteArrayToInt(byArray2, 96));
                this.setAsInt(905, BinaryConverter.byteArrayToInt(byArray2, 100));
                this.setAsInt(314, BinaryConverter.byteArrayToInt(byArray2, 104));
                this.setAsInt(316, BinaryConverter.byteArrayToInt(byArray2, 108));
                this.setAsLong(315, BinaryConverter.byteArrayToLong(byArray2, 112));
                this.setAsLong(317, BinaryConverter.byteArrayToLong(byArray2, 120));
                this.setAsLong(10008, BinaryConverter.byteArrayToLong(byArray2, 128));
                this.setAsLong(1609, BinaryConverter.byteArrayToLong(byArray2, 136));
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "De-serializing Job object.");
        }
        objectInputStream.defaultReadObject();
        this.remoteCommandLock_ = new Object();
    }

    public void release() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("QSYS/RLSJOB JOB(");
        stringBuffer.append(this.number_);
        stringBuffer.append('/');
        stringBuffer.append(this.user_);
        stringBuffer.append('/');
        stringBuffer.append(this.name_);
        stringBuffer.append(") DUPJOBOPT(*MSG)");
        String string = stringBuffer.toString();
        CommandCall commandCall = this.getCommandCall(string);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void resetStatistics() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(-1);
    }

    private void retrieve(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.connect();
        byte[] byArray = Job.lookupFormatName(n);
        if (Trace.traceOn_) {
            Trace.log(1, "QUSRJOBI format:", byArray);
        }
        int n2 = Job.lookupFormatLength(byArray);
        ProgramParameter[] programParameterArray = n == -1 ? new ProgramParameter[7] : new ProgramParameter[5];
        programParameterArray[0] = new ProgramParameter(n2);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        programParameterArray[2] = new ProgramParameter(byArray);
        programParameterArray[3] = new ProgramParameter(this.createQualifiedJobName());
        programParameterArray[4] = new ProgramParameter(this.realInternalJobID_ == null ? BLANKS16_ : this.realInternalJobID_);
        if (n == -1) {
            programParameterArray[5] = new ProgramParameter(new byte[8]);
            programParameterArray[6] = new ProgramParameter(new byte[]{-15});
        }
        ProgramCall programCall = this.getProgramCall("/QSYS.LIB/QUSRJOBI.PGM", programParameterArray);
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job information for job: " + this.toString());
        }
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        this.parseData(byArray, programParameterArray[0].getOutputData());
    }

    private void setAsDate(int n, Date date) {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        switch (setterKeys_.get(n)) {
            case 7: {
                int n2 = calendar.get(1) - 1900;
                if (n2 >= 100) {
                    stringBuffer.append('1');
                    n2 -= 100;
                } else {
                    stringBuffer.append('0');
                }
                if (n2 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n2);
                int n3 = calendar.get(2) + 1;
                if (n3 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n3);
                int n4 = calendar.get(5);
                if (n4 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n4);
                break;
            }
            case 6: {
                int n5 = calendar.get(11);
                if (n5 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n5);
                int n6 = calendar.get(12);
                if (n6 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n6);
                int n7 = calendar.get(13);
                if (n7 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n7);
            }
        }
        this.setValueInternal(n, stringBuffer.toString());
    }

    private void setAsDateToChange(int n, Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsDate(n, date);
        if (this.cachedChanges_ == null) {
            this.cachedChanges_ = new JobHashtable();
        }
        this.cachedChanges_.put(n, this.getValue(n));
        if (!this.cacheChanges_) {
            this.commitChanges();
        }
    }

    final void setAsInt(int n, int n2) {
        this.setValueInternal(n, new Integer(n2));
    }

    private void setAsIntToChange(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsInt(n, n2);
        if (this.cachedChanges_ == null) {
            this.cachedChanges_ = new JobHashtable();
        }
        this.cachedChanges_.put(n, this.getValue(n));
        if (!this.cacheChanges_) {
            this.commitChanges();
        }
    }

    final void setAsLong(int n, long l) {
        this.setValueInternal(n, new Long(l));
    }

    public void setBreakMessageHandling(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'breakMessageHandling' is null.");
            throw new NullPointerException("breakMessageHandling");
        }
        if (!(string.equals("*NORMAL") || string.equals(BREAK_MESSAGE_HANDLING_HOLD) || string.equals(BREAK_MESSAGE_HANDLING_NOTIFY))) {
            Trace.log(2, "Value of parameter 'breakMessageHandling' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("breakMessageHandling (" + string + ")", 2);
        }
        this.setValue(201, string);
    }

    public void setCacheChanges(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting cache changes:", bl);
        }
        if (!bl) {
            this.cachedChanges_ = null;
        }
        this.cacheChanges_ = bl;
    }

    public void setCodedCharacterSetID(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(302, n);
    }

    public void setCountryID(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'countryID' is null.");
            throw new NullPointerException("countryID");
        }
        this.setValue(303, string);
    }

    public void setDateFormat(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'dateFormat' is null.");
            throw new NullPointerException("dateFormat");
        }
        if (!(string.equals(DATE_FORMAT_SYSTEM_VALUE) || string.equals(DATE_FORMAT_YMD) || string.equals(DATE_FORMAT_MDY) || string.equals(DATE_FORMAT_DMY) || string.equals(DATE_FORMAT_JULIAN))) {
            Trace.log(2, "Value of parameter 'dateFormat' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("dateFormat (" + string + ")", 2);
        }
        this.setValue(405, string);
    }

    public void setDateSeparator(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'dateSeparator' is null.");
            throw new NullPointerException("dateSeparator");
        }
        int n = setterKeys_.get(406);
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        this.setValue(406, string);
    }

    public void setDDMConversationHandling(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'ddmConversationHandling' is null.");
            throw new NullPointerException("ddmConversationHandling");
        }
        if (!string.equals("*KEEP") && !string.equals(KEEP_DDM_CONNECTIONS_ACTIVE_DROP)) {
            Trace.log(2, "Value of parameter 'ddmConversationHandling' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("ddmConversationHandling (" + string + ")", 2);
        }
        this.setValue(408, string);
    }

    public void setDecimalFormat(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'decimalFormat' is null.");
            throw new NullPointerException("decimalFormat");
        }
        if (!(string.equals("") || string.equals("I") || string.equals("J") || string.equals("*SYSVAL"))) {
            Trace.log(2, "Value of parameter 'decimalFormat' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("decimalFormat (" + string + ")", 2);
        }
        this.setValue(413, string);
    }

    public void setDefaultWait(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(409, n);
    }

    public void setDeviceRecoveryAction(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'deviceRecoveryAction' is null.");
            throw new NullPointerException("deviceRecoveryAction");
        }
        if (!(string.equals("*MSG") || string.equals(DEVICE_RECOVERY_ACTION_DISCONNECT_MESSAGE) || string.equals(DEVICE_RECOVERY_ACTION_DISCONNECT_END_REQUEST) || string.equals(DEVICE_RECOVERY_ACTION_END_JOB) || string.equals(DEVICE_RECOVERY_ACTION_END_JOB_NO_LIST) || string.equals("*SYSVAL"))) {
            Trace.log(2, "Value of parameter 'deviceRecoveryAction' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("deviceRecoveryAction (" + string + ")", 2);
        }
        this.setValue(410, string);
    }

    public void setInquiryMessageReply(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'inquiryMessageReply' is null.");
            throw new NullPointerException("inquiryMessageReply");
        }
        if (!(string.equals(INQUIRY_MESSAGE_REPLY_REQUIRED) || string.equals(INQUIRY_MESSAGE_REPLY_DEFAULT) || string.equals(INQUIRY_MESSAGE_REPLY_SYSTEM_REPLY_LIST))) {
            Trace.log(2, "Value of parameter 'inquiryMessageReply' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("inquiryMessageReply (" + string + ")", 2);
        }
        this.setValue(901, string);
    }

    public void setInternalJobID(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting internal job ID: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'internalJobID' is null.");
            throw new NullPointerException("internalJobID");
        }
        if (string.length() != 16) {
            Trace.log(2, "Length of parameter 'internalJobID' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("internalJobID (" + string + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'internalJobID' after connect.");
            throw new ExtendedIllegalStateException("internalJobID", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.internalJobID_ = string;
            this.realInternalJobID_ = new byte[16];
            for (int i = 0; i < 16; ++i) {
                this.realInternalJobID_[i] = (byte)string.charAt(i);
            }
        } else {
            String string2 = this.internalJobID_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("internalJobID", string2, string3);
            }
            this.internalJobID_ = string;
            this.realInternalJobID_ = new byte[16];
            for (int i = 0; i < 16; ++i) {
                this.realInternalJobID_[i] = (byte)string.charAt(i);
            }
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("internalJobID", string2, string3);
            }
        }
    }

    public void setInternalJobIdentifier(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting internal job identifier:", byArray);
        }
        if (byArray == null) {
            Trace.log(2, "Parameter 'internalJobID' is null.");
            throw new NullPointerException("internalJobID");
        }
        if (byArray.length != 16) {
            Trace.log(2, "Length of parameter 'internalJobID' is not valid: " + byArray.length);
            throw new ExtendedIllegalArgumentException("internalJobID.length {" + byArray.length + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'internalJobID' after connect.");
            throw new ExtendedIllegalStateException("internalJobID", 5);
        }
        this.realInternalJobID_ = byArray;
        char[] cArray = new char[16];
        for (int i = 0; i < 16; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.internalJobID_ = new String(cArray);
    }

    public void setJobAccountingCode(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'jobAccountingCode' is null.");
            throw new NullPointerException("jobAccountingCode");
        }
        this.setValue(1001, string);
    }

    public void setJobDate(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            Trace.log(2, "Parameter 'jobAccountingCode' is null.");
            throw new NullPointerException("jobDate");
        }
        this.setAsDateToChange(1002, date);
    }

    public void setJobMessageQueueFullAction(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'jobMessageQueueFullAction' is null.");
            throw new NullPointerException("jobMessageQueueFullAction");
        }
        if (!(string.equals(MESSAGE_QUEUE_ACTION_NO_WRAP) || string.equals(MESSAGE_QUEUE_ACTION_WRAP) || string.equals(MESSAGE_QUEUE_ACTION_PRINT_WRAP) || string.equals("*SYSVAL"))) {
            Trace.log(2, "Value of parameter 'jobMessageQueueFullAction' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("jobMessageQueueFullAction (" + string + ")", 2);
        }
        this.setValue(1007, string);
    }

    public void setJobSwitches(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'jobSwitches' is null.");
            throw new NullPointerException("jobSwitches");
        }
        int n = setterKeys_.get(1006);
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        this.setValue(1006, string);
    }

    public void setLanguageID(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'languageID' is null.");
            throw new NullPointerException("languageID");
        }
        this.setValue(1201, string);
    }

    public void setLoggingCLPrograms(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'loggingCLPrograms' is null.");
            throw new NullPointerException("loggingCLPrograms");
        }
        if (!string.equals("*YES") && !string.equals("*NO")) {
            Trace.log(2, "Value of parameter 'loggingCLPrograms' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("loggingCLPrograms (" + string + ")", 2);
        }
        this.setValue(1203, string);
    }

    public void setLoggingLevel(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n < 0 || n > 4) {
            Trace.log(2, "Value of parameter 'loggingLevel' is not valid:", n);
            throw new ExtendedIllegalArgumentException("loggingLevel " + n + ")", 4);
        }
        this.setValue(1202, Integer.toString(n));
    }

    public void setLoggingSeverity(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(1204, n);
    }

    public void setLoggingText(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'loggingText' is null.");
            throw new NullPointerException("loggingText");
        }
        if (!(string.equals("*MSG") || string.equals(LOGGING_TEXT_SECLVL) || string.equals(LOGGING_TEXT_NO_LIST))) {
            Trace.log(2, "Value of parameter 'loggingText' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("loggingText (" + string + ")", 2);
        }
        this.setValue(1205, string);
    }

    public void setName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'name' after connect.");
            throw new ExtendedIllegalStateException("name", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.name_ = string;
            this.setValueInternal(11001, string);
        } else {
            String string2 = this.name_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("name", string2, string3);
            }
            this.name_ = string3;
            this.setValueInternal(11001, string);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("name", string2, string3);
            }
        }
    }

    public void setNumber(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting number: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'number' is null.");
            throw new NullPointerException("number");
        }
        if (string.length() > 6) {
            Trace.log(2, "Length of parameter 'number' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("number (" + string + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'number' after connect.");
            throw new ExtendedIllegalStateException("number", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.number_ = string;
            this.setValueInternal(11002, string);
        } else {
            String string2 = this.number_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("number", string2, string3);
            }
            this.number_ = string;
            this.setValueInternal(11002, string);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("number", string2, string3);
            }
        }
    }

    public void setOutputQueue(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'outputQueue' is null.");
            throw new NullPointerException("outputQueue");
        }
        if (!string.startsWith("*")) {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "OUTQ");
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = qSYSObjectPathName.getObjectName();
            stringBuffer.append(string2);
            for (int i = string2.length(); i < 10; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(qSYSObjectPathName.getLibraryName());
            this.setValue(1501, stringBuffer.toString());
        } else {
            this.setValue(1501, string);
        }
    }

    public void setOutputQueuePriority(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(1502, Integer.toString(n));
    }

    public void setPrinterDeviceName(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'printerDeviceName' is null.");
            throw new NullPointerException("printerDeviceName");
        }
        int n = setterKeys_.get(1603);
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        this.setValue(1603, string);
    }

    public void setPrintKeyFormat(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'printKeyFormat' is null.");
            throw new NullPointerException("printKeyFormat");
        }
        if (!(string.equals("*NONE") || string.equals(PRINT_KEY_FORMAT_BORDER) || string.equals(PRINT_KEY_FORMAT_HEADER) || string.equals(PRINT_KEY_FORMAT_ALL) || string.equals("*SYSVAL"))) {
            Trace.log(2, "Value of parameter 'printKeyFormat' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("printKeyFormat (" + string + ")", 2);
        }
        this.setValue(1601, string);
    }

    public void setPrintText(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'printText' is null.");
            throw new NullPointerException("printText");
        }
        this.setValue(1602, string);
    }

    public void setPurge(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValueInternal(1604, bl ? "*YES" : "*NO");
    }

    public void setQueue(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'jobQueue' is null.");
            throw new NullPointerException("jobQueue");
        }
        if (!string.startsWith("*")) {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "JOBQ");
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = qSYSObjectPathName.getObjectName();
            stringBuffer.append(string2);
            for (int i = string2.length(); i < 10; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(qSYSObjectPathName.getLibraryName());
            this.setValue(1004, stringBuffer.toString());
        } else {
            this.setValue(1004, string);
        }
    }

    public void setQueuePriority(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(1005, Integer.toString(n));
    }

    public void setRunPriority(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(1802, n);
    }

    public void setScheduleDate(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            Trace.log(2, "Parameter 'scheduleDate' is null.");
            throw new NullPointerException("scheduleDate");
        }
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.clear();
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        int n = calendar.get(1) - 1900;
        if (n >= 100) {
            stringBuffer.append('1');
            n -= 100;
        } else {
            stringBuffer.append('0');
        }
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        int n2 = calendar.get(2) + 1;
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        int n3 = calendar.get(5);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        String string = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        int n4 = calendar.get(11);
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
        int n5 = calendar.get(12);
        if (n5 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n5);
        int n6 = calendar.get(13);
        if (n6 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n6);
        String string2 = stringBuffer.toString();
        this.setValue(1920, string);
        this.setValue(1921, string2);
        this.setValueInternal(403, null);
    }

    public void setScheduleDate(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'scheduleDate' is null.");
            throw new NullPointerException("scheduleDate");
        }
        if (string.length() != 7) {
            Trace.log(2, "Value of parameter 'scheduleDate' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("scheduleDate (" + string + ")", 2);
        }
        this.setValue(1920, string);
        this.setValueInternal(403, null);
    }

    public void setScheduleTime(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            Trace.log(2, "Parameter 'scheduleTime' is null.");
            throw new NullPointerException("scheduleTime");
        }
        this.setScheduleDate(date);
    }

    public void setScheduleTime(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'scheduleTime' is null.");
            throw new NullPointerException("scheduleTime");
        }
        if (string.length() != 6) {
            Trace.log(2, "Value of parameter 'scheduleTime' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("scheduleTime (" + string + ")", 2);
        }
        this.setValue(1921, string);
        this.setValueInternal(403, null);
    }

    public void setSortSequenceTable(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'scheduleTime' is null.");
            throw new NullPointerException("sortSequenceTable");
        }
        if (!string.startsWith("*")) {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "FILE");
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = qSYSObjectPathName.getObjectName();
            stringBuffer.append(string2);
            for (int i = string2.length(); i < 10; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(qSYSObjectPathName.getLibraryName());
            this.setValue(1901, stringBuffer.toString());
        } else {
            this.setValue(1901, string);
        }
    }

    public void setStatusMessageHandling(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'statusMessageHandling' is null.");
            throw new NullPointerException("statusMessageHandling");
        }
        this.setValue(1902, string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    public void setTimeSeparator(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'timeSeparator' is null.");
            throw new NullPointerException("timeSeparator");
        }
        int n = setterKeys_.get(2001);
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        this.setValue(2001, string);
    }

    public void setTimeSlice(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setAsIntToChange(2002, n);
    }

    public void setTimeSliceEndPool(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'timeSliceEndPool' is null.");
            throw new NullPointerException("timeSliceEndPool");
        }
        this.setValue(2003, string);
    }

    public void setUser(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'user' is null.");
            throw new NullPointerException("user");
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of parameter 'user' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("user (" + string + ")", 1);
        }
        if (this.isConnected_) {
            Trace.log(2, "Cannot set property 'user' after connect.");
            throw new ExtendedIllegalStateException("user", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.user_ = string;
            this.setValueInternal(11006, string);
        } else {
            String string2 = this.user_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("user", string2, string3);
            }
            this.user_ = string;
            this.setValueInternal(11006, string);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("user", string2, string3);
            }
        }
    }

    public void setValue(int n, Object object) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting value, attribute: " + n + ", value: " + object);
        }
        if (n < 0 || Job.isReadOnly(n)) {
            Trace.log(2, "Value of parameter 'attribute' is not valid:", n);
            throw new ExtendedIllegalArgumentException("attribute (" + n + ")", 2);
        }
        if (n == 1920 || n == 1921) {
            this.setValueInternal(403, null);
        }
        if (this.cachedChanges_ == null) {
            this.cachedChanges_ = new JobHashtable();
        }
        this.cachedChanges_.put(n, object);
        if (!this.cacheChanges_) {
            this.commitChanges();
        }
        this.values_.put(n, object);
    }

    final void setValueInternal(int n, Object object) {
        this.values_.put(n, object);
    }

    public String toString() {
        if (this.number_ == null || this.user_ == null || this.name_ == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.number_);
        stringBuffer.append('/');
        stringBuffer.append(this.user_);
        stringBuffer.append('/');
        stringBuffer.append(this.name_);
        return stringBuffer.toString();
    }

    public String getJobAsp() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.retrieve(104);
        return ((String)this.values_.get(104)).trim();
    }

    static {
        setterKeys_.put(201, 10);
        setterKeys_.put(302, 4);
        setterKeys_.put(303, 8);
        setterKeys_.put(311, 10);
        setterKeys_.put(405, 4);
        setterKeys_.put(406, 1);
        setterKeys_.put(408, 5);
        setterKeys_.put(409, 4);
        setterKeys_.put(410, 13);
        setterKeys_.put(413, 8);
        setterKeys_.put(901, 10);
        setterKeys_.put(1001, 15);
        setterKeys_.put(1002, 7);
        setterKeys_.put(1018, 10);
        setterKeys_.put(1004, 20);
        setterKeys_.put(1005, 2);
        setterKeys_.put(1006, 8);
        setterKeys_.put(1007, 10);
        setterKeys_.put(1201, 8);
        setterKeys_.put(1202, 1);
        setterKeys_.put(1203, 10);
        setterKeys_.put(1204, 4);
        setterKeys_.put(1205, 7);
        setterKeys_.put(1501, 20);
        setterKeys_.put(1502, 2);
        setterKeys_.put(1601, 10);
        setterKeys_.put(1602, 30);
        setterKeys_.put(1603, 10);
        setterKeys_.put(1604, 4);
        setterKeys_.put(1802, 4);
        setterKeys_.put(1901, 20);
        setterKeys_.put(1902, 10);
        setterKeys_.put(1920, 10);
        setterKeys_.put(1921, 8);
        setterKeys_.put(1982, 10);
        setterKeys_.put(2001, 1);
        setterKeys_.put(2002, 4);
        setterKeys_.put(2003, 10);
    }
}

