/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSChangeAttrsReq;
import com.ibm.as400.access.IFSCloseRep;
import com.ibm.as400.access.IFSCloseReq;
import com.ibm.as400.access.IFSCommitReq;
import com.ibm.as400.access.IFSCopyReq;
import com.ibm.as400.access.IFSCreateUserHandleRep;
import com.ibm.as400.access.IFSCreateUserHandlerReq;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSExchangeAttrRep;
import com.ibm.as400.access.IFSExchangeAttrReq;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileOutputStreamImplRemote;
import com.ibm.as400.access.IFSFreeHandleReq;
import com.ibm.as400.access.IFSFreeUserHandlerReq;
import com.ibm.as400.access.IFSGetFileSystemRep;
import com.ibm.as400.access.IFSGetFileSystemReq;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSLockBytesRep;
import com.ibm.as400.access.IFSLockBytesReq;
import com.ibm.as400.access.IFSLookupRep;
import com.ibm.as400.access.IFSLookupReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSRandomAccessFileImplRemote;
import com.ibm.as400.access.IFSReadRep;
import com.ibm.as400.access.IFSReadReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.IFSUnlockBytesReq;
import com.ibm.as400.access.IFSUserHandleSeedRep;
import com.ibm.as400.access.IFSUserHandleSeedReq;
import com.ibm.as400.access.IFSWriteRep;
import com.ibm.as400.access.IFSWriteReq;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.SignonConverter;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;

class IFSFileDescriptorImplRemote
implements IFSFileDescriptorImpl {
    private static final int UNINITIALIZED = -1;
    private static final int MAX_BYTES_PER_READ = 16000000;
    ConverterImplRemote converter_;
    private int fileHandle_ = -1;
    int preferredServerCCSID_;
    private int fileDataCCSID_ = -1;
    private int fileAsp_ = -1;
    private int fileSystemType_ = -1;
    int serverDatastreamLevel_;
    int requestedDatastreamLevel_;
    private long fileOffset_;
    boolean isOpen_;
    boolean isOpenAllowed_ = true;
    private Object parent_;
    String path_ = "";
    byte[] pathnameBytes_;
    transient Object serverLock_ = new Object();
    AS400Server server_;
    private int shareOption_;
    AS400ImplRemote system_;
    private Object fileOffsetLock_ = new Object();
    private int maxDataBlockSize_ = 1024;
    private boolean determinedSystemVRM_ = false;
    private int systemVRM_;
    transient int errorRC_;
    int patternMatching_ = 0;
    private static final boolean DEBUG = false;
    String fileOwnerName_ = null;
    boolean isDirectory_ = false;

    IFSFileDescriptorImplRemote() {
    }

    static IFSFileDescriptorImplRemote castImplToImplRemote(IFSFileDescriptorImpl iFSFileDescriptorImpl) {
        try {
            return (IFSFileDescriptorImplRemote)iFSFileDescriptorImpl;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "Argument is not an instance of IFSFileDescriptorImplRemote", (Throwable)classCastException);
            throw new InternalErrorException(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int checkAccess(int n, int n2) throws IOException, AS400SecurityException {
        int n3 = -1;
        try {
            n3 = this.createFileHandle(n, n2);
            Object var5_4 = null;
            if (n3 == -1) return this.errorRC_;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (n3 == -1) throw throwable;
            this.close(n3);
            throw throwable;
        }
        this.close(n3);
        return this.errorRC_;
    }

    public void close() {
        try {
            this.close0();
        }
        catch (IOException iOException) {
            Trace.log(2, "Error while closing file " + this.path_, (Throwable)iOException);
        }
    }

    public void close0() throws IOException {
        this.isOpen_ = false;
        this.close(this.fileHandle_);
        this.fileHandle_ = -1;
    }

    void close(int n) throws IOException {
        if (n == -1) {
            return;
        }
        ClientAccessDataStream clientAccessDataStream = null;
        IFSCloseReq iFSCloseReq = new IFSCloseReq(n);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCloseReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream connection lost during close", (Throwable)connectionDroppedException);
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        if (clientAccessDataStream instanceof IFSCloseRep) {
            int n2 = ((IFSCloseRep)clientAccessDataStream).getReturnCode();
            if (n2 != 0) {
                Trace.log(2, "IFSCloseRep return code", n2);
                throw new ExtendedIOException(this.path_, n2);
            }
        } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n3 != 0) {
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n3));
                throw new ExtendedIOException(this.path_, n3);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    void connect() throws IOException, AS400SecurityException {
        if (this.server_ == null) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            try {
                this.server_ = this.system_.getConnection(0, false, false);
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, "Access to byte stream server on '" + this.system_.getSystemName() + "' denied.", (Throwable)aS400SecurityException);
                throw aS400SecurityException;
            }
            this.exchangeServerAttributes();
        }
    }

    void connectionDropped(ConnectionDroppedException connectionDroppedException) throws ConnectionDroppedException {
        if (this.server_ != null) {
            this.system_.disconnectServer(this.server_);
            this.server_ = null;
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.log(2, "Byte stream connection lost.");
        throw connectionDroppedException;
    }

    boolean copyTo(String string, boolean bl) throws AS400SecurityException, IOException {
        ClientAccessDataStream clientAccessDataStream = null;
        IFSCopyReq iFSCopyReq = new IFSCopyReq(this.path_, string, bl);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCopyReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream connection lost during copy", (Throwable)connectionDroppedException);
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                String string2 = n == 4 ? string : this.path_;
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(string2, n);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n));
                throw new ExtendedIOException(string2, n);
            }
            return true;
        }
        Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
        throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
    }

    private final int createFileHandle() throws IOException, AS400SecurityException {
        return this.createFileHandle(1, 8);
    }

    int createFileHandle(int n, int n2) throws IOException, AS400SecurityException {
        int n3;
        int n4;
        block9: {
            n4 = 2;
            n3 = -1;
            this.errorRC_ = 0;
            try {
                IFSOpenReq iFSOpenReq = new IFSOpenReq(this.getPathnameAsBytes(), this.preferredServerCCSID_, 0, n, 0, 0, n2, this.serverDatastreamLevel_);
                ClientAccessDataStream clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSOpenReq);
                if (clientAccessDataStream instanceof IFSOpenRep) {
                    n4 = 0;
                    n3 = ((IFSOpenRep)clientAccessDataStream).getFileHandle();
                    break block9;
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n4 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n4);
                    break block9;
                }
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost", (Throwable)connectionDroppedException);
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
        }
        if (n4 != 0) {
            if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
                Trace.log(1, "Unable to open file " + this.path_ + ": " + "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n4));
            }
            this.errorRC_ = n4;
            return -1;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exchangeServerAttributes() throws IOException, AS400SecurityException {
        Object object = this.serverLock_;
        synchronized (object) {
            DataStream dataStream = this.server_.getExchangeAttrReply();
            IFSExchangeAttrRep iFSExchangeAttrRep = null;
            try {
                iFSExchangeAttrRep = (IFSExchangeAttrRep)dataStream;
            }
            catch (ClassCastException classCastException) {
                if (dataStream instanceof IFSReturnCodeRep) {
                    int n = ((IFSReturnCodeRep)dataStream).getReturnCode();
                    IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n);
                    Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n));
                    throw new ExtendedIOException(this.path_, n);
                }
                String string = dataStream == null ? "null" : dataStream.getClass().getName();
                Trace.log(2, "Unexpected reply from Exchange Server Attributes: " + string);
                throw new InternalErrorException(2);
            }
            this.requestedDatastreamLevel_ = this.getSystemVRM() >= 393472 ? 16 : (this.getSystemVRM() >= 328448 ? 8 : (this.getSystemVRM() >= 263424 ? 2 : 0));
            if (iFSExchangeAttrRep == null) {
                dataStream = null;
                try {
                    int[] nArray = this.getSystemVRM() >= 328448 ? new int[]{1200, 13488, 61952} : (this.getSystemVRM() >= 263424 ? new int[]{13488, 61952} : new int[]{61952});
                    dataStream = this.server_.sendExchangeAttrRequest(new IFSExchangeAttrReq(true, false, 2, -1, this.requestedDatastreamLevel_, nArray));
                    iFSExchangeAttrRep = (IFSExchangeAttrRep)dataStream;
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    this.system_.disconnectServer(this.server_);
                    this.server_ = null;
                    InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                    try {
                        interruptedIOException.initCause(interruptedException);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw interruptedIOException;
                }
                catch (IOException iOException) {
                    Trace.log(2, "I/O error during attribute exchange.");
                    this.system_.disconnectServer(this.server_);
                    this.server_ = null;
                    throw iOException;
                }
                catch (ClassCastException classCastException) {
                    if (dataStream instanceof IFSReturnCodeRep) {
                        int n = ((IFSReturnCodeRep)dataStream).getReturnCode();
                        IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n);
                        Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n));
                        throw new ExtendedIOException(this.path_, n);
                    }
                    String string = dataStream == null ? "null" : dataStream.getClass().getName();
                    Trace.log(2, "Unexpected reply from Exchange Server Attributes: " + string);
                    throw new InternalErrorException(2);
                }
            }
            if (iFSExchangeAttrRep == null) {
                Trace.log(2, "Null reply data stream");
                this.system_.disconnectServer(this.server_);
                this.server_ = null;
                throw new InternalErrorException(2);
            }
            this.maxDataBlockSize_ = iFSExchangeAttrRep.getMaxDataBlockSize();
            this.preferredServerCCSID_ = iFSExchangeAttrRep.getPreferredCCSID();
            this.serverDatastreamLevel_ = iFSExchangeAttrRep.getDataStreamLevel();
            this.setConverter(ConverterImplRemote.getConverter(this.preferredServerCCSID_, this.system_));
        }
    }

    private static String descriptionForReturnCode(int n) {
        switch (n) {
            case 4636: {
                return n + ": Not authorized to command. (Check for user exit program.)";
            }
            case 4692: {
                return n + ": Command check. (Check for user exit program.)";
            }
            case 4702: {
                return n + ": Closed with damage.";
            }
            case 3391: {
                return n + ": File is temporarily unavailable.";
            }
            case 3392: {
                return n + ": Directory is temporarily unavailable.";
            }
            case 3393: {
                return n + ": Working directory handle is not valid.";
            }
            case 3394: {
                return n + ": File handle is not valid.";
            }
            case 3395: {
                return n + ": User handle is not valid.";
            }
            case 3396: {
                return n + ": User is temporarily unavailable.";
            }
        }
        return Integer.toString(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void finalize0() throws Throwable {
        try {
            try {
                if (this.fileHandle_ != -1) {
                    IFSCloseReq iFSCloseReq = new IFSCloseReq(this.fileHandle_);
                    try {
                        this.server_.sendAndDiscardReply(iFSCloseReq);
                        Object var3_3 = null;
                        this.isOpen_ = false;
                        this.fileHandle_ = -1;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        this.isOpen_ = false;
                        this.fileHandle_ = -1;
                        throw throwable;
                    }
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error during finalization.", throwable);
                Object var5_7 = null;
                super.finalize();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    void flush() throws IOException, AS400SecurityException {
        IFSCommitReq iFSCommitReq = new IFSCommitReq(this.fileHandle_);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCommitReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n));
                throw new ExtendedIOException(this.path_, n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    ConverterImplRemote getConverter() {
        return this.converter_;
    }

    public String getOwnerName() throws IOException {
        if (this.fileOwnerName_ == null) {
            try {
                this.connect();
                IFSListAttrsRep iFSListAttrsRep = this.listObjAttrs12(2048, 0);
                if (iFSListAttrsRep != null) {
                    this.fileOwnerName_ = iFSListAttrsRep.getOwnerName(this.system_.getCcsid());
                    if (this.fileDataCCSID_ == -1) {
                        this.fileDataCCSID_ = iFSListAttrsRep.getCCSID(this.serverDatastreamLevel_);
                    }
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(4, "getOwnerName: IFSReturnCodeRep return code", this.errorRC_);
                    }
                    if (this.errorRC_ == 2 || this.errorRC_ == 3) {
                        throw new ExtendedIOException(this.path_, 3);
                    }
                }
            }
            catch (ExtendedIOException extendedIOException) {
                if (extendedIOException.getReturnCode() == 4) {
                    if (Trace.traceOn_) {
                        Trace.log(4, "Unable to determine owner of directory.", (Throwable)extendedIOException);
                    }
                }
                throw extendedIOException;
            }
            catch (AS400SecurityException aS400SecurityException) {
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        return this.fileOwnerName_ == null ? "" : this.fileOwnerName_;
    }

    public int getCCSID(boolean bl) throws IOException {
        if (this.fileDataCCSID_ == -1) {
            try {
                this.connect();
                IFSListAttrsRep iFSListAttrsRep = null;
                iFSListAttrsRep = bl ? this.listObjAttrs12(2048, 0) : this.listObjAttrs2();
                if (iFSListAttrsRep != null) {
                    this.fileDataCCSID_ = iFSListAttrsRep.getCCSID(this.serverDatastreamLevel_);
                    if (bl && this.fileOwnerName_ == null) {
                        this.fileOwnerName_ = iFSListAttrsRep.getOwnerName(this.system_.getCcsid());
                    }
                }
            }
            catch (AS400SecurityException aS400SecurityException) {
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        return this.fileDataCCSID_;
    }

    public int getCCSID() throws IOException {
        if (this.fileDataCCSID_ == -1) {
            try {
                this.connect();
                IFSListAttrsRep iFSListAttrsRep = this.listObjAttrs2();
                if (iFSListAttrsRep != null) {
                    this.fileDataCCSID_ = iFSListAttrsRep.getCCSID(this.serverDatastreamLevel_);
                }
            }
            catch (AS400SecurityException aS400SecurityException) {
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        return this.fileDataCCSID_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCCSIDByUserHandle() throws IOException, AS400SecurityException {
        this.isDirectory_ = true;
        if (this.fileDataCCSID_ != -1) return this.fileDataCCSID_;
        ClientAccessDataStream clientAccessDataStream = null;
        this.connect();
        int n = -1;
        int n2 = -1;
        try {
            n = this.system_.createUserHandle();
            try {
                byte[] byArray = this.getConverter().stringToByteArray(this.path_);
                IFSLookupReq iFSLookupReq = new IFSLookupReq(byArray, this.preferredServerCCSID_, n, 12, 0x100800, 0);
                clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSLookupReq);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                    throw interruptedIOException;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
            int n3 = 0;
            if (!(clientAccessDataStream instanceof IFSLookupRep)) {
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n3 == 0) throw new ExtendedIOException(this.path_, n3);
                    Trace.log(2, "IFSReturnCodeRep return code", n3);
                    throw new ExtendedIOException(this.path_, n3);
                }
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            n2 = ((IFSLookupRep)clientAccessDataStream).getHandle();
            this.retrieveAttributes(clientAccessDataStream, n2);
            Object var8_11 = null;
            if (n2 == -1) return this.fileDataCCSID_;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (n2 == -1) throw throwable;
            this.freeHandle(n2);
            throw throwable;
        }
        this.freeHandle(n2);
        return this.fileDataCCSID_;
    }

    int getFileHandle() {
        return this.fileHandle_;
    }

    public long getFileOffset() {
        return this.fileOffset_;
    }

    Object getParent() {
        return this.parent_;
    }

    String getPath() {
        return this.path_;
    }

    final byte[] getPathnameAsBytes() {
        if (this.pathnameBytes_ == null) {
            this.pathnameBytes_ = this.converter_.stringToByteArray(this.path_);
        }
        return this.pathnameBytes_;
    }

    int getPreferredCCSID() {
        return this.preferredServerCCSID_;
    }

    AS400Server getServer() {
        return this.server_;
    }

    int getShareOption() {
        return this.shareOption_;
    }

    AS400ImplRemote getSystem() {
        return this.system_;
    }

    int getSystemVRM() {
        if (!this.determinedSystemVRM_) {
            this.systemVRM_ = this.system_.getVRM();
            this.determinedSystemVRM_ = true;
        }
        return this.systemVRM_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementFileOffset(long l) {
        Object object = this.fileOffsetLock_;
        synchronized (object) {
            this.fileOffset_ += l;
        }
    }

    public void initialize(long l, Object object, String string, int n, AS400Impl aS400Impl) {
        this.fileOffset_ = l;
        this.parent_ = object;
        this.path_ = string;
        this.shareOption_ = n;
        this.system_ = (AS400ImplRemote)aS400Impl;
    }

    public boolean isOpen() {
        return this.isOpen_;
    }

    boolean isOpenAllowed() {
        return this.isOpenAllowed_;
    }

    Vector listAttributes(IFSListAttrsReq iFSListAttrsReq) throws IOException, AS400SecurityException {
        this.errorRC_ = 0;
        Vector<ClientAccessDataStream> vector = new Vector<ClientAccessDataStream>(256);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSListAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        int n = -1;
        boolean bl = false;
        do {
            if (clientAccessDataStream instanceof IFSListAttrsRep) {
                vector.addElement(clientAccessDataStream);
            } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0 && n != 18 && n != 2 && n != 3) {
                    IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n);
                    Trace.log(2, "Error getting file attributes for file " + this.path_ + ": " + "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n));
                    throw new ExtendedIOException(this.path_, n);
                }
            } else {
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            bl = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
            if (bl) continue;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.server_.receive(iFSListAttrsReq.getCorrelation());
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
        } while (!bl);
        if (n == 3) {
            this.errorRC_ = n;
            vector = null;
        } else {
            vector.trimToSize();
        }
        return vector;
    }

    IFSListAttrsRep listObjAttrs1(int n, int n2) throws IOException, AS400SecurityException {
        return this.listObjAttrs(1, n, n2);
    }

    IFSListAttrsRep listObjAttrs2() throws IOException, AS400SecurityException {
        return this.listObjAttrs(2, 0, 0);
    }

    IFSListAttrsRep listObjAttrs12(int n, int n2) throws IOException, AS400SecurityException {
        return this.listObjAttrs(12, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IFSListAttrsRep listObjAttrs(int n, int n2, int n3) throws IOException, AS400SecurityException {
        boolean bl;
        int n4;
        IFSListAttrsRep iFSListAttrsRep;
        block14: {
            IFSListAttrsRep iFSListAttrsRep2;
            iFSListAttrsRep = null;
            n4 = -1;
            bl = false;
            try {
                if (this.fileHandle_ != -1) {
                    n4 = this.fileHandle_;
                    bl = true;
                    break block14;
                }
                n4 = this.createFileHandle();
                if (n4 != -1) break block14;
                if (Trace.traceOn_) {
                    Trace.log(2, "Unable to create handle to file " + this.path_ + ". IFSReturnCodeRep return code", this.errorRC_);
                }
                iFSListAttrsRep2 = null;
                Object var10_9 = null;
                if (bl) return iFSListAttrsRep2;
                if (n4 == -1) return iFSListAttrsRep2;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (bl || n4 == -1) throw throwable;
                this.close(n4);
                throw throwable;
            }
            this.close(n4);
            return iFSListAttrsRep2;
        }
        IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(n4, n, n2, n3);
        iFSListAttrsReq.setPatternMatching(this.patternMatching_);
        Vector vector = this.listAttributes(iFSListAttrsReq);
        if (vector == null) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received null from listAttributes(fileHandle).");
            }
        } else if (vector.size() == 0) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received no replies from listAttributes(fileHandle).");
            }
        } else if (vector.size() > 1) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received multiple replies from listAttributes(fileHandle) (" + vector.size() + ")");
            }
        } else {
            iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
        }
        Object var10_10 = null;
        if (bl || n4 == -1) return iFSListAttrsRep;
        this.close(n4);
        return iFSListAttrsRep;
    }

    IFSKey lock(long l) throws IOException, AS400SecurityException {
        return this.lock(this.fileOffset_, l);
    }

    IFSKey lock(long l, long l2) throws IOException, AS400SecurityException {
        int n;
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            IFSLockBytesReq iFSLockBytesReq = new IFSLockBytesReq(this.fileHandle_, true, false, l, l2, this.serverDatastreamLevel_);
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSLockBytesReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        if (clientAccessDataStream instanceof IFSLockBytesRep) {
            n = ((IFSLockBytesRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                Trace.log(2, "IFSLockBytesRep return code", n);
                throw new ExtendedIOException(this.path_, n);
            }
        } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n));
                throw new ExtendedIOException(this.path_, n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        IFSKey iFSKey = new IFSKey(this.fileHandle_, l, l2, true);
        return iFSKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int read(byte[] byArray, int n, int n2) throws IOException, AS400SecurityException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = n2;
        boolean bl = false;
        while (true) {
            ClientAccessDataStream clientAccessDataStream;
            IFSReadReq iFSReadReq;
            if (n3 < n2 && !bl) {
                int n5 = Math.min(n4, 16000000);
                iFSReadReq = new IFSReadReq(this.fileHandle_, this.fileOffset_, n5, this.serverDatastreamLevel_);
                clientAccessDataStream = null;
                try {
                    clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSReadReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                    try {
                        interruptedIOException.initCause(interruptedException);
                        throw interruptedIOException;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw interruptedIOException;
                }
            } else {
                if (bl && n3 == 0) {
                    return -1;
                }
                int n6 = n3;
                return n6;
            }
            boolean bl2 = false;
            int n7 = 0;
            do {
                if (clientAccessDataStream instanceof IFSReadRep) {
                    byte[] byArray2 = ((IFSReadRep)clientAccessDataStream).getData();
                    if (byArray2.length > 0) {
                        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                        n7 += byArray2.length;
                        n += byArray2.length;
                    } else {
                        n7 = -1;
                        bl = true;
                    }
                } else {
                    if (!(clientAccessDataStream instanceof IFSReturnCodeRep)) {
                        Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
                        throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                    }
                    int n8 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n8 != 0) {
                        if (n8 != 22) {
                            IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n8);
                            Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n8));
                            throw new ExtendedIOException(this.path_, n8);
                        }
                        n7 = -1;
                        bl = true;
                    }
                }
                bl2 = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
                if (bl2) continue;
                try {
                    clientAccessDataStream = (ClientAccessDataStream)this.server_.receive(iFSReadReq.getCorrelation());
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                    try {
                        interruptedIOException.initCause(interruptedException);
                        throw interruptedIOException;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw interruptedIOException;
                }
            } while (!bl2);
            if (n7 <= 0) continue;
            this.incrementFileOffset(n7);
            n3 += n7;
            n4 -= n7;
        }
    }

    void setConverter(ConverterImplRemote converterImplRemote) {
        this.converter_ = converterImplRemote;
    }

    void setCCSID(int n) throws IOException {
        this.fileDataCCSID_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileOffset(long l) {
        Object object = this.fileOffsetLock_;
        synchronized (object) {
            this.fileOffset_ = l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setLength(long l) throws IOException, AS400SecurityException {
        ClientAccessDataStream clientAccessDataStream;
        block14: {
            int n;
            block13: {
                boolean bl;
                block12: {
                    clientAccessDataStream = null;
                    n = -1;
                    try {
                        try {
                            n = this.createFileHandle(2, 8);
                            if (n == -1) {
                                if (Trace.traceOn_) {
                                    Trace.log(2, "Unable to create handle to file " + this.path_ + ". IFSReturnCodeRep return code", this.errorRC_);
                                }
                                bl = false;
                                Object var9_9 = null;
                                break block12;
                            }
                            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(n, l, this.serverDatastreamLevel_);
                            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSChangeAttrsReq);
                            break block13;
                        }
                        catch (ConnectionDroppedException connectionDroppedException) {
                            Trace.log(2, "Byte stream server connection lost.");
                            this.connectionDropped(connectionDroppedException);
                            Object var9_11 = null;
                            this.close(n);
                            break block14;
                        }
                        catch (InterruptedException interruptedException) {
                            Trace.log(2, "Interrupted");
                            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                            try {
                                interruptedIOException.initCause(interruptedException);
                                throw interruptedIOException;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw interruptedIOException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        this.close(n);
                        throw throwable;
                    }
                }
                this.close(n);
                return bl;
            }
            Object var9_10 = null;
            this.close(n);
        }
        boolean bl = false;
        if (!(clientAccessDataStream instanceof IFSReturnCodeRep)) {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
        if (n == 0) {
            bl = true;
        } else {
            IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n);
            Trace.log(2, this.path_ + ": IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n));
        }
        if (this.fileOffset_ <= l) return bl;
        this.fileOffset_ = l;
        return bl;
    }

    void setOpen(boolean bl, int n) {
        if (bl) {
            if (n == -1) {
                Trace.log(2, "Called setOpen with invalid file handle: " + n);
                throw new InternalErrorException(10);
            }
            if (n != this.fileHandle_) {
                this.close();
            }
            this.fileHandle_ = n;
        }
        this.isOpen_ = bl;
    }

    void setOpenAllowed(boolean bl) {
        this.isOpenAllowed_ = bl;
    }

    void setPreferredCCSID(int n) {
        this.preferredServerCCSID_ = n;
    }

    void setServer(AS400Server aS400Server) {
        this.server_ = aS400Server;
    }

    public void sync() throws IOException {
        if (this.parent_ == null) {
            Trace.log(2, "IFSFileDescriptor.sync() was called when parent is null.");
        } else if (this.parent_ instanceof IFSRandomAccessFileImplRemote) {
            ((IFSRandomAccessFileImplRemote)this.parent_).flush();
        } else if (this.parent_ instanceof IFSFileOutputStreamImplRemote) {
            ((IFSFileOutputStreamImplRemote)this.parent_).flush();
        } else {
            Trace.log(4, "IFSFileDescriptor.sync() was called when parent is neither an IFSRandomAccessFile nor an IFSFileOutputStream.");
        }
    }

    private static final void throwSecurityExceptionIfAccessDenied(String string, int n) throws AS400SecurityException {
        if (n == 5 || n == 13) {
            if (Trace.traceOn_) {
                Trace.log(1, "Access denied to file " + string + ". " + "IFSReturnCodeRep return code", n);
            }
            throw new AS400SecurityException(string, 1);
        }
    }

    void unlock(IFSKey iFSKey) throws IOException, AS400SecurityException {
        if (iFSKey.fileHandle_ != this.fileHandle_) {
            Trace.log(2, "Attempt to use IFSKey on different file stream.");
            throw new ExtendedIllegalArgumentException("key", 2);
        }
        ClientAccessDataStream clientAccessDataStream = null;
        IFSUnlockBytesReq iFSUnlockBytesReq = new IFSUnlockBytesReq(iFSKey.fileHandle_, iFSKey.offset_, iFSKey.length_, iFSKey.isMandatory_, this.serverDatastreamLevel_);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSUnlockBytesReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n));
                throw new ExtendedIOException(this.path_, n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    void writeBytes(byte[] byArray, int n, int n2) throws IOException, AS400SecurityException {
        this.writeBytes(byArray, n, n2, false);
    }

    void writeBytes(byte[] byArray, int n, int n2, boolean bl) throws IOException, AS400SecurityException {
        while (n2 > 0) {
            int n3 = n2 > this.maxDataBlockSize_ ? this.maxDataBlockSize_ : n2;
            IFSWriteReq iFSWriteReq = new IFSWriteReq(this.fileHandle_, this.fileOffset_, byArray, n, n3, 65535, bl, this.serverDatastreamLevel_);
            if (n2 - n3 > 0) {
                iFSWriteReq.setChainIndicator(1);
            }
            ClientAccessDataStream clientAccessDataStream = null;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSWriteReq);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost");
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
            if (clientAccessDataStream instanceof IFSWriteRep) {
                IFSWriteRep iFSWriteRep = (IFSWriteRep)clientAccessDataStream;
                int n4 = iFSWriteRep.getReturnCode();
                if (n4 != 0) {
                    Trace.log(2, "IFSWriteRep return code", n4);
                    throw new ExtendedIOException(this.path_, n4);
                }
                int n5 = n3 - iFSWriteRep.getLengthNotWritten();
                this.incrementFileOffset(n5);
                n += n5;
                n2 -= n5;
                if (n5 == n3) continue;
                Trace.log(2, "Incomplete write.  Only " + Integer.toString(n5) + " bytes of a requested " + Integer.toString(n3) + " were written.");
                throw new ExtendedIOException(this.path_, 25);
            }
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n6 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n6 == 0) continue;
                IFSFileDescriptorImplRemote.throwSecurityExceptionIfAccessDenied(this.path_, n6);
                Trace.log(2, "IFSReturnCodeRep return code", IFSFileDescriptorImplRemote.descriptionForReturnCode(n6));
                throw new ExtendedIOException(this.path_, n6);
            }
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    public int getServerDatastreamLevel() {
        return this.serverDatastreamLevel_;
    }

    public int createUserHandle() throws IOException, AS400SecurityException {
        Object object;
        ClientAccessDataStream clientAccessDataStream = null;
        int n = -1;
        byte[] byArray = BinaryConverter.longToByteArray(System.currentTimeMillis());
        byte[] byArray2 = null;
        try {
            object = new IFSUserHandleSeedReq(byArray);
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive((DataStream)object);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        if (!(clientAccessDataStream instanceof IFSUserHandleSeedRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n2 != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code", n2);
                }
                throw new ExtendedIOException(n2);
            }
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        byArray2 = ((IFSUserHandleSeedRep)clientAccessDataStream).getSeed();
        int n3 = 0;
        clientAccessDataStream = null;
        object = SignonConverter.stringToByteArray(this.system_.getUserId());
        byte[] byArray3 = this.system_.getPassword(byArray, byArray2);
        IFSCreateUserHandlerReq iFSCreateUserHandlerReq = new IFSCreateUserHandlerReq((byte[])object, byArray3);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCreateUserHandlerReq);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        if (clientAccessDataStream instanceof IFSCreateUserHandleRep) {
            n3 = ((IFSCreateUserHandleRep)clientAccessDataStream).getReturnCode();
            if (n3 != 0) {
                Trace.log(2, "IFSCreateUserHandleRep return code", n3);
            }
        } else {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n3 != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code", n3);
                }
                throw new ExtendedIOException(n3);
            }
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()), null);
        }
        n = ((IFSCreateUserHandleRep)clientAccessDataStream).getHandle();
        return n;
    }

    public void freeUserHandle(int n) throws IOException, AS400SecurityException {
        IFSFreeUserHandlerReq iFSFreeUserHandlerReq = new IFSFreeUserHandlerReq(n);
        this.server_.send(iFSFreeUserHandlerReq);
    }

    public void freeHandle(int n) throws IOException, AS400SecurityException {
        IFSFreeHandleReq iFSFreeHandleReq = new IFSFreeHandleReq(n);
        this.server_.send(iFSFreeHandleReq);
    }

    public int getASP(boolean bl) throws IOException, AS400SecurityException {
        this.isDirectory_ = bl;
        return this.getASP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getASP() throws IOException, AS400SecurityException {
        if (this.fileAsp_ != -1) return this.fileAsp_;
        ClientAccessDataStream clientAccessDataStream = null;
        int n = 0;
        this.connect();
        byte[] byArray = this.getConverter().stringToByteArray(this.path_);
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = this.system_.createUserHandle();
            try {
                IFSLookupReq iFSLookupReq = new IFSLookupReq(byArray, this.preferredServerCCSID_, n2, 12, 0x100800, 0);
                clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSLookupReq);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                    throw interruptedIOException;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
            n = 0;
            if (!(clientAccessDataStream instanceof IFSLookupRep)) {
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n == 0) throw new ExtendedIOException(this.path_, n);
                    Trace.log(2, "IFSReturnCodeRep return code", n);
                    throw new ExtendedIOException(this.path_, n);
                }
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            n3 = ((IFSLookupRep)clientAccessDataStream).getHandle();
            this.retrieveAttributes(clientAccessDataStream, n3);
            Object var10_11 = null;
            if (n3 == -1) return this.fileAsp_;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (n3 == -1) throw throwable;
            this.freeHandle(n3);
            throw throwable;
        }
        this.freeHandle(n3);
        return this.fileAsp_;
    }

    public String getOwnerNameByUserHandle(boolean bl) throws IOException, AS400SecurityException {
        Trace.log(3, "Owner Name " + (this.fileOwnerName_ == null ? "is null" : this.fileOwnerName_));
        this.isDirectory_ = true;
        if (bl || this.fileOwnerName_ == null) {
            Trace.log(3, "force retrieve for Owner Name.");
            this.fileOwnerName_ = this.getOwnerNameByUserHandle();
        }
        return this.fileOwnerName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOwnerNameByUserHandle() throws IOException, AS400SecurityException {
        block10: {
            int n;
            block11: {
                ClientAccessDataStream clientAccessDataStream = null;
                int n2 = 0;
                this.connect();
                byte[] byArray = this.getConverter().stringToByteArray(this.path_);
                int n3 = -1;
                n = -1;
                try {
                    n3 = this.system_.createUserHandle();
                    try {
                        IFSLookupReq iFSLookupReq = new IFSLookupReq(byArray, this.preferredServerCCSID_, n3, 12, 0x100800, 0);
                        clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSLookupReq);
                    }
                    catch (ConnectionDroppedException connectionDroppedException) {
                        Trace.log(2, "Byte stream server connection lost.");
                        this.connectionDropped(connectionDroppedException);
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.log(2, "Interrupted");
                        InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                        try {
                            interruptedIOException.initCause(interruptedException);
                            throw interruptedIOException;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw interruptedIOException;
                    }
                    n2 = 0;
                    if (clientAccessDataStream instanceof IFSLookupRep) {
                        n = ((IFSLookupRep)clientAccessDataStream).getHandle();
                        this.retrieveAttributes(clientAccessDataStream, n);
                        Object var10_11 = null;
                        if (n == -1) break block10;
                        break block11;
                    }
                    if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                        n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                        if (n2 == 0) throw new ExtendedIOException(this.path_, n2);
                        Trace.log(2, "IFSReturnCodeRep return code", n2);
                        throw new ExtendedIOException(this.path_, n2);
                    }
                    Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (n == -1) throw throwable;
                    this.freeHandle(n);
                    throw throwable;
                }
            }
            this.freeHandle(n);
        }
        if (this.fileOwnerName_ == null) {
            return "";
        }
        String string = this.fileOwnerName_;
        return string;
    }

    public String getFileSystemType(boolean bl) throws IOException, AS400SecurityException {
        this.isDirectory_ = bl;
        return this.getFileSystemType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getFileSystemType() throws IOException, AS400SecurityException {
        String string;
        block24: {
            string = "Unknown";
            if (this.fileSystemType_ == -1) {
                int n;
                block25: {
                    ClientAccessDataStream clientAccessDataStream = null;
                    int n2 = 0;
                    this.connect();
                    n = -1;
                    byte[] byArray = this.getConverter().stringToByteArray(this.path_);
                    int n3 = -1;
                    try {
                        n3 = this.system_.createUserHandle();
                        try {
                            IFSLookupReq iFSLookupReq = new IFSLookupReq(byArray, this.preferredServerCCSID_, n3, 12, 0x100800, 0);
                            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSLookupReq);
                        }
                        catch (ConnectionDroppedException connectionDroppedException) {
                            Trace.log(2, "Byte stream server connection lost.");
                            this.connectionDropped(connectionDroppedException);
                        }
                        catch (InterruptedException interruptedException) {
                            Trace.log(2, "Interrupted");
                            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                            try {
                                interruptedIOException.initCause(interruptedException);
                                throw interruptedIOException;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw interruptedIOException;
                        }
                        n2 = 0;
                        if (clientAccessDataStream instanceof IFSLookupRep) {
                            n = ((IFSLookupRep)clientAccessDataStream).getHandle();
                            this.retrieveAttributes(clientAccessDataStream, n);
                            Object var11_12 = null;
                            if (n == -1) break block24;
                            break block25;
                        }
                        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                            n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                            if (n2 == 0) throw new ExtendedIOException(this.path_, n2);
                            Trace.log(2, "IFSReturnCodeRep return code", n2);
                            throw new ExtendedIOException(this.path_, n2);
                        }
                        Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
                        throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (n == -1) throw throwable;
                        this.freeHandle(n);
                        throw throwable;
                    }
                }
                this.freeHandle(n);
            }
        }
        switch (this.fileSystemType_) {
            case 1: {
                return "EPFS";
            }
            case 2: {
                return "QDLS";
            }
            case 3: {
                return "QSYS";
            }
            case 4: {
                return "NFS";
            }
            case 5: {
                return "LRFS";
            }
            case 6: {
                return "QOPT";
            }
            case 7: {
                return "QRFS";
            }
            case 9: {
                return "EPFSP";
            }
            case 11: {
                return "QNETC";
            }
            case 12: {
                return "QDTL";
            }
            case 13: {
                return "IEPFS";
            }
            case 14: {
                return "ASPQSYS";
            }
        }
        return string;
    }

    private void retrieveAttributes(ClientAccessDataStream clientAccessDataStream, int n) throws IOException, AS400SecurityException {
        this.fileAsp_ = ((IFSLookupRep)clientAccessDataStream).getASP();
        this.fileOwnerName_ = ((IFSLookupRep)clientAccessDataStream).getOwnerName(this.system_.getCcsid());
        this.fileDataCCSID_ = ((IFSLookupRep)clientAccessDataStream).getCCSID(this.serverDatastreamLevel_);
        int n2 = this.system_.getUserHandle();
        int n3 = 0;
        clientAccessDataStream = null;
        try {
            IFSGetFileSystemReq iFSGetFileSystemReq = new IFSGetFileSystemReq(n, n2);
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSGetFileSystemReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            try {
                interruptedIOException.initCause(interruptedException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw interruptedIOException;
        }
        n3 = 0;
        if (!(clientAccessDataStream instanceof IFSGetFileSystemRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n3 != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code", n3);
                }
                throw new ExtendedIOException(this.path_, n3);
            }
            Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()), null);
        }
        this.fileSystemType_ = ((IFSGetFileSystemRep)clientAccessDataStream).getFileSystemType();
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSCloseRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSExchangeAttrRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSLockBytesRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSWriteRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReadRep(), 0);
    }
}

