/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400GenAuthTknDS;
import com.ibm.as400.access.AS400GenAuthTknReplyDS;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplNative;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400NoThreadServer;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.AS400StrSvrDS;
import com.ibm.as400.access.AS400StrSvrReplyDS;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ThreadedServer;
import com.ibm.as400.access.AS400XChgRandSeedDS;
import com.ibm.as400.access.AS400XChgRandSeedReplyDS;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ChangePasswordRep;
import com.ibm.as400.access.ChangePasswordReq;
import com.ibm.as400.access.ClassDecoupler;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.CurrentUser;
import com.ibm.as400.access.DDMTerm;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.GSSTokenVault;
import com.ibm.as400.access.IFSCreateUserHandleRep;
import com.ibm.as400.access.IFSCreateUserHandlerReq;
import com.ibm.as400.access.IFSFreeUserHandlerReq;
import com.ibm.as400.access.IFSPingReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.IFSUserHandle2Req;
import com.ibm.as400.access.IFSUserHandleSeedRep;
import com.ibm.as400.access.IFSUserHandleSeedReq;
import com.ibm.as400.access.IdentityTokenVault;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NLSImpl;
import com.ibm.as400.access.NLSImplNative;
import com.ibm.as400.access.NLSImplRemote;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.PasswordVault;
import com.ibm.as400.access.PortMapper;
import com.ibm.as400.access.ProfileTokenVault;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.ServerVersion;
import com.ibm.as400.access.SignonConverter;
import com.ibm.as400.access.SignonEndServerReq;
import com.ibm.as400.access.SignonExchangeAttributeRep;
import com.ibm.as400.access.SignonExchangeAttributeReq;
import com.ibm.as400.access.SignonGenAuthTokenReplyDS;
import com.ibm.as400.access.SignonGenAuthTokenRequestDS;
import com.ibm.as400.access.SignonInfo;
import com.ibm.as400.access.SignonInfoRep;
import com.ibm.as400.access.SignonInfoReq;
import com.ibm.as400.access.SignonPingReq;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.TokenManager;
import com.ibm.as400.access.TokenManager2;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AS400ImplRemote
implements AS400Impl {
    private static boolean PASSWORD_TRACE = false;
    private static final boolean DEBUG = false;
    private static final int UNINITIALIZED = -1;
    private Vector[] serverPool_ = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector()};
    private String systemName_ = "";
    private String userId_ = "";
    private boolean systemNameLocal_ = false;
    private CredentialVault credVault_ = new PasswordVault();
    private Object gssCredential_ = null;
    private String gssName_ = "";
    private SSLOptions useSSLConnection_ = null;
    private boolean canUseNativeOptimization_ = true;
    private boolean threadUsed_ = true;
    private int ccsid_ = 0;
    private boolean userOverrideCcsid_ = false;
    private String clientNlv_;
    private SocketProperties socketProperties_ = null;
    private String languageLibrary_ = null;
    private boolean skipFurtherSettingOfLanguageLibrary_ = false;
    private boolean detectedMissingPTF_ = false;
    private String ddmRDB_;
    private ServerVersion version_;
    private int serverLevel_;
    private int passwordLevel_ = 0;
    private boolean isPasswordTypeSet_ = false;
    private SignonInfo signonInfo_;
    private byte[] signonJobBytes_;
    private String signonJobString_;
    private ConnectionListener dispatcher_;
    private byte[] proxySeed_ = null;
    private byte[] remoteSeed_ = null;
    private int userHandle_ = -1;
    AS400NoThreadServer signonServer_;
    byte[] serverSeed_;
    byte[] clientSeed_;
    private int UserHandle2_ = -1;
    private static final String CLASSNAME = "com.ibm.as400.access.AS400ImplRemote";
    private SignonPingReq signonPingRequest_;
    private IFSPingReq ifsPingRequest_;
    private static final int NO_PRIOR_SERVICE = -1;
    private int priorService_ = -1;
    private boolean mustAddLanguageLibrary_ = false;
    private boolean mustUseNetSockets_ = false;
    private boolean mustUseSuppliedProfile_ = false;
    private static final int[] EPERM;
    private static final int[] INITPERM;
    private static final int[] OUTPERM;
    private static final int[] PPERM;
    private static final int[] PC1;
    private static final int[] PC2;
    private static final int[] S1;
    private static final int[] S2;
    private static final int[] S3;
    private static final int[] S4;
    private static final int[] S5;
    private static final int[] S6;
    private static final int[] S7;
    private static final int[] S8;
    private int bidiStringType = 0;

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding implementation connection listener.");
        }
        this.dispatcher_ = connectionListener;
    }

    boolean canUseNativeOptimizations() {
        return this.canUseNativeOptimization_;
    }

    public String ccsidToEncoding(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Mapping to encoding implementation, CCSID:", n);
        }
        return ConversionMaps.ccsidToEncoding(n);
    }

    private static char[] trimUnicodeSpace(char[] cArray) {
        char c = cArray[cArray.length - 1];
        if (c != '\u0000' && c != ' ' && c != '\u3000') {
            return cArray;
        }
        int n = cArray.length - 1;
        while (cArray[n] == '\u0000' || cArray[n] == ' ' || cArray[n] == '\u3000') {
            --n;
        }
        char[] cArray2 = new char[n + 1];
        System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
        return cArray2;
    }

    private static byte[] generateShaToken(byte[] byArray, byte[] byArray2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            byte[] byArray3 = messageDigest.digest();
            if (PASSWORD_TRACE) {
                Trace.log(1, "SHA-1 token:", byArray3);
            }
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.log(2, "Error getting instance of SHA-1 algorithm:", (Throwable)noSuchAlgorithmException);
            throw new InternalErrorException(10, (Throwable)noSuchAlgorithmException);
        }
    }

    private static byte[] generateShaSubstitute(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            messageDigest.update(byArray4);
            messageDigest.update(byArray5);
            byte[] byArray6 = messageDigest.digest();
            if (PASSWORD_TRACE) {
                Trace.log(1, "SHA-1 substitute:", byArray6);
            }
            return byArray6;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.log(2, "Error getting instance of SHA-1 algorithm:", (Throwable)noSuchAlgorithmException);
            throw new InternalErrorException(10, (Throwable)noSuchAlgorithmException);
        }
    }

    private static byte[] generateShaProtected(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        int n = ((byArray.length - 1) / 20 + 1) * 20;
        byte[] byArray7 = new byte[n];
        for (int i = 0; i < n; i += 20) {
            AS400ImplRemote.incrementString(byArray6);
            byte[] byArray8 = AS400ImplRemote.generateShaSubstitute(byArray2, byArray3, byArray4, byArray5, byArray6);
            for (int j = 0; j < 20; ++j) {
                byArray7[i + j] = i + j < byArray.length ? (byte)(byArray8[j] ^ byArray[i + j]) : byArray8[j];
            }
        }
        return byArray7;
    }

    public SignonInfo changePassword(String string, boolean bl, String string2, byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Change password implementation, system name: '" + string + "' user ID: '" + string2 + "'");
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "Old password bytes:", byArray);
            Trace.log(1, "New password bytes:", byArray2);
        }
        this.systemName_ = string;
        this.systemNameLocal_ = bl;
        this.userId_ = string2;
        Object[] objectArray = BinaryConverter.byteArrayToCharArray(CredentialVault.decode(this.proxySeed_, this.remoteSeed_, byArray));
        Object[] objectArray2 = BinaryConverter.byteArrayToCharArray(CredentialVault.decode(this.proxySeed_, this.remoteSeed_, byArray2));
        this.proxySeed_ = null;
        this.remoteSeed_ = null;
        if (PASSWORD_TRACE) {
            Trace.log(1, "Old password unscrambled: '" + new String((char[])objectArray) + "'");
            Trace.log(1, "New password unscrambled: '" + new String((char[])objectArray2) + "'");
        }
        boolean bl2 = this.signonServer_ == null;
        this.signonConnect();
        try {
            int n;
            Object object;
            byte[] byArray3;
            byte[] byArray4;
            byte[] byArray5;
            byte[] byArray6;
            Object object2;
            Object object3;
            byte[] byArray7 = SignonConverter.stringToByteArray(string2);
            if (this.passwordLevel_ < 2) {
                if (objectArray.length > 0 && Character.isDigit(objectArray[0])) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Prepending Q to numeric password.");
                    }
                    object3 = new char[objectArray.length + 1];
                    object3[0] = 81;
                    System.arraycopy(objectArray, 0, object3, 1, objectArray.length);
                    objectArray = (Object[])object3;
                }
                if (objectArray.length > 10) {
                    Trace.log(2, "Length of parameter 'oldPassword' is not valid:", objectArray.length);
                    throw new AS400SecurityException(10);
                }
                object3 = SignonConverter.stringToByteArray(new String((char[])objectArray).toUpperCase());
                if (objectArray2.length > 0 && Character.isDigit(objectArray2[0])) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Prepending Q to numeric password.");
                    }
                    object2 = new char[objectArray2.length + 1];
                    object2[0] = 81;
                    System.arraycopy(objectArray2, 0, object2, 1, objectArray2.length);
                    objectArray2 = (Object[])object2;
                }
                if (objectArray2.length > 10) {
                    Trace.log(2, "Length of parameter 'newPassword' is not valid:", objectArray2.length);
                    throw new AS400SecurityException(16);
                }
                object2 = SignonConverter.stringToByteArray(new String((char[])objectArray2).toUpperCase());
                byArray6 = object3[8] == 64 && object3[9] == 64 ? new byte[8] : new byte[16];
                byArray5 = object2[8] == 64 && object2[9] == 64 ? new byte[8] : new byte[16];
                byArray4 = AS400ImplRemote.encryptNewPassword(byArray7, object3, (byte[])object2, byArray6, byArray5, this.clientSeed_, this.serverSeed_);
            } else {
                object3 = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(byArray7));
                if (objectArray.length == 0) {
                    Trace.log(2, "Parameter 'oldPassword' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (objectArray[0] == '*') {
                    Trace.log(2, "Parameter 'oldPassword' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                if (objectArray2.length == 0) {
                    Trace.log(2, "Parameter 'newPassword' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (objectArray2[0] == '*') {
                    Trace.log(2, "Parameter 'newPassword' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                object2 = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(objectArray));
                byte[] byArray8 = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(objectArray2));
                byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                if (PASSWORD_TRACE) {
                    Trace.log(1, "Pre SHA-1 userIdBytes:", object3);
                    Trace.log(1, "Pre SHA-1 oldPasswordBytes:", (byte[])object2);
                    Trace.log(1, "Pre SHA-1 newPasswordBytes:", byArray8);
                    Trace.log(1, "Pre SHA-1 sequence:", byArray3);
                }
                object = AS400ImplRemote.generateShaToken(object3, (byte[])object2);
                byArray4 = AS400ImplRemote.generateShaSubstitute(object, this.serverSeed_, this.clientSeed_, object3, byArray3);
                byArray5 = AS400ImplRemote.generateShaProtected(byArray8, object, this.serverSeed_, this.clientSeed_, object3, byArray3);
                byte[] byArray9 = AS400ImplRemote.generateShaToken(object3, byArray8);
                byArray6 = AS400ImplRemote.generateShaProtected((byte[])object2, byArray9, this.serverSeed_, this.clientSeed_, object3, byArray3);
            }
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Change Password Request...");
                Trace.log(1, "  User ID:", string2);
                Trace.log(1, "  User ID bytes:", byArray7);
                Trace.log(1, "  Encrypted password:", byArray4);
                Trace.log(1, "  Protected old password:", byArray6);
                Trace.log(1, "  Protected new password:", byArray5);
            }
            if ((n = ((ChangePasswordRep)(object2 = (Object)((ChangePasswordRep)this.signonServer_.sendAndReceive((DataStream)(object3 = (Object)new ChangePasswordReq(byArray7, byArray4, byArray6, objectArray.length * 2, byArray5, objectArray2.length * 2, this.serverLevel_)))))).getRC()) == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Password change implementation successful.");
                }
                byArray3 = new byte[9];
                CredentialVault.rng.nextBytes(byArray3);
                object = this.signon2(string, bl, string2, CredentialVault.encode(byArray3, this.exchangeSeed(byArray3), BinaryConverter.charArrayToByteArray(objectArray2)), 0);
                if (bl2) {
                    this.signonDisconnect();
                }
                return object;
            }
            byArray3 = new byte[4];
            BinaryConverter.intToByteArray(n, byArray3, 0);
            Trace.log(2, "Change password implementation failed with return code:", byArray3);
            throw AS400ImplRemote.returnSecurityException(n, ((ChangePasswordRep)object2).getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), string2);
        }
        catch (IOException iOException) {
            Trace.log(2, "Change password failed:", (Throwable)iOException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Change password failed:", (Throwable)aS400SecurityException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw aS400SecurityException;
        }
    }

    public void connect(int n) throws AS400SecurityException, IOException {
        this.connect(n, -1, false);
    }

    public void connect(int n, int n2, boolean bl) throws AS400SecurityException, IOException {
        if (n == 7) {
            this.signonConnect();
        } else {
            this.getConnection(n, n2, false, bl);
        }
    }

    public Socket connectToPort(int n) throws AS400SecurityException, IOException {
        return this.getConnection(0, n, false);
    }

    public Socket connectToPort(int n, boolean bl) throws AS400SecurityException, IOException {
        return this.getConnection(0, n, bl);
    }

    public int createUserHandle() throws AS400SecurityException, IOException {
        if (this.userHandle_ != -1 && this.credVault_.getType() != 1) {
            return this.userHandle_;
        }
        if (this.credVault_.getType() == 1) {
            return this.createUserHandle2();
        }
        ClientAccessDataStream clientAccessDataStream = null;
        int n = -1;
        AS400Server aS400Server = this.getConnectedServer(new int[]{0});
        if (aS400Server != null) {
            byte[] byArray = BinaryConverter.longToByteArray(System.currentTimeMillis());
            byte[] byArray2 = null;
            try {
                IFSUserHandleSeedReq iFSUserHandleSeedReq = new IFSUserHandleSeedReq(byArray);
                clientAccessDataStream = (ClientAccessDataStream)aS400Server.sendAndReceive(iFSUserHandleSeedReq);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
            int n2 = 0;
            if (!(clientAccessDataStream instanceof IFSUserHandleSeedRep)) {
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n2 != 0) {
                        Trace.log(2, "IFSReturnCodeRep return code", n2);
                    }
                    throw new ExtendedIOException(n2);
                }
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            byArray2 = ((IFSUserHandleSeedRep)clientAccessDataStream).getSeed();
            n2 = 0;
            clientAccessDataStream = null;
            byte[] byArray3 = SignonConverter.stringToByteArray(this.userId_);
            byte[] byArray4 = this.getPassword(byArray, byArray2);
            IFSCreateUserHandlerReq iFSCreateUserHandlerReq = new IFSCreateUserHandlerReq(byArray3, byArray4);
            try {
                clientAccessDataStream = (ClientAccessDataStream)aS400Server.sendAndReceive(iFSCreateUserHandlerReq);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
            if (clientAccessDataStream instanceof IFSCreateUserHandleRep) {
                n2 = ((IFSCreateUserHandleRep)clientAccessDataStream).getReturnCode();
                if (n2 != 0) {
                    Trace.log(2, "IFSCreateUserHandleRep return code", n2);
                }
                n = ((IFSCreateUserHandleRep)clientAccessDataStream).getHandle();
            } else {
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n2 != 0) {
                        Trace.log(2, "IFSReturnCodeRep return code", n2);
                    }
                    throw new ExtendedIOException(n2);
                }
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
                throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()), null);
            }
        }
        this.setUserHandle(n);
        return n;
    }

    public int getUserHandle() {
        return this.userHandle_;
    }

    public void setUserHandle(int n) {
        this.userHandle_ = n;
    }

    public void freeUserHandle() throws IOException, AS400SecurityException {
        if (this.userHandle_ != -1) {
            IFSFreeUserHandlerReq iFSFreeUserHandlerReq = new IFSFreeUserHandlerReq(this.userHandle_);
            AS400Server aS400Server = this.getConnectedServer(new int[]{0});
            if (aS400Server != null) {
                aS400Server.send(iFSFreeUserHandlerReq);
            }
        }
        this.userHandle_ = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(int n) {
        if (n == 7) {
            this.signonDisconnect();
        } else {
            Vector vector;
            if (this.userHandle_ != -1 && n == 0) {
                try {
                    this.freeUserHandle();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Vector vector2 = vector = this.serverPool_[n];
            synchronized (vector2) {
                while (!vector.isEmpty()) {
                    this.disconnectServer((AS400Server)vector.elementAt(0));
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Service disconnected implementation:", AS400.getServerName(n));
        }
    }

    void disconnectAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting all services implementation...");
        }
        this.disconnect(0);
        this.disconnect(1);
        this.disconnect(3);
        this.disconnect(2);
        this.disconnect(4);
        this.disconnect(5);
        this.disconnect(6);
        this.disconnect(7);
        if (Trace.traceOn_) {
            Trace.log(1, "All services disconnected implementation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectServer(AS400Server aS400Server) {
        aS400Server.forceDisconnect();
        int n = aS400Server.getService();
        if (n != 7) {
            Vector vector;
            Vector vector2 = vector = this.serverPool_[n];
            synchronized (vector2) {
                if (!vector.isEmpty()) {
                    vector.removeElement(aS400Server);
                    if (vector.isEmpty()) {
                        this.fireConnectEvent(false, n);
                    }
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Server disconnected");
        }
    }

    public byte[] exchangeSeed(byte[] byArray) {
        this.proxySeed_ = byArray;
        this.remoteSeed_ = new byte[7];
        CredentialVault.rng.nextBytes(this.remoteSeed_);
        return this.remoteSeed_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for AS400 implementation invoked.");
        }
        try {
            this.disconnectAllServices();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    private void fireConnectEvent(boolean bl, int n) {
        if (this.dispatcher_ != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, n);
            if (bl) {
                this.dispatcher_.connected(connectionEvent);
            } else {
                this.dispatcher_.disconnected(connectionEvent);
            }
        }
    }

    public void generateProfileToken(ProfileTokenCredential profileTokenCredential, String string) throws AS400SecurityException, IOException {
        this.signonConnect();
        try {
            int n;
            AS400StrSvrDS aS400StrSvrDS;
            AS400StrSvrReplyDS aS400StrSvrReplyDS;
            byte[] byArray = SignonConverter.stringToByteArray(this.userId_);
            byte[] byArray2 = this.getPassword(this.clientSeed_, this.serverSeed_);
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Start Server Request...");
                Trace.log(1, "  User ID:", this.userId_);
                Trace.log(1, "  User ID bytes:", byArray);
                Trace.log(1, "  Client seed:", this.clientSeed_);
                Trace.log(1, "  Server seed:", this.serverSeed_);
                Trace.log(1, "  Encrypted password:", byArray2);
            }
            if ((aS400StrSvrReplyDS = (AS400StrSvrReplyDS)this.signonServer_.sendAndReceive(aS400StrSvrDS = new AS400StrSvrDS(n = AS400Server.getServerId(7), byArray, byArray2, this.credVault_.getType()))).getRC() != 0) {
                byte[] byArray3 = new byte[4];
                BinaryConverter.intToByteArray(aS400StrSvrReplyDS.getRC(), byArray3, 0);
                Trace.log(2, "Start server failed with return code:", byArray3);
                throw AS400ImplRemote.returnSecurityException(aS400StrSvrReplyDS.getRC(), null, this.userId_);
            }
            SignonGenAuthTokenRequestDS signonGenAuthTokenRequestDS = new SignonGenAuthTokenRequestDS(BinaryConverter.charArrayToByteArray(string.toCharArray()), profileTokenCredential.getTokenType(), profileTokenCredential.getTimeoutInterval(), this.serverLevel_);
            SignonGenAuthTokenReplyDS signonGenAuthTokenReplyDS = (SignonGenAuthTokenReplyDS)this.signonServer_.sendAndReceive(signonGenAuthTokenRequestDS);
            int n2 = signonGenAuthTokenReplyDS.getRC();
            if (n2 != 0) {
                byte[] byArray4 = new byte[4];
                BinaryConverter.intToByteArray(n2, byArray4, 0);
                Trace.log(2, "Generate profile token failed with return code:", byArray4);
                throw AS400ImplRemote.returnSecurityException(n2, signonGenAuthTokenReplyDS.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), this.userId_);
            }
            try {
                profileTokenCredential.setToken(signonGenAuthTokenReplyDS.getProfileTokenBytes());
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, propertyVetoException);
                throw new InternalErrorException(10, (Throwable)propertyVetoException);
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Generate profile token failed:", (Throwable)iOException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Generate profile token failed:", (Throwable)aS400SecurityException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw aS400SecurityException;
        }
    }

    public void generateProfileToken(ProfileTokenCredential profileTokenCredential, String string, CredentialVault credentialVault, String string2) throws AS400SecurityException, IOException, InterruptedException {
        this.signonConnect();
        try {
            byte[] byArray;
            Object object;
            Object object2;
            byte[] byArray2 = SignonConverter.stringToByteArray(string);
            byte[] byArray3 = null;
            int n = credentialVault.getType();
            switch (n) {
                case 1: {
                    try {
                        byArray3 = this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, string2) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                        break;
                    }
                    catch (Exception exception) {
                        Trace.log(2, "Error retrieving GSSToken:", (Throwable)exception);
                        throw new AS400SecurityException(62, (Throwable)exception);
                    }
                }
                case 2: 
                case 3: {
                    byArray3 = credentialVault.decode(this.proxySeed_, this.remoteSeed_);
                    break;
                }
                default: {
                    object2 = BinaryConverter.byteArrayToCharArray(credentialVault.decode(this.proxySeed_, this.remoteSeed_));
                    this.proxySeed_ = null;
                    this.remoteSeed_ = null;
                    if (this.passwordLevel_ < 2) {
                        if (((char[])object2).length > 0 && Character.isDigit(object2[0])) {
                            if (Trace.traceOn_) {
                                Trace.log(1, "Prepending Q to numeric password.");
                            }
                            object = new char[((char[])object2).length + 1];
                            object[0] = 81;
                            System.arraycopy(object2, 0, object, 1, ((char[])object2).length);
                            object2 = object;
                        }
                        if (((char[])object2).length > 10) {
                            Trace.log(2, "Length of parameter 'password' is not valid:", ((char[])object2).length);
                            throw new AS400SecurityException(10);
                        }
                        byArray3 = AS400ImplRemote.encryptPassword(byArray2, SignonConverter.stringToByteArray(new String((char[])object2).toUpperCase()), this.clientSeed_, this.serverSeed_);
                        break;
                    }
                    object = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(byArray2));
                    if (((char[])object2).length == 0) {
                        Trace.log(2, "Parameter 'password' is empty.");
                        throw new AS400SecurityException(63);
                    }
                    if (object2[0] == '*') {
                        Trace.log(2, "Parameter 'password' begins with a '*' character.");
                        throw new AS400SecurityException(63);
                    }
                    byte[] byArray4 = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(object2));
                    byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                    if (PASSWORD_TRACE) {
                        Trace.log(1, "Pre SHA-1 userIdBytes:", (byte[])object);
                        Trace.log(1, "Pre SHA-1 passwordBytes:", byArray4);
                        Trace.log(1, "Pre SHA-1 sequence:", byArray);
                    }
                    byte[] byArray5 = AS400ImplRemote.generateShaToken((byte[])object, byArray4);
                    byArray3 = AS400ImplRemote.generateShaSubstitute(byArray5, this.serverSeed_, this.clientSeed_, (byte[])object, byArray);
                }
            }
            object2 = new AS400GenAuthTknDS(byArray2, byArray3, n, profileTokenCredential.getTokenType(), profileTokenCredential.getTimeoutInterval(), this.serverLevel_);
            object = (AS400GenAuthTknReplyDS)this.signonServer_.sendAndReceive((DataStream)object2);
            int n2 = ((AS400GenAuthTknReplyDS)object).getRC();
            if (n2 != 0) {
                byArray = new byte[4];
                BinaryConverter.intToByteArray(n2, byArray, 0);
                Trace.log(2, "Generate profile token failed with return code:", byArray);
                throw AS400ImplRemote.returnSecurityException(n2, ((AS400GenAuthTknReplyDS)object).getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), string);
            }
            try {
                profileTokenCredential.setToken(((AS400GenAuthTknReplyDS)object).getProfileTokenBytes());
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, propertyVetoException);
                throw new InternalErrorException(10, (Throwable)propertyVetoException);
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Generate profile token failed:", (Throwable)iOException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Generate profile token failed:", (Throwable)aS400SecurityException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw aS400SecurityException;
        }
    }

    public int getCcsid() {
        int n = 0;
        int[] nArray = new int[]{this.ccsid_, 0, 0, 0};
        if (this.ccsid_ == 0 || this.ccsid_ == 65535) {
            if (this.signonInfo_ != null) {
                n = 1;
                nArray[n] = this.signonInfo_.serverCCSID;
                this.ccsid_ = nArray[n];
            }
            if (this.ccsid_ == 0 || this.ccsid_ == 65535) {
                n = 2;
                nArray[n] = this.getCcsidFromServer();
                this.ccsid_ = nArray[n];
            }
            if (this.ccsid_ == 0 || this.ccsid_ == 65535) {
                n = 3;
                nArray[n] = ExecutionEnvironment.getBestGuessAS400Ccsid();
                this.ccsid_ = nArray[n];
            }
        }
        if (this.ccsid_ == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "AS400ImplRemote.getCcsid() [after first pass]: CCSID=" + this.ccsid_ + ", howObtained=" + n);
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                n = i;
                this.ccsid_ = nArray[n];
                break;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "AS400ImplRemote.getCcsid(): CCSID=" + this.ccsid_ + ", howObtained=" + n);
            if (this.ccsid_ < 1 || this.ccsid_ >= 65535) {
                Trace.log(4, "AS400ImplRemote.getCcsid(): CCSID is out of valid range: CCSID=" + this.ccsid_ + ", howObtained=" + n);
            }
        }
        return this.ccsid_;
    }

    int getUserOverrideCcsid() {
        if (this.userOverrideCcsid_) {
            return this.ccsid_;
        }
        return 0;
    }

    public int getCcsidFromServer() {
        try {
            NLSImpl nLSImpl = (NLSImpl)this.loadImpl("com.ibm.as400.access.NLSImplNative", "com.ibm.as400.access.NLSImplRemote");
            nLSImpl.setSystem(this);
            nLSImpl.connect();
            nLSImpl.disconnect();
            return nLSImpl.getCcsid();
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(4, "Error when attempting to get CCSID from server.", (Throwable)exception);
            }
            return 0;
        }
    }

    synchronized Socket getConnection(int n) throws IOException {
        Socket socket = new Socket(this.systemNameLocal_ ? "localhost" : this.systemName_, n);
        try {
            PortMapper.setSocketProperties(socket, this.socketProperties_);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "ISO8859_1"));
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "ISO8859_1"), true);
            this.readFTPLine(bufferedReader);
            printWriter.println("USER " + this.userId_);
            this.readFTPLine(bufferedReader);
            printWriter.println("PASS " + new String(BinaryConverter.byteArrayToCharArray(this.credVault_.getClearCredential())));
            if (!this.readFTPLine(bufferedReader).startsWith("230")) {
                throw new IOException();
            }
            return socket;
        }
        catch (IOException iOException) {
            Trace.log(2, "Establishing FTP connection failed:", (Throwable)iOException);
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                Trace.log(2, "Error closing socket:", (Throwable)iOException2);
            }
            throw iOException;
        }
    }

    private String readFTPLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null || string.length() == 0) {
            throw new IOException();
        }
        String string2 = string.substring(0, 3);
        StringBuffer stringBuffer = new StringBuffer(string);
        while (!(string == null || string.length() > 3 && string.substring(0, 3).equals(string2) && string.charAt(3) == ' ')) {
            string = bufferedReader.readLine();
            stringBuffer.append("\n" + string);
        }
        return stringBuffer.toString();
    }

    synchronized Socket getConnection(int n, int n2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Establishing connection to system at port:", n2);
        }
        Socket socket = new Socket(this.systemNameLocal_ ? "localhost" : this.systemName_, n2);
        int n3 = socket.hashCode();
        try {
            PortMapper.setSocketProperties(socket, this.socketProperties_);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            int n4 = AS400Server.getServerId(2);
            AS400XChgRandSeedDS aS400XChgRandSeedDS = new AS400XChgRandSeedDS(n4);
            if (Trace.traceOn_) {
                aS400XChgRandSeedDS.setConnectionID(n3);
            }
            aS400XChgRandSeedDS.write(outputStream);
            AS400XChgRandSeedReplyDS aS400XChgRandSeedReplyDS = new AS400XChgRandSeedReplyDS();
            if (Trace.traceOn_) {
                aS400XChgRandSeedReplyDS.setConnectionID(n3);
            }
            aS400XChgRandSeedReplyDS.read(inputStream);
            if (aS400XChgRandSeedReplyDS.getRC() != 0) {
                byte[] byArray = new byte[4];
                BinaryConverter.intToByteArray(aS400XChgRandSeedReplyDS.getRC(), byArray, 0);
                Trace.log(2, "Exchange of random seeds failed with return code:", byArray);
                throw AS400ImplRemote.returnSecurityException(aS400XChgRandSeedReplyDS.getRC(), null, null);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Exchange of random seeds successful.");
            }
            byte[] byArray = aS400XChgRandSeedDS.getClientSeed();
            byte[] byArray2 = aS400XChgRandSeedReplyDS.getServerSeed();
            byte[] byArray3 = SignonConverter.stringToByteArray(this.userId_);
            byte[] byArray4 = this.getPassword(byArray, byArray2);
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Start Server Request...");
                Trace.log(1, "  User ID:", this.userId_);
                Trace.log(1, "  User ID bytes:", byArray3);
                Trace.log(1, "  Client seed:", byArray);
                Trace.log(1, "  Server seed:", byArray2);
                Trace.log(1, "  Encrypted password:", byArray4);
            }
            AS400StrSvrDS aS400StrSvrDS = new AS400StrSvrDS(n4, byArray3, byArray4, this.credVault_.getType());
            if (Trace.traceOn_) {
                aS400StrSvrDS.setConnectionID(n3);
            }
            aS400StrSvrDS.write(outputStream);
            AS400StrSvrReplyDS aS400StrSvrReplyDS = new AS400StrSvrReplyDS();
            if (Trace.traceOn_) {
                aS400StrSvrReplyDS.setConnectionID(n3);
            }
            aS400StrSvrReplyDS.read(inputStream);
            if (aS400StrSvrReplyDS.getRC() != 0) {
                byte[] byArray5 = new byte[4];
                BinaryConverter.intToByteArray(aS400StrSvrReplyDS.getRC(), byArray5, 0);
                Trace.log(2, "Start server failed with return code:", byArray5);
                throw AS400ImplRemote.returnSecurityException(aS400StrSvrReplyDS.getRC(), null, this.userId_);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Server started successfully.");
            }
            return socket;
        }
        catch (IOException iOException) {
            Trace.log(2, "Establishing DHCP connection failed:", (Throwable)iOException);
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                Trace.log(2, "Error closing socket:", (Throwable)iOException2);
            }
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Establishing DHCP connection failed:", (Throwable)aS400SecurityException);
            try {
                socket.close();
            }
            catch (IOException iOException) {
                Trace.log(2, "Error closing socket:", (Throwable)iOException);
            }
            throw aS400SecurityException;
        }
    }

    synchronized Socket getConnection(int n, int n2, boolean bl) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Establishing connection to system at port:", n2);
        }
        Socket socket = new Socket(this.systemNameLocal_ && !bl ? "localhost" : this.systemName_, n2);
        int n3 = socket.hashCode();
        try {
            PortMapper.setSocketProperties(socket, this.socketProperties_);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            int n4 = AS400Server.getServerId(2);
            AS400XChgRandSeedDS aS400XChgRandSeedDS = new AS400XChgRandSeedDS(n4);
            if (Trace.traceOn_) {
                aS400XChgRandSeedDS.setConnectionID(n3);
            }
            aS400XChgRandSeedDS.write(outputStream);
            AS400XChgRandSeedReplyDS aS400XChgRandSeedReplyDS = new AS400XChgRandSeedReplyDS();
            if (Trace.traceOn_) {
                aS400XChgRandSeedReplyDS.setConnectionID(n3);
            }
            aS400XChgRandSeedReplyDS.read(inputStream);
            if (aS400XChgRandSeedReplyDS.getRC() != 0) {
                byte[] byArray = new byte[4];
                BinaryConverter.intToByteArray(aS400XChgRandSeedReplyDS.getRC(), byArray, 0);
                Trace.log(2, "Exchange of random seeds failed with return code:", byArray);
                throw AS400ImplRemote.returnSecurityException(aS400XChgRandSeedReplyDS.getRC(), null, null);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Exchange of random seeds successful.");
            }
            byte[] byArray = aS400XChgRandSeedDS.getClientSeed();
            byte[] byArray2 = aS400XChgRandSeedReplyDS.getServerSeed();
            byte[] byArray3 = SignonConverter.stringToByteArray(this.userId_);
            byte[] byArray4 = this.getPassword(byArray, byArray2);
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Start Server Request...");
                Trace.log(1, "  User ID:", this.userId_);
                Trace.log(1, "  User ID bytes:", byArray3);
                Trace.log(1, "  Client seed:", byArray);
                Trace.log(1, "  Server seed:", byArray2);
                Trace.log(1, "  Encrypted password:", byArray4);
            }
            AS400StrSvrDS aS400StrSvrDS = new AS400StrSvrDS(n4, byArray3, byArray4, this.credVault_.getType());
            if (Trace.traceOn_) {
                aS400StrSvrDS.setConnectionID(n3);
            }
            aS400StrSvrDS.write(outputStream);
            AS400StrSvrReplyDS aS400StrSvrReplyDS = new AS400StrSvrReplyDS();
            if (Trace.traceOn_) {
                aS400StrSvrReplyDS.setConnectionID(n3);
            }
            aS400StrSvrReplyDS.read(inputStream);
            if (aS400StrSvrReplyDS.getRC() != 0) {
                byte[] byArray5 = new byte[4];
                BinaryConverter.intToByteArray(aS400StrSvrReplyDS.getRC(), byArray5, 0);
                Trace.log(2, "Start server failed with return code:", byArray5);
                throw AS400ImplRemote.returnSecurityException(aS400StrSvrReplyDS.getRC(), null, this.userId_);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Server started successfully.");
            }
            return socket;
        }
        catch (IOException iOException) {
            Trace.log(2, "Establishing DHCP connection failed:", (Throwable)iOException);
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                Trace.log(2, "Error closing socket:", (Throwable)iOException2);
            }
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Establishing DHCP connection failed:", (Throwable)aS400SecurityException);
            try {
                socket.close();
            }
            catch (IOException iOException) {
                Trace.log(2, "Error closing socket:", (Throwable)iOException);
            }
            throw aS400SecurityException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobs(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job names implementation, service:", n);
        }
        if (n == 7) {
            String[] stringArray;
            if (this.signonServer_ != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.signonJobString_;
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        Vector vector = this.serverPool_[n];
        String[] stringArray = new String[vector.size()];
        Vector vector2 = vector;
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = ((AS400Server)vector.elementAt(i)).getJobString();
            }
        }
        return stringArray;
    }

    public AS400Server getConnection(int n, boolean bl) throws AS400SecurityException, IOException {
        return this.getConnection(n, bl, false);
    }

    AS400Server getConnection(int n, boolean bl, boolean bl2) throws AS400SecurityException, IOException {
        return this.getConnection(n, -1, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized AS400Server getConnection(int n, int n2, boolean bl, boolean bl2) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Establishing connection to system: " + AS400.getServerName(n));
        }
        if (!this.isPasswordTypeSet_ && !bl2) {
            this.signonConnect();
            this.signonDisconnect();
        }
        AS400Server aS400Server = null;
        Vector vector = this.serverPool_[n];
        Object object = vector;
        synchronized (object) {
            if (!bl && !vector.isEmpty()) {
                aS400Server = (AS400Server)vector.firstElement();
                if (Trace.traceOn_) {
                    Trace.log(1, "Reusing previous server object...");
                }
                return aS400Server;
            }
        }
        object = PortMapper.getServerSocket(this.systemNameLocal_ ? "localhost" : this.systemName_, n, n2, this.useSSLConnection_, this.socketProperties_, this.mustUseNetSockets_);
        int n3 = object.hashCode();
        String string = "";
        try {
            Object object2;
            InputStream inputStream = ((SocketContainer)object).getInputStream();
            OutputStream outputStream = ((SocketContainer)object).getOutputStream();
            byte[] byArray = null;
            int n4 = this.credVault_.getType();
            if (n == 5) {
                byte[] byArray2;
                byte[] byArray3;
                object2 = ClassDecoupler.connectDDMPhase1(outputStream, inputStream, this.passwordLevel_ >= 2, n4, n3);
                byte[] byArray4 = (byte[])object2[0];
                byte[] byArray5 = (byte[])object2[1];
                byArray = (byte[])object2[2];
                byte[] byArray6 = null;
                boolean bl3 = object2[3] != null;
                KeyPair keyPair = (KeyPair)object2[4];
                if (keyPair != null) {
                    try {
                        byArray6 = DDMTerm.getSharedKey(keyPair, byArray5);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        ServerStartupException serverStartupException = new ServerStartupException(1);
                        serverStartupException.initCause(generalSecurityException);
                        throw serverStartupException;
                    }
                }
                if (bl3) {
                    n4 = 4;
                    byArray3 = this.getEncryptedUserid(byArray6, byArray5);
                    byArray2 = this.getEncryptedPassword(byArray6, byArray5);
                } else {
                    byArray3 = SignonConverter.stringToByteArray(this.userId_);
                    byArray2 = this.getPassword(byArray4, byArray5);
                }
                if (PASSWORD_TRACE) {
                    Trace.log(0, "Sending DDM SECCHK request...");
                    Trace.log(1, "  User ID:", this.userId_);
                    Trace.log(1, "  User ID bytes:", byArray3);
                    Trace.log(1, "  Client seed:", byArray4);
                    Trace.log(1, "  Server seed:", byArray5);
                    Trace.log(1, "  Encrypted password:", byArray2);
                }
                byte[] byArray7 = null;
                if (this.ddmRDB_ != null) {
                    AS400Text aS400Text = new AS400Text(18, this.signonInfo_.serverCCSID);
                    byArray7 = aS400Text.toBytes(this.ddmRDB_);
                }
                ClassDecoupler.connectDDMPhase2(outputStream, inputStream, byArray3, byArray2, byArray7, n4, this.ddmRDB_, this.systemName_, n3);
            } else {
                int n5 = AS400Server.getServerId(n);
                AS400XChgRandSeedDS aS400XChgRandSeedDS = new AS400XChgRandSeedDS(n5);
                if (Trace.traceOn_) {
                    aS400XChgRandSeedDS.setConnectionID(n3);
                }
                aS400XChgRandSeedDS.write(outputStream);
                AS400XChgRandSeedReplyDS aS400XChgRandSeedReplyDS = new AS400XChgRandSeedReplyDS();
                if (Trace.traceOn_) {
                    aS400XChgRandSeedReplyDS.setConnectionID(n3);
                }
                aS400XChgRandSeedReplyDS.read(inputStream);
                if (aS400XChgRandSeedReplyDS.getRC() != 0) {
                    byte[] byArray8 = new byte[4];
                    BinaryConverter.intToByteArray(aS400XChgRandSeedReplyDS.getRC(), byArray8, 0);
                    Trace.log(2, "Exchange of random seeds failed with return code:", byArray8);
                    throw AS400ImplRemote.returnSecurityException(aS400XChgRandSeedReplyDS.getRC(), null, this.userId_);
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Exchange of random seeds successful.");
                }
                byte[] byArray9 = aS400XChgRandSeedDS.getClientSeed();
                byte[] byArray10 = aS400XChgRandSeedReplyDS.getServerSeed();
                if (bl2) {
                    this.passwordLevel_ = aS400XChgRandSeedReplyDS.getServerAttributes();
                }
                byte[] byArray11 = SignonConverter.stringToByteArray(this.userId_);
                byte[] byArray12 = this.getPassword(byArray9, byArray10);
                if (PASSWORD_TRACE) {
                    Trace.log(1, "Sending Start Server Request...");
                    Trace.log(1, "  User ID:", this.userId_);
                    Trace.log(1, "  User ID bytes:", byArray11);
                    Trace.log(1, "  Client seed:", byArray9);
                    Trace.log(1, "  Server seed:", byArray10);
                    Trace.log(1, "  Encrypted password:", byArray12);
                    Trace.log(1, "  Password level: ", this.passwordLevel_);
                }
                AS400StrSvrDS aS400StrSvrDS = new AS400StrSvrDS(n5, byArray11, byArray12, this.credVault_.getType());
                if (Trace.traceOn_) {
                    aS400StrSvrDS.setConnectionID(n3);
                }
                aS400StrSvrDS.write(outputStream);
                AS400StrSvrReplyDS aS400StrSvrReplyDS = new AS400StrSvrReplyDS();
                if (Trace.traceOn_) {
                    aS400StrSvrReplyDS.setConnectionID(n3);
                }
                aS400StrSvrReplyDS.read(inputStream);
                if (aS400StrSvrReplyDS.getRC() != 0) {
                    byte[] byArray13 = new byte[4];
                    BinaryConverter.intToByteArray(aS400StrSvrReplyDS.getRC(), byArray13, 0);
                    Trace.log(2, "Start server failed with return code:", byArray13);
                    throw AS400ImplRemote.returnSecurityException(aS400StrSvrReplyDS.getRC(), null, this.userId_);
                }
                byArray = aS400StrSvrReplyDS.getJobNameBytes();
            }
            object2 = ConverterImplRemote.getConverter(37, this);
            string = AS400BidiTransform.SQL_statement_reordering(string, this.bidiStringType, ((ConverterImplRemote)object2).table_.bidiStringType_);
            string = ((ConverterImplRemote)object2).byteArrayToString(byArray, 0, byArray.length, ((ConverterImplRemote)object2).table_.bidiStringType_);
            if (Trace.traceOn_) {
                Trace.log(1, "System job:", string);
            }
        }
        catch (IOException iOException) {
            AS400ImplRemote.forceDisconnect(iOException, aS400Server, (SocketContainer)object);
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            AS400ImplRemote.forceDisconnect(aS400SecurityException, aS400Server, (SocketContainer)object);
            throw aS400SecurityException;
        }
        catch (RuntimeException runtimeException) {
            AS400ImplRemote.forceDisconnect(runtimeException, aS400Server, (SocketContainer)object);
            throw runtimeException;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Server started successfully.");
        }
        aS400Server = this.threadUsed_ ? new AS400ThreadedServer(this, n, (SocketContainer)object, string) : new AS400NoThreadServer(this, n, (SocketContainer)object, string);
        vector.addElement(aS400Server);
        this.fireConnectEvent(true, n);
        return aS400Server;
    }

    private static void forceDisconnect(Exception exception, AS400Server aS400Server, SocketContainer socketContainer) {
        Trace.log(2, "Establishing connection failed:", (Throwable)exception);
        if (aS400Server != null) {
            try {
                aS400Server.forceDisconnect();
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error closing socket:", throwable);
            }
        } else if (socketContainer != null) {
            try {
                socketContainer.close();
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error closing socket:", throwable);
            }
        }
    }

    String getNLV() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting NLV implementation:", this.clientNlv_);
        }
        return this.clientNlv_;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] getPassword(byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        byte[] byArray3;
        block19: {
            int n = this.credVault_.getType();
            if (n == 1) {
                try {
                    byte[] byArray4;
                    if (this.gssCredential_ == null) {
                        byArray4 = TokenManager.getGSSToken(this.systemName_, this.gssName_);
                        return byArray4;
                    }
                    byArray4 = TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                    return byArray4;
                }
                catch (Throwable throwable) {
                    Trace.log(2, "Error retrieving GSSToken:", throwable);
                    throw new AS400SecurityException(62, throwable);
                }
            }
            if (n == 2) return this.credVault_.getClearCredential();
            if (n == 3) {
                return this.credVault_.getClearCredential();
            }
            byArray3 = null;
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieving encrypted password.");
            }
            if (this.credVault_.isEmpty()) {
                if (!this.mustUseSuppliedProfile_ && AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification()))) {
                    byArray3 = CurrentUser.getUserInfo(AS400.nativeVRM.getVersionReleaseModification(), byArray, byArray2, this.userId_);
                    Trace.log(1, "  encrypted password retrieved");
                    break block19;
                } else {
                    Trace.log(2, "Password is null.");
                    throw new AS400SecurityException(22);
                }
            }
            byte[] byArray5 = SignonConverter.stringToByteArray(this.userId_);
            char[] cArray = BinaryConverter.byteArrayToCharArray(this.credVault_.getClearCredential());
            if (PASSWORD_TRACE) {
                Trace.log(1, "  user ID:", this.userId_);
                Trace.log(1, "  user ID EBCDIC:", byArray5);
                Trace.log(1, "  password untwiddled: '" + new String(cArray) + "'");
                Trace.log(1, "  client seed: ", byArray);
                Trace.log(1, "  server seed: ", byArray2);
            }
            if (this.passwordLevel_ < 2) {
                void var6_9;
                if (cArray.length > 0 && Character.isDigit(cArray[0])) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Prepending Q to numeric password.");
                    }
                    char[] cArray2 = new char[cArray.length + 1];
                    cArray2[0] = 81;
                    System.arraycopy(cArray, 0, cArray2, 1, cArray.length);
                    char[] cArray3 = cArray2;
                }
                if (((void)var6_9).length > 10) {
                    Trace.log(2, "Length of parameter 'password' is not valid:", ((void)var6_9).length);
                    throw new AS400SecurityException(10);
                }
                byte[] byArray6 = SignonConverter.stringToByteArray(new String((char[])var6_9).toUpperCase());
                if (PASSWORD_TRACE) {
                    Trace.log(1, "  password in ebcdic: ", byArray6);
                }
                byArray3 = AS400ImplRemote.encryptPassword(byArray5, byArray6, byArray, byArray2);
            } else {
                byte[] byArray7 = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(byArray5));
                if (cArray.length == 0) {
                    Trace.log(2, "Parameter 'password' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (cArray[0] == '*') {
                    Trace.log(2, "Parameter 'password' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                byte[] byArray8 = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(cArray));
                byte[] byArray9 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                if (PASSWORD_TRACE) {
                    Trace.log(1, "Pre SHA-1 userIdBytes:", byArray7);
                    Trace.log(1, "Pre SHA-1 passwordBytes:", byArray8);
                    Trace.log(1, "Pre SHA-1 sequence:", byArray9);
                }
                byte[] byArray10 = AS400ImplRemote.generateShaToken(byArray7, byArray8);
                byArray3 = AS400ImplRemote.generateShaSubstitute(byArray10, byArray2, byArray, byArray7, byArray9);
            }
        }
        if (!PASSWORD_TRACE) return byArray3;
        Trace.log(1, "Encrypted password: ", byArray3);
        return byArray3;
    }

    public static byte[] getAESEncryptionKey(byte[] byArray) throws NoSuchAlgorithmException, AS400SecurityException {
        Object object;
        Object[] objectArray;
        Object object2;
        Object[] objectArray2;
        Object object3;
        try {
            object3 = Class.forName("javax.crypto.Cipher");
            objectArray2 = new Class[]{Class.forName("java.lang.String")};
            object2 = ((Class)object3).getMethod("getMaxAllowedKeyLength", (Class<?>[])objectArray2);
            objectArray = new Object[]{"AES"};
            object = (Integer)((Method)object2).invoke(null, objectArray);
            int n = (Integer)object;
            if (n < 256) {
                String string = "THE MAX AES KEY LENGTH IS " + n + " AND MUST BE >= 256.  UPDATE THE JVM (" + System.getProperty("java.vm.info") + ") AT " + System.getProperty("java.home") + " WITH JCE";
                throw new AS400SecurityException(27, (Throwable)new Exception(string));
            }
        }
        catch (Exception exception) {
            throw new AS400SecurityException(27, (Throwable)exception);
        }
        object3 = new byte[32];
        objectArray2 = new byte[32];
        System.arraycopy(byArray, 0, object3, 0, 32);
        System.arraycopy(byArray, 32, objectArray2, 0, 32);
        object2 = MessageDigest.getInstance("SHA-1");
        ((MessageDigest)object2).reset();
        objectArray = ((MessageDigest)object2).digest((byte[])object3);
        ((MessageDigest)object2).reset();
        object = ((MessageDigest)object2).digest((byte[])objectArray2);
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray2[i] = (byte)(objectArray[12 + i] ^ object[i]);
        }
        byte[] byArray3 = new byte[32];
        System.arraycopy(objectArray, 0, byArray3, 0, 12);
        System.arraycopy(byArray2, 0, byArray3, 12, 8);
        System.arraycopy(object, 8, byArray3, 20, 12);
        return byArray3;
    }

    private byte[] getEncryptedUserid(byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        byte[] byArray3 = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving encrypted userid.");
        }
        if (this.credVault_.isEmpty()) {
            if (!this.mustUseSuppliedProfile_ && AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification()))) {
                Trace.log(1, "  encrypted password retrieved");
                throw new AS400SecurityException(22);
            }
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        byte[] byArray4 = SignonConverter.stringToByteArray(this.userId_);
        if (PASSWORD_TRACE) {
            Trace.log(1, "  user ID:", this.userId_);
            Trace.log(1, "  user ID EBCDIC:", byArray4);
            Trace.log(1, "  sharedPrivateKey: ", byArray);
            Trace.log(1, "  server seed: ", byArray2);
        }
        if (byArray4.length > 10) {
            Trace.log(2, "Length of parameter 'userId' is not valid:", byArray4.length);
            throw new AS400SecurityException(29);
        }
        try {
            if (byArray.length == 32) {
                byte[] byArray5 = new byte[8];
                System.arraycopy(byArray, 12, byArray5, 0, 8);
                Trace.log(1, "  sharedPrivateKey: ", byArray5);
                boolean bl = DESKeySpec.isParityAdjusted(byArray5, 0);
                Trace.log(1, "  isParityAdjusted: ", bl);
                Trace.log(1, "  sharedPrivateKey(parity): ", byArray5);
                Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
                DESKeySpec dESKeySpec = new DESKeySpec(byArray5);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
                SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
                byte[] byArray6 = new byte[8];
                System.arraycopy(byArray2, 12, byArray6, 0, 8);
                cipher.init(1, (Key)secretKey, new IvParameterSpec(byArray6));
                Trace.log(1, "  initalizationVector: ", byArray6);
                byArray3 = cipher.doFinal(byArray4);
                Trace.log(1, "  encryptedUserid: ", byArray3);
            } else {
                byArray3 = AS400ImplRemote.encryptAES(byArray, byArray2, byArray4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AS400SecurityException(47, (Throwable)exception);
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "Encrypted userid: ", byArray3);
        }
        return byArray3;
    }

    public static byte[] encryptAES(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NoSuchAlgorithmException, NoSuchPaddingException, AS400SecurityException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKey secretKey;
        Object object;
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] byArray4 = AS400ImplRemote.getAESEncryptionKey(byArray);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "AES");
        try {
            object = SecretKeyFactory.getInstance("AES");
            secretKey = ((SecretKeyFactory)object).generateSecret(secretKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            secretKey = secretKeySpec;
        }
        object = new byte[16];
        System.arraycopy(byArray2, 24, object, 0, 16);
        cipher.init(1, (Key)secretKey, new IvParameterSpec((byte[])object));
        byte[] byArray5 = cipher.doFinal(byArray3);
        return byArray5;
    }

    private byte[] getEncryptedPassword(byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        int n = this.credVault_.getType();
        if (n == 1) {
            try {
                return this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error retrieving GSSToken:", throwable);
                throw new AS400SecurityException(62, throwable);
            }
        }
        if (n == 2 || n == 3) {
            return this.credVault_.getClearCredential();
        }
        byte[] byArray3 = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving encrypted password.");
        }
        if (this.credVault_.isEmpty()) {
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        byte[] byArray4 = SignonConverter.stringToByteArray(this.userId_);
        Object[] objectArray = BinaryConverter.byteArrayToCharArray(this.credVault_.getClearCredential());
        if (PASSWORD_TRACE) {
            Trace.log(1, "  user ID:", this.userId_);
            Trace.log(1, "  user ID EBCDIC:", byArray4);
            Trace.log(1, "  password untwiddled: '" + new String((char[])objectArray) + "'");
            Trace.log(1, "  server seed: ", byArray2);
        }
        try {
            Object[] objectArray2;
            if (objectArray.length > 0 && Character.isDigit(objectArray[0])) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Prepending Q to numeric password.");
                }
                objectArray2 = new char[objectArray.length + 1];
                objectArray2[0] = 81;
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                objectArray = objectArray2;
            }
            objectArray2 = SignonConverter.stringToByteArray(new String((char[])objectArray));
            if (PASSWORD_TRACE) {
                Trace.log(1, "  password in ebcdic: ", objectArray2);
            }
            if (byArray.length == 32) {
                Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
                byte[] byArray5 = new byte[8];
                System.arraycopy(byArray, 12, byArray5, 0, 8);
                Trace.log(1, "  sharedPrivateKey: ", byArray5);
                DESKeySpec dESKeySpec = new DESKeySpec(byArray5);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
                SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
                byte[] byArray6 = new byte[8];
                System.arraycopy(byArray2, 12, byArray6, 0, 8);
                cipher.init(1, (Key)secretKey, new IvParameterSpec(byArray6));
                byArray3 = cipher.doFinal((byte[])objectArray2);
            } else {
                if (objectArray.length == 0) {
                    Trace.log(2, "Parameter 'password' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (objectArray[0] == '*') {
                    Trace.log(2, "Parameter 'password' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                byArray3 = AS400ImplRemote.encryptAES(byArray, byArray2, objectArray2);
            }
        }
        catch (Exception exception) {
            throw new AS400SecurityException(47, (Throwable)exception);
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "Encrypted password: ", byArray3);
        }
        return byArray3;
    }

    public int getServicePort(String string, int n) {
        return PortMapper.getServicePort(string, n, this.useSSLConnection_);
    }

    String getLanguageLibrary() {
        return this.languageLibrary_;
    }

    public String getSystemName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation system name: " + this.systemName_ + " is local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_ ? "localhost" : this.systemName_;
    }

    String getUserId() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation user ID:", this.userId_);
        }
        return this.userId_;
    }

    int getVRM() {
        if (this.signonInfo_ == null) {
            return 459008;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation VRM.");
        }
        int n = this.signonInfo_.version.getVersionReleaseModification();
        if (Trace.traceOn_) {
            byte[] byArray = new byte[4];
            BinaryConverter.intToByteArray(n, byArray, 0);
            Trace.log(1, "Implementation VRM:", byArray);
        }
        return n;
    }

    public boolean getPasswordType() {
        return this.passwordLevel_ >= 2;
    }

    public int getPasswordLevel() {
        return this.passwordLevel_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected(int n) {
        Vector vector;
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for service connection implementation:", n);
        }
        if (n == 7) {
            return this.signonServer_ != null;
        }
        Vector vector2 = vector = this.serverPool_[n];
        synchronized (vector2) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                if (!((AS400Server)vector.elementAt(i)).isConnected()) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isConnectionAlive() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking connection's current alive status");
        }
        if (this.getVRM() < 459008) {
            Trace.log(1, "The IBM i version is V6R1 or lower, therefore isConnectionAlive() defaults to the behavior of isConnected().");
            return this.isConnected(0) || this.isConnected(1) || this.isConnected(2) || this.isConnected(3) || this.isConnected(4) || this.isConnected(5) || this.isConnected(6) || this.isConnected(7);
        }
        boolean bl = false;
        try {
            AS400Server aS400Server = null;
            if (this.priorService_ != -1 && (this.priorService_ == 1 || this.priorService_ == 2 || this.priorService_ == 3 || this.priorService_ == 4 || this.priorService_ == 6 || this.priorService_ == 7)) {
                aS400Server = this.getConnectedServer(new int[]{this.priorService_});
            }
            if (aS400Server == null) {
                aS400Server = this.getConnectedServer(new int[]{7, 2, 4, 1, 3, 6});
            }
            if (aS400Server != null) {
                if (this.signonPingRequest_ == null) {
                    this.signonPingRequest_ = new SignonPingReq();
                }
                aS400Server.sendAndDiscardReply(this.signonPingRequest_);
                bl = true;
                this.priorService_ = aS400Server.getService();
            }
            if (aS400Server == null && (aS400Server = this.getConnectedServer(new int[]{0})) != null) {
                if (this.ifsPingRequest_ == null) {
                    this.ifsPingRequest_ = new IFSPingReq();
                }
                DataStream dataStream = aS400Server.sendAndReceive(this.ifsPingRequest_);
                bl = true;
                this.priorService_ = aS400Server.getService();
            }
            if (aS400Server == null && this.isConnected(5)) {
                Trace.log(1, "For the RECORDACCESS service, isConnectionAlive() defaults to the behavior of isConnected().");
                bl = true;
            }
            if (aS400Server == null) {
                this.priorService_ = -1;
            }
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(1, exception);
            }
            bl = false;
        }
        if (!bl) {
            this.priorService_ = -1;
        }
        return bl;
    }

    public boolean isConnectionAlive(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking service connection's current alive status:", n);
        }
        if (!this.isConnected(n)) {
            return false;
        }
        if (this.getVRM() < 459008) {
            Trace.log(1, "The IBM i version is V6R1 or lower, therefore isConnectionAlive() defaults to the behavior of isConnected().");
            return this.isConnected(n);
        }
        boolean bl = false;
        try {
            AS400Server aS400Server = this.getConnectedServer(new int[]{n});
            if (aS400Server != null) {
                if (n == 5) {
                    Trace.log(1, "For the RECORDACCESS service, isConnectionAlive() defaults to the behavior of isConnected().");
                    bl = true;
                } else if (n == 0) {
                    if (this.ifsPingRequest_ == null) {
                        this.ifsPingRequest_ = new IFSPingReq();
                    }
                    DataStream dataStream = aS400Server.sendAndReceive(this.ifsPingRequest_);
                    bl = true;
                } else {
                    if (this.signonPingRequest_ == null) {
                        this.signonPingRequest_ = new SignonPingReq();
                    }
                    aS400Server.sendAndDiscardReply(this.signonPingRequest_);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(1, exception);
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AS400Server getConnectedServer(int[] nArray) {
        AS400Server aS400Server = null;
        for (int i = 0; i < nArray.length && aS400Server == null; ++i) {
            Vector vector;
            int n = nArray[i];
            if (n == 7) {
                aS400Server = this.signonServer_;
                continue;
            }
            Vector vector2 = vector = this.serverPool_[n];
            synchronized (vector2) {
                for (int j = vector.size() - 1; j >= 0 && aS400Server == null; --j) {
                    if (!((AS400Server)vector.elementAt(j)).isConnected()) continue;
                    aS400Server = (AS400Server)vector.elementAt(j);
                }
                continue;
            }
        }
        return aS400Server;
    }

    boolean isMissingPTF() {
        return this.detectedMissingPTF_;
    }

    boolean isMustAddLanguageLibrary() {
        return this.mustAddLanguageLibrary_;
    }

    boolean isSkipFurtherSettingOfLanguageLibrary() {
        return this.skipFurtherSettingOfLanguageLibrary_;
    }

    boolean isThreadUsed() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking implementation if thread is used:", this.threadUsed_);
        }
        return this.threadUsed_;
    }

    Object loadImpl(String string, String string2) {
        Object object;
        if (this.canUseNativeOptimization_) {
            object = AS400.loadImpl(string);
            if (object != null) {
                return object;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + string + "' failed, attempting to load remote implementation.");
            }
        }
        if ((object = AS400.loadImpl(string2)) != null) {
            return object;
        }
        Trace.log(1, "Load of remote implementation '" + string2 + "' failed.");
        throw new ExtendedIllegalStateException(string2, 11);
    }

    public void newConverter(int n) throws UnsupportedEncodingException {
        ConverterImplRemote.getConverter(n, this);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing implementation connection listener.");
        }
        this.dispatcher_ = null;
    }

    static AS400SecurityException returnSecurityExceptionX(int n) throws ServerStartupException {
        return AS400ImplRemote.returnSecurityException(n, null, null);
    }

    static AS400SecurityException returnSecurityException(int n, AS400Message[] aS400MessageArray, String string) throws ServerStartupException {
        int n2 = 0;
        switch (n) {
            case 65537: {
                throw new ServerStartupException(5);
            }
            case 65538: {
                throw new ServerStartupException(16);
            }
            case 65539: {
                throw new ServerStartupException(6);
            }
            case 65540: {
                throw new ServerStartupException(7);
            }
            case 65541: {
                throw new ServerStartupException(8);
            }
            case 65542: {
                throw new ServerStartupException(9);
            }
            case 65543: {
                n2 = 29;
                break;
            }
            case 65544: {
                n2 = 10;
                break;
            }
            case 65545: {
                throw new ServerStartupException(14);
            }
            case 65546: {
                throw new ServerStartupException(14);
            }
            case 65547: {
                n2 = 26;
                break;
            }
            case 65548: {
                n2 = 5;
                break;
            }
            case 65549: {
                n2 = 23;
                break;
            }
            case 65550: {
                return new AS400SecurityException(16, aS400MessageArray);
            }
            case 65551: {
                return new AS400SecurityException(41, aS400MessageArray);
            }
            case 65552: {
                n2 = 42;
                break;
            }
            case 65553: {
                return new AS400SecurityException(43, aS400MessageArray);
            }
            case 65554: {
                n2 = 42;
                break;
            }
            case 131073: {
                n2 = 32;
                break;
            }
            case 131074: {
                n2 = 31;
                break;
            }
            case 131075: {
                n2 = 64;
                break;
            }
            case 196609: {
                n2 = 19;
                break;
            }
            case 196610: {
                n2 = 20;
                break;
            }
            case 196611: {
                n2 = 18;
                break;
            }
            case 196612: {
                n2 = 11;
                break;
            }
            case 196613: {
                n2 = 12;
                break;
            }
            case 196614: {
                n2 = 17;
                break;
            }
            case 196615: {
                n2 = 15;
                break;
            }
            case 196616: {
                n2 = 44;
                break;
            }
            case 196617: {
                n2 = 13;
                break;
            }
            case 196618: {
                n2 = 21;
                break;
            }
            case 196619: {
                n2 = 8;
                break;
            }
            case 196620: {
                n2 = 9;
                break;
            }
            case 196621: {
                n2 = 7;
                break;
            }
            case 196622: {
                n2 = 45;
                break;
            }
            case 196623: {
                n2 = 39;
                break;
            }
            case 196624: {
                n2 = 46;
                break;
            }
            case 196625: {
                n2 = 65;
                break;
            }
            case 196626: {
                n2 = 77;
                break;
            }
            case 196627: {
                n2 = 78;
                break;
            }
            case 262144: {
                n2 = 24;
                break;
            }
            case 262145: {
                throw new ServerStartupException(17);
            }
            case 262146: {
                throw new ServerStartupException(18);
            }
            case 262147: {
                throw new ServerStartupException(19);
            }
            case 262148: {
                throw new ServerStartupException(20);
            }
            case 262149: {
                throw new ServerStartupException(21);
            }
            case 262150: {
                throw new ServerStartupException(22);
            }
            case 262151: {
                throw new ServerStartupException(23);
            }
            case 262152: {
                throw new ServerStartupException(24);
            }
            case 262153: {
                throw new ServerStartupException(25);
            }
            case 262154: {
                throw new ServerStartupException(26);
            }
            case 262155: {
                throw new ServerStartupException(27);
            }
            case 262156: {
                throw new ServerStartupException(28);
            }
            case 262157: {
                throw new ServerStartupException(29);
            }
            case 262158: {
                n2 = 66;
                break;
            }
            case 262159: {
                n2 = 71;
                break;
            }
            case 262160: {
                n2 = 72;
                break;
            }
            case 262161: {
                n2 = 73;
                break;
            }
            case 262162: {
                n2 = 74;
                break;
            }
            case 262163: {
                n2 = 75;
                break;
            }
            case 262164: {
                n2 = 76;
                break;
            }
            case 327681: {
                n2 = 33;
                break;
            }
            case 327682: {
                n2 = 34;
                break;
            }
            case 327683: {
                n2 = 36;
                break;
            }
            case 327684: {
                n2 = 35;
                break;
            }
            case 393217: {
                n2 = 47;
                break;
            }
            case 393218: {
                n2 = 48;
                break;
            }
            case 393219: {
                n2 = 49;
                break;
            }
            case 393220: {
                n2 = 50;
                break;
            }
            case 393221: {
                n2 = 51;
                break;
            }
            case 393222: {
                n2 = 52;
                break;
            }
            case 393223: {
                n2 = 53;
                break;
            }
            case 393224: {
                n2 = 54;
                break;
            }
            case 393225: {
                n2 = 55;
                break;
            }
            case 393226: {
                n2 = 56;
                break;
            }
            case 393227: {
                n2 = 52;
                break;
            }
            case 393228: {
                n2 = 58;
                break;
            }
            case 393229: {
                n2 = 59;
                break;
            }
            case 393230: {
                n2 = 60;
                break;
            }
            case 393231: {
                n2 = 61;
                break;
            }
            case 458753: {
                n2 = 67;
                break;
            }
            case 458754: {
                n2 = 68;
                break;
            }
            case 458755: {
                n2 = 69;
                break;
            }
            case 458756: {
                n2 = 70;
                break;
            }
            default: {
                n2 = 27;
            }
        }
        if (string != null) {
            return new AS400SecurityException(n2, aS400MessageArray, string);
        }
        return new AS400SecurityException(n2, aS400MessageArray);
    }

    static AS400Message[] parseMessages(byte[] byArray, int n, ConverterImplRemote converterImplRemote) throws IOException {
        int n2 = n;
        int n3 = 0;
        while (n < byArray.length - 1) {
            if (BinaryConverter.byteArrayToShort(byArray, n + 4) != 4394) {
                n += BinaryConverter.byteArrayToInt(byArray, n);
                continue;
            }
            n3 = BinaryConverter.byteArrayToShort(byArray, n + 6);
            break;
        }
        if (n3 == 0) {
            return null;
        }
        AS400Message[] aS400MessageArray = new AS400Message[n3];
        n = n2;
        for (int i = 0; i < n3; ++i) {
            while (n < byArray.length - 1) {
                if (BinaryConverter.byteArrayToShort(byArray, n + 4) != 4395) {
                    n += BinaryConverter.byteArrayToInt(byArray, n);
                    continue;
                }
                aS400MessageArray[i] = AS400ImplRemote.parseMessage(byArray, n + 6, converterImplRemote);
                break;
            }
            n += BinaryConverter.byteArrayToInt(byArray, n);
        }
        return aS400MessageArray;
    }

    static AS400Message parseMessage(byte[] byArray, int n, ConverterImplRemote converterImplRemote) throws IOException {
        AS400Message aS400Message = new AS400Message();
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        aS400Message.setTextCcsid(n2);
        int n3 = BinaryConverter.byteArrayToInt(byArray, n += 4);
        aS400Message.setSubstitutionDataCcsid(n3);
        aS400Message.setSeverity(BinaryConverter.byteArrayToUnsignedShort(byArray, n += 4));
        int n4 = BinaryConverter.byteArrayToInt(byArray, n += 2);
        aS400Message.setType((byArray[n += 4] & 0xF) * 10 + (byArray[n + 1] & 0xF));
        int n5 = BinaryConverter.byteArrayToInt(byArray, n += n4);
        aS400Message.setID(converterImplRemote.byteArrayToString(byArray, n += 4, n5));
        int n6 = BinaryConverter.byteArrayToInt(byArray, n += n5);
        aS400Message.setFileName(converterImplRemote.byteArrayToString(byArray, n += 4, n6).trim());
        int n7 = BinaryConverter.byteArrayToInt(byArray, n += n6);
        aS400Message.setLibraryName(converterImplRemote.byteArrayToString(byArray, n += 4, n7).trim());
        int n8 = BinaryConverter.byteArrayToInt(byArray, n += n7);
        aS400Message.setText(converterImplRemote.byteArrayToString(byArray, n += 4, n8));
        int n9 = BinaryConverter.byteArrayToInt(byArray, n += n8);
        byte[] byArray2 = new byte[n9];
        System.arraycopy(byArray, n += 4, byArray2, 0, n9);
        aS400Message.setSubstitutionData(byArray2);
        int n10 = BinaryConverter.byteArrayToInt(byArray, n += n9);
        aS400Message.setHelp(converterImplRemote.byteArrayToString(byArray, n += 4, n10));
        return aS400Message;
    }

    public void setGSSCredential(Object object) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS credential into impl: '" + object + "'");
        }
        this.gssCredential_ = object;
    }

    void setMissingPTF() {
        this.detectedMissingPTF_ = true;
    }

    void setLanguageLibrary(String string) {
        this.languageLibrary_ = string;
    }

    void setSkipFurtherSettingOfLanguageLibrary() {
        this.skipFurtherSettingOfLanguageLibrary_ = true;
    }

    public void setServicePort(String string, int n, int n2) {
        PortMapper.setServicePort(string, n, n2, this.useSSLConnection_);
    }

    public void setServicePortsToDefault(String string) {
        PortMapper.setServicePortsToDefault(string);
    }

    public void setState(SSLOptions sSLOptions, boolean bl, boolean bl2, int n, String string, SocketProperties socketProperties, String string2, boolean bl3, boolean bl4, boolean bl5) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting up AS400 implementation object:");
            Trace.log(1, "  Enable SSL connections: " + sSLOptions);
            Trace.log(1, "  Native optimizations allowed:", bl);
            Trace.log(1, "  Use threaded communications:", bl2);
            Trace.log(1, "  User specified CCSID:", n);
            Trace.log(1, "  NLV:", string);
            Trace.log(1, "  Socket properties: " + socketProperties);
            Trace.log(1, "  DDM RDB:", string2);
            Trace.log(1, "  Must use net sockets:", bl3);
            Trace.log(1, "  Must use supplied profile:", bl4);
            Trace.log(1, "  Must add language library:", bl5);
        }
        this.useSSLConnection_ = sSLOptions;
        this.canUseNativeOptimization_ = bl;
        this.threadUsed_ = bl2;
        if (n != 0) {
            this.userOverrideCcsid_ = true;
            this.ccsid_ = n;
        }
        this.clientNlv_ = string;
        this.socketProperties_ = socketProperties;
        this.ddmRDB_ = string2;
        this.mustAddLanguageLibrary_ = bl5;
        this.mustUseNetSockets_ = bl3;
        this.mustUseSuppliedProfile_ = bl4;
    }

    private SignonInfo signon2(String string, boolean bl, String string2, byte[] byArray, int n) throws AS400SecurityException, IOException {
        CredentialVault credentialVault;
        if (byArray == null) {
            credentialVault = new PasswordVault();
        } else if (n == 1) {
            credentialVault = new GSSTokenVault(byArray);
        } else {
            byte[] byArray2 = CredentialVault.decode(this.proxySeed_, this.remoteSeed_, byArray);
            switch (n) {
                case 0: {
                    credentialVault = new PasswordVault(byArray2);
                    break;
                }
                case 2: {
                    credentialVault = new ProfileTokenVault(byArray2);
                    break;
                }
                case 3: {
                    credentialVault = new IdentityTokenVault(byArray2);
                    break;
                }
                default: {
                    Trace.log(2, "Unsupported byte type: " + n);
                    throw new InternalErrorException(6, n);
                }
            }
            credentialVault.storeEncodedUsingExternalSeeds(this.proxySeed_, this.remoteSeed_);
        }
        return this.signon(string, bl, string2, credentialVault, this.gssName_);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignonInfo signon(String string, boolean bl, String string2, CredentialVault credentialVault, String string3) throws AS400SecurityException, IOException {
        this.systemName_ = string;
        this.systemNameLocal_ = bl;
        this.userId_ = string2;
        this.gssName_ = string3;
        if (!credentialVault.equals(this.credVault_)) {
            this.credVault_.empty();
        }
        this.credVault_ = credentialVault;
        if (this.credVault_.getType() != 1) {
            this.credVault_.storeEncodedUsingInternalSeeds(this.proxySeed_, this.remoteSeed_);
        }
        this.proxySeed_ = null;
        this.remoteSeed_ = null;
        if (this.canUseNativeOptimization_) {
            byte[] byArray = new byte[12];
            byte[] byArray2 = new byte[12];
            Class<BinaryConverter> clazz = BinaryConverter.class;
            Class<GregorianCalendar> clazz2 = GregorianCalendar.class;
            Class<SignonInfo> clazz3 = SignonInfo.class;
            Class<NLSImplNative> clazz4 = NLSImplNative.class;
            Class<NLSImplRemote> clazz5 = NLSImplRemote.class;
            boolean bl2 = this.swapTo(byArray, byArray2);
            try {
                try {
                    byte[] byArray3 = AS400ImplNative.signonNative((byte[])SignonConverter.stringToByteArray(string2));
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(byArray3, 0), byArray3[2] - 1, byArray3[3], byArray3[4], byArray3[5], byArray3[6]);
                    this.signonInfo_ = new SignonInfo();
                    this.signonInfo_.currentSignonDate = gregorianCalendar;
                    this.signonInfo_.lastSignonDate = gregorianCalendar;
                    this.signonInfo_.expirationDate = BinaryConverter.byteArrayToInt(byArray3, 8) == 0 ? null : new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(byArray3, 8), byArray3[10] - 1, byArray3[11], byArray3[12], byArray3[13], byArray3[14]);
                    this.signonInfo_.version = AS400.nativeVRM;
                    this.signonInfo_.serverCCSID = this.getCcsidFromServer();
                }
                catch (NativeException nativeException) {
                    throw this.mapNativeSecurityException(nativeException);
                }
                Object var13_26 = null;
                if (!bl2) return this.signonInfo_;
            }
            catch (Throwable throwable) {
                Object var13_27 = null;
                if (!bl2) throw throwable;
                this.swapBack(byArray, byArray2);
                throw throwable;
            }
            this.swapBack(byArray, byArray2);
            return this.signonInfo_;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Opening a socket to verify security...");
        }
        this.signonConnect();
        try {
            Object object;
            int n;
            byte[] byArray;
            byte[] byArray4 = this.credVault_.getType() == 0 ? SignonConverter.stringToByteArray(string2) : null;
            byte[] byArray2 = byArray = this.credVault_.getType() == 1 ? this.credVault_.getClearCredential() : this.getPassword(this.clientSeed_, this.serverSeed_);
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Retrieve Signon Information Request...");
                Trace.log(1, "  User ID:", string2);
                Trace.log(1, "  User ID bytes:", byArray4);
                Trace.log(1, "  Client seed:", this.clientSeed_);
                Trace.log(1, "  Server seed:", this.serverSeed_);
                Trace.log(1, "  Encrypted password:", byArray);
            }
            SignonInfoReq signonInfoReq = new SignonInfoReq(byArray4, byArray, this.credVault_.getType(), this.serverLevel_);
            SignonInfoRep signonInfoRep = (SignonInfoRep)this.signonServer_.sendAndReceive(signonInfoReq);
            if (Trace.traceOn_) {
                Trace.log(1, "Read security validation reply...");
            }
            if ((n = signonInfoRep.getRC()) != 0) {
                byte[] byArray6 = new byte[4];
                BinaryConverter.intToByteArray(n, byArray6, 0);
                Trace.log(2, "Security validation failed with return code:", byArray6);
                throw AS400ImplRemote.returnSecurityException(n, signonInfoRep.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), string2);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Security validated successfully.");
            }
            this.signonInfo_ = new SignonInfo();
            this.signonInfo_.currentSignonDate = signonInfoRep.getCurrentSignonDate();
            this.signonInfo_.lastSignonDate = signonInfoRep.getLastSignonDate();
            this.signonInfo_.expirationDate = signonInfoRep.getExpirationDate();
            this.signonInfo_.PWDexpirationWarning = signonInfoRep.getPWDExpirationWarning();
            this.signonInfo_.version = this.version_;
            this.signonInfo_.serverCCSID = signonInfoRep.getServerCCSID();
            if (this.userId_.length() == 0 && (object = signonInfoRep.getUserIdBytes()) != null) {
                this.signonInfo_.userId = this.userId_ = SignonConverter.byteArrayToString((byte[])object);
            }
            if (DataStream.getDefaultConverter() == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Signon server reports CCSID:", this.signonInfo_.serverCCSID);
                }
                DataStream.setDefaultConverter(ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this));
            }
            object = ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this);
            this.signonJobString_ = ((ConverterImplRemote)object).byteArrayToString(this.signonJobBytes_, 0, this.signonJobBytes_.length, 0);
            this.signonServer_.setJobString(this.signonJobString_);
            if (!Trace.traceOn_) return this.signonInfo_;
            Trace.log(1, "Signon server job:", this.signonJobString_);
            return this.signonInfo_;
        }
        catch (IOException iOException) {
            Trace.log(2, "Signon failed:", (Throwable)iOException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw iOException;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Signon failed:", (Throwable)aS400SecurityException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw aS400SecurityException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignonInfo skipSignon(String string, boolean bl, String string2, CredentialVault credentialVault, String string3) throws AS400SecurityException, IOException {
        this.systemName_ = string;
        this.systemNameLocal_ = bl;
        this.userId_ = string2;
        this.gssName_ = string3;
        if (!credentialVault.equals(this.credVault_)) {
            this.credVault_.empty();
        }
        this.credVault_ = credentialVault;
        if (this.credVault_.getType() != 1) {
            this.credVault_.storeEncodedUsingInternalSeeds(this.proxySeed_, this.remoteSeed_);
        }
        this.proxySeed_ = null;
        this.remoteSeed_ = null;
        if (this.canUseNativeOptimization_) {
            byte[] byArray = new byte[12];
            byte[] byArray2 = new byte[12];
            Class<BinaryConverter> clazz = BinaryConverter.class;
            Class<GregorianCalendar> clazz2 = GregorianCalendar.class;
            Class<SignonInfo> clazz3 = SignonInfo.class;
            Class<NLSImplNative> clazz4 = NLSImplNative.class;
            Class<NLSImplRemote> clazz5 = NLSImplRemote.class;
            boolean bl2 = this.swapTo(byArray, byArray2);
            try {
                try {
                    byte[] byArray3 = AS400ImplNative.signonNative((byte[])SignonConverter.stringToByteArray(string2));
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(byArray3, 0), byArray3[2] - 1, byArray3[3], byArray3[4], byArray3[5], byArray3[6]);
                    this.signonInfo_ = new SignonInfo();
                    this.signonInfo_.currentSignonDate = gregorianCalendar;
                    this.signonInfo_.lastSignonDate = gregorianCalendar;
                    this.signonInfo_.expirationDate = BinaryConverter.byteArrayToInt(byArray3, 8) == 0 ? null : new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(byArray3, 8), byArray3[10] - 1, byArray3[11], byArray3[12], byArray3[13], byArray3[14]);
                    this.signonInfo_.version = AS400.nativeVRM;
                    this.signonInfo_.serverCCSID = this.getCcsidFromServer();
                }
                catch (NativeException nativeException) {
                    throw this.mapNativeSecurityException(nativeException);
                }
                Object var13_18 = null;
                if (!bl2) return this.signonInfo_;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                if (!bl2) throw throwable;
                this.swapBack(byArray, byArray2);
                throw throwable;
            }
            this.swapBack(byArray, byArray2);
            return this.signonInfo_;
        }
        try {
            if (Trace.traceOn_) {
                Trace.log(1, "Read security validation reply...");
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Security validated successfully.");
            }
            this.signonInfo_ = new SignonInfo();
            this.signonInfo_.currentSignonDate = null;
            this.signonInfo_.lastSignonDate = null;
            this.signonInfo_.expirationDate = null;
            this.signonInfo_.PWDexpirationWarning = -1;
            this.signonInfo_.version = new ServerVersion(459776);
            this.signonInfo_.serverCCSID = 37;
            this.signonInfo_.userId = this.userId_;
            if (DataStream.getDefaultConverter() == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Signon server reports CCSID:", this.signonInfo_.serverCCSID);
                }
                DataStream.setDefaultConverter(ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this));
            }
            this.signonInfo_ = null;
            return this.signonInfo_;
        }
        catch (IOException iOException) {
            Trace.log(2, "Signon failed:", (Throwable)iOException);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw iOException;
        }
    }

    private synchronized void signonConnect() throws AS400SecurityException, IOException {
        if (this.signonServer_ == null) {
            boolean bl = false;
            SocketContainer socketContainer = PortMapper.getServerSocket(this.systemNameLocal_ ? "localhost" : this.systemName_, 7, this.useSSLConnection_, this.socketProperties_, this.mustUseNetSockets_);
            this.signonServer_ = new AS400NoThreadServer(this, 7, socketContainer, "");
            int n = socketContainer.hashCode();
            try {
                block13: {
                    try {
                        InputStream inputStream = socketContainer.getInputStream();
                        OutputStream outputStream = socketContainer.getOutputStream();
                        this.clientSeed_ = this.credVault_.getType() == 0 ? BinaryConverter.longToByteArray(System.currentTimeMillis()) : null;
                        SignonExchangeAttributeReq signonExchangeAttributeReq = new SignonExchangeAttributeReq(this.clientSeed_);
                        if (Trace.traceOn_) {
                            signonExchangeAttributeReq.setConnectionID(n);
                        }
                        signonExchangeAttributeReq.write(outputStream);
                        SignonExchangeAttributeRep signonExchangeAttributeRep = new SignonExchangeAttributeRep();
                        if (Trace.traceOn_) {
                            signonExchangeAttributeRep.setConnectionID(n);
                        }
                        signonExchangeAttributeRep.read(inputStream);
                        if (signonExchangeAttributeRep.getRC() != 0) {
                            byte[] byArray = new byte[4];
                            BinaryConverter.intToByteArray(signonExchangeAttributeRep.getRC(), byArray, 0);
                            Trace.log(2, "Signon server exchange client/server attributes failed, return code:", byArray);
                            throw AS400ImplRemote.returnSecurityException(signonExchangeAttributeRep.getRC(), null, this.userId_);
                        }
                        this.version_ = new ServerVersion(signonExchangeAttributeRep.getServerVersion());
                        this.serverLevel_ = signonExchangeAttributeRep.getServerLevel();
                        this.passwordLevel_ = signonExchangeAttributeRep.getPasswordLevel();
                        this.isPasswordTypeSet_ = true;
                        this.serverSeed_ = signonExchangeAttributeRep.getServerSeed();
                        this.signonJobBytes_ = signonExchangeAttributeRep.getJobNameBytes();
                        bl = true;
                        if (Trace.traceOn_) {
                            if (PASSWORD_TRACE) {
                                Trace.log(1, "  Client seed:", this.clientSeed_);
                                Trace.log(1, "  Server seed:", this.serverSeed_);
                            }
                            byte[] byArray = new byte[4];
                            BinaryConverter.intToByteArray(this.version_.getVersionReleaseModification(), byArray, 0);
                            Trace.log(1, "  Server vrm:", byArray);
                            Trace.log(1, "  Server level: ", this.serverLevel_);
                        }
                        this.fireConnectEvent(true, 7);
                        if (!Trace.traceOn_) break block13;
                        Trace.log(1, "Socket opened successfully.");
                    }
                    catch (IOException iOException) {
                        Trace.log(2, "Signon server exchange client/server attributes failed:", (Throwable)iOException);
                        throw iOException;
                    }
                    catch (AS400SecurityException aS400SecurityException) {
                        Trace.log(2, "Signon server exchange client/server attributes failed:", (Throwable)aS400SecurityException);
                        throw aS400SecurityException;
                    }
                }
                Object var10_12 = null;
                if (!bl) {
                    this.signonServer_.forceDisconnect();
                    this.signonServer_ = null;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (!bl) {
                    this.signonServer_.forceDisconnect();
                    this.signonServer_ = null;
                }
                throw throwable;
            }
        }
    }

    private synchronized void signonDisconnect() {
        if (this.signonServer_ != null) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Sending end job data stream to signon server...");
                }
                SignonEndServerReq signonEndServerReq = new SignonEndServerReq();
                this.signonServer_.send(signonEndServerReq);
                this.signonServer_.forceDisconnect();
            }
            catch (IOException iOException) {
                Trace.log(2, "Error sending end job data stream to signon server:", (Throwable)iOException);
            }
            this.signonServer_ = null;
            this.fireConnectEvent(false, 7);
        }
    }

    boolean swapTo(byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        if (AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification()))) {
            return false;
        }
        if (this.credVault_.isEmpty()) {
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        try {
            byte[] byArray3 = this.credVault_.getClearCredential();
            if (byArray3[0] == 0 && byArray3[1] == 42) {
                Trace.log(2, "Parameter 'password' begins with a '*' character.");
                throw new AS400SecurityException(63);
            }
            AS400ImplNative.swapToNative((byte[])SignonConverter.stringToByteArray(this.userId_), (byte[])byArray3, (byte[])byArray, (byte[])byArray2);
        }
        catch (NativeException nativeException) {
            throw this.mapNativeSecurityException(nativeException);
        }
        return true;
    }

    void swapBack(byte[] byArray, byte[] byArray2) throws AS400SecurityException, IOException {
        try {
            AS400ImplNative.swapBackNative((byte[])byArray, (byte[])byArray2);
        }
        catch (NativeException nativeException) {
            throw this.mapNativeSecurityException(nativeException);
        }
    }

    private AS400SecurityException mapNativeSecurityException(NativeException nativeException) throws IOException {
        String string = ConverterImplRemote.getConverter(37, this).byteArrayToString(nativeException.data, 12, 7);
        if (string.equals("CPF2203") || string.equals("CPF2204")) {
            return new AS400SecurityException(32, this.userId_);
        }
        if (string.equals("CPF22E3")) {
            return new AS400SecurityException(31, this.userId_);
        }
        if (string.equals("CPF22E2") || string.equals("CPF22E5")) {
            return new AS400SecurityException(8, this.userId_);
        }
        if (string.equals("CPF22E4")) {
            return new AS400SecurityException(7, this.userId_);
        }
        return new AS400SecurityException(24, this.userId_);
    }

    private static byte[] encryptNewPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) {
        byte[] byArray8;
        byte[] byArray9 = new byte[8];
        byte[] byArray10 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] byArray11 = AS400ImplRemote.generateToken(byArray, byArray2);
        byte[] byArray12 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
        AS400ImplRemote.incrementString(byArray10);
        byte[] byArray13 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
        AS400ImplRemote.xORArray(byArray13, byArray3, byArray5);
        if (byArray5.length == 16) {
            byArray8 = new byte[8];
            AS400ImplRemote.incrementString(byArray10);
            byArray13 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
            for (int i = 0; i < 8; ++i) {
                byArray8[i] = 64;
            }
            byArray8[0] = byArray3[8];
            byArray8[1] = byArray3[9];
            byte[] byArray14 = new byte[8];
            AS400ImplRemote.xORArray(byArray13, byArray8, byArray14);
            System.arraycopy(byArray14, 0, byArray5, 8, 8);
        }
        byArray11 = AS400ImplRemote.generateToken(byArray, byArray3);
        AS400ImplRemote.incrementString(byArray10);
        byArray13 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
        AS400ImplRemote.xORArray(byArray13, byArray2, byArray4);
        if (byArray4.length == 16) {
            byArray8 = new byte[8];
            AS400ImplRemote.incrementString(byArray10);
            byArray13 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray11, byArray9, byArray10, byArray6, byArray7);
            for (int i = 0; i < 8; ++i) {
                byArray8[i] = 64;
            }
            byArray8[0] = byArray2[8];
            byArray8[1] = byArray2[9];
            byte[] byArray15 = new byte[8];
            AS400ImplRemote.xORArray(byArray13, byArray8, byArray15);
            System.arraycopy(byArray15, 0, byArray4, 8, 8);
        }
        return byArray12;
    }

    private static byte[] encryptPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] byArray6 = new byte[8];
        byte[] byArray7 = AS400ImplRemote.generateToken(byArray, byArray2);
        if (PASSWORD_TRACE) {
            Trace.log(1, "In encryptPassword, token: ", byArray7);
        }
        byte[] byArray8 = AS400ImplRemote.generatePasswordSubstitute(byArray, byArray7, byArray6, byArray5, byArray3, byArray4);
        if (PASSWORD_TRACE) {
            Trace.log(1, "In encryptPassword, encryptedPassword: ", byArray8);
        }
        return byArray8;
    }

    private static byte[] generatePasswordSubstitute(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        byte[] byArray7 = new byte[8];
        byte[] byArray8 = new byte[8];
        byte[] byArray9 = new byte[8];
        AS400ImplRemote.addArray(byArray4, byArray6, byArray7, 8);
        byArray9 = AS400ImplRemote.enc_des(byArray2, byArray7);
        AS400ImplRemote.xORArray(byArray9, byArray5, byArray8);
        byArray9 = AS400ImplRemote.enc_des(byArray2, byArray8);
        System.arraycopy(byArray9, 0, byArray3, 0, 8);
        AS400ImplRemote.xORArray(byArray, byArray7, byArray8);
        AS400ImplRemote.xORArray(byArray8, byArray9, byArray8);
        byArray9 = AS400ImplRemote.enc_des(byArray2, byArray8);
        for (int i = 0; i < 8; ++i) {
            byArray8[i] = 64;
        }
        byArray8[0] = byArray[8];
        byArray8[1] = byArray[9];
        AS400ImplRemote.xORArray(byArray7, byArray8, byArray8);
        AS400ImplRemote.xORArray(byArray8, byArray9, byArray8);
        byArray9 = AS400ImplRemote.enc_des(byArray2, byArray8);
        AS400ImplRemote.xORArray(byArray4, byArray9, byArray8);
        return AS400ImplRemote.enc_des(byArray2, byArray8);
    }

    private static byte[] generateToken(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[10];
        byte[] byArray5 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        byte[] byArray6 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        System.arraycopy(byArray, 0, byArray4, 0, 10);
        int n = AS400ImplRemote.ebcdicStrLen(byArray, 10);
        if (n > 8) {
            byArray4[0] = (byte)(byArray4[0] ^ byArray4[8] & 0xC0);
            byArray4[1] = (byte)(byArray4[1] ^ (byArray4[8] & 0x30) << 2);
            byArray4[2] = (byte)(byArray4[2] ^ (byArray4[8] & 0xC) << 4);
            byArray4[3] = (byte)(byArray4[3] ^ (byArray4[8] & 3) << 6);
            byArray4[4] = (byte)(byArray4[4] ^ byArray4[9] & 0xC0);
            byArray4[5] = (byte)(byArray4[5] ^ (byArray4[9] & 0x30) << 2);
            byArray4[6] = (byte)(byArray4[6] ^ (byArray4[9] & 0xC) << 4);
            byArray4[7] = (byte)(byArray4[7] ^ (byArray4[9] & 3) << 6);
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "In generateToken, folded user ID:", byArray4);
        }
        if ((n = AS400ImplRemote.ebcdicStrLen(byArray2, 10)) > 8) {
            System.arraycopy(byArray2, 0, byArray5, 0, 8);
            System.arraycopy(byArray2, 8, byArray6, 0, n - 8);
            AS400ImplRemote.xorWith0x55andLshift(byArray5);
            byArray5 = AS400ImplRemote.enc_des(byArray5, byArray4);
            AS400ImplRemote.xorWith0x55andLshift(byArray6);
            byArray6 = AS400ImplRemote.enc_des(byArray6, byArray4);
            AS400ImplRemote.xORArray(byArray5, byArray6, byArray3);
        } else {
            System.arraycopy(byArray2, 0, byArray5, 0, n);
            if (PASSWORD_TRACE) {
                Trace.log(1, "In generateToken, workBuffer2: ", byArray5);
            }
            AS400ImplRemote.xorWith0x55andLshift(byArray5);
            if (PASSWORD_TRACE) {
                Trace.log(1, "In generateToken, workBuffer2: ", byArray5);
            }
            byArray3 = AS400ImplRemote.enc_des(byArray5, byArray4);
        }
        return byArray3;
    }

    private static void addArray(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            int n3 = (byArray[i] & 0xFF) + (byArray2[i] & 0xFF) + n2;
            n2 = n3 >>> 8;
            byArray3[i] = (byte)n3;
        }
    }

    private static int ebcdicStrLen(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < n && byArray[n2] != 64 && byArray[n2] != 0; ++n2) {
        }
        return n2;
    }

    private static void incrementString(byte[] byArray) {
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        AS400ImplRemote.addArray(byArray, byArray2, byArray, 8);
    }

    private static void xORArray(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < 8; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    private static void xorWith0x55andLshift(byte[] byArray) {
        byArray[0] = (byte)(byArray[0] ^ 0x55);
        byArray[1] = (byte)(byArray[1] ^ 0x55);
        byArray[2] = (byte)(byArray[2] ^ 0x55);
        byArray[3] = (byte)(byArray[3] ^ 0x55);
        byArray[4] = (byte)(byArray[4] ^ 0x55);
        byArray[5] = (byte)(byArray[5] ^ 0x55);
        byArray[6] = (byte)(byArray[6] ^ 0x55);
        byArray[7] = (byte)(byArray[7] ^ 0x55);
        byArray[0] = (byte)(byArray[0] << 1 | (byArray[1] & 0x80) >>> 7);
        byArray[1] = (byte)(byArray[1] << 1 | (byArray[2] & 0x80) >>> 7);
        byArray[2] = (byte)(byArray[2] << 1 | (byArray[3] & 0x80) >>> 7);
        byArray[3] = (byte)(byArray[3] << 1 | (byArray[4] & 0x80) >>> 7);
        byArray[4] = (byte)(byArray[4] << 1 | (byArray[5] & 0x80) >>> 7);
        byArray[5] = (byte)(byArray[5] << 1 | (byArray[6] & 0x80) >>> 7);
        byArray[6] = (byte)(byArray[6] << 1 | (byArray[7] & 0x80) >>> 7);
        byArray[7] = (byte)(byArray[7] << 1);
    }

    private static byte[] enc_des(byte[] byArray, byte[] byArray2) {
        int n;
        if (PASSWORD_TRACE) {
            Trace.log(1, "In enc_des, key: ", byArray);
            Trace.log(1, "In enc_des, data: ", byArray2);
        }
        byte[] byArray3 = new byte[65];
        byte[] byArray4 = new byte[65];
        for (n = 0; n < 8; ++n) {
            byArray3[8 * n + 1] = (byte)((byArray2[n] & 0x80) == 0 ? 48 : 49);
            byArray3[8 * n + 2] = (byte)((byArray2[n] & 0x40) == 0 ? 48 : 49);
            byArray3[8 * n + 3] = (byte)((byArray2[n] & 0x20) == 0 ? 48 : 49);
            byArray3[8 * n + 4] = (byte)((byArray2[n] & 0x10) == 0 ? 48 : 49);
            byArray3[8 * n + 5] = (byte)((byArray2[n] & 8) == 0 ? 48 : 49);
            byArray3[8 * n + 6] = (byte)((byArray2[n] & 4) == 0 ? 48 : 49);
            byArray3[8 * n + 7] = (byte)((byArray2[n] & 2) == 0 ? 48 : 49);
            byArray3[8 * n + 8] = (byte)((byArray2[n] & 1) == 0 ? 48 : 49);
        }
        for (n = 0; n < 8; ++n) {
            byArray4[8 * n + 1] = (byte)((byArray[n] & 0x80) == 0 ? 48 : 49);
            byArray4[8 * n + 2] = (byte)((byArray[n] & 0x40) == 0 ? 48 : 49);
            byArray4[8 * n + 3] = (byte)((byArray[n] & 0x20) == 0 ? 48 : 49);
            byArray4[8 * n + 4] = (byte)((byArray[n] & 0x10) == 0 ? 48 : 49);
            byArray4[8 * n + 5] = (byte)((byArray[n] & 8) == 0 ? 48 : 49);
            byArray4[8 * n + 6] = (byte)((byArray[n] & 4) == 0 ? 48 : 49);
            byArray4[8 * n + 7] = (byte)((byArray[n] & 2) == 0 ? 48 : 49);
            byArray4[8 * n + 8] = (byte)((byArray[n] & 1) == 0 ? 48 : 49);
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "In enc_des, e1: ", byArray3);
            Trace.log(1, "In enc_des, e2: ", byArray4);
        }
        byte[] byArray5 = new byte[65];
        byte[] byArray6 = new byte[58];
        for (int i = 1; i <= 56; ++i) {
            byArray6[i] = byArray4[PC1[i - 1]];
        }
        AS400ImplRemote.lshift1(byArray6);
        byte[] byArray7 = new byte[49];
        for (int i = 1; i <= 48; ++i) {
            byArray7[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray8 = new byte[49];
        AS400ImplRemote.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray8[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray9 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray9[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray10 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray10[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray11 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray11[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray12 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray12[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray13 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray13[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray14 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray14[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray15 = new byte[49];
        AS400ImplRemote.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray15[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray16 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray16[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray17 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray17[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray18 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray18[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray19 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray19[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray20 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray20[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray21 = new byte[49];
        AS400ImplRemote.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray21[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray22 = new byte[49];
        AS400ImplRemote.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray22[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray23 = new byte[33];
        byte[] byArray24 = new byte[33];
        for (int i = 1; i <= 32; ++i) {
            byArray23[i] = byArray3[INITPERM[i - 1]];
            byArray24[i] = byArray3[INITPERM[i + 31]];
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "In enc_des, Ln: ", byArray23);
            Trace.log(1, "In enc_des, Rn: ", byArray24);
        }
        AS400ImplRemote.cipher(byArray7, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray8, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray9, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray10, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray11, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray12, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray13, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray14, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray15, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray16, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray17, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray18, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray19, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray20, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray21, byArray23, byArray24);
        AS400ImplRemote.cipher(byArray22, byArray23, byArray24);
        if (PASSWORD_TRACE) {
            Trace.log(1, "In enc_des, Ln: ", byArray23);
            Trace.log(1, "In enc_des, Rn: ", byArray24);
        }
        System.arraycopy(byArray24, 1, byArray5, 1, 32);
        System.arraycopy(byArray23, 1, byArray5, 33, 32);
        byte[] byArray25 = new byte[65];
        for (int i = 1; i <= 64; ++i) {
            byArray25[i] = byArray5[OUTPERM[i - 1]];
        }
        byte[] byArray26 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            if (byArray25[8 * i + 1] == 49) {
                int n2 = i;
                byArray26[n2] = (byte)(byArray26[n2] | 0x80);
            }
            if (byArray25[8 * i + 2] == 49) {
                int n3 = i;
                byArray26[n3] = (byte)(byArray26[n3] | 0x40);
            }
            if (byArray25[8 * i + 3] == 49) {
                int n4 = i;
                byArray26[n4] = (byte)(byArray26[n4] | 0x20);
            }
            if (byArray25[8 * i + 4] == 49) {
                int n5 = i;
                byArray26[n5] = (byte)(byArray26[n5] | 0x10);
            }
            if (byArray25[8 * i + 5] == 49) {
                int n6 = i;
                byArray26[n6] = (byte)(byArray26[n6] | 8);
            }
            if (byArray25[8 * i + 6] == 49) {
                int n7 = i;
                byArray26[n7] = (byte)(byArray26[n7] | 4);
            }
            if (byArray25[8 * i + 7] == 49) {
                int n8 = i;
                byArray26[n8] = (byte)(byArray26[n8] | 2);
            }
            if (byArray25[8 * i + 8] != 49) continue;
            int n9 = i;
            byArray26[n9] = (byte)(byArray26[n9] | 1);
        }
        return byArray26;
    }

    private static void cipher(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        byte[] byArray4 = new byte[49];
        byte[] byArray5 = new byte[49];
        byte[] byArray6 = new byte[33];
        byte[] byArray7 = new byte[33];
        int[] nArray = new int[9];
        int[] nArray2 = new int[9];
        for (n = 1; n <= 48; ++n) {
            byArray4[n] = byArray3[EPERM[n - 1]];
        }
        for (n = 1; n <= 48; ++n) {
            byArray5[n] = byArray4[n] != byArray[n] ? 49 : 48;
        }
        nArray[1] = (byArray5[1] == 49 ? 32 : 0) | (byArray5[6] == 49 ? 16 : 0) | (byArray5[2] == 49 ? 8 : 0) | (byArray5[3] == 49 ? 4 : 0) | (byArray5[4] == 49 ? 2 : 0) | (byArray5[5] == 49 ? 1 : 0);
        nArray[2] = (byArray5[7] == 49 ? 32 : 0) | (byArray5[12] == 49 ? 16 : 0) | (byArray5[8] == 49 ? 8 : 0) | (byArray5[9] == 49 ? 4 : 0) | (byArray5[10] == 49 ? 2 : 0) | (byArray5[11] == 49 ? 1 : 0);
        nArray[3] = (byArray5[13] == 49 ? 32 : 0) | (byArray5[18] == 49 ? 16 : 0) | (byArray5[14] == 49 ? 8 : 0) | (byArray5[15] == 49 ? 4 : 0) | (byArray5[16] == 49 ? 2 : 0) | (byArray5[17] == 49 ? 1 : 0);
        nArray[4] = (byArray5[19] == 49 ? 32 : 0) | (byArray5[24] == 49 ? 16 : 0) | (byArray5[20] == 49 ? 8 : 0) | (byArray5[21] == 49 ? 4 : 0) | (byArray5[22] == 49 ? 2 : 0) | (byArray5[23] == 49 ? 1 : 0);
        nArray[5] = (byArray5[25] == 49 ? 32 : 0) | (byArray5[30] == 49 ? 16 : 0) | (byArray5[26] == 49 ? 8 : 0) | (byArray5[27] == 49 ? 4 : 0) | (byArray5[28] == 49 ? 2 : 0) | (byArray5[29] == 49 ? 1 : 0);
        nArray[6] = (byArray5[31] == 49 ? 32 : 0) | (byArray5[36] == 49 ? 16 : 0) | (byArray5[32] == 49 ? 8 : 0) | (byArray5[33] == 49 ? 4 : 0) | (byArray5[34] == 49 ? 2 : 0) | (byArray5[35] == 49 ? 1 : 0);
        nArray[7] = (byArray5[37] == 49 ? 32 : 0) | (byArray5[42] == 49 ? 16 : 0) | (byArray5[38] == 49 ? 8 : 0) | (byArray5[39] == 49 ? 4 : 0) | (byArray5[40] == 49 ? 2 : 0) | (byArray5[41] == 49 ? 1 : 0);
        nArray[8] = (byArray5[43] == 49 ? 32 : 0) | (byArray5[48] == 49 ? 16 : 0) | (byArray5[44] == 49 ? 8 : 0) | (byArray5[45] == 49 ? 4 : 0) | (byArray5[46] == 49 ? 2 : 0) | (byArray5[47] == 49 ? 1 : 0);
        nArray2[1] = S1[nArray[1]];
        nArray2[2] = S2[nArray[2]];
        nArray2[3] = S3[nArray[3]];
        nArray2[4] = S4[nArray[4]];
        nArray2[5] = S5[nArray[5]];
        nArray2[6] = S6[nArray[6]];
        nArray2[7] = S7[nArray[7]];
        nArray2[8] = S8[nArray[8]];
        AS400ImplRemote.dectobin(nArray2[1], byArray6, 1);
        AS400ImplRemote.dectobin(nArray2[2], byArray6, 5);
        AS400ImplRemote.dectobin(nArray2[3], byArray6, 9);
        AS400ImplRemote.dectobin(nArray2[4], byArray6, 13);
        AS400ImplRemote.dectobin(nArray2[5], byArray6, 17);
        AS400ImplRemote.dectobin(nArray2[6], byArray6, 21);
        AS400ImplRemote.dectobin(nArray2[7], byArray6, 25);
        AS400ImplRemote.dectobin(nArray2[8], byArray6, 29);
        for (n = 1; n <= 32; ++n) {
            byArray7[n] = byArray6[PPERM[n - 1]];
        }
        byte[] byArray8 = new byte[33];
        System.arraycopy(byArray3, 1, byArray8, 1, 32);
        for (int i = 1; i <= 32; ++i) {
            byArray3[i] = byArray2[i] == byArray7[i] ? 48 : 49;
        }
        System.arraycopy(byArray8, 1, byArray2, 1, 32);
    }

    private static void dectobin(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 8) != 0 ? 49 : 48);
        byArray[n2 + 1] = (byte)((n & 4) != 0 ? 49 : 48);
        byArray[n2 + 2] = (byte)((n & 2) != 0 ? 49 : 48);
        byArray[n2 + 3] = (byte)((n & 1) != 0 ? 49 : 48);
    }

    private static void lshift1(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[29]};
        System.arraycopy(byArray, 2, byArray, 1, 27);
        System.arraycopy(byArray, 30, byArray, 29, 27);
        byArray[28] = byArray2[0];
        byArray[56] = byArray2[1];
    }

    private static void lshift2(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[2], byArray[29], byArray[30]};
        System.arraycopy(byArray, 3, byArray, 1, 27);
        System.arraycopy(byArray, 31, byArray, 29, 27);
        byArray[27] = byArray2[0];
        byArray[28] = byArray2[1];
        byArray[55] = byArray2[2];
        byArray[56] = byArray2[3];
    }

    public void setBidiStringType(int n) {
        this.bidiStringType = n;
    }

    public int getBidiStringType() {
        return this.bidiStringType;
    }

    public int createUserHandle2() throws AS400SecurityException, IOException {
        if (this.UserHandle2_ != -1) {
            return this.UserHandle2_;
        }
        ClientAccessDataStream clientAccessDataStream = null;
        AS400Server aS400Server = this.getConnectedServer(new int[]{0});
        if (aS400Server != null) {
            try {
                byte[] byArray = this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                IFSUserHandle2Req iFSUserHandle2Req = new IFSUserHandle2Req(byArray);
                clientAccessDataStream = (ClientAccessDataStream)aS400Server.sendAndReceive(iFSUserHandle2Req);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                try {
                    interruptedIOException.initCause(interruptedException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw interruptedIOException;
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error retrieving GSSToken:", throwable);
                throw new AS400SecurityException(62, throwable);
            }
            int n = 0;
            if (clientAccessDataStream instanceof IFSCreateUserHandleRep) {
                n = ((IFSCreateUserHandleRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSCreateUserHandleRep return code", n);
                }
                this.UserHandle2_ = ((IFSCreateUserHandleRep)clientAccessDataStream).getHandle();
            } else {
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n != 0) {
                        Trace.log(2, "IFSReturnCodeRep return code", n);
                    }
                    throw new ExtendedIOException(n);
                }
                Trace.log(2, "Unknown reply data stream", clientAccessDataStream.getReqRepID());
                throw new InternalErrorException(2, Integer.toHexString(clientAccessDataStream.getReqRepID()), null);
            }
        }
        this.setUserHandle(this.UserHandle2_);
        return this.UserHandle2_;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        AS400Server.addReplyStream((DataStream)new ChangePasswordRep(), 7);
        AS400Server.addReplyStream((DataStream)new AS400StrSvrReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new SignonGenAuthTokenReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new AS400GenAuthTknReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new AS400XChgRandSeedReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new SignonInfoRep(), 7);
        AS400Server.addReplyStream((DataStream)new SignonExchangeAttributeRep(), 7);
        AS400Server.addReplyStream((DataStream)new IFSUserHandleSeedRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSCreateUserHandleRep(), 0);
        EPERM = new int[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
        INITPERM = new int[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
        OUTPERM = new int[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
        PPERM = new int[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
        PC1 = new int[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
        PC2 = new int[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
        S1 = new int[]{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13};
        S2 = new int[]{15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9};
        S3 = new int[]{10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12};
        S4 = new int[]{7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14};
        S5 = new int[]{2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3};
        S6 = new int[]{12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13};
        S7 = new int[]{4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12};
        S8 = new int[]{13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11};
    }
}

