/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.rest;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.rest.HttpRequest;
import miworkplace.ui.rest.RequestPersistence;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.json.JSONObject;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class RestView {
    private final String EXECUTE_REQUEST_COMMAND_ID = "miworkplace.ui.rest.command.execute";
    @Inject
    private LogService logger;
    @Inject
    private IResourcePool imagePool;
    @Inject
    private RequestPersistence persistence;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    private Button addHeader;
    private Button addParameter;
    private List<Text[]> parameters = new ArrayList<Text[]>();
    private List<Text[]> headers = new ArrayList<Text[]>();
    private TextViewer requestBody;
    private FormToolkit toolkit;
    private Form form;
    private Composite inputPanel;
    private Composite headersPanel;
    private Composite parametersPanel;
    private CCombo method;
    private Text endpoint;
    private TextViewer outputViewer;
    private Composite requestBodyPanel;
    private Button addRequestBody;
    private Button execute;

    @PostConstruct
    public void postConstruct(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.form.setText("Calling Web Service");
        this.form.setImage(this.imagePool.getImageUnchecked("IMAGE_REST_API24"));
        this.form.setBackgroundImage(this.imagePool.getImageUnchecked("IMAGE_WIZARD"));
        this.form.getBody().setLayout((Layout)new FormLayout());
        this.form.getBody().setLayoutData((Object)new GridData(4, 4, true, true));
        this.inputPanel = this.toolkit.createComposite(this.form.getBody());
        this.buildInputPanel(this.form);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 15);
        layoutData.left = new FormAttachment((Control)this.inputPanel, 25, 131072);
        Label labelOutput = this.toolkit.createLabel(this.form.getBody(), Messages.rest_output);
        labelOutput.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)labelOutput, 10);
        layoutData.left = new FormAttachment((Control)labelOutput, 0, 16384);
        layoutData.right = new FormAttachment(100, -15);
        layoutData.bottom = new FormAttachment(100, -15);
        this.outputViewer = new TextViewer(this.form.getBody(), 2632);
        this.outputViewer.getControl().setLayoutData((Object)layoutData);
        this.outputViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        parent.layout();
    }

    @Focus
    private void focus() {
        this.endpoint.forceFocus();
        this.endpoint.selectAll();
    }

    private void buildInputPanel(Form form) {
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.right = new FormAttachment(40);
        layoutData.top = new FormAttachment(0);
        layoutData.bottom = new FormAttachment(100);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        this.inputPanel.setLayout((Layout)layout);
        this.inputPanel.setLayoutData((Object)layoutData);
        Label labelMethod = this.toolkit.createLabel(this.inputPanel, Messages.rest_method);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)labelMethod, 100, 131072);
        Label labelEndpoint = this.toolkit.createLabel(this.inputPanel, Messages.rest_endpoint);
        labelEndpoint.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)labelMethod, 10);
        layoutData.width = 125;
        this.method = new CCombo(this.inputPanel, 0x800800);
        this.method.setEditable(false);
        this.toolkit.adapt((Composite)this.method);
        this.toolkit.paintBordersFor((Composite)this.method);
        this.method.setItems(new String[]{"GET", "PUT", "POST", "OPTIONS", "HEAD", "DELETE"});
        this.method.setLayoutData((Object)layoutData);
        this.method.select(0);
        layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)labelEndpoint, 0, 16384);
        layoutData.bottom = new FormAttachment((Control)this.method, 0, 0x1000000);
        layoutData.right = new FormAttachment(100);
        this.endpoint = this.toolkit.createText(this.inputPanel, "http://", 2048);
        this.endpoint.setLayoutData((Object)layoutData);
        this.endpoint.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    RestView.this.executeRequest();
                }
                super.keyReleased(e);
            }
        });
        this.buildRequestBodySection(this.toolkit, this.inputPanel, (Control)this.method);
        this.buildHeaderSection(this.toolkit, this.inputPanel, (Control)this.addRequestBody);
        this.buildParameterSection(this.toolkit, this.inputPanel, (Control)this.addHeader);
        this.buildExecuteButton(this.toolkit, this.inputPanel);
        this.inputPanel.layout();
    }

    private void buildRequestBodySection(FormToolkit toolkit, final Composite parent, Control controlAbove) {
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(controlAbove, 0, 16384);
        layoutData.right = new FormAttachment(100);
        layoutData.top = new FormAttachment(controlAbove, 25);
        this.requestBodyPanel = toolkit.createComposite(parent);
        this.requestBodyPanel.setLayoutData((Object)layoutData);
        GridLayout panelLayout = new GridLayout(1, false);
        this.requestBodyPanel.setLayout((Layout)panelLayout);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(controlAbove, 0, 16384);
        layoutData.top = new FormAttachment((Control)this.requestBodyPanel, 5);
        this.addRequestBody = toolkit.createButton(parent, Messages.rest_add_body, 8);
        this.addRequestBody.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if ("add".equals(((Button)event.getSource()).getData())) {
                    RestView.this.addRequestBodyControl();
                    RestView.this.requestBody.getTextWidget().forceFocus();
                } else {
                    Control[] controlArray = RestView.this.requestBodyPanel.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        c.dispose();
                        ++n2;
                    }
                }
                RestView.this.toggleRequestBodyButton((Button)event.getSource());
                RestView.this.requestBodyPanel.layout();
                parent.layout();
            }
        });
        this.addRequestBody.setLayoutData((Object)layoutData);
        this.addRequestBody.setData((Object)"add");
    }

    protected void toggleRequestBodyButton(Button button) {
        if ("add".equals(button.getData())) {
            button.setText(Messages.rest_remove_body);
            button.setData((Object)"remove");
        } else {
            button.setText(Messages.rest_add_body);
            button.setData((Object)"add");
        }
    }

    private void addRequestBodyControl() {
        this.toolkit.createLabel(this.requestBodyPanel, Messages.rest_body);
        GridData layoutData = new GridData();
        layoutData.heightHint = 150;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.requestBody = new TextViewer(this.requestBodyPanel, 2624);
        this.requestBody.getControl().setLayoutData((Object)layoutData);
    }

    private void buildExecuteButton(FormToolkit toolkit, Composite inputPanel) {
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment((Control)this.addParameter, 0, 16384);
        layoutData.top = new FormAttachment((Control)this.addParameter, 25);
        this.execute = toolkit.createButton(inputPanel, Messages.common_execute, 8);
        this.execute.setImage(this.imagePool.getImageUnchecked("IMAGE_START"));
        this.execute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestView.this.executeRequest();
            }
        });
        this.execute.setLayoutData((Object)layoutData);
    }

    private boolean isValid(HttpRequest request) {
        try {
            URL url = new URL(request.getEndpoint());
            if (StringUtils.isEmpty((CharSequence)url.getHost())) {
                this.form.setMessage(Messages.rest_invalid_url, 3);
                return false;
            }
        }
        catch (Exception exception) {
            this.form.setMessage(Messages.rest_invalid_url, 3);
            return false;
        }
        return true;
    }

    private void buildHeaderSection(FormToolkit toolkit, Composite parent, Control controlAbove) {
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(controlAbove, 0, 16384);
        layoutData.right = new FormAttachment(100);
        layoutData.top = new FormAttachment(controlAbove, 25);
        this.headersPanel = toolkit.createComposite(parent);
        this.headersPanel.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 20;
        this.headersPanel.setLayout((Layout)gridLayout);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(controlAbove, 0, 16384);
        layoutData.top = new FormAttachment((Control)this.headersPanel, 5);
        this.addHeader = toolkit.createButton(parent, Messages.rest_add_header, 8);
        this.addHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestView.this.addHeaderPanel();
                RestView.this.headers.get(RestView.this.headers.size() - 1)[0].forceFocus();
            }
        });
        this.addHeader.setLayoutData((Object)layoutData);
    }

    private void addHeaderPanel() {
        if (this.headersPanel.getChildren().length == 0) {
            this.toolkit.createLabel(this.headersPanel, Messages.rest_header_name);
            this.toolkit.createLabel(this.headersPanel, Messages.rest_header_value);
            this.toolkit.createLabel(this.headersPanel, "");
        }
        GridData layoutData = new GridData();
        layoutData.widthHint = 125;
        Text newKey = this.toolkit.createText(this.headersPanel, "");
        newKey.setLayoutData((Object)layoutData);
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        Text newValue = this.toolkit.createText(this.headersPanel, "");
        newValue.setLayoutData((Object)layoutData);
        Text[] controls = new Text[]{newKey, newValue};
        this.headers.add(controls);
        Button remove = this.toolkit.createButton(this.headersPanel, null, 8);
        remove.setData((Object)controls);
        remove.setImage(this.imagePool.getImageUnchecked("IMAGE_REMOVE"));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                Control[] children = RestView.this.headersPanel.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i] == button) {
                        RestView.this.headers.remove(button.getData());
                        children[i - 2].dispose();
                        children[i - 1].dispose();
                        children[i].dispose();
                        if (children.length == 6) {
                            children[0].dispose();
                            children[1].dispose();
                            children[2].dispose();
                        }
                        RestView.this.inputPanel.layout(true);
                        break;
                    }
                    ++i;
                }
                super.widgetSelected(e);
            }
        });
        this.inputPanel.layout(true);
    }

    private void buildParameterSection(FormToolkit toolkit, Composite parent, Control controlAbove) {
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(controlAbove, 0, 16384);
        layoutData.right = new FormAttachment(100);
        layoutData.top = new FormAttachment(controlAbove, 25);
        this.parametersPanel = toolkit.createComposite(parent);
        this.parametersPanel.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 20;
        this.parametersPanel.setLayout((Layout)gridLayout);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(controlAbove, 0, 16384);
        layoutData.top = new FormAttachment((Control)this.parametersPanel, 5);
        this.addParameter = toolkit.createButton(parent, Messages.rest_add_parameter, 8);
        this.addParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestView.this.addParameterPanel();
                RestView.this.parameters.get(RestView.this.parameters.size() - 1)[0].forceFocus();
            }
        });
        this.addParameter.setLayoutData((Object)layoutData);
    }

    private void addParameterPanel() {
        if (this.parametersPanel.getChildren().length == 0) {
            this.toolkit.createLabel(this.parametersPanel, Messages.rest_parameter_name);
            this.toolkit.createLabel(this.parametersPanel, Messages.rest_parameter_value);
            this.toolkit.createLabel(this.parametersPanel, "");
        }
        GridData layoutData = new GridData();
        layoutData.widthHint = 125;
        Text newKey = this.toolkit.createText(this.parametersPanel, "");
        newKey.setLayoutData((Object)layoutData);
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        Text newValue = this.toolkit.createText(this.parametersPanel, "");
        newValue.setLayoutData((Object)layoutData);
        Text[] controls = new Text[]{newKey, newValue};
        this.parameters.add(controls);
        Button remove = this.toolkit.createButton(this.parametersPanel, null, 8);
        remove.setData((Object)controls);
        remove.setImage(this.imagePool.getImageUnchecked("IMAGE_REMOVE"));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                Control[] children = RestView.this.parametersPanel.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i] == button) {
                        RestView.this.parameters.remove(button.getData());
                        children[i - 2].dispose();
                        children[i - 1].dispose();
                        children[i].dispose();
                        if (children.length == 6) {
                            children[0].dispose();
                            children[1].dispose();
                            children[2].dispose();
                        }
                        RestView.this.inputPanel.layout(true);
                        break;
                    }
                    ++i;
                }
                super.widgetSelected(e);
            }
        });
        this.inputPanel.layout(true);
    }

    public HttpRequest toModel() {
        HttpRequest request = new HttpRequest();
        request.setId(String.valueOf(System.currentTimeMillis()));
        request.setMethod(this.method.getText());
        request.setEndpoint(this.endpoint.getText());
        for (Text[] controls : this.headers) {
            request.addHeader(controls[0].getText(), controls[1].getText());
        }
        for (Text[] controls : this.parameters) {
            request.addParameter(controls[0].getText(), controls[1].getText());
        }
        if (this.requestBody != null && !this.requestBody.getControl().isDisposed()) {
            request.setBody(this.requestBody.getTextWidget().getText());
        }
        return request;
    }

    public void fromModel(HttpRequest request) {
        this.clear();
        this.method.select(this.method.indexOf(request.getMethod()));
        this.endpoint.setText(request.getEndpoint());
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            this.addHeaderPanel();
            Text[] lastHeader = this.headers.get(this.headers.size() - 1);
            lastHeader[0].setText(entry.getKey());
            lastHeader[1].setText(entry.getValue());
        }
        for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
            this.addParameterPanel();
            Text[] lastParameter = this.parameters.get(this.parameters.size() - 1);
            lastParameter[0].setText(entry.getKey());
            lastParameter[1].setText(entry.getValue());
        }
        if (!StringUtils.isEmpty((CharSequence)request.getBody())) {
            this.addRequestBodyControl();
            this.toggleRequestBodyButton(this.addRequestBody);
            this.requestBody.setInput((Object)new Document(request.getBody()));
            this.requestBodyPanel.layout();
            this.inputPanel.layout();
        }
        this.form.layout();
    }

    private void clear() {
        Control[] children;
        this.headers.clear();
        this.parameters.clear();
        Control[] controlArray = children = this.inputPanel.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            this.inputPanel.layout();
            ++n2;
        }
        this.buildInputPanel(this.form);
        this.outputViewer.setInput(null);
        this.form.setMessage(null);
    }

    @Inject
    @Optional
    public void notifiedRequestSelected(@UIEventTopic(value="miworkplace/ui/rest/request/select") HttpRequest request) {
        this.fromModel(request);
        this.execute.forceFocus();
    }

    @Inject
    @Optional
    public void notifiedRequestClear(@UIEventTopic(value="miworkplace/ui/rest/clear") Event event) {
        this.clear();
    }

    @Inject
    @Optional
    public void notifiedResponse(@UIEventTopic(value="miworkplace/ui/rest/response") HttpResponse response) {
        try {
            this.outputViewer.setInput(this.buildDocument(response));
        }
        catch (Exception e) {
            this.logger.log(1, "Could not build output from HTTP response.", (Throwable)e);
            Notifier.error((String)"REST UI", (String)Messages.rest_error_build_output);
        }
    }

    @Inject
    @Optional
    public void notifiedError(@UIEventTopic(value="miworkplace/ui/rest/error") String message) {
        this.form.setMessage(message, 3);
    }

    private Object buildDocument(HttpResponse response) throws Exception {
        Document document = new Document();
        StringBuilder s = new StringBuilder();
        s.append("HTTP " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + "\n");
        s.append("\n");
        Header[] headerArray = response.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            s.append(header.getName() + ": " + header.getValue() + "\n");
            ++n2;
        }
        s.append("\n");
        String content = null;
        content = response.getEntity() == null || response.getEntity().getContentLength() == 0L ? "" : IOUtils.toString((InputStream)response.getEntity().getContent());
        if (this.isJson(response)) {
            try {
                s.append(new JSONObject(content).toString(4));
            }
            catch (Exception exception) {
                s.append(content);
            }
        } else if (this.isXml(response)) {
            try {
                InputSource src = new InputSource(new StringReader(content));
                Element node = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
                Boolean keepDeclaration = content.startsWith("<?xml");
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                LSSerializer writer = impl.createLSSerializer();
                writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
                s.append(writer.writeToString(node));
            }
            catch (Exception exception) {
                s.append(content);
            }
        } else {
            s.append(content);
        }
        document.set(s.toString());
        return document;
    }

    private boolean isXml(HttpResponse response) {
        Header header = response.getLastHeader("content-type");
        if (header == null) {
            return false;
        }
        return header.getValue().toLowerCase().contains("xml");
    }

    private boolean isJson(HttpResponse response) {
        Header header = response.getLastHeader("content-type");
        if (header == null) {
            return false;
        }
        return header.getValue().toLowerCase().contains("json");
    }

    private void executeRequest() {
        HttpRequest request = this.toModel();
        if (!this.isValid(request)) {
            return;
        }
        this.form.setMessage(null);
        try {
            this.persistence.persist(request);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("miworkplace.ui.rest.command.execute.parameter.request", request.getId());
            Command command = this.commandService.getCommand("miworkplace.ui.rest.command.execute");
            ParameterizedCommand parmCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
            this.handlerService.executeHandler(parmCommand);
        }
        catch (Exception e) {
            Notifier.error((String)"REST UI", (String)e.getMessage());
        }
    }
}

