/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.rest;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import miworkplace.extra.xstream.XStream;
import miworkplace.ui.rest.HttpRequest;
import miworkplace.ui.rest.PersistenceData;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class RequestPersistence {
    private static final int MAX_REQUESTS = 10;
    private File requestFile;
    private List<HttpRequest> requests;

    public void activate() {
        Bundle bundle = Platform.getBundle((String)"miworkplace.ui.rest");
        this.requestFile = Platform.getStateLocation((Bundle)bundle).append("requests.xml").toFile();
        this.requests = this.load();
    }

    private List<HttpRequest> load() {
        if (this.requestFile.exists()) {
            XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
            xstream.setClassLoader(this.getClass().getClassLoader());
            PersistenceData data = (PersistenceData)xstream.fromXML(this.requestFile);
            return data.requests;
        }
        return new ArrayList<HttpRequest>();
    }

    public HttpRequest get(String id) {
        for (HttpRequest request : this.requests) {
            if (!request.getId().equals(id)) continue;
            return request;
        }
        return null;
    }

    public List<HttpRequest> list() {
        return new ArrayList<HttpRequest>(this.requests);
    }

    public void persist(List<HttpRequest> requests) throws Exception {
        this.requests.clear();
        this.requests.addAll(requests);
        this.persist();
    }

    private void persist() throws Exception {
        PersistenceData data = new PersistenceData();
        data.requests = new ArrayList<HttpRequest>(this.requests);
        if (!this.requestFile.getParentFile().exists()) {
            this.requestFile.getParentFile().mkdirs();
        }
        this.requestFile.delete();
        this.requestFile.createNewFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(this.requestFile);){
            XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.toXML((Object)data, (Writer)writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void persist(HttpRequest request) throws Exception {
        this.requests.remove(request);
        this.requests.add(0, request);
        if (this.requests.size() > 10) {
            this.requests.remove(9);
        }
        this.persist();
    }

    private StaxDriver createSerializationDriverInstance() {
        return new StaxDriver();
    }
}

