/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.rest;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.rest.HttpRequest;
import miworkplace.ui.rest.RequestPersistence;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.osgi.service.log.LogService;

public class ExecuteRequestHandler {
    @Inject
    private RequestPersistence persistence;
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public void execute(@Optional MMenuItem menuItem, @Optional @Named(value="miworkplace.ui.rest.command.execute.parameter.request") String id) {
        HttpRequest request = null;
        if (menuItem != null) {
            request = (HttpRequest)menuItem.getTransientData().get("request");
        } else if (id != null) {
            request = this.persistence.get(id);
        }
        if (request == null) {
            this.logger.log(4, "No request passed.");
            return;
        }
        if (this.isValid(request)) {
            try {
                Request httpRequest = this.buildRequest(request);
                try {
                    HttpResponse response = httpRequest.execute().returnResponse();
                    this.eventBroker.send("miworkplace/ui/rest/response", (Object)response);
                }
                catch (IOException ioe) {
                    this.eventBroker.send("miworkplace/ui/rest/error", (Object)ioe.getMessage());
                }
                catch (Exception e) {
                    this.logger.log(1, "Error on executing the HTTP request.", (Throwable)e);
                    Notifier.error((String)"REST UI", (String)Messages.rest_error_execute);
                }
            }
            catch (Exception e) {
                this.logger.log(1, "Could not build URI for request.", (Throwable)e);
                Notifier.info((String)"REST UI", (String)Messages.rest_error_build_uri);
            }
        }
    }

    private Request buildRequest(HttpRequest httpRequest) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(httpRequest.getEndpoint());
        Set<Map.Entry<String, String>> parametersEntrySet = httpRequest.getParameters().entrySet();
        for (Map.Entry<String, String> entry : parametersEntrySet) {
            uriBuilder = uriBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        URI uri = uriBuilder.build();
        Request request = null;
        if (httpRequest.getMethod().equals("GET")) {
            request = Request.Get((URI)uri);
        } else if (httpRequest.getMethod().equals("POST")) {
            request = Request.Post((URI)uri);
        } else if (httpRequest.getMethod().equals("PUT")) {
            request = Request.Put((URI)uri);
        } else if (httpRequest.getMethod().equals("DELETE")) {
            request = Request.Delete((URI)uri);
        } else if (httpRequest.getMethod().equals("OPTIONS")) {
            request = Request.Options((URI)uri);
        } else if (httpRequest.getMethod().equals("HEAD")) {
            request = Request.Head((URI)uri);
        }
        if (request == null) {
            return null;
        }
        Set<Map.Entry<String, String>> headersEntrySet = httpRequest.getHeaders().entrySet();
        for (Map.Entry<String, String> entry : headersEntrySet) {
            request = request.addHeader(entry.getKey(), entry.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)httpRequest.getBody())) {
            request = request.body((HttpEntity)new StringEntity(httpRequest.getBody()));
        }
        return request;
    }

    private boolean isValid(HttpRequest request) {
        try {
            new URL(request.getEndpoint());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

