/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.ContextButtonHelpHandler;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.WizardPageDescriptor;
import com.ibm.as400.ui.framework.XMLWizardDefinition;
import com.ibm.as400.ui.framework.java.ArrowKeyListener;
import com.ibm.as400.ui.framework.java.ConditionalBlock;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.HelpViewer;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.JavaComponentDescriptor;
import com.ibm.as400.ui.framework.java.LookAndFeelManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.MessagePump;
import com.ibm.as400.ui.framework.java.PaneManager;
import com.ibm.as400.ui.framework.java.PanelFocusManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import com.ibm.as400.ui.framework.java.WindowManager;
import com.ibm.as400.ui.framework.java.WizardStateMachine;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class WizardManager
implements PaneManager,
WindowManager {
    public static final int BACK_BUTTON = 1;
    public static final int NEXT_BUTTON = 2;
    public static final int FINISH_BUTTON = 4;
    public static final int CANCEL_BUTTON = 8;
    public static final int HELP_BUTTON = 16;
    private Locale m_locale;
    private XMLWizardDefinition m_wd;
    private DataBean[] m_dataBeans;
    private Window m_owner;
    private WizardStateMachine m_wizardStateMachine;
    private Window m_window;
    private WindowManager m_ownerManager;
    private Point m_location;
    private JPanel m_stepPanel;
    private JPanel m_buttonPanel;
    private JPanel m_wizardPanel;
    private Container m_container;
    private JButton m_buttonBack;
    private JButton m_buttonNext;
    private JButton m_buttonFinish;
    private JButton m_buttonCancel;
    private JButton m_buttonHelp;
    private JButton m_lastButtonHit = null;
    private JToggleButton m_contextHelp;
    private JPanel m_helpButtonPanel;
    private Vector m_userButtons = new Vector();
    private Dimension m_maxButtonSize;
    private Vector m_visibleButtons = null;
    private ArrowKeyListener m_arrowKeyListener = null;
    private Vector m_pages;
    private Vector m_panels = new Vector();
    private Hashtable m_panelTable = new Hashtable();
    private Vector m_stepLabels = new Vector();
    private int m_currentPageIndex = -1;
    private Stack m_pageStack = new Stack();
    private boolean m_exitOnClose = false;
    private boolean m_initialDisplay = true;
    private boolean m_loadInBackground = false;
    private boolean m_loadOnShow = false;
    private boolean m_saveOnThread = false;
    private boolean m_blocking = false;
    private Vector m_commitListeners = new Vector();
    private Vector m_cancelListeners = new Vector();
    private Vector m_backListeners;
    private static final boolean m_descriptorTrace = false;
    private PanelManager.ContextHelpHandler m_contextHelpHandler = null;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        String string = SystemResourceFinder.format("wizardManagerArguments");
        if (stringArray.length == 2) {
            WizardManager wizardManager = null;
            try {
                wizardManager = new WizardManager(stringArray[0], stringArray[1], null, null);
            }
            catch (DisplayManagerException displayManagerException) {
                System.exit(-1);
            }
            wizardManager.setExitOnClose(true);
            wizardManager.setVisible(true);
        } else if (stringArray.length == 3) {
            if (stringArray[0].equalsIgnoreCase("-SERIALIZE")) {
                try {
                    new WizardManager(stringArray[1], null, stringArray[2]);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
            } else if (stringArray[0].equalsIgnoreCase("-DYNAMIC")) {
                WizardManager wizardManager = null;
                try {
                    wizardManager = new WizardManager(stringArray[1], null, stringArray[2], null, null, null, true);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
                wizardManager.setExitOnClose(true);
                wizardManager.setVisible(true);
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else if (stringArray.length == 4) {
            if (stringArray[0].equalsIgnoreCase("-LOCALE")) {
                String string2;
                String string3 = stringArray[1];
                String string4 = null;
                int n = string3.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string5 = string3.substring(0, n);
                if ((n = (string3 = string3.substring(n + 1)).indexOf("_")) == -1) {
                    string2 = string3;
                } else {
                    string2 = string3.substring(0, n);
                    string4 = string3.substring(n + 1);
                }
                Locale locale = string4 == null ? new Locale(string5, string2) : new Locale(string5, string2, string4);
                WizardManager wizardManager = null;
                try {
                    wizardManager = new WizardManager(stringArray[2], locale, stringArray[3], null, null);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
                wizardManager.setExitOnClose(true);
                wizardManager.setVisible(true);
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else if (stringArray.length == 5) {
            if (stringArray[0].equalsIgnoreCase("-SERIALIZE") && stringArray[1].equalsIgnoreCase("-LOCALE")) {
                String string6;
                String string7 = stringArray[2];
                String string8 = null;
                int n = string7.indexOf("_");
                if (n == -1) {
                    System.err.println(string);
                    System.exit(0);
                }
                String string9 = string7.substring(0, n);
                if ((n = (string7 = string7.substring(n + 1)).indexOf("_")) == -1) {
                    string6 = string7;
                } else {
                    string6 = string7.substring(0, n);
                    string8 = string7.substring(n + 1);
                }
                Locale locale = string8 == null ? new Locale(string9, string6) : new Locale(string9, string6, string8);
                try {
                    new WizardManager(stringArray[3], locale, stringArray[4]);
                }
                catch (DisplayManagerException displayManagerException) {
                    System.exit(-1);
                }
            } else {
                System.err.println(string);
                System.exit(0);
            }
        } else {
            System.err.println(string);
            System.exit(0);
        }
    }

    public WizardManager(String string, String string2, DataBean[] dataBeanArray, WizardStateMachine wizardStateMachine) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, (Frame)null, wizardStateMachine);
    }

    public WizardManager(String string, String string2, DataBean[] dataBeanArray, WizardStateMachine wizardStateMachine, boolean bl) throws DisplayManagerException {
        this(string, (Locale)null, string2, dataBeanArray, (Frame)null, wizardStateMachine, bl);
    }

    public WizardManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, WizardStateMachine wizardStateMachine) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, (Frame)null, wizardStateMachine);
    }

    public WizardManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, WizardStateMachine wizardStateMachine, boolean bl) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, (Frame)null, wizardStateMachine, bl);
    }

    public WizardManager(String string, String string2, DataBean[] dataBeanArray, Frame frame, WizardStateMachine wizardStateMachine) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, frame, wizardStateMachine);
    }

    public WizardManager(String string, String string2, DataBean[] dataBeanArray, Frame frame, WizardStateMachine wizardStateMachine, boolean bl) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, frame, wizardStateMachine, bl);
    }

    public WizardManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Frame frame, WizardStateMachine wizardStateMachine) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, frame, wizardStateMachine, false);
    }

    public WizardManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Frame frame, WizardStateMachine wizardStateMachine, boolean bl) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, frame, wizardStateMachine, bl, false);
    }

    public WizardManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Frame frame, WizardStateMachine wizardStateMachine, boolean bl, boolean bl2) throws DisplayManagerException {
        UIFramework.setDynamicResizingEnabled(bl);
        this.m_loadInBackground = bl2;
        this.m_wd = this.constructWizardDefinition(string, locale, string2);
        this.m_locale = locale;
        this.m_dataBeans = dataBeanArray;
        this.m_owner = frame;
        this.m_wizardStateMachine = wizardStateMachine;
        this.constructUI();
    }

    public WizardManager(String string, String string2, DataBean[] dataBeanArray, Container container, WizardStateMachine wizardStateMachine) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, container, wizardStateMachine);
    }

    public WizardManager(String string, String string2, DataBean[] dataBeanArray, Container container, WizardStateMachine wizardStateMachine, boolean bl) throws DisplayManagerException {
        this(string, null, string2, dataBeanArray, container, wizardStateMachine, bl);
    }

    public WizardManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Container container, WizardStateMachine wizardStateMachine) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, container, wizardStateMachine, false);
    }

    public WizardManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Container container, WizardStateMachine wizardStateMachine, boolean bl) throws DisplayManagerException {
        this(string, locale, string2, dataBeanArray, container, wizardStateMachine, bl, false);
    }

    public WizardManager(String string, Locale locale, String string2, DataBean[] dataBeanArray, Container container, WizardStateMachine wizardStateMachine, boolean bl, boolean bl2) throws DisplayManagerException {
        UIFramework.setDynamicResizingEnabled(bl);
        this.m_loadInBackground = bl2;
        if (container == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullContainerArgument"));
        }
        this.m_wd = this.constructWizardDefinition(string, locale, string2);
        this.m_locale = locale;
        this.m_dataBeans = dataBeanArray;
        this.m_container = container;
        this.m_wizardStateMachine = wizardStateMachine;
        this.constructUI();
    }

    public WizardManager(String string, Locale locale, String string2) throws DisplayManagerException {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullWizardNameArgument"));
        }
        try {
            this.m_wd = new XMLWizardDefinition(string, locale, string2);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        try {
            this.serialize();
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
    }

    public void serialize() throws IOException {
        this.saveWizardDefinition(this.m_wd.getWizard().m_name + this.m_wd.getWizardDefinitions().m_localeString + ".pdml.ser");
    }

    public JButton getBackButton() {
        return this.m_buttonBack;
    }

    public JButton getNextButton() {
        return this.m_buttonNext;
    }

    public JButton getCancelButton() {
        return this.m_buttonCancel;
    }

    public JButton getFinishButton() {
        return this.m_buttonFinish;
    }

    public void setExitOnClose(boolean bl) {
        this.m_exitOnClose = bl;
    }

    public boolean getExitOnClose() {
        return this.m_exitOnClose;
    }

    public void setVisible(boolean bl) {
        final boolean bl2 = bl;
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible0(bl2);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    WizardManager.this.setVisible0(bl2);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVisible0(boolean bl) {
        if (bl) {
            Object object;
            if (this.m_initialDisplay && this.m_container != null) {
                object = this;
                synchronized (object) {
                    for (int i = 0; i < this.m_panels.size(); ++i) {
                        PanelManager panelManager = (PanelManager)this.m_panels.elementAt(i);
                        panelManager.loadData();
                    }
                }
                this.showPage(0);
            }
            if (this.m_window != null) {
                if (this.m_window instanceof Dialog && ((Dialog)this.m_window).isModal()) {
                    HelpViewer.setActivationWindow(this.m_window);
                }
                if (this.m_initialDisplay) {
                    this.m_window.pack();
                    if (this.m_window instanceof JFrame) {
                        ((JFrame)this.m_window).setResizable(UIFramework.isDynamicResizingEnabled());
                    } else if (this.m_window instanceof JDialog) {
                        ((JDialog)this.m_window).setResizable(UIFramework.isDynamicResizingEnabled());
                    }
                    object = this.m_window.getToolkit().getScreenSize();
                    Dimension dimension = this.m_window.getPreferredSize();
                    if (this.m_window instanceof JFrame || this.m_location == null) {
                        this.m_window.setLocation(((Dimension)object).width / 2 - dimension.width / 2, ((Dimension)object).height / 2 - dimension.height / 2);
                    } else {
                        if (this.m_location.x + dimension.width > ((Dimension)object).width || this.m_location.y + dimension.height > ((Dimension)object).height) {
                            this.m_location = new Point(((Dimension)object).width / 2 - dimension.width / 2, ((Dimension)object).height / 2 - dimension.height / 2);
                        }
                        this.m_window.setLocation(this.m_location);
                    }
                }
                UIFramework.notifyGlobalRegisteredListeners(this.m_window, bl);
                if (UIFramework.isApplet()) {
                    if (this.m_window instanceof JDialog) {
                        ((JDialog)this.m_window).setModal(true);
                    }
                    this.m_window.setVisible(true);
                } else {
                    this.m_window.setVisible(true);
                    if (this.m_window instanceof JDialog && this.m_owner.isVisible() && (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 || this.m_owner instanceof Dialog)) {
                        this.m_blocking = true;
                        if (SwingUtilities.isEventDispatchThread()) {
                            object = new MessagePump(PanelManager.getRealSystemEventQueue());
                            ((MessagePump)object).pumpEvents(new ConditionalBlock(){

                                public boolean evaluate() {
                                    return WizardManager.this.m_blocking;
                                }
                            });
                        } else {
                            object = this.m_window.getTreeLock();
                            synchronized (object) {
                                while (this.m_blocking) {
                                    try {
                                        this.m_window.getTreeLock().wait(250L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.m_initialDisplay = false;
        } else if (this.m_window != null) {
            UIFramework.notifyGlobalRegisteredListeners(this.m_window, false);
            this.m_window.setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.m_window != null ? this.m_window.isVisible() : false;
    }

    public Dimension getPreferredSize() {
        if (this.m_window != null) {
            this.m_window.pack();
            return this.m_window.getPreferredSize();
        }
        if (this.m_container != null) {
            return this.m_container.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public void setFormatter(String string, DataFormatter dataFormatter, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        if (dataFormatter == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullFormatterArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        if (panelManager == null) {
            Object[] objectArray = new Object[]{string2, new String(this.m_wd.getWizardDefinitions().m_baseName + this.m_wd.getWizardDefinitions().m_localeString)};
            throw new IllegalArgumentException(SystemResourceFinder.format("panelNotFound", objectArray));
        }
        panelManager.setFormatter(string3, dataFormatter, bl);
    }

    public DataFormatter getFormatter(String string) {
        if (string == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullComponentNameArgument"));
        }
        int n = string.indexOf(46);
        if (n == -1) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("invalidComponentNameArgument", objectArray));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        if (panelManager == null) {
            return null;
        }
        return panelManager.getFormatter(string3);
    }

    public String getTitle() {
        return "";
    }

    public void setTitle(String string) {
        if (this.m_currentPageIndex >= 0) {
            ((PanelManager)this.m_panels.elementAt(this.m_currentPageIndex)).setTitle(string);
            if (this.m_window != null && this.m_window instanceof JFrame) {
                ((JFrame)this.m_window).setTitle(string);
            }
            if (this.m_window != null && this.m_window instanceof JDialog) {
                ((JDialog)this.m_window).setTitle(string);
            }
        }
    }

    public void setTitle(String string, String string2) {
        PaneManager paneManager = (PaneManager)this.m_panelTable.get(string2);
        if (paneManager != null && paneManager instanceof PanelManager) {
            ((PanelManager)paneManager).setTitle(string);
        } else {
            Object[] objectArray = new Object[]{new String(string2)};
            MessageLog.logError(SystemResourceFinder.format("nullPanelNameArgument", objectArray));
        }
    }

    public void loadData() {
    }

    public void activatePanel() {
    }

    public void showPane(String string) {
    }

    public Component getComponent(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        return panelManager != null ? panelManager.getComponent(string3) : null;
    }

    public void refreshComponent(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = null;
        if (this.getDelegateManager(string2) instanceof PanelManager) {
            panelManager = (PanelManager)this.getDelegateManager(string2);
        }
        if (panelManager != null) {
            panelManager.refreshComponent(string3);
        }
    }

    public JavaComponentDescriptor getComponentDescriptor(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PanelManager panelManager = (PanelManager)this.m_panelTable.get(string2);
        return panelManager != null ? panelManager.getComponentDescriptor(string3) : null;
    }

    public PaneManager getDelegateManager(String string) {
        return (PaneManager)this.m_panelTable.get(string);
    }

    public void setAggregateManager(PaneManager paneManager) {
    }

    public PaneManager getAggregateManager() {
        return null;
    }

    public PaneManager getRootManager() {
        return null;
    }

    public void applyChanges() {
    }

    public void prepareToCommit(Vector vector) {
    }

    public void commit(Vector vector) {
    }

    public Window getWindow() {
        return this.m_window;
    }

    public void setModalRelativeTo(WindowManager windowManager) {
        if (!this.isVisible()) {
            this.m_ownerManager = windowManager;
            this.m_owner = this.m_ownerManager.getWindow();
            this.buildDialog();
        }
    }

    public WindowManager getOwnerManager() {
        return this.m_ownerManager;
    }

    public void addCommitListener(ActionListener actionListener) {
        this.m_commitListeners.addElement(actionListener);
    }

    public void addCommitListener(Object object) {
        this.m_commitListeners.addElement(object);
    }

    public void addCancelListener(ActionListener actionListener) {
        this.m_cancelListeners.addElement(actionListener);
    }

    public void addCancelListener(Object object) {
        this.m_cancelListeners.addElement(object);
    }

    public void dispose() {
        if (this.getWindow() != null) {
            if (this.m_owner != null && this.m_owner.isVisible() && (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 || this.m_owner instanceof Dialog)) {
                this.m_blocking = false;
                this.m_owner.setEnabled(true);
                this.m_owner.toFront();
            }
            this.getWindow().dispose();
        }
    }

    public void handleDataException(IllegalUserDataException illegalUserDataException) {
        ((PanelManager)this.m_panels.elementAt(this.m_currentPageIndex)).handleDataException(illegalUserDataException);
    }

    public boolean getSaveOnThread() {
        return this.m_saveOnThread;
    }

    public void setSaveOnThread(boolean bl) {
        this.m_saveOnThread = bl;
    }

    public void setHelpPath(String string) {
        Enumeration enumeration = this.m_panelTable.elements();
        while (enumeration.hasMoreElements()) {
            PanelManager panelManager = (PanelManager)enumeration.nextElement();
            panelManager.setHelpPath(string);
        }
    }

    public void addPanel(PanelManager panelManager, int n, int n2) {
        panelManager.setAggregateManager(this);
        this.m_panels.insertElementAt(panelManager, n);
        this.m_panelTable.put(panelManager.getName(), panelManager);
        WizardPageDescriptor wizardPageDescriptor = new WizardPageDescriptor();
        wizardPageDescriptor.m_pageName = panelManager.getName();
        wizardPageDescriptor.m_stepIndex = n2;
        this.m_pages.insertElementAt(wizardPageDescriptor, n);
        this.m_wizardPanel.add(panelManager.getContainer(), panelManager.getName(), n);
    }

    public PanelManager getPage(int n) {
        return (PanelManager)this.m_panels.elementAt(n);
    }

    public PanelManager getPage(String string) {
        return (PanelManager)this.m_panelTable.get(string);
    }

    public void removePanel(int n) {
        PanelManager panelManager = (PanelManager)this.m_panels.elementAt(n);
        this.m_wizardPanel.remove(panelManager.getContainer());
        this.m_panels.removeElement(panelManager);
        this.m_panelTable.remove(panelManager.getName());
        this.m_pages.removeElementAt(n);
        panelManager.setAggregateManager(null);
    }

    public void addButtons(int n) {
        int n2 = this.determineButtonVisibility(n);
        this.populateButtonPanel(n2);
    }

    public void removeButtons(int n) {
        int n2 = this.determineButtonVisibility(0);
        this.populateButtonPanel(n2 &= ~n);
    }

    public void enableButtons(int n) {
        this.setButtonsEnablement(n, true);
    }

    public void disableButtons(int n) {
        this.setButtonsEnablement(n, false);
    }

    public void addUserButton(String string, String string2, ActionListener actionListener, ImageIcon imageIcon) throws IllegalArgumentException {
        if (actionListener == null || string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        if (this.findUserButtonIndex(string) != -1) {
            throw new IllegalArgumentException();
        }
        JButton jButton = null;
        jButton = imageIcon != null ? new JButton(string2, imageIcon) : new JButton(string2);
        jButton.setName(string);
        jButton.addActionListener(actionListener);
        Dimension dimension = jButton.getPreferredSize();
        dimension.height = this.m_maxButtonSize.height;
        if (this.m_maxButtonSize.width > dimension.width) {
            dimension.width = this.m_maxButtonSize.width;
        }
        jButton.setPreferredSize(dimension);
        this.m_userButtons.addElement(jButton);
        if (this.m_arrowKeyListener == null) {
            this.m_arrowKeyListener = new ArrowKeyListener();
        }
        jButton.addKeyListener(this.m_arrowKeyListener);
        int n = this.determineButtonVisibility(0);
        this.populateButtonPanel(n);
    }

    public void removeUserButton(String string) throws IllegalArgumentException {
        int n = this.findUserButtonIndex(string);
        if (n <= -1) {
            throw new IllegalArgumentException();
        }
        this.m_userButtons.removeElementAt(n);
        int n2 = this.determineButtonVisibility(0);
        this.populateButtonPanel(n2);
    }

    public JButton getUserButton(String string) throws IllegalArgumentException {
        int n = this.findUserButtonIndex(string);
        if (n > -1) {
            return (JButton)this.m_userButtons.elementAt(n);
        }
        throw new IllegalArgumentException();
    }

    public void enableUserButton(String string) throws IllegalArgumentException {
        this.setUserButtonEnablement(string, true);
    }

    public void disableUserButton(String string) throws IllegalArgumentException {
        this.setUserButtonEnablement(string, false);
    }

    public void addBackListener(ActionListener actionListener) {
        if (this.m_backListeners == null) {
            this.m_backListeners = new Vector(3, 3);
        }
        this.m_backListeners.addElement(actionListener);
    }

    private XMLWizardDefinition constructWizardDefinition(String string, Locale locale, String objectArray) throws DisplayManagerException {
        Object object;
        XMLWizardDefinition xMLWizardDefinition;
        block15: {
            Locale locale2;
            if (string == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullBaseNameArgument"));
            }
            if (objectArray == null) {
                throw new IllegalArgumentException(SystemResourceFinder.format("nullWizardNameArgument"));
            }
            xMLWizardDefinition = null;
            Locale locale3 = locale2 = locale != null ? locale : Locale.getDefault();
            if (UIFramework.getSearchMode() != 3) {
                int n = string.lastIndexOf(46);
                object = n != -1 ? string.substring(0, n) + "/" + (String)objectArray : objectArray;
                try {
                    xMLWizardDefinition = this.loadWizardDefinition((String)object, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    if (UIFramework.getSearchMode() == 1) {
                        Object[] objectArray2 = new Object[]{new String((String)objectArray + "_" + locale2)};
                        MessageLog.logError(SystemResourceFinder.format("serializedWizardNotFound", objectArray2));
                        throw new DisplayManagerException(missingResourceException.getClass().getName());
                    }
                }
                catch (IOException iOException) {
                    MessageLog.printStackTrace(iOException);
                    if (UIFramework.getSearchMode() == 1) {
                        throw new DisplayManagerException(iOException.getClass().getName());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageLog.printStackTrace(classNotFoundException);
                    if (UIFramework.getSearchMode() != 1) break block15;
                    throw new DisplayManagerException(classNotFoundException.getClass().getName());
                }
            }
        }
        if (xMLWizardDefinition != null) {
            object = new Object[]{new String((String)objectArray + SystemResourceFinder.getLastDocumentLocale() + ".pdml.ser")};
            MessageLog.traceOut(SystemResourceFinder.format("wizardLoaded", object));
            return xMLWizardDefinition;
        }
        try {
            xMLWizardDefinition = new XMLWizardDefinition(string, locale, (String)objectArray);
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new DisplayManagerException(parseException.getClass().getName());
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            throw new DisplayManagerException(missingResourceException.getClass().getName());
        }
        catch (PDMLSpecificationException pDMLSpecificationException) {
            pDMLSpecificationException.reportErrors();
            throw new DisplayManagerException(pDMLSpecificationException.getClass().getName());
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            throw new DisplayManagerException(iOException.getClass().getName());
        }
        object = new Object[]{objectArray, new String(xMLWizardDefinition.getWizardDefinitions().m_baseName + xMLWizardDefinition.getWizardDefinitions().m_localeString)};
        MessageLog.traceOut(SystemResourceFinder.format("wizardParsed", object));
        return xMLWizardDefinition;
    }

    private XMLWizardDefinition loadWizardDefinition(String string, Locale locale) throws IOException, ClassNotFoundException {
        InputStream inputStream = SystemResourceFinder.getSerializedPDMLDocument(string, locale);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        XMLWizardDefinition xMLWizardDefinition = (XMLWizardDefinition)objectInputStream.readObject();
        objectInputStream.close();
        return xMLWizardDefinition;
    }

    private void saveWizardDefinition(String string) throws IOException {
        Object[] objectArray = new Object[]{string};
        MessageLog.traceOut(SystemResourceFinder.format("wizardSaved", objectArray));
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(this.m_wd);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private void constructUI() throws DisplayManagerException {
        LookAndFeelManager.setLookAndFeel();
        boolean bl = false;
        if (this.m_container == null) {
            this.m_container = new JPanel();
            this.m_container.setLayout(new BorderLayout());
            bl = true;
        }
        this.buildSteps();
        this.m_container.add((Component)this.m_stepPanel, "West");
        this.buildButtons();
        this.m_container.add((Component)this.m_buttonPanel, "South");
        this.m_wizardPanel = new JPanel(new CardLayout(), false);
        this.m_container.add((Component)this.m_wizardPanel, "Center");
        this.m_pages = this.m_wd.getWizardPages();
        PageLoader pageLoader = null;
        if (!this.m_pages.isEmpty()) {
            PanelManager panelManager = null;
            if (this.m_loadInBackground) {
                WizardPageDescriptor wizardPageDescriptor = (WizardPageDescriptor)this.m_pages.elementAt(0);
                JPanel jPanel = new JPanel(false);
                panelManager = UIFramework.isDynamicResizingEnabled() ? new DynamicPanelManager(wizardPageDescriptor.m_baseName, this.m_locale, wizardPageDescriptor.m_pageName, this.m_dataBeans, (Container)jPanel) : new PanelManager(wizardPageDescriptor.m_baseName, this.m_locale, wizardPageDescriptor.m_pageName, this.m_dataBeans, jPanel);
                panelManager.setAggregateManager(this);
                this.m_panels.addElement(panelManager);
                this.m_panelTable.put(wizardPageDescriptor.m_pageName, panelManager);
                if (panelManager.isContainerScrollable()) {
                    JScrollPane jScrollPane = new JScrollPane(jPanel);
                    jScrollPane.setBorder(null);
                    this.m_wizardPanel.add((Component)jScrollPane, wizardPageDescriptor.m_pageName);
                } else {
                    this.m_wizardPanel.add((Component)jPanel, wizardPageDescriptor.m_pageName);
                    pageLoader = new PageLoader();
                    new Thread(pageLoader).start();
                }
            } else {
                for (int i = 0; i < this.m_pages.size(); ++i) {
                    WizardPageDescriptor wizardPageDescriptor = (WizardPageDescriptor)this.m_pages.elementAt(i);
                    JPanel jPanel = new JPanel(false);
                    panelManager = UIFramework.isDynamicResizingEnabled() ? new DynamicPanelManager(wizardPageDescriptor.m_baseName, this.m_locale, wizardPageDescriptor.m_pageName, this.m_dataBeans, (Container)jPanel) : new PanelManager(wizardPageDescriptor.m_baseName, this.m_locale, wizardPageDescriptor.m_pageName, this.m_dataBeans, jPanel);
                    panelManager.setAggregateManager(this);
                    this.m_panels.addElement(panelManager);
                    this.m_panelTable.put(wizardPageDescriptor.m_pageName, panelManager);
                    this.m_wizardPanel.add((Component)jPanel, wizardPageDescriptor.m_pageName);
                }
            }
        }
        this.addHelpHandlerToButtons(0);
        if (bl) {
            if (this.m_owner != null || this.m_ownerManager != null) {
                this.buildDialog();
            } else {
                this.buildFrame();
            }
        }
        if (this.m_window != null && pageLoader != null) {
            this.m_window.addWindowListener(pageLoader);
        }
    }

    private void buildSteps() {
        Vector vector = this.m_wd.getWizard().m_steps;
        if (vector != null) {
            this.m_stepLabels = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                this.m_stepLabels.addElement(new JLabel((String)vector.elementAt(i)));
            }
            this.m_stepPanel = new JPanel(new GridLayout(this.m_stepLabels.size(), 1), false);
            this.m_stepPanel.setBackground(Color.black);
            ImageIcon imageIcon = null;
            try {
                imageIcon = SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/task.gif");
            }
            catch (MissingResourceException missingResourceException) {
                MessageLog.logError(missingResourceException);
            }
            for (int i = 0; i < this.m_stepLabels.size(); ++i) {
                JLabel jLabel = (JLabel)this.m_stepLabels.elementAt(i);
                jLabel.setForeground(Color.white);
                if (imageIcon != null) {
                    jLabel.setIcon(imageIcon);
                }
                this.m_stepPanel.add(jLabel);
            }
        } else {
            this.m_stepPanel = new JPanel(new GridLayout(1, 1), false);
            this.m_stepPanel.setBackground(Color.black);
        }
    }

    private int determineButtonVisibility(int n) {
        Component[] componentArray = this.m_buttonPanel.getComponents();
        int n2 = n;
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof JButton) {
                JButton jButton = (JButton)componentArray[i];
                if (jButton.equals(this.m_buttonBack)) {
                    n2 |= 1;
                    continue;
                }
                if (jButton.equals(this.m_buttonNext)) {
                    n2 |= 2;
                    continue;
                }
                if (jButton.equals(this.m_buttonFinish)) {
                    n2 |= 4;
                    continue;
                }
                if (!jButton.equals(this.m_buttonCancel)) continue;
                n2 |= 8;
                continue;
            }
            n2 |= 0x10;
        }
        return n2;
    }

    private void populateButtonPanel(int n) {
        this.m_buttonPanel.removeAll();
        if (this.m_visibleButtons == null) {
            this.m_visibleButtons = new Vector(5 + this.m_userButtons.size());
        }
        this.m_visibleButtons.clear();
        if ((n & 1) == 1) {
            this.m_buttonPanel.add(this.m_buttonBack);
            this.m_visibleButtons.add(this.m_buttonBack);
        }
        if ((n & 2) == 2) {
            this.m_buttonPanel.add(this.m_buttonNext);
            this.m_visibleButtons.add(this.m_buttonNext);
        }
        if ((n & 4) == 4) {
            this.m_buttonPanel.add(this.m_buttonFinish);
            this.m_visibleButtons.add(this.m_buttonFinish);
        }
        if ((n & 8) == 8) {
            this.m_buttonPanel.add(this.m_buttonCancel);
            this.m_visibleButtons.add(this.m_buttonCancel);
        }
        if (!this.m_userButtons.isEmpty()) {
            for (int i = 0; i < this.m_userButtons.size(); ++i) {
                this.m_buttonPanel.add((JButton)this.m_userButtons.elementAt(i));
                this.m_visibleButtons.add((JButton)this.m_userButtons.elementAt(i));
            }
        }
        if ((n & 0x10) == 16) {
            this.m_buttonPanel.add(this.m_helpButtonPanel);
            this.m_visibleButtons.add(this.m_buttonHelp);
        }
        this.m_arrowKeyListener.setButtonVector(this.m_visibleButtons);
        this.m_buttonPanel.validate();
        this.m_buttonPanel.repaint();
    }

    private void setButtonsEnablement(int n, boolean bl) {
        if ((n & 1) == 1) {
            this.m_buttonBack.setEnabled(bl);
        }
        if ((n & 2) == 2) {
            this.m_buttonNext.setEnabled(bl);
        }
        if ((n & 4) == 4) {
            this.m_buttonFinish.setEnabled(bl);
        }
        if ((n & 8) == 8) {
            this.m_buttonCancel.setEnabled(bl);
        }
        if ((n & 0x10) == 16) {
            this.m_buttonHelp.setEnabled(bl);
            this.m_contextHelp.setEnabled(bl);
        }
    }

    private void setUserButtonEnablement(String string, boolean bl) throws IllegalArgumentException {
        int n = this.findUserButtonIndex(string);
        if (n <= -1) {
            throw new IllegalArgumentException();
        }
        JButton jButton = (JButton)this.m_userButtons.elementAt(n);
        jButton.setEnabled(bl);
    }

    private int findUserButtonIndex(String string) {
        int n = -1;
        if (!this.m_userButtons.isEmpty() && string != null) {
            for (int i = 0; i < this.m_userButtons.size(); ++i) {
                if (!((JButton)this.m_userButtons.elementAt(i)).getName().equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private void buildButtons() {
        try {
            this.m_buttonBack = new JButton(SystemResourceFinder.format("back"), SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/barrow.gif"));
            this.m_buttonNext = new JButton(SystemResourceFinder.format("next"), SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/farrow.gif"));
            this.m_buttonFinish = new JButton(SystemResourceFinder.format("finish"), SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/check.gif"));
            this.m_buttonCancel = new JButton(SystemResourceFinder.format("cancel"), SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/cancel.gif"));
            this.m_buttonHelp = new JButton(SystemResourceFinder.format("help"), SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/question.gif"));
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError(missingResourceException);
            this.m_buttonBack = new JButton(SystemResourceFinder.format("back"));
            this.m_buttonNext = new JButton(SystemResourceFinder.format("next"));
            this.m_buttonFinish = new JButton(SystemResourceFinder.format("finish"));
            this.m_buttonCancel = new JButton(SystemResourceFinder.format("cancel"));
            this.m_buttonHelp = new JButton(SystemResourceFinder.format("help"));
        }
        this.m_contextHelp = new JToggleButton("?"){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.m_contextHelp.setFocusPainted(false);
        Font font = this.m_contextHelp.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.m_contextHelp.setFont(font2);
        int n = this.m_buttonBack.getToolkit().getFontMetrics(font2).stringWidth("?") + 4;
        if (n < 15) {
            n = 15;
        }
        ContextButtonHelpHandler contextButtonHelpHandler = new ContextButtonHelpHandler(this.m_container, this.m_contextHelp);
        this.m_contextHelp.addActionListener(contextButtonHelpHandler);
        this.m_buttonBack.addActionListener(new BackHandler());
        this.m_buttonNext.addActionListener(new NextHandler());
        this.m_buttonFinish.addActionListener(new FinishHandler());
        this.m_buttonCancel.addActionListener(new CancelHandler());
        this.m_buttonHelp.addActionListener(new HelpHandler());
        if (this.m_arrowKeyListener == null) {
            this.m_arrowKeyListener = new ArrowKeyListener();
        }
        this.m_buttonBack.addKeyListener(this.m_arrowKeyListener);
        this.m_buttonNext.addKeyListener(this.m_arrowKeyListener);
        this.m_buttonFinish.addKeyListener(this.m_arrowKeyListener);
        this.m_buttonCancel.addKeyListener(this.m_arrowKeyListener);
        this.m_buttonHelp.addKeyListener(this.m_arrowKeyListener);
        this.m_buttonPanel = new DividerPanel();
        ((FlowLayout)this.m_buttonPanel.getLayout()).setAlignment(2);
        this.m_helpButtonPanel = new JPanel();
        this.m_helpButtonPanel.setLayout(new GridBagLayout());
        this.m_helpButtonPanel.add(this.m_buttonHelp);
        this.m_helpButtonPanel.add(this.m_contextHelp);
        this.m_buttonPanel.add(this.m_buttonBack);
        this.m_buttonPanel.add(this.m_buttonNext);
        this.m_buttonPanel.add(this.m_buttonFinish);
        this.m_buttonPanel.add(this.m_buttonCancel);
        this.m_buttonPanel.add(this.m_helpButtonPanel);
        this.m_maxButtonSize = this.m_buttonBack.getPreferredSize();
        Dimension dimension = this.m_buttonNext.getPreferredSize();
        if (dimension.width > this.m_maxButtonSize.width) {
            this.m_maxButtonSize.width = dimension.width;
        }
        if (dimension.height > this.m_maxButtonSize.height) {
            this.m_maxButtonSize.height = dimension.height;
        }
        dimension = this.m_buttonFinish.getPreferredSize();
        if (dimension.width > this.m_maxButtonSize.width) {
            this.m_maxButtonSize.width = dimension.width;
        }
        if (dimension.height > this.m_maxButtonSize.height) {
            this.m_maxButtonSize.height = dimension.height;
        }
        dimension = this.m_buttonCancel.getPreferredSize();
        if (dimension.width > this.m_maxButtonSize.width) {
            this.m_maxButtonSize.width = dimension.width;
        }
        if (dimension.height > this.m_maxButtonSize.height) {
            this.m_maxButtonSize.height = dimension.height;
        }
        dimension = this.m_buttonHelp.getPreferredSize();
        if (dimension.width > this.m_maxButtonSize.width) {
            this.m_maxButtonSize.width = dimension.width;
        }
        if (dimension.height > this.m_maxButtonSize.height) {
            this.m_maxButtonSize.height = dimension.height;
        }
        this.m_buttonBack.setPreferredSize(this.m_maxButtonSize);
        this.m_buttonNext.setPreferredSize(this.m_maxButtonSize);
        this.m_buttonFinish.setPreferredSize(this.m_maxButtonSize);
        this.m_buttonCancel.setPreferredSize(this.m_maxButtonSize);
        this.m_buttonHelp.setPreferredSize(this.m_maxButtonSize);
        Dimension dimension2 = this.m_buttonHelp.getPreferredSize();
        this.m_buttonHelp.setPreferredSize(new Dimension(dimension2.width - n, dimension2.height));
        this.m_contextHelp.setMargin(new Insets(2, 0, 2, 0));
        this.m_buttonHelp.setMargin(new Insets(2, 0, 2, 0));
        this.m_contextHelp.setPreferredSize(new Dimension(n, dimension2.height));
        int n2 = this.determineButtonVisibility(0);
        this.populateButtonPanel(n2);
    }

    private void addHelpHandlerToButtons(int n) {
        PanelManager panelManager = null;
        if (this.m_panels != null) {
            panelManager = (PanelManager)this.m_panels.elementAt(n);
            if (panelManager != null) {
                this.m_contextHelpHandler = panelManager.new PanelManager.ContextHelpHandler();
            }
            if (this.m_contextHelpHandler != null) {
                this.m_buttonBack.addKeyListener(this.m_contextHelpHandler);
                this.m_buttonNext.addKeyListener(this.m_contextHelpHandler);
                this.m_buttonFinish.addKeyListener(this.m_contextHelpHandler);
                this.m_buttonCancel.addKeyListener(this.m_contextHelpHandler);
                this.m_buttonHelp.addKeyListener(this.m_contextHelpHandler);
                this.m_contextHelp.addKeyListener(this.m_contextHelpHandler);
                if (this.m_userButtons != null) {
                    for (int i = 0; i < this.m_userButtons.size(); ++i) {
                        ((JButton)this.m_userButtons.get(i)).addKeyListener(this.m_contextHelpHandler);
                    }
                }
            }
        }
    }

    private void removeHelpHandlers() {
        if (this.m_contextHelpHandler != null) {
            this.m_buttonBack.removeKeyListener(this.m_contextHelpHandler);
            this.m_buttonNext.removeKeyListener(this.m_contextHelpHandler);
            this.m_buttonFinish.removeKeyListener(this.m_contextHelpHandler);
            this.m_buttonCancel.removeKeyListener(this.m_contextHelpHandler);
            this.m_buttonHelp.removeKeyListener(this.m_contextHelpHandler);
            this.m_contextHelp.removeKeyListener(this.m_contextHelpHandler);
            if (this.m_userButtons != null) {
                for (int i = 0; i < this.m_userButtons.size(); ++i) {
                    ((JButton)this.m_userButtons.get(i)).removeKeyListener(this.m_contextHelpHandler);
                }
            }
        }
    }

    private void buildDialog() {
        JDialog jDialog = this.m_owner.isVisible() ? (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 ? new JDialog((Frame)this.m_owner, this.getTitle(), false) : (this.m_owner instanceof JDialog ? new JDialog((JDialog)this.m_owner, this.getTitle(), false) : new JDialog((Frame)this.m_owner, this.getTitle(), false))) : (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 ? new JDialog((Frame)this.m_owner, this.getTitle(), true) : (this.m_owner instanceof JDialog ? new JDialog((JDialog)this.m_owner, this.getTitle(), true) : new JDialog((Frame)this.m_owner, this.getTitle(), true)));
        if (this.m_owner != null) {
            if (this.m_owner.isVisible() && (this.m_owner instanceof Frame && ((Frame)this.m_owner).getState() != 1 || this.m_owner instanceof Dialog)) {
                Point point = this.m_owner.getLocationOnScreen();
                this.m_location = new Point(point.x + 50, point.y + 50);
            }
        } else {
            Window window = this.m_ownerManager.getWindow();
            if (window != null && window.isVisible()) {
                Point point = window.getLocationOnScreen();
                this.m_location = new Point(point.x + 50, point.y + 50);
            }
        }
        if (this.m_window != null) {
            this.m_window.dispose();
        }
        this.m_window = jDialog;
        jDialog.setFocusTraversalPolicy(new PanelFocusManager());
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)this.m_container, "Center");
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ((PanelManager)WizardManager.this.m_panels.elementAt(0)).activatePanel();
            }

            public void windowClosing(WindowEvent windowEvent) {
                CancelHandler cancelHandler = new CancelHandler();
                cancelHandler.actionPerformed(new ActionEvent(WizardManager.this, 1001, "Cancel"));
            }

            public void windowActivated(WindowEvent windowEvent) {
                PanelManager.windowActivatedActions(windowEvent, WizardManager.this.m_owner);
            }
        });
    }

    private void buildFrame() {
        JFrame jFrame = new JFrame("");
        this.m_window = jFrame;
        jFrame.setFocusTraversalPolicy(new PanelFocusManager());
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this.m_container, "Center");
        if (this.m_wd.getWizard().m_icon != null) {
            ImageIcon imageIcon = null;
            try {
                imageIcon = SystemResourceFinder.getImageResource(this.m_wd.getWizard().m_icon);
            }
            catch (MissingResourceException missingResourceException) {
                MessageLog.logError(missingResourceException);
            }
            if (imageIcon != null) {
                jFrame.setIconImage(imageIcon.getImage());
            }
        }
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ((PanelManager)WizardManager.this.m_panels.elementAt(0)).activatePanel();
            }

            public void windowClosing(WindowEvent windowEvent) {
                CancelHandler cancelHandler = new CancelHandler();
                cancelHandler.actionPerformed(new ActionEvent(WizardManager.this, 1001, "Cancel"));
            }
        });
    }

    private synchronized void showPage(int n) {
        Container container;
        this.m_container.setCursor(new Cursor(3));
        try {
            while (n >= this.m_panels.size()) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.m_container.setCursor(new Cursor(0));
        this.m_currentPageIndex = n;
        this.m_buttonFinish.setEnabled(this.m_currentPageIndex == this.m_pages.size() - 1);
        this.m_buttonBack.setEnabled(this.m_currentPageIndex != 0);
        this.m_buttonNext.setEnabled(this.m_currentPageIndex != this.m_pages.size() - 1);
        if (this.m_wizardStateMachine != null) {
            this.m_wizardStateMachine.setButtonStates(this.m_currentPageIndex);
        }
        if (this.m_window != null) {
            if (this.m_window instanceof JFrame) {
                ((JFrame)this.m_window).setTitle(((PanelManager)this.m_panels.elementAt(this.m_currentPageIndex)).getTitle());
            } else if (this.m_window instanceof JDialog) {
                ((JDialog)this.m_window).setTitle(((PanelManager)this.m_panels.elementAt(this.m_currentPageIndex)).getTitle());
            }
        }
        if (this.m_loadOnShow) {
            ((PanelManager)this.m_panels.elementAt(this.m_currentPageIndex)).loadData();
        }
        ((CardLayout)this.m_wizardPanel.getLayout()).show(this.m_wizardPanel, ((WizardPageDescriptor)this.m_pages.elementAt((int)this.m_currentPageIndex)).m_pageName);
        this.removeHelpHandlers();
        this.addHelpHandlerToButtons(n);
        for (container = this.m_container.getParent(); !(container instanceof JRootPane) && container != null; container = container.getParent()) {
        }
        if (container != null) {
            JButton jButton;
            JButton jButton2 = jButton = this.m_lastButtonHit == null ? this.m_buttonNext : this.m_lastButtonHit;
            if (!jButton.isEnabled()) {
                jButton = jButton == this.m_buttonBack ? this.m_buttonNext : this.m_buttonFinish;
            }
            ((JRootPane)container).setDefaultButton(null);
            ((JRootPane)container).setDefaultButton(jButton);
            jButton.requestFocus();
        }
        ((PanelManager)this.m_panels.elementAt(this.m_currentPageIndex)).activatePanel();
    }

    private void checkStep(int n) {
        block8: {
            int n2;
            int n3;
            block9: {
                if (this.m_stepLabels.size() <= 0) break block8;
                n3 = ((WizardPageDescriptor)this.m_pages.elementAt((int)this.m_currentPageIndex)).m_stepIndex;
                if (n3 == -1) {
                    n3 = this.m_stepLabels.size();
                }
                if ((n2 = ((WizardPageDescriptor)this.m_pages.elementAt((int)n)).m_stepIndex) == -1) {
                    n2 = this.m_stepLabels.size();
                }
                if (n2 <= n3) break block9;
                for (int i = n3; i < n2; ++i) {
                    try {
                        ((JLabel)this.m_stepLabels.elementAt(i)).setIcon(SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/checkedtask.gif"));
                        continue;
                    }
                    catch (MissingResourceException missingResourceException) {
                        MessageLog.logError(missingResourceException);
                        break block8;
                    }
                }
                break block8;
            }
            if (n2 >= n3) break block8;
            for (int i = n2; i < n3; ++i) {
                try {
                    ((JLabel)this.m_stepLabels.elementAt(i)).setIcon(SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/task.gif"));
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    break;
                }
            }
        }
    }

    private void commitBeans(Vector vector) {
        for (int i = 0; i < this.m_panels.size(); ++i) {
            PanelManager panelManager = (PanelManager)this.m_panels.elementAt(i);
            panelManager.commit(vector);
        }
    }

    private void disposeAfterCommit() {
        if (this.m_window != null) {
            for (int i = 0; i < this.m_commitListeners.size(); ++i) {
                EventListener eventListener;
                Object e = this.m_commitListeners.elementAt(i);
                if (e instanceof ActionListener) {
                    eventListener = (ActionListener)e;
                    eventListener.actionPerformed(new ActionEvent(this.m_window, 1001, "COMMIT"));
                    continue;
                }
                if (!(e instanceof TaskActionListener)) continue;
                eventListener = (TaskActionListener)e;
                eventListener.actionPerformed(new TaskActionEvent(this, this.m_wd.getWizard().m_name, "COMMIT"));
            }
            this.dispose();
        }
        if (this.m_exitOnClose) {
            System.exit(0);
        }
    }

    public void setLoadOnPageSwap(boolean bl) {
        this.m_loadOnShow = bl;
    }

    public boolean isLoadOnPageSwap() {
        return this.m_loadOnShow;
    }

    private static final void debug(String string) {
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    private class HelpHandler
    implements ActionListener {
        private HelpHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WizardManager.this.m_container.setCursor(new Cursor(3));
            PanelManager panelManager = (PanelManager)WizardManager.this.m_panels.elementAt(WizardManager.this.m_currentPageIndex);
            panelManager.displayHelp(((WizardManager)WizardManager.this).m_wd.getWizard().m_icon);
            WizardManager.this.m_container.setCursor(new Cursor(0));
        }
    }

    private class CancelHandler
    implements ActionListener {
        private CancelHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MessageLog.traceOut(SystemResourceFinder.format("actionCancelled"));
            if (WizardManager.this.m_window != null) {
                for (int i = 0; i < WizardManager.this.m_cancelListeners.size(); ++i) {
                    try {
                        EventListener eventListener;
                        Object e = WizardManager.this.m_cancelListeners.elementAt(i);
                        if (e instanceof ActionListener) {
                            eventListener = (ActionListener)e;
                            eventListener.actionPerformed(new ActionEvent(WizardManager.this.m_window, 1001, "CANCEL"));
                            continue;
                        }
                        if (!(e instanceof TaskActionListener)) continue;
                        eventListener = (TaskActionListener)e;
                        eventListener.actionPerformed(new TaskActionEvent(WizardManager.this, ((WizardManager)WizardManager.this).m_wd.getWizard().m_name, "CANCEL"));
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        return;
                    }
                }
                WizardManager.this.dispose();
            }
            if (WizardManager.this.m_exitOnClose) {
                System.exit(0);
            }
        }
    }

    private class FinishHandler
    implements ActionListener {
        private FinishHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MessageLog.traceOut(SystemResourceFinder.format("actionPerformed"));
            WizardManager.this.m_container.setCursor(new Cursor(3));
            PanelManager panelManager = (PanelManager)WizardManager.this.m_panels.elementAt(WizardManager.this.m_currentPageIndex);
            try {
                panelManager.applyChanges();
            }
            catch (IllegalUserDataException illegalUserDataException) {
                WizardManager.this.handleDataException(illegalUserDataException);
                WizardManager.this.m_container.setCursor(new Cursor(0));
                return;
            }
            Vector vector = new Vector();
            for (int i = 0; i < WizardManager.this.m_panels.size(); ++i) {
                PanelManager panelManager2 = (PanelManager)WizardManager.this.m_panels.elementAt(i);
                try {
                    panelManager2.prepareToCommit(vector);
                    continue;
                }
                catch (IllegalUserDataException illegalUserDataException) {
                    Component component = illegalUserDataException.getComponent();
                    String string = null;
                    if (component == null) {
                        string = illegalUserDataException.getComponentName();
                    }
                    boolean bl = false;
                    if (component != null || string != null) {
                        block7: for (int j = 0; j < WizardManager.this.m_panels.size(); ++j) {
                            PanelManager panelManager3 = (PanelManager)WizardManager.this.m_panels.elementAt(j);
                            if (string != null) {
                                component = panelManager3.getComponent(string);
                                if (component == null) continue;
                                WizardManager.this.showPage(j);
                                j = WizardManager.this.m_panels.size();
                                bl = true;
                                break;
                            }
                            Enumeration enumeration = panelManager3.m_componentDictionary.elements();
                            while (enumeration.hasMoreElements()) {
                                Component component2 = (Component)enumeration.nextElement();
                                if (!component2.getName().equals(component.getName())) continue;
                                WizardManager.this.showPage(j);
                                j = WizardManager.this.m_panels.size();
                                bl = true;
                                continue block7;
                            }
                        }
                    }
                    if (!bl) {
                        WizardManager.this.showPage(i);
                    }
                    WizardManager.this.handleDataException(illegalUserDataException);
                    WizardManager.this.m_container.setCursor(new Cursor(0));
                    return;
                }
            }
            vector.removeAllElements();
            try {
                if (WizardManager.this.m_saveOnThread) {
                    if (WizardManager.this.getWindow() != null) {
                        WizardManager.this.getWindow().setEnabled(false);
                    }
                    final Vector vector2 = vector;
                    Thread thread = new Thread(){

                        public void run() {
                            WizardManager.debug("Commit processing threaded!");
                            try {
                                WizardManager.this.commitBeans(vector2);
                            }
                            catch (IllegalUserDataException illegalUserDataException) {
                                SwingUtilities.invokeLater(new Thread(){

                                    public void run() {
                                        if (WizardManager.this.getWindow() != null) {
                                            WizardManager.this.getWindow().setEnabled(true);
                                        }
                                        WizardManager.this.handleDataException(illegalUserDataException);
                                        WizardManager.this.m_container.setCursor(new Cursor(0));
                                    }
                                });
                                return;
                            }
                            SwingUtilities.invokeLater(new Thread(){

                                public void run() {
                                    if (WizardManager.this.getWindow() != null) {
                                        WizardManager.this.getWindow().setEnabled(true);
                                    }
                                    WizardManager.this.disposeAfterCommit();
                                }
                            });
                        }
                    };
                    thread.setDaemon(false);
                    thread.start();
                } else {
                    WizardManager.this.commitBeans(vector);
                    WizardManager.this.m_container.setCursor(new Cursor(0));
                    WizardManager.this.disposeAfterCommit();
                }
            }
            catch (IllegalUserDataException illegalUserDataException) {
                WizardManager.this.handleDataException(illegalUserDataException);
                WizardManager.this.m_container.setCursor(new Cursor(0));
                return;
            }
        }
    }

    private class NextHandler
    implements ActionListener {
        private NextHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            WizardManager.this.m_lastButtonHit = WizardManager.this.m_buttonNext;
            PanelManager panelManager = (PanelManager)WizardManager.this.m_panels.elementAt(WizardManager.this.m_currentPageIndex);
            try {
                panelManager.applyChanges();
            }
            catch (IllegalUserDataException illegalUserDataException) {
                WizardManager.this.handleDataException(illegalUserDataException);
                return;
            }
            if (WizardManager.this.m_wizardStateMachine == null) {
                n = WizardManager.this.m_currentPageIndex + 1;
            } else {
                n = WizardManager.this.m_wizardStateMachine.getNextPage(WizardManager.this.m_currentPageIndex);
                if (n == WizardManager.this.m_currentPageIndex) {
                    return;
                }
            }
            if (WizardManager.this.m_pageStack.empty()) {
                WizardManager.this.m_pageStack.push(new Integer(WizardManager.this.m_currentPageIndex));
            } else if (WizardManager.this.m_currentPageIndex != (Integer)WizardManager.this.m_pageStack.peek()) {
                WizardManager.this.m_pageStack.push(new Integer(WizardManager.this.m_currentPageIndex));
            }
            WizardManager.this.checkStep(n);
            WizardManager.this.showPage(n);
        }
    }

    private class BackHandler
    implements ActionListener {
        private BackHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            WizardManager.this.m_lastButtonHit = WizardManager.this.m_buttonBack;
            if (WizardManager.this.m_backListeners != null) {
                for (n = 0; n < WizardManager.this.m_backListeners.size(); ++n) {
                    ActionListener actionListener = (ActionListener)WizardManager.this.m_backListeners.elementAt(n);
                    actionListener.actionPerformed(new ActionEvent(WizardManager.this.m_window, 1001, "BACK"));
                }
            }
            if (!WizardManager.this.m_pageStack.empty()) {
                n = (Integer)WizardManager.this.m_pageStack.pop();
                WizardManager.this.checkStep(n);
                WizardManager.this.showPage(n);
            }
        }
    }

    private class PageLoader
    extends WindowAdapter
    implements Runnable {
        private boolean m_windowClosing = false;

        private PageLoader() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.m_windowClosing = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PanelManager panelManager = null;
            for (int i = 1; i < WizardManager.this.m_pages.size(); ++i) {
                if (this.m_windowClosing) {
                    return;
                }
                WizardPageDescriptor wizardPageDescriptor = (WizardPageDescriptor)WizardManager.this.m_pages.elementAt(i);
                JPanel jPanel = new JPanel(false);
                try {
                    panelManager = UIFramework.isDynamicResizingEnabled() ? new DynamicPanelManager(wizardPageDescriptor.m_baseName, WizardManager.this.m_locale, wizardPageDescriptor.m_pageName, WizardManager.this.m_dataBeans, (Container)jPanel) : new PanelManager(wizardPageDescriptor.m_baseName, WizardManager.this.m_locale, wizardPageDescriptor.m_pageName, WizardManager.this.m_dataBeans, jPanel);
                }
                catch (DisplayManagerException displayManagerException) {
                    continue;
                }
                panelManager.setAggregateManager(WizardManager.this);
                if (WizardManager.this.m_currentPageIndex != -1) {
                    panelManager.loadData();
                }
                WizardManager wizardManager = WizardManager.this;
                synchronized (wizardManager) {
                    WizardManager.this.m_panels.addElement(panelManager);
                    WizardManager.this.m_panelTable.put(wizardPageDescriptor.m_pageName, panelManager);
                    WizardManager.this.m_wizardPanel.add((Component)jPanel, wizardPageDescriptor.m_pageName);
                    WizardManager.this.notifyAll();
                    continue;
                }
            }
        }
    }
}

