/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.SystemResourceFinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupMenuButton
extends JPanel {
    private JButton m_button;
    private JToggleButton m_arrowButton;
    private JPopupMenu m_popup = null;
    private PopupMenuButtonPopupListener m_popupListener;
    private boolean m_buttonPressed = false;
    private boolean m_arrowButtonPressed = false;
    private boolean m_enabled = true;

    public PopupMenuButton() {
        this(null, null, null, null, null, null);
    }

    public PopupMenuButton(Icon icon, String string, JPopupMenu jPopupMenu) {
        this(null, icon, string, null, string, jPopupMenu);
    }

    public PopupMenuButton(Icon icon, String string, String string2, JPopupMenu jPopupMenu) {
        this(null, icon, string, null, string2, jPopupMenu);
    }

    public PopupMenuButton(Icon icon, String string, Icon icon2, String string2, JPopupMenu jPopupMenu) {
        this(null, icon, string, icon2, string2, jPopupMenu);
    }

    public PopupMenuButton(String string, Icon icon, String string2, JPopupMenu jPopupMenu) {
        this(string, icon, string2, null, string2, jPopupMenu);
    }

    public PopupMenuButton(String string, Icon icon, String string2, String string3, JPopupMenu jPopupMenu) {
        this(string, icon, string2, null, string3, jPopupMenu);
    }

    public PopupMenuButton(String string, Icon icon, String string2, Icon icon2, String string3, JPopupMenu jPopupMenu) {
        Insets insets = null;
        if (icon != null && (string == null || string.equals(""))) {
            insets = new Insets(0, 0, 0, 0);
        }
        this.m_button = new JButton(string, icon);
        this.m_button.setToolTipText(string2);
        if (insets != null) {
            this.m_button.setMargin(insets);
        }
        this.m_button.setDefaultCapable(false);
        this.m_arrowButton = new JToggleButton(){

            public boolean isFocusTraversable() {
                return true;
            }
        };
        if (icon2 == null) {
            this.m_arrowButton.setIcon(SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/java/PopupMenuButton.gif"));
        } else {
            this.m_arrowButton.setIcon(icon2);
        }
        this.m_arrowButton.setToolTipText(string3);
        this.m_arrowButton.setMargin(new Insets(0, 2, 0, 2));
        this.m_arrowButton.addActionListener(new PopupMenuButtonArrowListener());
        PopupMenuButtonMouseListener popupMenuButtonMouseListener = new PopupMenuButtonMouseListener();
        this.m_button.addMouseListener(popupMenuButtonMouseListener);
        this.m_arrowButton.addMouseListener(popupMenuButtonMouseListener);
        this.setPaintButtonBorders(false);
        this.m_popupListener = new PopupMenuButtonPopupListener();
        this.setPopupMenu(jPopupMenu);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_button, "Center");
        this.add((Component)this.m_arrowButton, "East");
    }

    public void setActionCommand(String string) {
        this.m_button.setActionCommand(string);
    }

    public String getActionCommand() {
        return this.m_button.getActionCommand();
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_button.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_button.removeActionListener(actionListener);
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
        this.m_button.setEnabled(bl);
        this.m_arrowButton.setEnabled(bl && this.m_popup != null);
        if (!bl) {
            this.setPaintButtonBorders(false);
            if (this.m_popup != null) {
                this.m_popup.setVisible(false);
            }
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public JButton getButton() {
        return this.m_button;
    }

    public JToggleButton getArrowButton() {
        return this.m_arrowButton;
    }

    public JPopupMenu getPopupMenu() {
        return this.m_popup;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        if (this.m_popup != null) {
            this.m_popup.removePopupMenuListener(this.m_popupListener);
        }
        this.m_popup = jPopupMenu;
        if (this.m_popup != null) {
            this.m_popup.addPopupMenuListener(this.m_popupListener);
            this.m_arrowButton.setEnabled(true);
        } else {
            this.m_arrowButton.setEnabled(false);
        }
    }

    void setPaintButtonBorders(boolean bl) {
        if (!this.m_enabled) {
            bl = false;
        }
        this.m_button.setBorderPainted(bl);
        this.m_arrowButton.setBorderPainted(bl && this.m_popup != null);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    class PopupMenuButtonMouseListener
    extends MouseAdapter {
        PopupMenuButtonMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PopupMenuButton.this.m_popup != null) {
                if (PopupMenuButton.this.m_popup.isVisible() && !mouseEvent.isPopupTrigger()) {
                    if (mouseEvent.getSource().equals(PopupMenuButton.this.m_arrowButton)) {
                        PopupMenuButton.this.m_arrowButtonPressed = true;
                    } else {
                        PopupMenuButton.this.m_buttonPressed = true;
                    }
                } else if (mouseEvent.isPopupTrigger() && PopupMenuButton.this.m_enabled) {
                    Rectangle rectangle = ((AbstractButton)mouseEvent.getSource()).getBounds();
                    PopupMenuButton.this.m_popup.show(PopupMenuButton.this, rectangle.x + mouseEvent.getX(), rectangle.y + mouseEvent.getY());
                    PopupMenuButton.this.m_popup.requestFocus();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && PopupMenuButton.this.m_enabled && PopupMenuButton.this.m_popup != null && !PopupMenuButton.this.m_popup.isVisible()) {
                Rectangle rectangle = ((AbstractButton)mouseEvent.getSource()).getBounds();
                PopupMenuButton.this.m_popup.show(PopupMenuButton.this, rectangle.x + mouseEvent.getX(), rectangle.y + mouseEvent.getY());
                PopupMenuButton.this.m_popup.requestFocus();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (PopupMenuButton.this.m_popup != null || mouseEvent.getSource().equals(PopupMenuButton.this.m_button)) {
                PopupMenuButton.this.setPaintButtonBorders(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (PopupMenuButton.this.m_popup != null) {
                PopupMenuButton.this.setPaintButtonBorders(PopupMenuButton.this.m_popup.isVisible());
            } else {
                PopupMenuButton.this.setPaintButtonBorders(false);
            }
        }
    }

    class PopupMenuButtonPopupListener
    implements PopupMenuListener {
        PopupMenuButtonPopupListener() {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            PopupMenuButton.this.m_arrowButton.setSelected(false);
            PopupMenuButton.this.setPaintButtonBorders(PopupMenuButton.this.m_arrowButtonPressed || PopupMenuButton.this.m_buttonPressed);
            if (PopupMenuButton.this.m_buttonPressed) {
                PopupMenuButton.this.m_arrowButtonPressed = false;
            }
            PopupMenuButton.this.m_buttonPressed = false;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            PopupMenuButton.this.setPaintButtonBorders(true);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    class PopupMenuButtonArrowListener
    implements ActionListener {
        PopupMenuButtonArrowListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PopupMenuButton.this.m_popup != null) {
                if (PopupMenuButton.this.m_arrowButtonPressed) {
                    PopupMenuButton.this.m_arrowButton.setSelected(false);
                    PopupMenuButton.this.m_arrowButtonPressed = false;
                } else if (PopupMenuButton.this.m_arrowButton.isSelected() && !PopupMenuButton.this.m_popup.isVisible()) {
                    Rectangle rectangle = PopupMenuButton.this.m_button.getBounds();
                    PopupMenuButton.this.m_popup.show(PopupMenuButton.this, rectangle.x, rectangle.y + rectangle.height);
                    PopupMenuButton.this.m_popup.requestFocus();
                } else if (!PopupMenuButton.this.m_arrowButton.isSelected() && PopupMenuButton.this.m_popup.isVisible()) {
                    PopupMenuButton.this.m_popup.setVisible(false);
                }
            }
        }
    }
}

