/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class PercentFormatter
extends DataFormatter {
    int m_minimumFractionDigits = 0;
    int m_maximumFractionDigits = 0;

    public PercentFormatter() {
    }

    public PercentFormatter(int n, int n2) {
        this.m_minimumFractionDigits = n;
        this.m_maximumFractionDigits = n2;
        if (this.m_minimumFractionDigits > this.m_maximumFractionDigits) {
            this.m_maximumFractionDigits = this.m_minimumFractionDigits;
        }
    }

    public Object parse(String string) throws IllegalUserDataException {
        String string2 = string.trim();
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormat.parse(string2, parsePosition);
        if (parsePosition.getIndex() < string2.length()) {
            double d = 0.1;
            String string3 = m_loader.getString("badPercent");
            Object[] objectArray = new Object[]{string2, numberFormat.format(d)};
            String string4 = MessageFormat.format(string3, objectArray);
            throw new IllegalUserDataException(string4);
        }
        return number;
    }

    public String format(double d) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(this.m_minimumFractionDigits);
        numberFormat.setMaximumFractionDigits(this.m_maximumFractionDigits);
        return numberFormat.format(d);
    }

    public String format(long l) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(this.m_minimumFractionDigits);
        numberFormat.setMaximumFractionDigits(this.m_maximumFractionDigits);
        return numberFormat.format(l);
    }

    public String format(Object object) {
        if (object != null) {
            if (object.getClass().isInstance(new Double(0.0)) || object.getClass().isInstance(new Float(0.0f)) || object.getClass().isInstance(new Long(0L)) || object.getClass().isInstance(new Integer(0))) {
                return this.format(((Number)object).doubleValue());
            }
            String string = m_loader.getString("badFormatObjectType");
            Object[] objectArray = new Object[]{"PercentFormatter", new String(object.getClass().getName()), "java.lang.Double, java.lang.Float, java.lang.Long, java.lang.Integer, java.lang.Short"};
            String string2 = MessageFormat.format(string, objectArray);
            throw new IllegalArgumentException(string2);
        }
        throw new IllegalArgumentException(m_loader.getString("nullFormatObject"));
    }

    public void setMinimumFractionDigits(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_minimumFractionDigits = n;
        if (this.m_minimumFractionDigits > this.m_maximumFractionDigits) {
            this.m_maximumFractionDigits = this.m_minimumFractionDigits;
        }
    }

    public void setMaximumFractionDigits(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_maximumFractionDigits = n;
        if (this.m_minimumFractionDigits > this.m_maximumFractionDigits) {
            this.m_minimumFractionDigits = this.m_maximumFractionDigits;
        }
    }

    public int getMaximumFractionDigits() {
        return this.m_maximumFractionDigits;
    }

    public int getMinimumFractionDigits() {
        return this.m_minimumFractionDigits;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

