/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.ColumnDescriptor;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.ItemDescriptor;
import com.ibm.as400.ui.framework.java.MessageLog;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PanelTableModel
extends AbstractTableModel {
    int m_rowCount;
    int m_columnCount;
    Vector m_tableColumns;
    Object[][] m_columnData;
    Hashtable m_cellStatusDictionary;

    public PanelTableModel(Vector vector) {
        this.m_tableColumns = vector;
        this.m_columnCount = this.m_tableColumns.size();
        this.m_columnData = new Object[this.m_columnCount][];
        this.m_cellStatusDictionary = new Hashtable(this.m_columnCount * 3);
    }

    public Object[] getColumn(int n) {
        return this.m_columnData[n];
    }

    public Object[] getColumn(String string) {
        for (int i = 0; i < this.m_columnData.length; ++i) {
            if (!string.equals(((ColumnDescriptor)this.m_tableColumns.elementAt((int)i)).m_name)) continue;
            return this.m_columnData[i];
        }
        return null;
    }

    public void setColumn(int n, Object[] objectArray) {
        this.m_columnData[n] = objectArray;
        this.m_rowCount = objectArray.length;
        for (int i = 0; i < this.m_columnCount; ++i) {
            Object[] objectArray2 = this.getColumn(i);
            if (objectArray2 == null || objectArray2.length <= this.m_rowCount) continue;
            this.m_rowCount = this.m_columnData[i].length;
        }
        this.fireTableDataChanged();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.m_rowCount + "x" + this.m_columnCount + "]";
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    public int getRowCount() {
        return this.m_rowCount;
    }

    public Object getValueAt(int n, int n2) {
        Object[] objectArray = this.m_columnData[n2];
        if (n < objectArray.length) {
            return objectArray[n];
        }
        return null;
    }

    public String getColumnName(int n) {
        return ((ColumnDescriptor)this.m_tableColumns.elementAt((int)n)).m_title;
    }

    public String getColumnIdentifier(int n) {
        return ((ColumnDescriptor)this.m_tableColumns.elementAt((int)n)).m_name;
    }

    public Class getColumnClass(int n) {
        if (this.m_columnData[n].length > 0) {
            return this.m_columnData[n][0].getClass();
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = true;
        if (n2 < this.m_tableColumns.size()) {
            Boolean bl2 = (Boolean)this.m_cellStatusDictionary.get(this.makeKey(n, n2));
            bl = bl2 != null ? bl2 : ((ColumnDescriptor)this.m_tableColumns.elementAt((int)n2)).m_editable;
        }
        return bl;
    }

    public void setCellEditable(boolean bl, int n, int n2) {
        this.m_cellStatusDictionary.put(this.makeKey(n, n2), new Boolean(bl));
    }

    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.m_columnData[n2];
        if (n < objectArray.length) {
            ((ItemDescriptor)objectArray[n]).setTitle(object.toString());
            this.fireTableCellUpdated(n, n2);
        } else {
            Object[] objectArray2 = new Object[]{new Integer(n), new Integer(n2)};
            MessageLog.traceErr(SystemResourceFinder.format("noColumnData", objectArray2));
        }
    }

    public void addRow(Vector vector) {
        if (vector == null || vector.size() == this.m_tableColumns.size()) {
            for (int i = 0; i < this.m_tableColumns.size(); ++i) {
                ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[this.m_rowCount + 1];
                if (this.m_rowCount > 0) {
                    System.arraycopy(this.m_columnData[i], 0, itemDescriptorArray, 0, this.m_columnData[i].length);
                }
                itemDescriptorArray[this.m_rowCount] = vector != null ? vector.elementAt(i) : null;
                this.m_columnData[i] = itemDescriptorArray;
            }
            ++this.m_rowCount;
            this.fireTableRowsInserted(this.m_rowCount - 1, this.m_rowCount - 1);
        }
    }

    public void setRows(Vector[] vectorArray) {
        if (vectorArray == null || vectorArray.length == 0) {
            return;
        }
        this.m_columnData = new Object[this.m_columnCount][];
        if (this.m_rowCount > 0) {
            this.fireTableRowsDeleted(0, this.m_rowCount - 1);
        }
        for (int i = 0; i < this.m_columnCount; ++i) {
            Object[] objectArray = new Object[vectorArray.length];
            for (int j = 0; j < vectorArray.length; ++j) {
                if (vectorArray[j].size() != this.m_columnCount) continue;
                objectArray[j] = vectorArray[j].elementAt(i);
            }
            this.setColumn(i, objectArray);
        }
        this.m_rowCount = vectorArray.length;
        this.fireTableRowsInserted(0, vectorArray.length - 1);
    }

    public Vector[] getRows() {
        Vector[] vectorArray = new Vector[this.m_rowCount];
        for (int i = 0; i < this.m_rowCount; ++i) {
            Vector<Object> vector = new Vector<Object>(this.m_columnCount);
            for (int j = 0; j < this.m_columnCount; ++j) {
                vector.addElement(this.getValueAt(i, j));
            }
            vectorArray[i] = vector;
        }
        return vectorArray;
    }

    public void removeRow(int n) {
        if (n < this.m_rowCount) {
            Object[][] objectArrayArray = new Object[this.m_columnCount][];
            for (int i = 0; i < this.m_columnCount; ++i) {
                Object[] objectArray = this.m_columnData[i];
                ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[this.m_rowCount - 1];
                int n2 = 0;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (j == n) continue;
                    itemDescriptorArray[n2++] = objectArray[j];
                }
                objectArrayArray[i] = itemDescriptorArray;
            }
            this.m_columnData = objectArrayArray;
            --this.m_rowCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(n + ">=" + this.m_rowCount);
        }
        this.fireTableRowsDeleted(n, n);
    }

    public void removeRows(int[] nArray) {
        if (nArray.length > 0) {
            int n;
            Object[][] objectArrayArray = new Object[this.m_columnCount][];
            for (n = 0; n < this.m_columnCount; ++n) {
                Object[] objectArray = this.m_columnData[n];
                Object[] objectArray2 = new Object[this.m_rowCount - nArray.length];
                int n2 = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.isRowInArray(i, nArray)) continue;
                    objectArray2[n2++] = objectArray[i];
                }
                objectArrayArray[n] = objectArray2;
            }
            this.m_columnData = objectArrayArray;
            this.m_rowCount -= nArray.length;
            for (n = 0; n < nArray.length; ++n) {
                this.fireTableRowsDeleted(nArray[n], nArray[n]);
            }
        }
    }

    private boolean isRowInArray(int n, int[] nArray) {
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    private String makeKey(int n, int n2) {
        String string = new Integer(n).toString();
        String string2 = new Integer(n2).toString();
        return string.concat(string2);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

