/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.ComponentDescriptor;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.java.JToolBarFW;
import com.ibm.as400.ui.framework.java.PanelManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JToolBar;

class FormattedLayout
implements LayoutManager {
    private Container m_container;
    private Window m_window;
    private XMLPanelDefinition m_pd;
    private Hashtable m_componentDictionary;
    private Hashtable m_descriptorDictionary;
    private JToolBarFW m_toolBar;
    private Dimension m_toolBarSize;
    private int m_tbOrientation = -1;
    private Insets m_insets;
    private Insets m_pInsets;
    private Dimension m_panelSize = new Dimension();
    private Dimension m_panelSizeOrig = new Dimension();
    private static boolean m_formatTrace = false;

    public FormattedLayout(PanelManager panelManager) {
        this.m_container = panelManager.m_container;
        this.m_window = panelManager.getWindow();
        this.m_pd = panelManager.m_pd;
        this.m_componentDictionary = panelManager.m_componentDictionary;
        this.m_descriptorDictionary = panelManager.m_descriptorDictionary;
        this.m_toolBar = (JToolBarFW)panelManager.getToolBar();
        this.m_insets = this.m_container.getInsets();
        Rectangle rectangle = new Rectangle(this.m_pd.getPanel().m_size.width, this.m_pd.getPanel().m_size.height);
        this.m_panelSize.setSize(rectangle.getSize());
        this.m_panelSizeOrig.setSize(rectangle.getSize());
    }

    public void addLayoutComponent(String string, Component component) {
        this.debug("In addLayoutComponent!");
        if (component instanceof JToolBarFW) {
            this.m_toolBar = (JToolBarFW)component;
            this.m_toolBar.setConstraint(string);
            this.debug("CONSTRAINT: " + string);
            this.m_window.pack();
        }
    }

    public void removeLayoutComponent(Component component) {
        this.debug("In removeLayoutComponent!");
    }

    public Dimension preferredLayoutSize(Container container) {
        this.debug("In preferredLayoutSize!");
        if (this.m_toolBar != null) {
            this.m_panelSize.setSize(this.m_panelSizeOrig);
            this.m_tbOrientation = this.m_toolBar.getOrientation();
            this.m_toolBarSize = this.m_toolBar.getPreferredSize();
            if (this.m_toolBar.getConstraint() == null) {
                if (this.m_tbOrientation == 0) {
                    this.m_toolBar.setConstraint("North");
                } else if (this.m_tbOrientation == 1) {
                    this.m_toolBar.setConstraint("West");
                }
            }
            if (this.m_tbOrientation == 0) {
                this.m_panelSize.width = Math.max(this.m_panelSize.width, this.m_toolBarSize.width);
                this.m_panelSize.height += this.m_toolBarSize.height;
            } else if (this.m_tbOrientation == 1) {
                this.m_panelSize.width += this.m_toolBarSize.width;
                this.m_panelSize.height = Math.max(this.m_panelSize.height, this.m_toolBarSize.height);
            }
        }
        return this.m_panelSize;
    }

    public Dimension minimumLayoutSize(Container container) {
        this.debug("In minimumLayoutSize!");
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        this.debug("In layoutContainer!");
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            Component component = container.getComponent(i);
            if (component instanceof JToolBarFW) {
                serializable = (JToolBarFW)component;
                if (((JToolBarFW)serializable).getConstraint().equals("North") || ((JToolBarFW)serializable).getConstraint().equals("West")) {
                    component.setLocation(Math.max(0, this.m_insets.left), Math.max(0, this.m_insets.top));
                } else if (((JToolBarFW)serializable).getConstraint().equals("South")) {
                    component.setLocation(Math.max(0, this.m_insets.left), this.m_panelSize.height - component.getSize().height);
                } else if (((JToolBarFW)serializable).getConstraint().equals("East")) {
                    component.setLocation(this.m_panelSize.width - component.getSize().width, Math.max(0, this.m_insets.top));
                }
                int n2 = ((JToolBar)serializable).getOrientation();
                if (n2 == 0) {
                    component.setSize(this.m_panelSize.width, component.getPreferredSize().height);
                    continue;
                }
                if (n2 != 1) continue;
                component.setSize(component.getPreferredSize().width, this.m_panelSize.height);
                continue;
            }
            serializable = (ComponentDescriptor)this.m_descriptorDictionary.get(component.getName());
            component.setBounds(this.adjustBounds(((ComponentDescriptor)serializable).m_position));
        }
    }

    public String toString() {
        return this.getClass().getName() + "[m_panelSize=" + this.m_panelSize + "]";
    }

    private Rectangle adjustBounds(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.setLocation(Math.max(rectangle2.x, this.m_insets.left), Math.max(rectangle2.y, this.m_insets.top));
        if (this.m_toolBarSize != null) {
            if (this.m_toolBar.getConstraint().equals("North")) {
                rectangle2.y += this.m_toolBarSize.height;
            } else if (this.m_toolBar.getConstraint().equals("West")) {
                rectangle2.x += this.m_toolBarSize.width;
            }
        }
        return rectangle2;
    }

    private void debug(String string) {
        if (m_formatTrace) {
            System.out.println("FormattedLayout: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

