/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class FloatFormatter
extends DataFormatter {
    double m_minValue;
    double m_maxValue;

    public FloatFormatter(double d, double d2) {
        this.m_minValue = d;
        this.m_maxValue = d2;
    }

    public String format(double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        return numberFormat.format(d);
    }

    public String format(Object object) {
        if (object != null) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (Double.class.isAssignableFrom(object.getClass())) {
                return numberFormat.format((Double)object);
            }
            if (Float.class.isAssignableFrom(object.getClass())) {
                return numberFormat.format(((Float)object).doubleValue());
            }
            if (Long.class.isAssignableFrom(object.getClass())) {
                return numberFormat.format(((Long)object).doubleValue());
            }
            if (Integer.class.isAssignableFrom(object.getClass())) {
                return numberFormat.format(((Integer)object).doubleValue());
            }
            String string = m_loader.getString("badFormatObjectType");
            Object[] objectArray = new Object[]{"FloatFormatter", new String(object.getClass().getName()), "Double, Float, Long, Integer"};
            String string2 = MessageFormat.format(string, objectArray);
            throw new IllegalArgumentException(string2);
        }
        throw new IllegalArgumentException(m_loader.getString("nullFormatObject"));
    }

    public Object parse(String string) throws IllegalUserDataException {
        String string2 = string.trim();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Double d = null;
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormat.parse(string2, parsePosition);
        if (number == null || parsePosition.getIndex() < string2.length()) {
            String string3 = m_loader.getString("valueNotANumber");
            Object[] objectArray = new Object[]{string2};
            throw new IllegalUserDataException(MessageFormat.format(string3, objectArray));
        }
        d = new Double(number.doubleValue());
        if (d < this.m_minValue || d > this.m_maxValue) {
            String string4 = m_loader.getString("valueOutOfRange");
            Object[] objectArray = new Object[]{string2, new Double(this.m_minValue), new Double(this.m_maxValue)};
            throw new IllegalUserDataException(MessageFormat.format(string4, objectArray));
        }
        return d;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

