/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.java.MessageLog;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class FileClassLoader
extends ClassLoader {
    private Vector m_pathList = new Vector();
    private Hashtable m_loadedClasses = new Hashtable();
    private static final boolean dbgFlag = false;
    private static final boolean dbgFlag2 = false;

    public FileClassLoader() {
        this((String)null);
    }

    public FileClassLoader(String string) {
        if (string != null) {
            this.setClasspath(string);
        }
    }

    public void setClasspath(String string) {
        String string2;
        this.m_pathList.clear();
        int n = 0;
        int n2 = string.indexOf(File.pathSeparator);
        while (n2 != -1) {
            string2 = string.substring(n, n2);
            this.addPath(string2);
            n = n2 + 1;
            n2 = string.indexOf(File.pathSeparator, n);
        }
        if (n != string.length()) {
            string2 = string.substring(n);
            this.addPath(string2);
        }
    }

    public void addPath(String string) {
        String string2 = string.replace('\\', '/');
        if (string2.endsWith(File.pathSeparator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        FileClassLoader.debug2("Adding path " + string2);
        File file = new File(string2);
        PathInfo pathInfo = null;
        if (file.isFile()) {
            String string3 = file.getName();
            if (!string3.endsWith(".zip") && !string3.endsWith(".jar")) {
                throw new IllegalArgumentException(string);
            }
            pathInfo = new PathInfo(string2, file, true);
        } else if (file.isDirectory()) {
            pathInfo = new PathInfo(string2, file, false);
        } else {
            throw new IllegalArgumentException(string);
        }
        this.m_pathList.addElement(pathInfo);
    }

    public boolean removePath(String string) {
        String string2 = string.replace('\\', '/');
        if (string2.endsWith(File.pathSeparator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        for (int i = 0; i < this.m_pathList.size(); ++i) {
            PathInfo pathInfo = (PathInfo)this.m_pathList.elementAt(i);
            if (!pathInfo.m_name.equals(string2)) continue;
            this.m_pathList.remove(pathInfo);
            return true;
        }
        return false;
    }

    public String getClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_pathList.size(); ++i) {
            PathInfo pathInfo = (PathInfo)this.m_pathList.elementAt(i);
            stringBuffer.append(pathInfo.m_name);
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (string.startsWith("com.sun")) {
            FileClassLoader.debug2("Delegating load of " + string);
            return super.loadClass(string, bl);
        }
        if (string.startsWith("java")) {
            FileClassLoader.debug2("Delegating load of " + string);
            return super.loadClass(string, bl);
        }
        if (string.startsWith("org.omg")) {
            FileClassLoader.debug2("Delegating load of " + string);
            return super.loadClass(string, bl);
        }
        if (string.startsWith("sun")) {
            FileClassLoader.debug2("Delegating load of " + string);
            return super.loadClass(string, bl);
        }
        Class clazz = null;
        clazz = (Class)this.m_loadedClasses.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.buildClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FileClassLoader.debug2("Couldn't load " + string + ", delegating");
            return super.loadClass(string, bl);
        }
        this.m_loadedClasses.put(string, clazz);
        if (bl) {
            super.resolveClass(clazz);
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = this.getFileAsStream(string);
        if (inputStream == null) {
            FileClassLoader.debug2("Couldn't load " + string + ", delegating");
            inputStream = super.getResourceAsStream(string);
        }
        return inputStream;
    }

    public URL getResource(String string) {
        URL uRL = this.buildResource(string);
        if (uRL == null) {
            FileClassLoader.debug2("Couldn't load " + string + ", delegating");
            uRL = super.getResource(string);
        }
        return uRL;
    }

    public void clearCache() {
        if (this.m_loadedClasses != null) {
            this.m_loadedClasses.clear();
        }
    }

    private Class buildClass(String string) throws ClassNotFoundException {
        byte[] byArray = this.loadClassData(string);
        if (byArray == null) {
            throw new ClassNotFoundException(string);
        }
        return super.defineClass(string, byArray, 0, byArray.length);
    }

    private URL buildResource(String string) {
        String string2 = null;
        for (int i = 0; i < this.m_pathList.size(); ++i) {
            PathInfo pathInfo = (PathInfo)this.m_pathList.elementAt(i);
            string2 = pathInfo.m_isFile ? "jar:file:" + pathInfo.m_name + "!/" + string : "file:" + pathInfo.m_name + "/" + string;
            try {
                URL uRL = new URL(string2);
                if (uRL.openConnection().getContentLength() <= 0) continue;
                FileClassLoader.debug("Loaded " + string + " from " + uRL);
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                MessageLog.printStackTrace(malformedURLException);
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private byte[] loadClassData(String string) {
        InputStream inputStream = this.getFileAsStream(FileClassLoader.getFileNameForClass(string));
        if (inputStream == null) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = bufferedInputStream.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = bufferedInputStream.read();
            }
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private InputStream getFileAsStream(String string) {
        InputStream inputStream = null;
        URL uRL = this.buildResource(string);
        try {
            if (uRL != null && (inputStream = uRL.openStream()) != null) {
                return inputStream;
            }
        }
        catch (IOException iOException) {
            MessageLog.printStackTrace(iOException);
        }
        return null;
    }

    private static String getFileNameForClass(String string) {
        return string.replace('.', '/') + ".class";
    }

    private static final void debug(String string) {
    }

    private static final void debug2(String string) {
    }

    private class PathInfo {
        String m_name;
        File m_file;
        boolean m_isFile;

        PathInfo(String string, File file, boolean bl) {
            this.m_name = string;
            this.m_file = file;
            this.m_isFile = bl;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

