/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.java.ConditionalBlock;
import com.ibm.as400.ui.framework.java.MessagePump;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import com.ibm.as400.ui.framework.java.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class FileChooserDialog {
    public static final int DIRECTORIES_ONLY = 100;
    public static final int FILES_ONLY = 101;
    public static final int FILES_AND_DIRECTORIES = 102;
    public static final int COMMIT_OPTION = 200;
    public static final int CANCEL_OPTION = 201;
    private JFileChooserFW m_filechooser;
    static /* synthetic */ Class class$java$awt$Frame;

    public FileChooserDialog() {
        this.m_filechooser = new JFileChooserFW();
    }

    public FileChooserDialog(String string) {
        this.m_filechooser = new JFileChooserFW(string);
    }

    public FileChooserDialog(File file) {
        this.m_filechooser = new JFileChooserFW();
        if (file != null) {
            this.m_filechooser.setSelectedFile(file);
        }
    }

    public void setDialogTitle(String string) {
        this.m_filechooser.setDialogTitle(string);
    }

    public String getDialogTitle() {
        return this.m_filechooser.getDialogTitle();
    }

    public void setSelectionMode(int n) {
        int n2 = 2;
        if (n == 100) {
            n2 = 1;
        } else if (n == 101) {
            n2 = 0;
        } else if (n == 102) {
            n2 = 2;
        }
        this.m_filechooser.setFileSelectionMode(n2);
    }

    public int getSelectionMode() {
        int n = this.m_filechooser.getFileSelectionMode();
        if (n == 1) {
            return 100;
        }
        if (n == 0) {
            return 101;
        }
        return 102;
    }

    public void setMultiSelectionEnabled(boolean bl) {
        this.m_filechooser.setMultiSelectionEnabled(bl);
    }

    public boolean isMultiSelectionEnabled() {
        return this.m_filechooser.isMultiSelectionEnabled();
    }

    public void setSelectedFile(File file) {
        this.m_filechooser.setSelectedFile(file);
    }

    public File getSelectedFile() {
        return this.m_filechooser.getSelectedFile();
    }

    public void setSelectedFiles(File[] fileArray) {
        this.m_filechooser.setSelectedFiles(fileArray);
    }

    public File[] getSelectedFiles() {
        return this.m_filechooser.getSelectedFiles();
    }

    public void setCurrentDirectory(File file) {
        this.m_filechooser.setCurrentDirectory(file);
    }

    public File getCurrentDirectory() {
        return this.m_filechooser.getCurrentDirectory();
    }

    public int showOpenDialog(WindowManager windowManager) {
        int n;
        Window window = null;
        if (windowManager != null) {
            window = windowManager.getWindow();
        }
        if ((n = this.m_filechooser.showOpenDialog(window)) == 0) {
            return 200;
        }
        return 201;
    }

    public int showSaveDialog(WindowManager windowManager) {
        int n;
        Window window = null;
        if (windowManager != null) {
            window = windowManager.getWindow();
        }
        if ((n = this.m_filechooser.showSaveDialog(window)) == 0) {
            return 200;
        }
        return 201;
    }

    public int showCustomDialog(WindowManager windowManager, String string) {
        Window window = null;
        if (windowManager != null) {
            window = windowManager.getWindow();
        }
        this.m_filechooser.setDialogType(1);
        int n = this.m_filechooser.showDialog(window, string);
        if (n == 0) {
            return 200;
        }
        return 201;
    }

    public void addFilter(String[] stringArray, String string) {
        FileFilterFW fileFilterFW = new FileFilterFW(stringArray, string);
        this.m_filechooser.addChoosableFileFilter(fileFilterFW);
    }

    public String[] getFilter() {
        FileFilter fileFilter = this.m_filechooser.getFileFilter();
        if (fileFilter instanceof FileFilterFW) {
            return ((FileFilterFW)fileFilter).getExtensions();
        }
        return new String[]{"*.*"};
    }

    public void setFilter(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        FileFilter[] fileFilterArray = this.m_filechooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            if (i == 0 && stringArray[i].equals("*.*")) {
                this.m_filechooser.setFileFilter(this.m_filechooser.getAcceptAllFileFilter());
            }
            if (!(fileFilterArray[i] instanceof FileFilterFW) || !((FileFilterFW)fileFilterArray[i]).getExtensions().equals(stringArray)) continue;
            this.m_filechooser.setFileFilter(fileFilterArray[i]);
        }
    }

    public void removeAcceptAllFilter() {
        FileFilter fileFilter = this.m_filechooser.getAcceptAllFileFilter();
        this.m_filechooser.removeChoosableFileFilter(fileFilter);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    class JFileChooserFW
    extends JFileChooser {
        private int m_returnValue;
        private JDialog m_dialog;

        public JFileChooserFW() {
            this.m_returnValue = -1;
        }

        public JFileChooserFW(String string) {
            super(string);
            this.m_returnValue = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int showDialog(Component component, String string) {
            if (string != null) {
                this.setApproveButtonText(string);
                this.setDialogType(2);
            }
            Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = FileChooserDialog.class$("java.awt.Frame")) : class$java$awt$Frame, component);
            String string2 = null;
            string2 = this.getDialogTitle() != null ? this.getDialogTitle() : this.getUI().getDialogTitle(this);
            if (component != null) {
                component.setEnabled(false);
            }
            this.m_dialog = new JDialog(frame, string2, false);
            Container container = this.m_dialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            this.m_dialog.pack();
            this.m_dialog.setLocationRelativeTo(component);
            UIFramework.notifyGlobalRegisteredListeners(this.m_dialog, true);
            this.m_dialog.setVisible(true);
            if (SwingUtilities.isEventDispatchThread()) {
                MessagePump messagePump = new MessagePump(PanelManager.getRealSystemEventQueue());
                messagePump.pumpEvents(new ConditionalBlock(){

                    public boolean evaluate() {
                        return JFileChooserFW.this.m_dialog.isVisible();
                    }
                });
            } else {
                Object object = this.m_dialog.getTreeLock();
                synchronized (object) {
                    while (this.m_dialog.isVisible()) {
                        try {
                            this.m_dialog.getTreeLock().wait(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
            if (component != null) {
                component.setEnabled(true);
                component.requestFocus();
            }
            return this.m_returnValue;
        }

        public void approveSelection() {
            this.m_returnValue = 0;
            if (this.m_dialog != null) {
                UIFramework.notifyGlobalRegisteredListeners(this.m_dialog, false);
                this.m_dialog.setVisible(false);
            }
            this.fireActionPerformed("ApproveSelection");
        }

        public void cancelSelection() {
            this.m_returnValue = 1;
            if (this.m_dialog != null) {
                UIFramework.notifyGlobalRegisteredListeners(this.m_dialog, false);
                this.m_dialog.setVisible(false);
            }
            this.fireActionPerformed("CancelSelection");
        }
    }

    private class FileFilterFW
    extends FileFilter {
        private String m_description;
        private String[] m_extension;

        public FileFilterFW(String[] stringArray, String string) {
            this.m_description = string;
            this.m_extension = stringArray;
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getPath().toLowerCase();
            if (this.m_extension != null) {
                int n = this.m_extension.length;
                for (int i = 0; i < n; ++i) {
                    if (!string.endsWith(this.m_extension[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String[] getExtensions() {
            return this.m_extension;
        }
    }
}

