/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.AbortException;
import com.ibm.as400.ui.framework.FrameworkDefaults;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.PaneDescriptor;
import com.ibm.as400.ui.framework.PanelDefinitionsDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.ResourceLoader;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.TabbedPaneDescriptor;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.XMLSAXErrorHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class XMLTabbedPaneDefinition
implements Serializable,
DocumentHandler {
    private transient String m_baseName;
    private transient Locale m_locale;
    private transient String m_tabbedPaneName;
    private transient ResourceBundle m_bundle;
    private transient String m_documentName;
    private transient String m_sxml = null;
    private static transient boolean m_bElementTrace = false;
    private transient PDMLSpecificationException m_pdmlException = null;
    private PanelDefinitionsDescriptor m_tabbedPaneDefinitions = new PanelDefinitionsDescriptor();
    private TabbedPaneDescriptor m_tabbedPaneDescriptor = new TabbedPaneDescriptor();
    private Vector m_paneDescriptors = new Vector();
    static final long serialVersionUID = -6364700749927753259L;
    private String m_chars = "";
    private Stack m_stack = null;
    private boolean found = false;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        m_bElementTrace = true;
        if (stringArray.length == 2) {
            XMLTabbedPaneDefinition xMLTabbedPaneDefinition;
            try {
                xMLTabbedPaneDefinition = new XMLTabbedPaneDefinition(stringArray[0], null, stringArray[1]);
            }
            catch (ParseException parseException) {
                parseException.reportErrors();
                return;
            }
            catch (PDMLSpecificationException pDMLSpecificationException) {
                pDMLSpecificationException.reportErrors();
                return;
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println(missingResourceException);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            xMLTabbedPaneDefinition.dump();
        } else {
            System.out.println("Arguments are: <resource bundle name> <tabbed pane name>");
        }
    }

    public XMLTabbedPaneDefinition(String string, Locale locale, String string2) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale = ResourceLoader.getOpNavLocale(locale);
        this.m_tabbedPaneName = string2;
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = FrameworkDefaults.m_resourceMode == 1 ? (locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string)) : SystemResourceFinder.getUncachedBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLTabbedPaneDefinition(String string, Locale locale) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale = ResourceLoader.getOpNavLocale(locale);
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLTabbedPaneDefinition(String string, ResourceBundle resourceBundle, String string2, String string3, PanelDefinitionsDescriptor panelDefinitionsDescriptor) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_bundle = resourceBundle;
        this.m_documentName = this.addLocale(this.m_baseName, panelDefinitionsDescriptor.m_localeString) + ".pdml";
        this.m_tabbedPaneName = string2;
        this.m_sxml = string3;
        this.m_tabbedPaneDefinitions = panelDefinitionsDescriptor;
        this.parseXML(true);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLTabbedPaneDefinition(String string) {
        this.m_tabbedPaneName = string;
        this.m_tabbedPaneDescriptor.m_name = string;
    }

    public PanelDefinitionsDescriptor getTabbedPaneDefinitions() {
        return this.m_tabbedPaneDefinitions;
    }

    public TabbedPaneDescriptor getTabbedPane() {
        return this.m_tabbedPaneDescriptor;
    }

    public Vector getPanes() {
        return this.m_paneDescriptors;
    }

    public String toString() {
        return this.getClass().getName() + "[baseName=" + this.m_baseName + ",tabbedPaneName=" + this.m_tabbedPaneName + "]";
    }

    public void dump() {
        System.out.println(this.m_tabbedPaneDefinitions);
        System.out.println(this.m_tabbedPaneDescriptor);
        Enumeration enumeration = this.m_paneDescriptors.elements();
        while (enumeration.hasMoreElements()) {
            PaneDescriptor paneDescriptor = (PaneDescriptor)enumeration.nextElement();
            System.out.println(paneDescriptor);
        }
    }

    private String addLocale(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string2.trim().length() == 0) {
            return string;
        }
        return string + "_" + string2;
    }

    private void parseXML(boolean bl) throws MissingResourceException, IOException, ParseException {
        InputStream inputStream = SystemResourceFinder.getPDMLHeader();
        InputStream inputStream2 = null;
        inputStream2 = !bl ? SystemResourceFinder.getPDMLDocument(this.m_baseName, this.m_locale) : new BufferedInputStream(new FileInputStream(this.m_sxml));
        this.m_documentName = this.m_baseName + SystemResourceFinder.getLastDocumentLocale() + ".pdml";
        this.debug("Storing m_documentName  " + this.m_documentName);
        XMLSAXErrorHandler xMLSAXErrorHandler = new XMLSAXErrorHandler(this.m_documentName, SystemResourceFinder.getHeaderLineCount());
        Object object = XMLPanelDefinition.getParser(this, xMLSAXErrorHandler);
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, inputStream2);
        InputSource inputSource = new InputSource(sequenceInputStream);
        XMLPanelDefinition.introspectMethod(object, "parse", new Object[]{inputSource}, new Class[]{inputSource.getClass()}, this.m_baseName);
        sequenceInputStream.close();
        ParseException parseException = xMLSAXErrorHandler.getException();
        if (parseException != null) {
            throw parseException;
        }
    }

    private void processError(String string) {
        if (this.m_pdmlException == null) {
            Object[] objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        this.m_pdmlException.addMessage(string);
    }

    private void processError(Throwable throwable, String string) {
        Object[] objectArray;
        if (this.m_pdmlException == null) {
            objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        if (throwable instanceof NumberFormatException) {
            objectArray = new Object[]{throwable.getMessage(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("valueNotNumeric", objectArray));
        } else {
            objectArray = new Object[]{throwable.toString(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("unknownValidationError", objectArray));
        }
    }

    public void startDocument() {
        this.m_stack = new Stack();
    }

    public void endDocument() {
        if (this.m_tabbedPaneDescriptor.m_name == null) {
            if (this.m_locale == null) {
                Object[] objectArray = new Object[]{this.m_tabbedPaneName, this.m_baseName};
                throw new MissingResourceException(SystemResourceFinder.format("tabbedPaneNotFound", objectArray), this.m_baseName, this.m_tabbedPaneName);
            }
            Object[] objectArray = new Object[]{this.m_tabbedPaneName, new String(this.m_baseName + "_" + this.m_locale)};
            throw new MissingResourceException(SystemResourceFinder.format("tabbedPaneNotFound", objectArray), this.m_baseName + "_" + this.m_locale, this.m_tabbedPaneName);
        }
        this.m_stack = null;
    }

    public void startElement(String string, AttributeList attributeList) {
        if (this.found) {
            this.debug("<" + string + ">");
        }
        if (!this.found) {
            if (string.equalsIgnoreCase("PDML")) {
                this.m_tabbedPaneDefinitions.m_baseName = this.m_baseName;
                this.debug("Base name: " + this.m_tabbedPaneDefinitions.m_baseName);
                this.m_tabbedPaneDefinitions.m_locale = this.m_locale;
                this.m_tabbedPaneDefinitions.m_localeString = SystemResourceFinder.getLastDocumentLocale();
                this.debug("Locale string: " + this.m_tabbedPaneDefinitions.m_localeString);
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    Object[] objectArray;
                    String string2 = attributeList.getName(i);
                    String string3 = attributeList.getValue(i).trim();
                    if (string2.equalsIgnoreCase("VERSION")) {
                        this.m_tabbedPaneDefinitions.m_version = string3;
                        this.debug("Version: " + this.m_tabbedPaneDefinitions.m_version);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("SOURCE")) {
                        this.m_tabbedPaneDefinitions.m_source = string3.toUpperCase();
                        this.debug("Source: " + this.m_tabbedPaneDefinitions.m_source);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("BASESCREENSIZE")) continue;
                    String string4 = string3;
                    int n = string4.indexOf(120);
                    if (n == -1) {
                        this.debug("Base Screen Size '" + string4 + "' invalid");
                        objectArray = new Object[]{string4, string2.toString()};
                        this.processError(SystemResourceFinder.format("baseScreenSizeNotValid", objectArray));
                        continue;
                    }
                    objectArray = string4.substring(0, n).trim();
                    String string5 = string4.substring(n + 1).trim();
                    try {
                        int n2 = Integer.parseInt((String)objectArray);
                        int n3 = Integer.parseInt(string5);
                        this.m_tabbedPaneDefinitions.m_baseScreenSize.setSize(n2, n3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.debug("Base Screen Size '" + string4 + "' invalid");
                        this.processError(numberFormatException, string2 + "= " + string3);
                        continue;
                    }
                    this.debug("Storing base screen size: " + string4);
                }
            } else if (string.equals("TABBEDPANE")) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string6 = attributeList.getName(i);
                    String string7 = attributeList.getValue(i).trim();
                    if (string6.equalsIgnoreCase("NAME")) {
                        if (string7 == null || !string7.equals(this.m_tabbedPaneName)) continue;
                        this.found = true;
                        this.m_tabbedPaneDescriptor.m_name = string7;
                        this.m_stack.push(this.m_tabbedPaneDescriptor);
                        continue;
                    }
                    if (!string6.equalsIgnoreCase("PLACEMENT")) continue;
                    this.m_tabbedPaneDescriptor.m_placement = string7.toUpperCase();
                    this.debug("Storing tabbed pane placement: " + this.m_tabbedPaneDescriptor.m_placement);
                }
            }
        } else if (string.equalsIgnoreCase("TITLE") || string.equalsIgnoreCase("LOCATION") || string.equalsIgnoreCase("SIZE")) {
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("PANE")) {
            PaneDescriptor paneDescriptor = new PaneDescriptor();
            paneDescriptor.m_paneType = "PANEL";
            for (int i = 0; i < attributeList.getLength(); ++i) {
                String string8 = attributeList.getName(i);
                String string9 = attributeList.getValue(i).trim();
                if (string8.equalsIgnoreCase("NAME")) {
                    paneDescriptor.m_paneName = string9;
                    continue;
                }
                if (string8.equalsIgnoreCase("RESOURCE")) {
                    paneDescriptor.m_baseName = string9;
                    continue;
                }
                if (!string8.equalsIgnoreCase("TYPE")) continue;
                paneDescriptor.m_paneType = string9.toUpperCase();
            }
            this.debug("Storing resource name: " + paneDescriptor.m_baseName);
            this.debug("Storing pane name: " + paneDescriptor.m_paneName);
            this.debug("Storing pane type: " + paneDescriptor.m_paneType);
            this.m_paneDescriptors.addElement(paneDescriptor);
            this.m_stack.push(paneDescriptor);
        }
    }

    public void endElement(String string) {
        if (!this.m_chars.equals("")) {
            this.writeChars();
            this.m_chars = "";
        }
        if (this.found) {
            this.m_stack.pop();
            if (this.m_stack.empty()) {
                this.found = false;
                throw new AbortException();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (!this.found) {
            return;
        }
        if (!(this.m_stack.peek() instanceof String)) {
            this.debug("STRING expected on the stack");
            return;
        }
        this.m_chars = this.m_chars + new String(cArray, n, n2).trim();
    }

    private void writeChars() {
        String string = this.m_chars;
        String string2 = (String)this.m_stack.pop();
        if (string2.equalsIgnoreCase("TITLE")) {
            this.m_tabbedPaneDescriptor.m_title = string;
            this.m_tabbedPaneDescriptor.m_titleBundle = string;
            try {
                this.m_tabbedPaneDescriptor.m_title = this.m_bundle.getString(this.m_tabbedPaneDescriptor.m_titleBundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.debug("Storing tabbed pane title: " + this.m_tabbedPaneDescriptor.m_title);
        } else if (string2.equalsIgnoreCase("LOCATION")) {
            String string3 = string;
            int n = string3.indexOf(44);
            if (n == -1) {
                this.debug("Tabbed Pane location '" + string3 + "' invalid");
                Object[] objectArray = new Object[]{string3, string2};
                this.processError(SystemResourceFinder.format("locationNotValid", objectArray));
            } else {
                String string4 = string3.substring(0, n).trim();
                String string5 = string3.substring(n + 1).trim();
                try {
                    int n2 = Integer.parseInt(string4);
                    int n3 = Integer.parseInt(string5);
                    this.m_tabbedPaneDescriptor.m_position.setLocation(n2, n3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.debug("Split tabbed location '" + string3 + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                }
                this.debug("Storing tabbed pane location: " + string3);
            }
        } else if (string2.equalsIgnoreCase("SIZE")) {
            String string6 = string;
            int n = string6.indexOf(44);
            if (n == -1) {
                this.debug("Split pane size '" + string6 + "' invalid");
                Object[] objectArray = new Object[]{string6, string2};
                this.processError(SystemResourceFinder.format("sizeNotValid", objectArray));
            } else {
                String string7 = string6.substring(0, n).trim();
                String string8 = string6.substring(n + 1).trim();
                try {
                    int n4 = Integer.parseInt(string7);
                    int n5 = Integer.parseInt(string8);
                    this.m_tabbedPaneDescriptor.m_position.setSize(n4, n5);
                }
                catch (NumberFormatException numberFormatException) {
                    this.debug("Deck pane size '" + string6 + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                }
                this.debug("Storing tabbed pane size: " + string6);
            }
        }
        this.m_stack.push(string2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    private void debug(String string) {
        if (m_bElementTrace) {
            System.out.println("XMLTabbedPaneDefinition: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

